/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PropertiedObject;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@MappedSuperclass
@AccessType(value="property")
public abstract class AbstractTakeawayAccount
extends Account {
    public static final Props Properties = new Props();
    private static final String EXT_ICON = "/waitermate/images/ext_id.gif";
    private String extID;
    public String ordNumber;

    public AbstractTakeawayAccount() {
    }

    protected AbstractTakeawayAccount(AccountType accountType) {
        super(accountType);
    }

    public AbstractTakeawayAccount(User createUser, Terminal createdOn, AccountType accountType) {
        super(new EventContext(createdOn, createUser), accountType);
    }

    @Override
    @Transient
    public String getLabel() {
        SimpleDateFormat formatter = new SimpleDateFormat("h:mm a");
        String timeString = formatter.format(this.getCreationDateTime());
        if (this.hasExtID()) {
            return this.getExtID() + " - " + timeString;
        }
        return this.getOrderNumber() + " - " + timeString;
    }

    @Transient
    public String getLabelNoTime() {
        if (this.hasExtID()) {
            return this.getExtID();
        }
        return "" + this.getOrderNumber();
    }

    @Transient
    public String getLabelNoInternalOrderNumber() {
        SimpleDateFormat formatter = new SimpleDateFormat("h:mm a");
        String timeString = formatter.format(this.getCreationDateTime());
        if (this.hasExtID()) {
            return this.getExtID() + " - " + timeString;
        }
        return this.getAccountType().getLabel() + " - " + timeString;
    }

    @Override
    @Transient
    public int getOrderNumber() {
        int limit = 100;
        try {
            limit = SystemProperty.getInstance().getLimitOfOrderNumber();
        }
        catch (Exception ex) {
            OrderMateLog.LOG.error("Cannot get limit of order number, no SystemProperty");
        }
        int orderNumb = 0;
        orderNumb = (int)this.intID() % limit;
        this.ordNumber = Integer.toString(orderNumb);
        return orderNumb;
    }

    public void setExtID(String accountExtID) {
        this.extID = accountExtID;
    }

    @Override
    @Transient
    public String getIcon() {
        if (this.hasExtID()) {
            return EXT_ICON;
        }
        return super.getIcon();
    }

    @Column(name="external_id")
    public String getExtID() {
        return this.extID;
    }

    public boolean hasExtID() {
        return this.extID != null && !this.extID.equalsIgnoreCase("") && !this.extID.equalsIgnoreCase("0");
    }

    @Override
    public boolean needsInfo() {
        return false;
    }

    @Override
    @Transient
    public List<PropertiedObject.Property> getCustomerRequirements() {
        return Customer.REQUIRE_BASIC;
    }

    public static class Props
    extends Account.Props {
        public PropertiedObject.Property<String> EXT_ID;
    }
}

