/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.EventContext;
import ordermate.database.PayableHelper;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.OrderedQuantity;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.Course;
import ordermate.database.misc.OrderItemLogType;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.colour.ConfigColor;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.sales.AccountSaveContext;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountTimeDueHelper;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemHelper;
import ordermate.database.sales.TakeawayTicketData;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.PrintedFilter;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.integration.PropertyIntegrationUtils;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.services.sales.ItemGroupPriceLevelPolicy;
import org.apache.logging.log4j.Level;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_account")
@DiscriminatorColumn(name="acc_class")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class Account
extends ItemGroup {
    public static final int MAX_NUM_PATRONS = 100;
    private static boolean LOCAL_MODE = false;
    public static final Props Properties = new Props();
    private PersistentWriteableList<TakeawayTicketData> ticketData;
    public static final Reference BILL_PRINTED_COLOR = ConfigColor.createLocalCachedReference("Table Bill Printed");
    public static final Color HOLD_COLOR = Color.BLUE;
    public static final Color NOT_FULLY_PRINTED = Color.CYAN;
    private AccountState accountState;
    private Date creationDateTime;
    private Date creationTime;
    private Date eta;
    private ReceiptPrintState receiptState;
    private AccountType accountType;
    private Price savedTotal;
    private Reference<User> user;
    private Reference<User> openingUser;
    private Reference<User> assignedUser;
    private Reference<User> closingUser;
    private Reference<Customer> customer;
    private Reference<TradingDay> tradingDay;
    private Reference<Shift> shift;
    private Reference<SalesLocation> salesLocation;
    private PersistentWriteableList<SalesLineItem> items;
    private PersistentWriteableList<SalesPriceAdjustment> adjustments;
    private PersistentWriteableList<FinanceTransaction> allFinanceTransactions;
    private PersistentWriteableList<SalesCouponUsage> couponUsages;
    private PersistentList<DebtorSale> debtorSale;
    private PersistentWriteableList<GiftVoucherTransaction> voucherTxns;
    private transient List<SalesLineItem> activeItems;
    private List<FinanceTransaction> removedTransactions;
    private Date localCreationTime;
    private transient String rendererLabel;
    private transient int duration;
    private transient List<SalesLineItem> orderedItems;
    private boolean onHold;
    private int numPatrons;
    private String cardId;
    private String comment;
    protected transient AccountSaveContext currentSaveContext;
    private transient boolean needsPriceUpdate;
    private transient boolean closeUnchecked;
    protected boolean notifyClosed;
    private Date timeDue;
    private Date dateDue;
    private Date prepPrintDue;
    private Date closedDateTime;
    private Date modDateTime;
    private String extHRef;
    private String source;
    private String extDocketHRef;
    private String extOrderID;
    private Date extOrderDateTime;
    private String extOrigin;

    @Deprecated
    protected Account() {
        this.ticketData = (PersistentWriteableList)this.createList(Account.Properties.TICKET_DATA);
        this.receiptState = ReceiptPrintState.RECEIPT_NOT_PRINTED;
        this.accountType = null;
        this.user = this.createReference(Account.Properties.USER);
        this.openingUser = this.createReference(Account.Properties.OPENING_USER);
        this.assignedUser = this.createReference(Account.Properties.ASSIGNED_USER);
        this.closingUser = this.createReference(Account.Properties.CLOSING_USER);
        this.customer = this.createReference(Account.Properties.CUSTOMER);
        this.tradingDay = this.createReference(Account.Properties.TRADING_DAY);
        this.shift = this.createReference(Account.Properties.SHIFT);
        this.salesLocation = this.createReference(Account.Properties.SALES_LOCATION);
        this.items = (PersistentWriteableList)this.createList(Account.Properties.ITEMS);
        this.adjustments = (PersistentWriteableList)this.createList(Account.Properties.ADJUSTMENTS);
        this.allFinanceTransactions = (PersistentWriteableList)this.createList(Account.Properties.ALL_FINANCE_TRANSACTIONS);
        this.couponUsages = this.createWriteableList(Account.Properties.COUPON_USAGES);
        this.debtorSale = this.createList(Account.Properties.DEBTOR_SALE);
        this.voucherTxns = this.createWriteableList(Account.Properties.VOUCHER_TXNS);
        this.removedTransactions = new ArrayList<FinanceTransaction>();
        this.localCreationTime = new Date();
        this.orderedItems = new LinkedList<SalesLineItem>();
        this.onHold = false;
        this.numPatrons = 0;
        this.needsPriceUpdate = false;
        this.closeUnchecked = false;
    }

    protected Account(AccountType accountType) {
        this();
        this.accountType = accountType;
    }

    public Account(EventContext context, AccountType accountType) {
        this.ticketData = (PersistentWriteableList)this.createList(Account.Properties.TICKET_DATA);
        this.receiptState = ReceiptPrintState.RECEIPT_NOT_PRINTED;
        this.accountType = null;
        this.user = this.createReference(Account.Properties.USER);
        this.openingUser = this.createReference(Account.Properties.OPENING_USER);
        this.assignedUser = this.createReference(Account.Properties.ASSIGNED_USER);
        this.closingUser = this.createReference(Account.Properties.CLOSING_USER);
        this.customer = this.createReference(Account.Properties.CUSTOMER);
        this.tradingDay = this.createReference(Account.Properties.TRADING_DAY);
        this.shift = this.createReference(Account.Properties.SHIFT);
        this.salesLocation = this.createReference(Account.Properties.SALES_LOCATION);
        this.items = (PersistentWriteableList)this.createList(Account.Properties.ITEMS);
        this.adjustments = (PersistentWriteableList)this.createList(Account.Properties.ADJUSTMENTS);
        this.allFinanceTransactions = (PersistentWriteableList)this.createList(Account.Properties.ALL_FINANCE_TRANSACTIONS);
        this.couponUsages = this.createWriteableList(Account.Properties.COUPON_USAGES);
        this.debtorSale = this.createList(Account.Properties.DEBTOR_SALE);
        this.voucherTxns = this.createWriteableList(Account.Properties.VOUCHER_TXNS);
        this.removedTransactions = new ArrayList<FinanceTransaction>();
        this.localCreationTime = new Date();
        this.orderedItems = new LinkedList<SalesLineItem>();
        this.onHold = false;
        this.numPatrons = 0;
        this.needsPriceUpdate = false;
        this.closeUnchecked = false;
        this.accountType = accountType;
        this.accountState = AccountState.OPEN;
        this.setReceiptState(ReceiptPrintState.RECEIPT_NOT_PRINTED);
        this.creationDateTime = null;
        this.setCreationTime(context.getTradingDay(), context.getTerminal().getShift());
        this.setSalesLocation(context.getTerminal().getSalesLocation());
        this.setOpeningUser(context.getUser());
        this.getPriceAdjHelper().applyAutomaticAdjustment(context, null);
        this.logAccountCreationTime(context.getUser(), context.getTradingDay(), context.getTerminal(), context.getTerminal().getShift());
    }

    @Override
    public void init() {
        super.init();
        this.getFinanceTransactions();
    }

    public static String[] getCourses() {
        return Course.getCourseNames();
    }

    @Transient
    public String getDescription() {
        return "Sale";
    }

    @Override
    @Transient
    public abstract String getLabel();

    public abstract boolean needsInfo();

    public boolean allowsOrderingItems() {
        return this.isOpen();
    }

    public boolean allowsPrintMove() {
        return true;
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return false;
    }

    @Transient
    public List<PropertiedObject.Property> getCustomerRequirements() {
        return Customer.REQUIRE_FIRST_NAME;
    }

    @Transient
    public boolean getRequiresCustomer() {
        return false;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (this.isOnHold()) {
            return HOLD_COLOR;
        }
        if (this.getReceiptState().equals(ReceiptPrintState.RECEIPT_PRINTED) && !this.isLocked()) {
            return ((ConfigColor)BILL_PRINTED_COLOR.get()).getColor();
        }
        return super.getBackgroundColor();
    }

    public boolean allowsHold(Terminal term) {
        return this.onHold;
    }

    @Deprecated
    @Transient
    public OrderedQuantity getUnsavedData() {
        OrderedQuantity toReturn = new OrderedQuantity(this.getItemList(), true);
        return toReturn;
    }

    @Override
    @Transient
    public boolean isOpen() {
        return AccountState.OPEN.equals((Object)this.accountState);
    }

    @Transient
    public boolean isSaveEmptyAllowed() {
        return false;
    }

    @Transient
    public boolean isSaveAllowed() {
        if (this.isSaveEmptyAllowed()) {
            return true;
        }
        return !this.getItems().isEmpty() || !this.getFinanceTransactions().isEmpty() || !this.getVoucherTxns().isEmpty() || this.isOpen() || this.isPersistent();
    }

    @Transient
    public boolean isClosePossible() {
        for (GiftVoucherTransaction txn : this.voucherTxns) {
            if (!txn.isActive() || txn.isAuthorised()) continue;
            return false;
        }
        return true;
    }

    public void closeUnchecked(EventContext context) {
        this.closeUnchecked = true;
        this.close(context);
    }

    @Override
    public void close(EventContext context) {
        if (this.isOpen() && (this.closeUnchecked || this.isClosePossible())) {
            this.notifyClosed = true;
            this.accountState = AccountState.CLOSED;
            this.closedDateTime = new Date();
            if (this.closingUser.isNull()) {
                this.setClosingUser(this.getUser());
            }
        }
        if (!this.isOpen()) {
            LoyaltyPointAdministrator.getInstance().earnLoyaltyPoints(this, context);
        }
    }

    private void setReceiptState(ReceiptPrintState newReceiptState) {
        this.receiptState = newReceiptState;
    }

    @Override
    public String toString() {
        if (this.isPersistent()) {
            return "[" + this.getID() + "] " + this.getLabel();
        }
        return this.getLabel();
    }

    @Override
    public List<SalesLineItem> setCustomer(Customer newCustomer, EventContext context) {
        Customer oldCustomer = this.getCustomer();
        if (oldCustomer != null) {
            oldCustomer.save();
        }
        this.customer.set(newCustomer);
        if (newCustomer != null && newCustomer.equals(oldCustomer) || newCustomer == oldCustomer) {
            return new ArrayList<SalesLineItem>();
        }
        CustomerAssignmentHelper helper = new CustomerAssignmentHelper();
        CustomerAssignmentContext aContext = new CustomerAssignmentContext(newCustomer, this, -2, context);
        return helper.updateItemsForCustomer(aContext);
    }

    public List<SalesLineItem> autoFillLastAccountForCustomer(EventContext context) {
        if (this.getUser() == null || context.getUser() == null || !this.getItems().isEmpty()) {
            return Collections.emptyList();
        }
        Account previous = AccountQueries.getLastAccountForCustomer(this, this.getCustomer());
        if (previous != null) {
            ArrayList<SalesLineItem> newItems = new ArrayList<SalesLineItem>();
            if (!SalesLineItemHelper.validateItems(previous.getItems())) {
                return Collections.emptyList();
            }
            newItems.addAll(this.copyItems(previous.getItems(), context, false));
            for (SalesLineItem item : newItems) {
                item.removePriceAdjustments(item.getPriceAdjustments());
                item.markAsLoyaltyPointsNotRedeemed();
                for (SalesItem nextItem : item.getSalesItems()) {
                    for (SalesComponent component : nextItem.getComponents()) {
                        UnitPriceLevel unitLevel = PersistenceManager.getObject(UnitPriceLevel.class, Query.select(UnitPriceLevel.class).equals(UnitPriceLevel.Properties.PRICE_LEVEL, component.getPriceLevel()).equals(UnitPriceLevel.Properties.UNIT, component.getUnit()).toString());
                        if (unitLevel == null) continue;
                        component.getSalesItem().setComponentPriceLevel(component, unitLevel);
                    }
                }
            }
            ItemGroupPriceLevelPolicy policy = new ItemGroupPriceLevelPolicy(this);
            Set<PriceLevel> levels = policy.getPossiblePriceLevels(true, context);
            policy.useHighestActivePriceLevel(levels, true, context, "Adjusted to current prices.");
            return newItems;
        }
        return Collections.emptyList();
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    @Override
    @Transient
    public void updateCustomerReference() {
        if (this.customer.isPersistent() && this.hasCustomer()) {
            this.customer.set((Customer)PersistenceManager.reacquire(this.getCustomer()));
        }
    }

    @Override
    public boolean hasCustomer() {
        return this.customer.getID() != null || this.getCustomer() != null && !(this.getCustomer() instanceof Customer.NULL_CUSTOMER);
    }

    @Override
    @Column(name="Creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationDateTime() {
        return (Date)(this.creationDateTime != null ? this.creationDateTime.clone() : this.localCreationTime.clone());
    }

    @Transient
    public Date getCreationTime() {
        if (this.creationTime == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getCreationDateTime());
            cal.set(0, 0, 1);
            this.creationTime = cal.getTime();
        }
        return this.creationTime;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setCreationTime(TradingDay day, Shift newShift) {
        this.tradingDay.set(day);
        this.shift.set(newShift);
    }

    private void logAccountCreationTime(User user, TradingDay day, Terminal terminal, Shift shift) {
        OrderMate.LOG.info("Creating Account by User : " + user + " for Terminal : " + terminal.getID() + " with Trading Day : " + day.getID() + " and Shift : " + (shift == null ? "" : shift.getID()));
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    public void setSalesLocation(SalesLocation salesLocation) {
        this.salesLocation.set(salesLocation);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_sales_location")
    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    @Column(name="on_hold")
    public boolean isOnHold() {
        return this.onHold;
    }

    public void setOnHold(boolean hold) {
        this.onHold = hold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transient
    public List<SalesLineItem> getItems() {
        Account account;
        if (this.activeItems == null) {
            account = this;
            synchronized (account) {
                if (this.activeItems == null) {
                    ArrayList<SalesLineItem> newActives = new ArrayList<SalesLineItem>(this.getItemList().size());
                    for (SalesLineItem item : this.getItemList()) {
                        if (item.getQuantity().equals(0L)) continue;
                        newActives.add(item);
                    }
                    this.activeItems = newActives;
                }
            }
        }
        account = this;
        synchronized (account) {
            return new ArrayList<SalesLineItem>(this.activeItems);
        }
    }

    @Transient
    public List<SalesCombo> getSalesCombos() {
        ArrayList<SalesCombo> salesCombos = new ArrayList<SalesCombo>();
        List<SalesLineItem> filterItems = this.getItems();
        for (SalesLineItem currentItem : filterItems) {
            if (!(currentItem instanceof SalesCombo)) continue;
            salesCombos.add((SalesCombo)currentItem);
        }
        return salesCombos;
    }

    public boolean hasUnsavedDeletedItems() {
        for (SalesLineItem item : this.getItemList()) {
            if (!item.hasUnsavedDeletedQuantity()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnsavedRefundedItems() {
        for (SalesLineItem item : this.getItemList()) {
            if (!item.hasUnsavedRefundedQuantity()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public boolean isWastageCheckNeeded() {
        for (SalesLineItem item : this.getItemList()) {
            if (!item.isWastageCheckNeeded()) continue;
            return true;
        }
        return false;
    }

    @Override
    @OneToMany(mappedBy="account", targetEntity=SalesLineItem.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public List<SalesLineItem> getAllItems() {
        return this.items.getUnmodifiable();
    }

    @Override
    @Transient
    public List getAllItemsModifiable() {
        return this.items;
    }

    @Transient
    public List<SalesLineItem> getAllItemsExcDeleted() {
        ArrayList<SalesLineItem> toReturn = new ArrayList<SalesLineItem>(this.getAllItems());
        ArrayList toRemove = new ArrayList();
        for (SalesLineItem item : toReturn) {
            if (!item.getQuantity().equals(0L)) continue;
        }
        toReturn.removeAll(toRemove);
        return toReturn;
    }

    protected void setAllItems(List<SalesLineItem> values) {
        this.items = this.items.clone();
        this.items.set(values);
    }

    @Override
    @Transient
    public Account getAccount() {
        return this;
    }

    @Deprecated
    public void removeItem(SalesLineItem itemToRemove, Terminal removedFrom, User removeUser) {
        this.getItemHelper().removeItem(itemToRemove, new EventContext(removedFrom, removeUser));
    }

    void unsafeRemove(SalesLineItem toRemove) {
        this.items.remove(toRemove);
        if (this.activeItems != null) {
            this.activeItems.remove(toRemove);
        }
    }

    @Deprecated
    public void refundItem(SalesLineItem toRefund, Terminal refundedFrom, User refundUser) {
        this.refundItem(toRefund, new EventContext(refundedFrom, refundUser));
    }

    public void refundItem(SalesLineItem toRefund, EventContext context) {
        if (toRefund.getAccount() != this) {
            throw new IllegalArgumentException("Item " + toRefund + " did not come from this account.");
        }
        toRefund.markAsRefunded(context);
        if (this.activeItems != null) {
            this.activeItems.remove(toRefund);
        }
        this.getPriceAdjHelper().checkItemsOrderedTriggerAdjustments();
        this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
    }

    public void removeAllItems(EventContext context) {
        for (SalesLineItem item : this.getItems()) {
            if (item.hasSavedItems()) {
                item.markAsDeleted(context);
                continue;
            }
            this.items.remove(item);
        }
        if (this.activeItems != null) {
            this.activeItems.clear();
        }
        this.getPriceAdjHelper().checkItemsOrderedTriggerAdjustments();
        this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
    }

    public static final void SET_MODE(boolean local) {
        LOCAL_MODE = local;
        String message = local ? "Local Mode" : "Normal Mode";
        OrderMate.LOG.info("Database account access mode set to " + message);
    }

    @Transient
    private List<SalesLineItem> getItemList() {
        if (LOCAL_MODE) {
            return this.items.getLocalObjects();
        }
        return this.items;
    }

    public boolean hasItems() {
        return !this.getItems().isEmpty();
    }

    @Transient
    private List<SalesItem> getAllSalesItems() {
        ArrayList<SalesItem> allSalesItems = new ArrayList<SalesItem>();
        allSalesItems = new ArrayList(this.getAllItems().size());
        for (SalesLineItem currentItem : this.getAllItems()) {
            allSalesItems.addAll(currentItem.getSalesItems());
        }
        return allSalesItems;
    }

    public boolean hasPrintableItems() {
        return !ItemFilter.filterItems(this.getAllSalesItems(), new PrintedFilter(Boolean.FALSE)).isEmpty();
    }

    public boolean hasSellables() {
        return !this.getItems().isEmpty() || !this.getActiveVoucherTxns().isEmpty();
    }

    public boolean hasSavedItems() {
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT sum(sales_item_quantity.quantity) as total FROM sales_item, sales_item_quantity WHERE sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_account = ? HAVING total > 0 ", new Object[]{this.getID()});
        return results.length > 0;
    }

    @Override
    @Transient
    public synchronized Price getDue() {
        return this.getDue(0.01);
    }

    @Override
    @Transient
    public synchronized Price getDue(double roundAmt) {
        if (this.isDebtorSale()) {
            Price total = this.getTotal();
            Price paid = this.getPaid();
            Price paidByDebtor = this.getUniqueDebtorSale().getTotal();
            return new Price(total.doubleValue() - paid.doubleValue() - paidByDebtor.doubleValue(), 0.01);
        }
        return super.getDue(roundAmt);
    }

    @Transient
    public Price getSummaryDue() {
        Price total = this.getSavedTotal();
        Price paid = this.getPaid();
        return new Price(total.doubleValue() - paid.doubleValue(), 0.01);
    }

    @Override
    @Transient
    public List<FinanceTransaction> getFinanceTransactions() {
        ArrayList<FinanceTransaction> activeTxns = new ArrayList<FinanceTransaction>();
        for (FinanceTransaction txn : this.allFinanceTransactions) {
            if (!"ACTIVE".equals(txn.getSystemState())) continue;
            activeTxns.add(txn);
        }
        return activeTxns;
    }

    @OneToMany(mappedBy="account", targetEntity=FinanceTransaction.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public List<FinanceTransaction> getAllFinanceTransactions() {
        return this.allFinanceTransactions.getUnmodifiable();
    }

    protected void setAllFinanceTransactions(List<FinanceTransaction> newTxns) {
        if (newTxns != null) {
            this.allFinanceTransactions = this.allFinanceTransactions.clone();
            this.allFinanceTransactions.set(newTxns);
        }
    }

    @Override
    public void removeFinanceTransaction(FinanceTransaction toRemove) {
        toRemove.setSystemState("DELETED");
        if (!toRemove.isPersistent()) {
            this.removedTransactions.add(toRemove);
        }
        for (SalesLineItem nextItem : this.getAllItems()) {
            nextItem.removeFinanceTransaction(toRemove);
        }
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction toAdd, List<SalesLineItem> linkItems) {
        this.allFinanceTransactions.add(toAdd);
        for (SalesLineItem item : linkItems) {
            item.addFinanceTransaction(toAdd);
        }
    }

    @Override
    @Transient
    public List<SalesPriceAdjustment> getPriceAdjustments() {
        return this.adjustments.getUnmodifiable();
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        if (PriceAdjustmentLevel.ITEM_LEVEL.equals(adjustment.getLevel())) {
            throw new IllegalArgumentException("Cannot add adjustment to account, adjustment is item level " + adjustment);
        }
        if (!this.adjustments.contains(adjustment) || PriceAdjustmentDirection.SURCHARGE.equals(adjustment.getDirection())) {
            this.adjustments.add(adjustment);
        }
        TerminalEventLog.logAddAdjustment(context, adjustment, this);
        this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
    }

    public void removeAllDiscounts(InventoryPriceAdjustment adjustment, EventContext context) {
        for (SalesPriceAdjustment slsDiscount : this.getPriceAdjHelper().getDiscounts()) {
            if (!slsDiscount.matchesTypeAndUnit(adjustment)) continue;
            this.removePriceAdjustment(slsDiscount, context);
        }
    }

    public void removeAllSurcharges(InventoryPriceAdjustment surcharge, EventContext context) {
        for (SalesPriceAdjustment slsSurcharge : this.getPriceAdjHelper().getSurcharges()) {
            if (!slsSurcharge.matchesTypeAndUnit(surcharge)) continue;
            this.removePriceAdjustment(slsSurcharge, context);
        }
    }

    @Override
    public boolean removePriceAdjustment(SalesPriceAdjustment adjToRemove, EventContext context) {
        boolean success = false;
        if (adjToRemove.getLevel().equals(PriceAdjustmentLevel.ACCOUNT_LEVEL)) {
            success = this.removeAdjustment(adjToRemove, context);
        } else {
            for (SalesLineItem item : this.getItems()) {
                for (SalesItem salesItem : item.getSalesItems()) {
                    success |= salesItem.removePriceAdjustment(adjToRemove, false, context);
                }
            }
        }
        if (!success) {
            if (Config.isDebuging()) {
                throw new IllegalStateException("Could not find adjustment " + adjToRemove + " to remove");
            }
            OrderMate.LOG.log(Level.WARN, "Could not find adjustment " + adjToRemove + " to remove");
        }
        this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        return success;
    }

    @Override
    protected boolean removeAdjustment(SalesPriceAdjustment adjToRemove, EventContext context) {
        boolean foundIt = false;
        if (this.adjustments.contains(adjToRemove)) {
            if (context != null) {
                TerminalEventLog.logRemoveAdjustment(context, adjToRemove, this);
            }
            foundIt = this.adjustments.remove(adjToRemove);
        }
        adjToRemove.tearDownUsages();
        return foundIt;
    }

    @Override
    public boolean lock(User newUser) {
        Long userID = this.hasUser();
        if (userID != null) {
            return false;
        }
        this.user.set(newUser);
        return true;
    }

    @Override
    public boolean relock(User newUser) {
        this.unlock();
        return this.lock(newUser);
    }

    @Override
    public void unlock() {
        this.user.set(null);
    }

    @Override
    @Transient
    public boolean isLocked() {
        return !this.user.isNull();
    }

    @Override
    public synchronized boolean isLocked(User byUser) {
        return !this.user.isNull() && this.user.getObjectID().equals(PersistenceManager.getID(byUser));
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    public Long hasUser() {
        if (this.getID() == null) {
            return null;
        }
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT sales_account.FK_config_user FROM sales_account WHERE sales_account.ID = ? ", new Object[]{this.getID()});
        Long ID = null;
        if (results.length > 0) {
            ID = (Long)results[0][0];
        }
        return ID;
    }

    @Override
    public final void delete() {
        throw new UnsupportedOperationException("Accounts cannot be deleted. Instead try closing them");
    }

    public SaveContext createSaveContext(String reason, String usage, Terminal saveTerminal) {
        return new AccountSaveContext(reason, usage, saveTerminal, this.getUser());
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.currentSaveContext = (AccountSaveContext)context;
    }

    @Transient
    public AccountSaveContext getCurrentSaveContext() {
        return this.currentSaveContext;
    }

    public void setCurrentSaveContext(AccountSaveContext context) {
        this.currentSaveContext = context;
    }

    @Override
    public void save() {
        boolean notifyCreated;
        this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        this.calculateNumPatrons();
        this.accountType = this.getAccountType();
        if (!this.isLocked()) {
            throw new IllegalStateException("Cannot save unlocked account " + this);
        }
        this.initCurrentSaveContext();
        boolean bl = notifyCreated = !this.isPersistent();
        if (!this.isPersistent()) {
            this.localCreationTime = new Date();
        }
        this.customer.saveChild();
        this.checkAndApplyAccountRoundingIfRequired();
        this.savedTotal = this.getSummaryTotal();
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            this.modDateTime = new Date();
        }
        if (this.openingUser.isNull()) {
            this.setOpeningUser(this.getUser());
        }
        if (this.assignedUser.isNull() && !this.getItems().isEmpty()) {
            this.setAssignedUser(this.getUser());
        }
        if (this.closingUser.isNull() && AccountState.CLOSED.equals((Object)this.getAccountState())) {
            this.setClosingUser(this.getUser());
            if (this.assignedUser.isNull()) {
                this.setAssignedUser(this.getUser());
            }
        }
        PersistenceManager.save(this);
        TerminalEventLog.logOrderedItems(this.getUser(), this.currentSaveContext.getTerminal(), this, this.getAllItems(), OrderItemLogType.SAVE);
        TerminalEventLog.logDeletedItems(this.getUser(), this.currentSaveContext.getTerminal(), this, this.getAllItems());
        TerminalEventLog.logRefundedItems(this.currentSaveContext, this, this.getAllItems());
        TerminalEventLog.logMovedItems(this.getUser(), this.currentSaveContext.getTerminal(), this, this.getAllItems());
        this.allFinanceTransactions.prepareForSave(this.currentSaveContext);
        this.allFinanceTransactions.saveChild();
        this.saveRemovedTransactions();
        this.adjustments.prepareForSave(this.currentSaveContext);
        this.adjustments.saveChild();
        this.items.prepareForSave(this.currentSaveContext);
        this.items.saveChild();
        this.ticketData.saveChild();
        this.couponUsages.saveChild();
        this.voucherTxns.saveChild();
        Price newTotal = this.getTotal(0.01).add(this.getTotalRoundingAmt());
        if (!newTotal.equals(this.savedTotal)) {
            OrderMate.LOG.warn("TOTAL HAS CHANGED! WAS " + this.savedTotal + ", is now" + newTotal);
        }
        if (notifyCreated) {
            PropertyIntegrationUtils.accountCreated(this);
        }
        if (this.notifyClosed) {
            PropertyIntegrationUtils.accountClosed(this);
            ReservationIntegrationUtils.accountClosed(this);
            this.notifyClosed = false;
        }
        this.customer.saveChild();
        this.currentSaveContext = null;
        if (AccountState.CLOSED.equals((Object)this.getAccountState()) && !Price.ZERO_DOLLAR.equals(this.getDue()) && !this.isDebtorSale()) {
            OrderMate.LOG.warn("ACCOUNT WAS CLOSED BUT WAS NOT BALANCED: Account " + this.getID() + " Due:" + this.getDue());
        }
    }

    public void initCurrentSaveContext() {
        if (this.currentSaveContext == null) {
            this.currentSaveContext = (AccountSaveContext)this.createSaveContext(null, "NORMAL", Terminal.getLocalHost());
        }
    }

    public void saveRemovedTransactions() {
        for (FinanceTransaction transaction : this.removedTransactions) {
            transaction.saveChild();
        }
        this.removedTransactions.clear();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.items.hasChildChanged() || this.allFinanceTransactions.hasChildChanged() || this.voucherTxns.hasChildChanged() || this.customer.hasChildChanged() || this.adjustments.hasChildChanged() || this.ticketData.hasChildChanged();
    }

    public boolean hasItemsChanged() {
        return this.items.hasChildChanged();
    }

    public boolean hasVoucherTxnsChanged() {
        return this.voucherTxns.hasChildChanged();
    }

    protected List<SalesLineItem> copyItems(List<SalesLineItem> copyItems, EventContext context, boolean allowDeleted) {
        ArrayList<SalesLineItem> newItems = new ArrayList<SalesLineItem>(copyItems.size());
        for (SalesLineItem toMove : copyItems) {
            Terminal originalTerminal = toMove.getOriginalTerminal();
            if (originalTerminal == null) {
                originalTerminal = context.getTerminal();
            }
            SalesLineItem copyItem = toMove.copy(new EventContext(originalTerminal, this.getUser()), true);
            if (!allowDeleted && !this.getItemHelper().checkUnitStillActive(toMove)) continue;
            newItems.add(copyItem);
        }
        this.getItemHelper().addItemBefore(null, newItems.toArray(new SalesLineItem[newItems.size()]));
        return newItems;
    }

    protected Map<SalesLineItem, Boolean> copyItemsWithPrintState(List<SalesLineItem> copyItems, EventContext context, boolean allowDeleted) {
        LinkedHashMap<SalesLineItem, Boolean> newItemsMap = new LinkedHashMap<SalesLineItem, Boolean>();
        for (SalesLineItem toMove : copyItems) {
            Terminal originalTerminal = toMove.getOriginalTerminal();
            if (originalTerminal == null) {
                originalTerminal = context.getTerminal();
            }
            SalesLineItem copyItem = toMove.copy(new EventContext(originalTerminal, this.getUser()), true);
            if (!allowDeleted && !this.getItemHelper().checkUnitStillActive(toMove)) continue;
            newItemsMap.put(copyItem, toMove.isPrinted());
        }
        for (SalesLineItem item : newItemsMap.keySet()) {
            this.getItemHelper().addItemBefore(null, item);
        }
        return newItemsMap;
    }

    public List<SalesLineItem> transferItemsTo(Account target, List<? extends SalesLineItem> itemsToTransfer, EventContext context) {
        return this.getItemHelper().transferItemsTo(target, itemsToTransfer, true, context);
    }

    public void printPrepDockets(Terminal printedFrom) throws Exception {
        if (!this.isOnHold()) {
            PrepDocketHelper.create(this).printPrepDockets(printedFrom, false, false);
        } else {
            IllegalStateException ex = new IllegalStateException("Cannot print prep dockets for account on hold");
            if (Config.isDebuging()) {
                throw ex;
            }
            OrderMate.LOG.warn("Attempt to print prep dockets for on hold account", (Throwable)ex);
        }
    }

    public void printClosingReceiptDockets(Terminal printedOn, List receiptPrinters) throws Exception {
        if (!receiptPrinters.isEmpty()) {
            if (!this.isPersistent() && Config.getBooleanValue("debug")) {
                throw new IllegalStateException("Cannot print the Closing Receipt Docket because the account " + this.toString() + " has  no order number.");
            }
            DocketProcessor.printPayoffDocket(receiptPrinters, this, this.getUser(), printedOn);
        }
    }

    @Override
    public void printReceiptDockets(User usr, Terminal printedFrom, List receiptPrinters) throws Exception {
        super.printReceiptDockets(usr, printedFrom, receiptPrinters);
        this.setReceiptState(ReceiptPrintState.RECEIPT_PRINTED);
        if (this.isPersistent()) {
            PersistenceManager.update(this, new PropertiedObject.Property[]{Account.Properties.RECEIPT_STATE});
        }
        PropertyIntegrationUtils.receiptPrinted(this);
        ReservationIntegrationUtils.receiptPrinted(this);
    }

    public static Account reload(Account toReload) {
        if (!toReload.isPersistent()) {
            throw new IllegalStateException("Cannot reload an account which is not in the DB");
        }
        return (Account)PersistenceManager.getByID(toReload.getID(), toReload.getClass());
    }

    public static List<Account> getOpenAccounts(AccountType type) {
        return PersistenceManager.getObjectList(Account.class, "SELECT sales_account.* FROM sales_account WHERE account_type = ? AND account_state = 'OPEN'ORDER BY creation_time", new Object[]{type.toString()});
    }

    public static List<Account> getOpenCurrentDayAccounts(AccountType type, TradingDay tradingDay) {
        return PersistenceManager.getObjectList(Account.class, "SELECT sales_account.* FROM sales_account WHERE account_type = ? AND account_state = 'OPEN'AND FK_finance_trading_day = ? ORDER BY creation_time", new Object[]{type.toString(), tradingDay.getID()});
    }

    public static List<Account> getAccounts(Shift shift) {
        return PersistenceManager.getObjectList(Account.class, "SELECT sales_account.* FROM sales_account WHERE FK_Finance_shift = ?", new Object[]{shift.getID()});
    }

    public static List getAccounts(AccountType type, boolean open, Shift shift) {
        String openStatus = open ? "OPEN" : "CLOSED";
        return PersistenceManager.getObjectList(Account.class, "SELECT sales_account.* FROM sales_account WHERE sales_account.FK_finance_shift = ? AND account_type = ? AND sales_account.account_state = ? ORDER BY creation_time", new Object[]{shift.getID(), type.toString(), openStatus});
    }

    public static List<Account> getAllOpenAccounts() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        AccountType[] accountTypes = AccountType.getTypes();
        for (int i = 0; i < accountTypes.length; ++i) {
            accounts.addAll(Account.getOpenAccounts(accountTypes[i]));
        }
        return accounts;
    }

    public static List<Account> getAllOpenCurrentDayAccount() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        AccountType[] accountTypes = AccountType.getTypes();
        for (int i = 0; i < accountTypes.length; ++i) {
            accounts.addAll(Account.getOpenCurrentDayAccounts(accountTypes[i], TradingDay.getCurrentTradingDay()));
        }
        return accounts;
    }

    @Override
    @Transient
    public int getOrderNumber() {
        int limit = SystemProperty.getInstance().getLimitOfOrderNumber();
        return (int)this.intID() % limit;
    }

    @Column(name="saved_total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getSavedTotal() {
        if (this.savedTotal == null) {
            return this.getTotal();
        }
        return this.savedTotal;
    }

    @Transient
    public DebtorSale getUniqueDebtorSale() {
        if (this.debtorSale.size() == 1) {
            return (DebtorSale)this.debtorSale.get(0);
        }
        if (this.debtorSale.size() > 1) {
            throw new IllegalStateException("Sale accounts and debtor sales should have a one to one relationship.  DebtorSale size: " + this.debtorSale.size());
        }
        return null;
    }

    @Transient
    public AbstractDebtor getDebtor() {
        if (this.isDebtorSale()) {
            return this.getUniqueDebtorSale().getDebtor();
        }
        return null;
    }

    @Transient
    public boolean isDebtorSale() {
        if (this.debtorSale.size() == 1) {
            return true;
        }
        if (this.debtorSale.size() > 1) {
            throw new IllegalStateException("Sale accounts and debtor sales should have a one to one relationship.  DebtorSale size: " + this.debtorSale.size());
        }
        return false;
    }

    public void setDebtorSale(DebtorSale theDebtorSale) {
        if (!theDebtorSale.getSaleAccount().equals(this)) {
            throw new IllegalArgumentException("Should only be called by debtor sale to set up the link back before being persisted!!!");
        }
        this.debtorSale.clear();
        this.debtorSale.add(theDebtorSale);
    }

    public void nukeAccount() {
        if (this.isDebtorSale()) {
            this.getUniqueDebtorSale().nukeSale();
        }
        try {
            Data.database.nukeAccount(this.intID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.AccountType")})
    @Column(name="account_type")
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Transient
    public List<SalesLineItem> getOrderedItems() {
        if (this.orderedItems == null) {
            this.orderedItems = new LinkedList<SalesLineItem>();
        }
        return this.orderedItems;
    }

    @Override
    public void addOrderedItem(SalesLineItem item) {
        if (item.getAccount() != null) {
            throw new IllegalStateException("Items belonging to accounts should not be added to this list. This list holds temporary items which may be added to this account.");
        }
        this.getOrderedItems().add(item);
    }

    public void addOrderedItems(List newItems) {
        Iterator i = newItems.iterator();
        while (i.hasNext()) {
            this.addOrderedItem((SalesLineItem)i.next());
        }
    }

    public void removeOrderedItems(List itemsToRemove) {
        this.getOrderedItems().removeAll(itemsToRemove);
    }

    @Transient
    public SalesLineItem getLastItemOrdered() {
        if (this.getOrderedItems().size() == 0) {
            return null;
        }
        return this.orderedItems.get(this.orderedItems.size() - 1);
    }

    public void addOrderedItemsToAccount() {
        for (SalesLineItem toAdd : this.getOrderedItems()) {
            if (!toAdd.getQuantity().notEquals(0)) continue;
            this.getItemHelper().addItem(toAdd);
        }
        this.clearOrderedItems();
    }

    public void addOrderedItemToAccount(SalesLineItem toAdd) {
        this.orderedItems.remove(toAdd);
        this.getItemHelper().addItem(toAdd);
    }

    public void clearOrderedItems() {
        this.getOrderedItems().clear();
    }

    public void mergeItemIntoOrderedList(SalesLineItem newItem, boolean increment, EventContext context) {
        this.getItemHelper().mergeItemIntoOrderedList(this.orderedItems, newItem, increment, context);
    }

    public boolean isNumberPatronsModifiable(List itemsToTransfer) {
        return false;
    }

    private void calculateNumPatrons() {
        if (DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            int num = 0;
            for (SalesLineItem lineItem : this.activeItems) {
                num += lineItem.getNumPatrons();
            }
            this.numPatrons = num;
        }
    }

    @Transient
    protected boolean isNeedsPriceUpdate() {
        return this.needsPriceUpdate;
    }

    protected void setNeedsPriceUpdate() {
        this.needsPriceUpdate = true;
    }

    @Override
    @Transient
    public Price getTotal() {
        Price total = this.getSummaryTotal();
        if (!(this.isLocked() || this.isOpen() || this.savedTotal == null || total.equals(this.savedTotal))) {
            OrderMate.LOG.info("Account.getTotal() - Recalculating total, saved total was not equal to getTotal on closed account Saved total : " + this.getSavedTotal() + "  Account total : " + total + "  on account: " + this);
            this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
            total = this.getSummaryTotal();
            if (!total.equals(this.savedTotal) && !total.subtract(this.getTotalRoundingAmt()).equals(this.savedTotal)) {
                OrderMate.LOG.warn("Having recalculated the total and resaved it, saved total should equal getTotal(), savedTotal : " + this.getSavedTotal() + "  getTotal(): " + total);
            }
        }
        return total;
    }

    @Transient
    public String getRendererLabel() {
        if (this.rendererLabel == null) {
            this.rendererLabel = this.createRendererLabel();
        }
        return this.rendererLabel;
    }

    protected String createRendererLabel() {
        return this.getLabel();
    }

    @Override
    @Transient
    public String getType() {
        return this.getAccountType().toString();
    }

    @Override
    @Transient
    public boolean isAccount() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Account otherAccount = (Account)other;
        if (this.isPersistent() && otherAccount.isPersistent() && otherAccount.getID().equals(this.getID())) {
            return true;
        }
        return super.equals(other);
    }

    @Column(name="eta")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getEta() {
        return this.eta;
    }

    public void setEta(Date value) {
        this.eta = value;
    }

    public boolean hasPayments() {
        Price totalPayments = Price.ZERO_DOLLAR;
        for (FinanceTransaction tran : this.getFinanceTransactions()) {
            totalPayments = totalPayments.add(tran.getPaid());
        }
        return !totalPayments.isZero();
    }

    protected void setOpen(boolean newOpen) {
        if (newOpen) {
            this.setAccountState(AccountState.OPEN);
        } else {
            this.setAccountState(AccountState.CLOSED);
        }
    }

    @Column(name="account_state")
    @Enumerated(value=EnumType.STRING)
    public AccountState getAccountState() {
        return this.accountState;
    }

    protected void setAccountState(AccountState state) {
        this.accountState = state;
    }

    protected void setCustomer(Customer cust) {
        this.customer.set(cust);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.Account$ReceiptPrintState"), @Parameter(name="defaultValue", value="receipt printed")})
    @Column(name="receipt_state")
    public ReceiptPrintState getReceiptState() {
        return this.receiptState;
    }

    protected void setTradingDay(TradingDay day) {
        this.tradingDay.set(day);
    }

    @OneToMany(mappedBy="account", targetEntity=SalesPriceAdjustment.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected List<SalesPriceAdjustment> getAdjustments() {
        return this.adjustments;
    }

    protected void setAdjustments(List<SalesPriceAdjustment> adjs) {
        this.adjustments = this.adjustments.clone();
        this.adjustments.set(adjs);
    }

    protected void setUser(User usr) {
        this.user.set(usr);
    }

    protected void setFinanceTransactions(List<FinanceTransaction> financeTransactions) {
        this.allFinanceTransactions = this.allFinanceTransactions.clone();
        this.allFinanceTransactions.set(financeTransactions);
    }

    protected void setShift(Shift shft) {
        this.shift.set(shft);
    }

    protected void setItems(List<SalesLineItem> itms) {
        this.items = this.items.clone();
        this.items.set(itms);
    }

    protected void setSavedTotal(Price total) {
        this.savedTotal = total;
    }

    public void setAccountType(AccountType type) {
        this.accountType = type;
    }

    protected void setCreationDateTime(Date dateTime) {
        this.creationDateTime = dateTime;
    }

    public boolean hasUnsavedFinanceTransaction() {
        boolean hasUnsaved = false;
        Iterator<FinanceTransaction> it = this.getFinanceTransactions().iterator();
        while (it.hasNext()) {
            if (it.next().isPersistent()) continue;
            hasUnsaved = true;
            break;
        }
        return hasUnsaved;
    }

    @Override
    public boolean hasEftposDockets() {
        return PayableHelper.hasEftposDockets(this.allFinanceTransactions);
    }

    @Override
    @Transient
    public List<FinanceTransactionDocket> getEftposDockets() {
        return PayableHelper.getEftposDockets(this.allFinanceTransactions);
    }

    public void addToTicketData(String line) {
        if (line == null) {
            return;
        }
        for (TakeawayTicketData data : this.ticketData) {
            if (!line.equals(data.getText())) continue;
            return;
        }
        this.ticketData.add(new TakeawayTicketData(line));
    }

    @Transient
    public List<String> getTicketData() {
        ArrayList<String> stringTicketData = new ArrayList<String>();
        for (TakeawayTicketData data : this.ticketData) {
            stringTicketData.add(data.getText());
        }
        return stringTicketData;
    }

    public boolean hasTicketData() {
        return !this.ticketData.isEmpty();
    }

    public void clearTicketData() {
        this.ticketData.clear();
    }

    public void replaceTicketData(String replace, String with) {
        for (TakeawayTicketData data : this.ticketData) {
            if (!replace.equals(data.getText())) continue;
            data.setText(with);
        }
    }

    protected void setTicketData(List<TakeawayTicketData> newTicketData) {
        this.ticketData = this.ticketData.clone();
        this.ticketData.set(newTicketData);
    }

    public boolean requiresTicketDataName(Terminal terminal) {
        return false;
    }

    public boolean requiresTicketDataEatIn(Terminal terminal) {
        return false;
    }

    public boolean requiresTicketDataStandNum(Terminal terminal) {
        return false;
    }

    @Transient
    public boolean isTotalChanged() {
        return !this.isPersistent() || !this.getTotal().equals(this.getSavedTotal());
    }

    @Transient
    public boolean isDeliverable() {
        return false;
    }

    @Override
    @Column(name="patrons")
    public int getNumPatrons() {
        return this.numPatrons;
    }

    public void setNumPatrons(int newNumPatrons) {
        int newNum = newNumPatrons;
        if (newNum > 100) {
            newNum = 100;
        }
        this.numPatrons = newNum;
    }

    @Column(name="card_id")
    public String getCardId() {
        return this.cardId;
    }

    public void setCardId(String value) {
        this.cardId = value;
    }

    @Column(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        this.comment = newComment == null || newComment.equals("") ? null : newComment;
    }

    public boolean hasComment() {
        return this.getComment() != null;
    }

    public void clearCustomerFields(EventContext context) {
        this.setCustomer(null, context);
        this.setCardId(null);
    }

    public boolean shouldAutoFillAccount() {
        return false;
    }

    @Override
    @Transient
    public List<SalesLineItem> getActiveItemsModifiable() {
        if (this.activeItems == null) {
            this.getItems();
            if (this.activeItems == null) {
                this.activeItems = new ArrayList<SalesLineItem>();
            }
        }
        return this.activeItems;
    }

    @Transient
    public List<SalesCouponUsage> getCouponUsages() {
        return this.couponUsages;
    }

    protected void setCouponUsages(List<SalesCouponUsage> usages) {
        this.couponUsages = this.couponUsages.clone();
        this.couponUsages.set(usages);
    }

    public synchronized void addSalesCouponUsage(SalesCouponUsage usage) {
        if (!this.couponUsages.contains(usage)) {
            this.couponUsages.add(usage);
        }
    }

    public synchronized void removeSalesCouponUsage(SalesCouponUsage usage) {
        this.couponUsages.remove(usage);
    }

    @Column(name="Time_Due")
    @Temporal(value=TemporalType.TIME)
    public Date getTimeDue() {
        return this.timeDue;
    }

    public void setTimeDue(Date newTimeDue) {
        this.timeDue = newTimeDue;
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            AccountTimeDueHelper.calculatePrepPrintDue(this);
        }
    }

    @Column(name="Date_Due")
    @Temporal(value=TemporalType.DATE)
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date newDateDue) {
        this.dateDue = newDateDue;
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            AccountTimeDueHelper.calculatePrepPrintDue(this);
        }
    }

    @Column(name="prep_docket_print_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getPrepPrintDue() {
        return this.prepPrintDue;
    }

    protected void setPrepPrintDue(Date newPrepPrintDue) {
        this.prepPrintDue = newPrepPrintDue;
    }

    @Transient
    public void clearPrepPrintDue() {
        this.setPrepPrintDue(null);
    }

    public boolean hasTimeDue() {
        return this.timeDue != null;
    }

    @Transient
    public String getFormattedTimeDueString() {
        return AccountTimeDueHelper.getFormattedTimeDueString(this);
    }

    private void checkAndApplyAccountRoundingIfRequired() {
        if (AccountState.CLOSED.equals((Object)this.getAccountState())) {
            double due = this.getDue().doubleValue();
            if (!this.getDue().equals(Price.ZERO_DOLLAR) && due >= -Price.EQUIVALENT_THRESHOLD && due <= Price.EQUIVALENT_THRESHOLD) {
                FinanceTransaction roundingTran = this.getExistingAccountRoundingTransaction();
                if (roundingTran == null) {
                    EventContext context = this.getEventContext();
                    CashDrawer transactionCD = null;
                    Terminal transactionTerm = context.getTerminal();
                    List<CashDrawer> cashdrawers = transactionTerm.getAvailableCashDrawers(context.getUser());
                    OrderMate.LOG.info("Performing rounding transaction, User: " + context.getUser().toString() + ", Cashdrawers Found: " + cashdrawers.toString());
                    if (!cashdrawers.isEmpty()) {
                        transactionCD = cashdrawers.get(0);
                    } else {
                        transactionTerm = Terminal.getServerMateTerminal();
                        transactionCD = CashDrawer.getOfficeCashDrawer(transactionTerm, context.getUser());
                    }
                    CashTransaction cashTransaction = new CashTransaction(new FinanceTransactionContext(new EventContext(transactionTerm, context.getUser()), transactionCD), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR);
                    cashTransaction.setRoundingAmt(this.getDue(0.01).negate());
                    this.addFinanceTransaction(cashTransaction);
                } else {
                    roundingTran.setRoundingAmt(roundingTran.getRoundingAmt().subtract(new Price(due, 0.01)));
                }
            }
        }
    }

    @Transient
    private FinanceTransaction getExistingAccountRoundingTransaction() {
        for (FinanceTransaction financeTrans : this.allFinanceTransactions) {
            if (!financeTrans.isActive() || !financeTrans.getType().equals(FinanceUnit.CASH_TYPE.toString()) || !financeTrans.getPaid().isZero() || !financeTrans.getTendered().isZero() || !financeTrans.isActive()) continue;
            return financeTrans;
        }
        return null;
    }

    @Column(name="closed_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getClosedDateTime() {
        return this.closedDateTime;
    }

    protected void setClosedDateTime(Date closedDateTime) {
        this.closedDateTime = closedDateTime;
    }

    @Column(name="mod_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getModDateTime() {
        return this.modDateTime;
    }

    protected void setModDateTime(Date modDateTime) {
        this.modDateTime = modDateTime;
    }

    @Override
    @Transient
    public List<GiftVoucherTransaction> getVoucherTxns() {
        return this.voucherTxns;
    }

    protected void setVoucherTxns(List<GiftVoucherTransaction> txns) {
        this.voucherTxns = this.voucherTxns.clone();
        this.voucherTxns.set(txns);
    }

    public boolean addVoucherTransaction(GiftVoucherTransaction txn) {
        if (txn != null) {
            txn.setAccount(this);
            if (!this.voucherTxns.contains(txn)) {
                return this.voucherTxns.add(txn);
            }
        }
        return false;
    }

    public boolean updateVoucherTransaction(GiftVoucherTransaction txn) {
        if (txn != null) {
            txn.setAccount(this);
            if (!this.voucherTxns.contains(txn)) {
                return this.voucherTxns.add(txn);
            }
            this.voucherTxns.remove(txn);
            return this.voucherTxns.add(txn);
        }
        return false;
    }

    public boolean removeVoucherTransaction(GiftVoucherTransaction txn) {
        if (txn == null) {
            return false;
        }
        return this.voucherTxns.remove(txn);
    }

    public void refreshVoucherTxns() {
        if (!this.isPersistent()) {
            return;
        }
        ArrayList<GiftVoucherTransaction> local = new ArrayList<GiftVoucherTransaction>();
        for (GiftVoucherTransaction txn : this.voucherTxns) {
            if (txn.isPersistent()) continue;
            local.add(txn);
        }
        List<GiftVoucherTransaction> voucherFreshList = PersistenceManager.getObjectList(GiftVoucherTransaction.class, Query.select(GiftVoucherTransaction.class).not().isNull(GiftVoucherTransaction.Properties.ACCOUNT).equals(GiftVoucherTransaction.Properties.ACCOUNT, this).toString());
        this.voucherTxns.clear();
        for (GiftVoucherTransaction vTxn : voucherFreshList) {
            this.addVoucherTransaction(vTxn);
        }
        this.voucherTxns.addAll(local);
    }

    public void disableNotifyClosed() {
        this.notifyClosed = false;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user_opened")
    public User getOpeningUser() {
        return this.openingUser.get();
    }

    public void setOpeningUser(User openingUser) {
        this.openingUser.set(openingUser);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user_assigned")
    public User getAssignedUser() {
        return this.assignedUser.get();
    }

    public void setAssignedUser(User assignedUser) {
        this.assignedUser.set(assignedUser);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user_closed")
    public User getClosingUser() {
        return this.closingUser.get();
    }

    public void setClosingUser(User closingUser) {
        this.closingUser.set(closingUser);
    }

    @Transient
    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Column(name="ext_href")
    public String getExtHRef() {
        return this.extHRef;
    }

    public void setExtHRef(String href) {
        this.extHRef = href;
    }

    @Column(name="source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String newSource) {
        this.source = newSource;
    }

    @Column(name="ext_docket_href")
    public String getExtDocketHRef() {
        return this.extDocketHRef;
    }

    public void setExtDocketHRef(String docketHRef) {
        this.extDocketHRef = docketHRef;
    }

    @Column(name="ext_order_id")
    public String getExtOrderID() {
        return this.extOrderID;
    }

    public void setExtOrderID(String orderID) {
        this.extOrderID = orderID;
    }

    @Column(name="ext_order_date_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getExtOrderDateTime() {
        return this.extOrderDateTime;
    }

    public void setExtOrderDateTime(Date dateTime) {
        this.extOrderDateTime = dateTime;
    }

    @Transient
    public String getExtOrigin() {
        return this.extOrigin;
    }

    public void setExtOrigin(String value) {
        this.extOrigin = value;
    }

    public static class AccountClassType
    extends PersistentEnumeration {
        public static final AccountClassType TABLE = new AccountClassType("TABLE");
        public static final AccountClassType PHONE = new AccountClassType("PHONE");
        public static final AccountClassType TAKE_AWAY = new AccountClassType("TAKE_AWAY");
        public static final AccountClassType DRIVE_THRU = new AccountClassType("DRIVE_THRU");
        public static final AccountClassType BAR_TAB = new AccountClassType("BAR_TAB");
        public static final AccountClassType REFUND = new AccountClassType("REFUND");
        public static final AccountClassType ONLINE = new AccountClassType("ONLINE");
        public static final Map register = AccountClassType.buildRegister(TABLE, PHONE, TAKE_AWAY, DRIVE_THRU, BAR_TAB, REFUND, ONLINE);

        private AccountClassType(String desc) {
            super(desc);
        }

        public static Map getRegister() {
            return register;
        }
    }

    public static class ReceiptPrintState
    extends PersistentEnumeration {
        public static final ReceiptPrintState RECEIPT_PRINTED = new ReceiptPrintState("receipt printed");
        public static final ReceiptPrintState RECEIPT_NOT_PRINTED = new ReceiptPrintState("receipt not printed");
        public static final Map<String, ReceiptPrintState> register = ReceiptPrintState.buildRegister(RECEIPT_PRINTED, RECEIPT_NOT_PRINTED);

        private ReceiptPrintState(String desc) {
            super(desc);
        }

        public static Map getRegister() {
            return register;
        }
    }

    public static class Props
    extends ItemGroup.Props {
        public PersistentObject.DerivedProperty OPEN = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Account.class), "open");
        public PropertiedObject.Property<AccountState> ACCOUNT_STATE;
        public PropertiedObject.Property<Date> CREATION_DATE_TIME;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<SalesLineItem> ITEMS;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<ReceiptPrintState> RECEIPT_STATE;
        public PropertiedObject.Property<SalesPriceAdjustment> ADJUSTMENTS;
        public PropertiedObject.Property<FinanceTransaction> ALL_FINANCE_TRANSACTIONS;
        public PropertiedObject.Property<DebtorSale> DEBTOR_SALE;
        public PropertiedObject.Property<AccountType> ACCOUNT_TYPE;
        public PropertiedObject.Property<Price> SAVED_TOTAL;
        public PropertiedObject.Property<TakeawayTicketData> TICKET_DATA;
        public PropertiedObject.Property ON_HOLD;
        public PersistentObject.DerivedProperty<String> RENDERER_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Account.class), "rendererLabel");
        public PersistentObject.DerivedProperty<String> CREATION_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Account.class), "creationTime");
        public PropertiedObject.Property NUM_PATRONS;
        public PropertiedObject.Property CARD_ID;
        public PropertiedObject.Property COMMENT;
        public PropertiedObject.Property<Date> ETA;
        public PropertiedObject.Property<SalesCouponUsage> COUPON_USAGES;
        public PropertiedObject.Property<Date> TIME_DUE;
        public PropertiedObject.Property<Date> DATE_DUE;
        public PropertiedObject.Property<Date> PREP_PRINT_DUE;
        public PropertiedObject.Property<Date> CLOSED_DATE_TIME;
        public PropertiedObject.Property<Date> MOD_DATE_TIME;
        public PropertiedObject.Property<GiftVoucherTransaction> VOUCHER_TXNS;
        public PropertiedObject.Property<User> OPENING_USER;
        public PropertiedObject.Property<User> ASSIGNED_USER;
        public PropertiedObject.Property<User> CLOSING_USER;
        public PropertiedObject.Property<String> EXT_HREF;
        public PropertiedObject.Property<String> SOURCE;
        public PropertiedObject.Property<String> EXT_ORDER_ID;
        public PropertiedObject.Property<String> EXT_DOCKET_HREF;
        public PropertiedObject.Property<Date> EXT_ORDER_DATE_TIME;
        public PropertiedObject.Property<String> EXT_ORIGIN;
    }
}

