/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.glazedlists.PropertyMatcher;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;

public class AccountItemsHelper {
    private final Account account;

    public AccountItemsHelper(Account acc) {
        this.account = acc;
    }

    public void addActiveItems(SalesItem item) {
        if (item.hasSavedItems()) {
            if (this.account.getActiveItemsModifiable() != null) {
                this.account.getActiveItemsModifiable().add(item);
            }
        } else {
            this.account.getItemHelper().addItem(item);
        }
    }

    public static List<SalesLineItem> getItemsFor(List<? extends SalesLineItem> items, PropertyAccessor prop, Object match) {
        PropertyMatcher<SalesLineItem> matcher = new PropertyMatcher<SalesLineItem>(prop);
        matcher.setMatchValue(match);
        ArrayList<SalesLineItem> matchList = new ArrayList<SalesLineItem>();
        for (SalesLineItem salesLineItem : items) {
            if (!matcher.matches(salesLineItem)) continue;
            matchList.add(salesLineItem);
        }
        return matchList;
    }

    public static List<? extends SalesLineItem> getTableCustomerItems(Account account, Customer customer) {
        if (new CustomerAssignmentHelper().isAssignmentPerSeat(account)) {
            return AccountItemsHelper.getItemsFor(account.getItemHelper().getUnpaidItems(), SalesLineItem.Properties.CUSTOMER, customer);
        }
        return account.getItemHelper().getUnpaidItems();
    }
}

