/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLocaliser;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.TransactionLocaliser;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItemQtyLocaliser;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;

public class AccountLocaliser {
    private final TradingDay day;
    private final Shift shift;

    public AccountLocaliser(TradingDay tradingDay, Shift theShift) {
        this.day = tradingDay;
        this.shift = theShift;
    }

    public void localiseAccount(Account account) {
        account.setTradingDay(this.day);
        account.setShift(this.shift);
        TransactionLocaliser txnLocal = new TransactionLocaliser(this.day, this.shift);
        List txns = (List)((Object)PropertiedObject.PropsHelper.getPropertyValue(account, Account.Properties.ALL_FINANCE_TRANSACTIONS));
        for (FinanceTransaction txn : txns) {
            txnLocal.localiseTransactions(txn);
        }
        PriceAdjustmentLocaliser adjLocal = new PriceAdjustmentLocaliser(this.day, this.shift);
        List<SalesPriceAdjustment> adjs = account.getPriceAdjustments();
        for (SalesPriceAdjustment adj : adjs) {
            adjLocal.localiseAdjustment(adj);
        }
        SalesItemQtyLocaliser qtyLocal = new SalesItemQtyLocaliser(this.day, this.shift);
        for (SalesLineItem item : account.getAllItems()) {
            for (SalesPriceAdjustment adj : item.getPriceAdjustments()) {
                adjLocal.localiseAdjustment(adj);
            }
            for (SalesItemQuantity itemQty : item.getSalesItemQuantities()) {
                qtyLocal.localiseItemQty(itemQty);
            }
        }
    }
}

