/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;

public class AccountTimeDueHelper {
    public static String getFormattedTimeDueString(Account account) {
        if (account.hasTimeDue()) {
            SimpleDateFormat formatter;
            Date dateDue;
            String output = "";
            Date date = dateDue = account.getDateDue() == null ? new Date() : account.getDateDue();
            if (!DateTimeUtils.clearTimePart(dateDue).equals(DateTimeUtils.clearTimePart(new Date()))) {
                formatter = new SimpleDateFormat("dd-MM-yy ");
                output = formatter.format(dateDue);
            }
            formatter = BusinessInfo.getInstance().getDocketHourFormat().equals("12h") ? new SimpleDateFormat("h:mm a") : new SimpleDateFormat("kk:mm:ss");
            output = output + formatter.format(account.getTimeDue());
            return output;
        }
        return null;
    }

    public static void calculatePrepPrintDue(Account account) {
        if (account.hasTimeDue()) {
            int preOrderTime = SystemProperty.getInstance().getFutureOrderDocketTime() * 60 * 1000;
            if (preOrderTime > 0) {
                Date dateDue;
                Date timeDue = account.getTimeDue();
                if (timeDue == null) {
                    timeDue = Calendar.getInstance().getTime();
                }
                if ((dateDue = account.getDateDue()) == null) {
                    dateDue = Calendar.getInstance().getTime();
                }
                Date dateTime = DateTimeUtils.combineDateAndTime(dateDue, timeDue);
                long dateTimeDueTimeInMillis = dateTime.getTime();
                Date prepPrintDueDate = new Date(dateTimeDueTimeInMillis - (long)preOrderTime);
                account.setPrepPrintDue(prepPrintDueDate);
            } else {
                account.setPrepPrintDue(null);
            }
        }
    }
}

