/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import ordermate.database.sales.Account;

public final class AccountType
extends PersistentEnumeration {
    public static final AccountType tableType = new AccountType("TABLE", "Table", "TABLE");
    public static final AccountType phoneType = new AccountType("PHONE", "Phone", "PHONE");
    public static final AccountType deliveryType = new AccountType("DELIVERY", "Delivery", "PHONE");
    public static final AccountType takeawayType = new AccountType("TAKE_AWAY", "Take away", "TAKE_AWAY");
    public static final AccountType driveThruType = new AccountType("DRIVE_THRU", "Drive Thru", "DRIVE_THRU");
    public static final AccountType barTabType = new AccountType("BAR_TAB", "Bar Tabs", "BAR_TAB");
    public static final AccountType refundType = new AccountType("REFUND", "Customer Refunds", "REFUND");
    public static final AccountType onlineDeliveryType = new AccountType("ONLINE_DELIVERY", "Online delivery", "ONLINE");
    public static final AccountType onlinePickupType = new AccountType("ONLINE_PICKUP", "Online Pickup", "ONLINE");
    public static final AccountType onlineTableType = new AccountType("ONLINE_TABLE", "Online Table", "ONLINE");
    public static final AccountType quickSaleDineInType = new AccountType("QS_DINE_IN", "Quick Sale Dine In", "QS_DINE_IN");
    public static final AccountType allType = new AccountType("ALL", "All", "ALL");
    public static final Map<String, ? extends AccountType> register = AccountType.buildRegister(tableType, phoneType, deliveryType, takeawayType, driveThruType, refundType, barTabType, onlineDeliveryType, onlinePickupType, onlineTableType, quickSaleDineInType);
    public static final AccountType[] TYPES = register.values().toArray(new AccountType[0]);
    private final String discriminator;
    public static final Map<String, AccountType> onlineAccountTypes = PersistentEnumeration.buildRegister(onlineDeliveryType, onlinePickupType, onlineTableType);

    public static Map<String, ? extends AccountType> getRegister() {
        return register;
    }

    private AccountType(String newType, String newTypeDisplayName, String newDiscriminator) {
        super(newType, newTypeDisplayName);
        this.discriminator = newDiscriminator;
    }

    public String getType() {
        return super.toString();
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public String getCapitilizedLabel() {
        return StringUtils.capitalize(super.getLabel());
    }

    public static AccountType[] getTypes() {
        return register.values().toArray(new AccountType[register.size()]);
    }

    public static Collection<AccountType> getOnlineAccountTypes() {
        return Collections.unmodifiableCollection(onlineAccountTypes.values());
    }

    public static boolean isOnline(Account account) {
        return onlineDeliveryType.equals(account.getAccountType()) || onlinePickupType.equals(account.getAccountType()) || onlineTableType.equals(account.getAccountType());
    }
}

