/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.CreditLimited;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.AbstractTakeawayAccount;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabAdministrator;
import ordermate.integration.bartabs.clipp.ClippBarTabAuthority;
import ordermate.integration.reservations.ReservationNotifier;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="BAR_TAB")
@AccessType(value="property")
public class BarTabAccount
extends AbstractTakeawayAccount
implements CreditLimited {
    public static final AccountType TYPE = AccountType.barTabType;
    public static final Props Properties = new Props();
    private String tabName = null;
    private Price creditLimit = Price.ZERO_DOLLAR;
    private Reference<LogicalTable> logicalTable;

    public BarTabAccount() {
        super(TYPE);
        this.logicalTable = this.createReference(BarTabAccount.Properties.LOGICAL_TABLE);
        this.tabName = "New Bar Tab";
    }

    public BarTabAccount(User createUser, Terminal createdOn, String name) {
        super(createUser, createdOn, TYPE);
        this.logicalTable = this.createReference(BarTabAccount.Properties.LOGICAL_TABLE);
        this.tabName = name;
        this.creditLimit = SystemProperty.getInstance().getTabCreditLimit();
    }

    @Override
    @Transient
    public boolean isSaveEmptyAllowed() {
        return true;
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return true;
    }

    @Override
    public boolean allowsPrintMove() {
        if (SystemProperty.getInstance() != null) {
            return SystemProperty.getInstance().isPrintBarTabTransfers();
        }
        return false;
    }

    @Override
    @Transient
    public String getLabel() {
        String name = "Unnamed Bar Tab";
        if (this.getSource() != null && ClippBarTabAuthority.VENDOR.getId().equals(this.getSource())) {
            return ClippBarTabAuthority.getBarTabName(this);
        }
        if (this.tabName != null) {
            name = this.tabName;
        }
        StringBuilder SB = new StringBuilder(name);
        if (this.hasCustomer()) {
            SB.append(" - ").append(this.getCustomer().getName());
        }
        return SB.toString();
    }

    @Override
    @Transient
    public String getIcon() {
        if (this.hasCustomer()) {
            return "/waitermate/images/customerSingle.png";
        }
        return "";
    }

    @Transient
    public LogicalTable getLogicalTable() {
        if (this.logicalTable == null) {
            OrderMate.LOG.warn("The logicalTable is not yet initialized, returning null.");
            return null;
        }
        return this.logicalTable.get();
    }

    protected void setLogicalTable(LogicalTable value) {
        this.logicalTable.set(value);
    }

    @Column(name="tab_name")
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public void save() {
        boolean firstSave = !this.isPersistent();
        LogicalTable tableLinked = this.getLogicalTable();
        if (!this.isOpen()) {
            this.delinkFromLogicalTable();
            ReservationNotifier.notifyForDelinkedAccount(tableLinked, this, ReservationNotifier.DelinkReason.CLOSE);
        }
        if (tableLinked != null) {
            tableLinked.saveChild();
        }
        boolean needToNotifyAuth = this.notifyClosed;
        super.save();
        if (firstSave) {
            TerminalEventLog.logBarTabCreation(this.getUser(), Terminal.getLocalHost(), this.tabName);
        }
        if (!firstSave && this.getSource() != null && !this.getSource().isEmpty()) {
            BarTabAdministrator.getInstance().barTabUpdated(this);
        }
        if (needToNotifyAuth) {
            BarTabAdministrator.getInstance().requestCloseBarTab(this);
        }
    }

    @Override
    public void printPrepDockets(Terminal printedFrom) throws Exception {
        super.printPrepDockets(printedFrom);
    }

    public void printTransferPrepDockets(Account targetAccount, Terminal printedFrom) throws Exception {
        PrepDocketHelper.create(this).markItemsAsPrinted();
    }

    @Override
    @Column(name="credit_limit")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getCreditLimit() {
        return this.creditLimit;
    }

    @Override
    public void setCreditLimit(Price newLimit) {
        this.creditLimit = newLimit;
    }

    @Override
    @Transient
    public Price getCreditLimitRemaining() {
        if (this.creditLimit == null) {
            this.creditLimit = Price.ZERO_DOLLAR;
        }
        return this.creditLimit.subtract(this.getTotal().subtract(this.getPaid()));
    }

    @Override
    public boolean exceedsCreditLimit(Price newSaleAmount) {
        return this.getCreditLimitRemaining().subtract(newSaleAmount).lessThan(Price.ZERO_DOLLAR);
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        Payable.PaidState paidState;
        if (this.isLocked()) {
            return ACCOUNT_LOCKED;
        }
        Payable.PaidState paidState2 = paidState = this.getSavedTotal().subtract(this.getPaid()).greaterThan(Price.ZERO_DOLLAR) ? NOT_PAID : PAID;
        if (paidState.equals(PAID) || paidState.equals(CREDIT)) {
            return PAID_COLOR;
        }
        if (paidState.equals(NOT_PAID)) {
            return OVERDUE_COLOR;
        }
        return super.getBackgroundColor();
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public void linkToLogicalTable(LogicalTable toLink) {
        this.setLogicalTable(toLink);
        if (toLink != null) {
            toLink.linkBarTab(this);
            this.setLogicalTableState(toLink, AccountState.OPEN);
        }
        this.getPriceAdjHelper().applyAutomaticAdjustment(this.getEventContext(), null);
    }

    public LogicalTable delinkFromLogicalTable() {
        LogicalTable table = this.getLogicalTable();
        if (table != null) {
            this.setLogicalTable(null);
            table.delinkBarTab(this);
            if (table.getBarTabs().isEmpty()) {
                this.setLogicalTableState(table, AccountState.CLOSED);
            }
        }
        return table;
    }

    private void setLogicalTableState(LogicalTable table, AccountState accState) {
        LogicalTableState tableState = LogicalTableState.getStateFor(accState);
        if (table.getTableState() == null || !table.getTableState().equals(tableState)) {
            table.updateTableState(tableState, new EventContext(this.getUser()));
        }
    }

    @Transient
    public boolean isIntegrationAccount() {
        return this.getSource() != null && !this.getSource().isEmpty();
    }

    @Override
    @Transient
    public boolean isCreditLimitChangeAllowed() {
        return !this.isIntegrationAccount() || BarTabAdministrator.getInstance().getBarTabAuthorityForAccount(this).isCreditLimitModifiable(this);
    }

    public static class Props
    extends AbstractTakeawayAccount.Props {
        public PropertiedObject.Property<String> TAB_NAME;
        public PropertiedObject.Property<Price> CREDIT_LIMIT;
        public PropertiedObject.Property<LogicalTable> LOGICAL_TABLE;
    }
}

