/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.List;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.TableAccount;
import ordermate.database.users.User;
import ordermate.scheduler.Task;

public class ClosePaidUnallocatedTableTask
implements Task {
    public static final String NAME = "Close Paid Unallocated Table Task";
    private static final Semaphore closePaidUnallocatedTableLock = new Semaphore(1);

    @Override
    public void run() {
        if (!closePaidUnallocatedTableLock.tryAcquire()) {
            OrderMate.LOG.warn("close Paid Unallocated Table : Lock already in use");
            return;
        }
        try {
            this.closePaidUnallocatedTable();
        }
        finally {
            closePaidUnallocatedTableLock.release();
        }
    }

    private void closePaidUnallocatedTable() {
        List<TableAccount> accs = PersistenceManager.getObjectList(TableAccount.class, Query.select(TableAccount.class).equals(TableAccount.Properties.ACCOUNT_STATE, "OPEN").equals(TableAccount.Properties.ACCOUNT_TYPE, "TABLE").isNull(TableAccount.Properties.TABLE).toString());
        Terminal.setupLocalhost("ServerMate");
        Terminal.getLocalHost();
        EventContext context = new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser());
        for (TableAccount tableAcc : accs) {
            if (!Price.ZERO_DOLLAR.equals(tableAcc.getDue())) continue;
            OrderMate.LOG.info("Close Unallocated Table Account: " + tableAcc);
            tableAcc.lock(context.getUser());
            tableAcc.closeUnchecked(context);
            tableAcc.save();
            tableAcc.unlock();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
    }
}

