/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.course.CourseHoldStrategy;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;

public class CourseHoldStrategyHelper {
    public static List<SalesAccountCourse> createSalesAccountCourseLinks(TableAccount tableAccount) {
        ArrayList<SalesAccountCourse> salesAccountCourses = new ArrayList<SalesAccountCourse>();
        Course.clearCache();
        List<Course> courseList = Course.getCourses();
        for (Course course : courseList) {
            SalesAccountCourse salesAccountCourse = CourseHoldStrategyHelper.createSalesAccountCourseLink(tableAccount, course);
            salesAccountCourses.add(salesAccountCourse);
        }
        return salesAccountCourses;
    }

    private static SalesAccountCourse createSalesAccountCourseLink(TableAccount account, Course course) {
        SalesAccountCourse salesAccountCourse = new SalesAccountCourse();
        salesAccountCourse.setTableAccount(account);
        salesAccountCourse.setCourse(course);
        CourseHoldStrategy courseHoldStrategy = course.getCourseHoldStrategy();
        if (courseHoldStrategy == CourseHoldStrategy.FORCE_COURSE_PRINTING_TO_HOLD) {
            salesAccountCourse.setCoursePrintStatus(CoursePrintStatus.HOLD);
        }
        return salesAccountCourse;
    }

    public static boolean isCourseHoldEnabled(TableAccount account, int courseIndex) {
        String[] courseNames = Account.getCourses();
        Course course = Course.getCourseByName(courseNames[courseIndex]);
        return course.getCourseHoldStrategy() != CourseHoldStrategy.DISABLED;
    }
}

