/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.RequiredFields;
import ordermate.database.config.CustomerGroup;
import ordermate.database.config.customer.CustomerInterest;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.LoyaltyType;
import ordermate.database.misc.enums.PhoneOrderForceContactStrategy;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerPoints;
import ordermate.database.sales.Gender;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.customer.CustomerInterestLink;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import ordermate.database.web.CustomerWebInfo;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="sales_customer")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Customer
extends PersistentObject
implements Saveable,
RequiredFields,
Displayable {
    public static final Props Properties = new Props();
    public static final String CUSTOMER_TYPE = "CUSTOMER";
    public static final String MEMBER_TYPE = "MEMBER";
    private String title = "";
    private String firstName = "";
    private String lastName = "";
    private String primaryPhoneNumber;
    private String secondaryPhoneNumber;
    private String email = "";
    private boolean receiveMarketing = true;
    private Date DOB;
    private Date anniversary;
    private String company = "";
    private String occupation = "";
    private Gender gender;
    private String roomAptNumber = "";
    private String houseNumber = "";
    private String streetName = "";
    private String streetType = "";
    private String suburb = "";
    private String state = "";
    private String postcode = "";
    private String streetDirRef = "";
    private Reference<CustomerPoints> customerPoints;
    private String cardID;
    private String systemState;
    private String type;
    private String comments;
    private Date mod;
    private boolean receiveDebtorInvoice;
    private Date creationTime;
    private transient boolean displayedComments;
    private Reference<InventoryPriceAdjustment> priceAdjustment;
    private Reference<CustomerCategory> category;
    private PersistentList<BarTabAccount> tabs;
    private Reference<ConfigSmallImage> image;
    private String extWebId;
    private String extOrigin;
    public static final List<PropertiedObject.Property> REQUIRE_BASIC = Collections.unmodifiableList(Arrays.asList(Customer.Properties.FIRST_NAME, Customer.Properties.PRIMARY_PHONE_NUMBER));
    public static final List<PropertiedObject.Property> REQUIRE_EMAIL = Collections.unmodifiableList(Arrays.asList(Customer.Properties.FIRST_NAME, Customer.Properties.E_MAIL));
    public static final List<PropertiedObject.Property> REQUIRE_EMAIL_ONLY = Collections.unmodifiableList(Arrays.asList(Customer.Properties.E_MAIL));
    public static final List<PropertiedObject.Property> REQUIRE_PHONE = Collections.unmodifiableList(Arrays.asList(Customer.Properties.PRIMARY_PHONE_NUMBER));
    public static final List<PropertiedObject.Property> REQUIRE_FIRST_NAME = Collections.unmodifiableList(Arrays.asList(Customer.Properties.FIRST_NAME));
    public static final List<PropertiedObject.Property> REQUIRE_ADDRESS = Collections.unmodifiableList(Arrays.asList(Customer.Properties.FIRST_NAME, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.SUBURB, Customer.Properties.STATE, Customer.Properties.STREET_TYPE));
    public static final List<PropertiedObject.Property> REQUIRE_ADDRESS_AND_EMAIL = Collections.unmodifiableList(Arrays.asList(Customer.Properties.FIRST_NAME, Customer.Properties.HOUSE_NUMBER, Customer.Properties.STREET_NAME, Customer.Properties.SUBURB, Customer.Properties.STATE, Customer.Properties.STREET_TYPE, Customer.Properties.E_MAIL));
    private static final List<PropertiedObject.Property> list = new ArrayList<PropertiedObject.Property>();
    private transient Set<LoyaltyPointTransaction> loyaltyPointTransactions;
    private PersistentWriteableList<CustomerInterestLink> interestLinks;
    private transient int loyaltyPoints;
    private Reference<CustomerGroup> customerGroup;
    private CustomerWebInfo webInfo;
    private transient Date localCreationTime;
    public static final List REQUIRE_BASIC_AND_ADDRESS;

    public Customer() {
        this.customerPoints = this.createReference(Customer.Properties.CUSTOMER_POINTS);
        this.cardID = "";
        this.systemState = "ACTIVE";
        this.type = CUSTOMER_TYPE;
        this.comments = "";
        this.displayedComments = false;
        this.priceAdjustment = this.createReference(Customer.Properties.PRICE_ADJUSTMENT);
        this.category = this.createReference(Customer.Properties.CATEGORY);
        this.tabs = this.createList(Customer.Properties.TABS);
        this.image = this.createReference(Customer.Properties.IMAGE);
        this.interestLinks = this.createWriteableList(Customer.Properties.INTEREST_LINKS);
        this.customerGroup = this.createReference(Customer.Properties.CUSTOMER_GROUP);
        this.localCreationTime = new Date();
    }

    public void shallowCopy(Customer toCopy) {
        this.title = toCopy.title;
        this.firstName = toCopy.firstName;
        this.lastName = toCopy.lastName;
        this.comments = toCopy.comments;
        this.email = toCopy.email;
        this.streetDirRef = toCopy.streetDirRef;
        this.roomAptNumber = toCopy.roomAptNumber;
        this.houseNumber = toCopy.houseNumber;
        this.streetName = toCopy.streetName;
        this.streetType = toCopy.streetType;
        this.suburb = toCopy.suburb;
        this.state = toCopy.state;
        this.postcode = toCopy.postcode;
        this.cardID = toCopy.cardID;
        this.customerPoints.set(toCopy.getCustomerPoints());
        this.receiveMarketing = toCopy.receiveMarketing;
        this.primaryPhoneNumber = toCopy.primaryPhoneNumber;
        this.secondaryPhoneNumber = toCopy.secondaryPhoneNumber;
        this.company = toCopy.company;
        this.occupation = toCopy.occupation;
        this.DOB = toCopy.DOB;
        this.anniversary = toCopy.anniversary;
        this.interestLinks = toCopy.interestLinks;
        this.systemState = toCopy.systemState;
        this.type = toCopy.type;
        this.priceAdjustment.set(toCopy.getPriceAdjustment());
        this.category.set(toCopy.getCategory());
        this.mod = toCopy.getMod();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    @Transient
    public String getLabel() {
        StringBuffer label = new StringBuffer();
        label.append("<html>");
        label.append(" ").append(this.getName());
        if (SystemProperty.getInstance().isLoyaltyEnabled() && this.getCategory() != null && this.getCategory().isLoyaltyPointsEnabled()) {
            label.append(" (").append(this.getLoyaltyPointsString()).append(")");
        }
        label.append("<br>");
        if (this.appendIfNotNull(label, this.getPhoneNumbers(), false)) {
            label.append("<br>");
        }
        this.appendIfNotNull(label, this.getRoomAptNumber(), true);
        this.appendIfNotNull(label, this.getHouseNumber(), true);
        this.appendIfNotNull(label, this.getStreetName(), true);
        this.appendIfNotNull(label, this.getStreetType(), true);
        this.appendIfNotNull(label, this.getSuburb(), true);
        this.appendIfNotNull(label, this.getState(), true);
        this.appendIfNotNull(label, this.getPostcode(), true);
        label.append("</html>");
        return label.toString();
    }

    private boolean appendIfNotNull(StringBuffer strBuffer, String strToAppend, boolean appendWithSpace) {
        if (strToAppend != null && !strToAppend.equals("")) {
            if (appendWithSpace) {
                strBuffer.append(" ");
            }
            strBuffer.append(strToAppend);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getNameAndTitle();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Column(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle != null ? newTitle : "";
    }

    @Column(name="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String newFirstName) {
        this.firstName = newFirstName;
    }

    @Column(name="last_name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String newLastName) {
        this.lastName = newLastName;
    }

    @Column(name="primary_phone")
    public String getPrimaryPhoneNumber() {
        if (this.primaryPhoneNumber == null) {
            this.primaryPhoneNumber = "";
        }
        return this.primaryPhoneNumber;
    }

    public void setPrimaryPhoneNumber(String newPhoneNumber) {
        this.primaryPhoneNumber = newPhoneNumber;
    }

    @Column(name="secondary_phone")
    public String getSecondaryPhoneNumber() {
        if (this.secondaryPhoneNumber == null) {
            this.secondaryPhoneNumber = "";
        }
        return this.secondaryPhoneNumber;
    }

    public void setSecondaryPhoneNumber(String newPhoneNumber) {
        this.secondaryPhoneNumber = newPhoneNumber != null ? newPhoneNumber : "";
    }

    @Column(name="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String newEmail) {
        this.email = newEmail != null ? newEmail : "";
    }

    @Column(name="receive_marketing")
    public boolean getReceiveMarketing() {
        return this.receiveMarketing;
    }

    public void setReceiveMarketing(boolean newReceiveMarketing) {
        this.receiveMarketing = newReceiveMarketing;
    }

    @Column(name="dob")
    @Temporal(value=TemporalType.DATE)
    public Date getDOB() {
        return this.DOB;
    }

    public void setDOB(Date newDOB) {
        this.DOB = newDOB;
    }

    @Column(name="anniversary")
    @Temporal(value=TemporalType.DATE)
    public Date getAnniversary() {
        return this.anniversary;
    }

    public void setAnniversary(Date newAnniversary) {
        this.anniversary = newAnniversary;
    }

    @Column(name="occupation")
    public String getOccupation() {
        return this.occupation;
    }

    public void setOccupation(String newOccupation) {
        this.occupation = newOccupation != null ? newOccupation : "";
    }

    @Column(name="company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String newCompany) {
        this.company = newCompany != null ? newCompany : "";
    }

    @Column(name="room_apt_number")
    public String getRoomAptNumber() {
        return this.roomAptNumber;
    }

    public void setRoomAptNumber(String number) {
        this.roomAptNumber = number;
    }

    @Column(name="house_number")
    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String newHouseNumber) {
        this.houseNumber = newHouseNumber;
    }

    @Column(name="street_name")
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String newStreetName) {
        this.streetName = newStreetName;
    }

    @Column(name="street_type")
    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String newStreetType) {
        this.streetType = newStreetType;
    }

    @Column(name="suburb")
    public String getSuburb() {
        return this.suburb;
    }

    public void setSuburb(String newSuburb) {
        this.suburb = newSuburb;
    }

    @Column(name="state")
    public String getState() {
        if (this.state != null) {
            return this.state;
        }
        return "";
    }

    public void setState(String newState) {
        this.state = newState;
    }

    @Column(name="postcode")
    public String getPostcode() {
        if (this.postcode != null) {
            return this.postcode;
        }
        return "";
    }

    public void setPostcode(String newPostcode) {
        this.postcode = newPostcode;
    }

    @Column(name="street_directory_ref")
    public String getStreetDirRef() {
        return this.streetDirRef;
    }

    public void setStreetDirRef(String newRef) {
        this.streetDirRef = newRef;
    }

    @Transient
    public int getLoyaltyPoints() {
        this.ensureHasPoints();
        this.loyaltyPoints = this.getCustomerPoints().getTotalPoints();
        return this.loyaltyPoints;
    }

    public void setLoyaltyPoints(int points) {
        this.ensureHasPoints();
        this.loyaltyPoints = points;
        this.getCustomerPoints().setTotalPoints(points);
    }

    @Transient
    public String getLoyaltyPointsString() {
        if (LoyaltyType.DOLLARS.equals(SystemProperty.getInstance().getLoyaltyPointsType())) {
            return new Price((double)this.getLoyaltyPoints() / 100.0, 0.01).toString();
        }
        return this.getLoyaltyPoints() + "";
    }

    @Column(name="card_id")
    public String getCardID() {
        return this.cardID;
    }

    public void setCardID(String newCardID) {
        this.cardID = newCardID;
    }

    @Column(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType != null ? theType : "";
    }

    @ManyToOne
    @JoinColumn(name="FK_config_price_adjustment")
    public InventoryPriceAdjustment getPriceAdjustment() {
        return this.priceAdjustment.get();
    }

    public void setPriceAdjustment(InventoryPriceAdjustment adjustment) {
        this.priceAdjustment.set(adjustment);
    }

    public boolean hasPriceAdjustment() {
        return this.priceAdjustment.get() != null;
    }

    public void setCategory(CustomerCategory newCategory) {
        if (newCategory != null) {
            this.category.set(newCategory);
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_customer_category")
    public CustomerCategory getCategory() {
        return this.category.get();
    }

    @Transient
    public String getCategoryLabel() {
        CustomerCategory cat = this.getCategory();
        return cat == null ? "None" : cat.getLabel();
    }

    @Transient
    public List<BarTabAccount> getTabs() {
        return this.tabs.getUnmodifiable();
    }

    protected void setTabs(List<BarTabAccount> barTabs) {
        this.tabs = this.tabs.clone();
        this.tabs.set(barTabs);
    }

    @Override
    public boolean getMeetsRequirements(List requiredProperties) {
        return RequiredFields.RequiredFieldsValidator.validate(this, requiredProperties);
    }

    @Override
    public boolean getMeetsRequirement(PropertiedObject.Property prop) {
        try {
            Object value = PropertyUtils.getProperty((Object)this, (String)prop.getName());
            if (value == null) {
                return false;
            }
            if (prop == Customer.Properties.PRIMARY_PHONE_NUMBER) {
                String stringValue = value.toString();
                String areaCodePrefix = BusinessInfo.getInstance().getPhoneAreaCodePrefix();
                if (SystemProperty.getInstance().getPhoneOrderForceStrategy().equals(PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_PHONE) || SystemProperty.getInstance().getPhoneOrderForceStrategy().equals(PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_BOTH)) {
                    return stringValue.length() >= 5;
                }
                return stringValue.isEmpty() || stringValue.equals(areaCodePrefix) || stringValue.length() > 6;
            }
            if (value.toString().length() > 0) {
                return true;
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        return false;
    }

    @Transient
    public String getName() {
        StringBuffer buffer = new StringBuffer();
        Customer.appendIfNotEmpty(buffer, this.getFirstName(), true);
        Customer.appendIfNotEmpty(buffer, this.getLastName(), false);
        return buffer.toString();
    }

    @Transient
    public String getNameAndTitle() {
        StringBuffer buffer = new StringBuffer();
        Customer.appendIfNotEmpty(buffer, this.getTitle(), true);
        Customer.appendIfNotEmpty(buffer, this.getName(), false);
        return buffer.toString();
    }

    @Transient
    public String getNameAndNumber() {
        StringBuffer buffer = new StringBuffer();
        Customer.appendIfNotEmpty(buffer, this.getName(), true);
        Customer.appendIfNotEmpty(buffer, this.getPhoneNumbers(), false);
        return buffer.toString();
    }

    @Transient
    public String getPhoneNumbers() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPrimaryPhoneNumber() != null && this.getPrimaryPhoneNumber().length() > 2) {
            Customer.appendIfNotEmpty(buffer, "P: ", this.getPrimaryPhoneNumber(), true);
        }
        if (this.getSecondaryPhoneNumber() != null && this.getSecondaryPhoneNumber().length() > 2) {
            Customer.appendIfNotEmpty(buffer, "S: ", this.getSecondaryPhoneNumber(), false);
        }
        return buffer.toString();
    }

    @Transient
    public String getAddress() {
        StringBuffer buffer = new StringBuffer();
        Customer.appendIfNotEmpty(buffer, null, " / ", this.getRoomAptNumber(), true);
        Customer.appendIfNotEmpty(buffer, this.getHouseNumber(), true);
        Customer.appendIfNotEmpty(buffer, this.getStreetName(), true);
        Customer.appendIfNotEmpty(buffer, this.getStreetType(), true);
        Customer.appendIfNotEmpty(buffer, this.getSuburb(), true);
        Customer.appendIfNotEmpty(buffer, this.getPostcode(), false);
        return buffer.toString();
    }

    @Transient
    public String getAddressForPost() {
        StringBuffer buffer = new StringBuffer();
        Customer.appendIfNotEmpty(buffer, null, " / ", this.getRoomAptNumber(), true);
        Customer.appendIfNotEmpty(buffer, this.getHouseNumber(), true);
        Customer.appendIfNotEmpty(buffer, this.getStreetName(), true);
        Customer.appendIfNotEmpty(buffer, this.getStreetType(), true);
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        Customer.appendIfNotEmpty(buffer, this.getSuburb() + "  ", true);
        Customer.appendIfNotEmpty(buffer, this.getPostcode(), false);
        return buffer.toString();
    }

    @Transient
    public String getAddressNoSuburbPostCode() {
        StringBuffer buffer = new StringBuffer();
        Customer.appendIfNotEmpty(buffer, null, " / ", this.getRoomAptNumber(), true);
        Customer.appendIfNotEmpty(buffer, this.getHouseNumber(), true);
        Customer.appendIfNotEmpty(buffer, this.getStreetName(), true);
        Customer.appendIfNotEmpty(buffer, this.getStreetType(), true);
        return buffer.toString();
    }

    @Transient
    public String getPhoneNumber() {
        String phone = "";
        if (this.getPrimaryPhoneNumber() != null) {
            phone = this.getPrimaryPhoneNumber();
        } else if (this.getSecondaryPhoneNumber() != null) {
            phone = this.getSecondaryPhoneNumber();
        }
        return phone;
    }

    @Transient
    public boolean isDisplayedComments() {
        return this.displayedComments;
    }

    public void setDisplayedComments(boolean displayed) {
        this.displayedComments = displayed;
    }

    @Column(name="comments")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String newComments) {
        this.comments = newComments;
    }

    private static void appendIfNotEmpty(StringBuffer buffer, String value, boolean space) {
        Customer.appendIfNotEmpty(buffer, null, null, value, space);
    }

    private static void appendIfNotEmpty(StringBuffer buffer, String prefix, String value, boolean space) {
        Customer.appendIfNotEmpty(buffer, prefix, null, value, space);
    }

    private static void appendIfNotEmpty(StringBuffer buffer, String prefix, String suffix, String value, boolean space) {
        if (value != null && !value.equals("")) {
            if (prefix != null) {
                buffer.append(prefix);
            }
            buffer.append(value);
            if (suffix != null) {
                buffer.append(suffix);
            }
            if (space) {
                buffer.append(" ");
            }
        }
    }

    @Override
    public void save() {
        if (this.primaryPhoneNumber == null) {
            this.primaryPhoneNumber = BusinessInfo.getInstance().getPhoneAreaCodePrefix();
        }
        if (this.secondaryPhoneNumber == null) {
            this.secondaryPhoneNumber = BusinessInfo.getInstance().getPhoneAreaCodePrefix();
        }
        if (this.category.get() == null) {
            this.setCategory(CustomerCategory.getDefaultCategory());
        }
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            this.saveLoyaltyPointTxns();
            this.mod = HOConfig.getInstance() != null && HOConfig.getInstance().isEnabled() ? new Date(System.currentTimeMillis() + HOConfig.getInstance().getTimeDifference()) : new Date();
        } else {
            this.mod = new Date();
        }
        if (!this.isPersistent()) {
            this.localCreationTime = new Date();
        }
        PersistenceManager.save(this);
        this.interestLinks.saveChild();
        if (!PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            this.ensureHasPoints();
            this.getCustomerPoints().save();
        }
    }

    private synchronized void saveLoyaltyPointTxns() {
        if (this.loyaltyPointTransactions == null) {
            return;
        }
        for (LoyaltyPointTransaction txn : this.getLoyaltyPointTransactions()) {
            txn.saveChild();
        }
        this.getLoyaltyPointTransactions().clear();
        LoyaltyPointAdministrator.getInstance().updatePointsForCustomer(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return !this.getLoyaltyPointTransactions().isEmpty() || PersistenceManager.hasChanged(this);
    }

    public Account loadLastOrder() {
        if (this.isPersistent()) {
            Account tempAccount = PersistenceManager.getObject(Account.class, "SELECT DISTINCT sales_account.* FROM sales_account, sales_item WHERE sales_item.FK_sales_account = sales_account.ID AND sales_item.FK_sales_customer = ? ORDER BY ID DESC LIMIT 1", new Object[]{this.getID()});
            return tempAccount;
        }
        return null;
    }

    public static Customer getCustomerByCard(String data) {
        return new CustomerCardHelper().getCustomerByCard(data);
    }

    public static ObjectQuery getAllCustomersWithSales(Date from, Date to) {
        return Query.select(Customer.class).distinct().linkUsing(Customer.Properties.ID, SalesItem.Properties.CUSTOMER).linkUsing(Account.Properties.ID, SalesItem.Properties.ACCOUNT).active(Customer.class).not().isNull(Account.Properties.CUSTOMER).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.CLOSED).wherePropertyBetween(Account.Properties.CREATION_DATE_TIME, from, to, SQLDateType.TIMESTAMP).orderBy(Customer.Properties.LAST_NAME).orderBy(Customer.Properties.FIRST_NAME);
    }

    public static List<Customer> getSomeCustomers(Integer limit) {
        return PersistenceManager.getObjectList(Customer.class, "SELECT sales_customer.* FROM sales_customer WHERE system_state = 'ACTIVE' ORDER BY sales_customer.first_name, sales_customer.last_name LIMIT ?", new Object[]{limit});
    }

    public void setSystemState(String sysState) {
        this.systemState = sysState;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Column(name="modTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getMod() {
        return this.mod;
    }

    public void setMod(Date value) {
        this.mod = value;
    }

    @OneToOne(mappedBy="customer", cascade={CascadeType.ALL})
    public CustomerPoints getCustomerPoints() {
        return this.customerPoints.get();
    }

    @PrePersist
    public void hibernatePrepersist() {
        if (this.mod == null) {
            this.mod = new Date();
        }
        this.ensureHasPoints();
    }

    @PreUpdate
    public void hibernatePreupdate() {
        this.mod = new Date();
    }

    public void ensureHasPoints() {
        if (this.customerPoints.get() == null) {
            OrderMate.LOG.info("Could not find CustomerPoints, creating new one.");
            this.setCustomerPoints(new CustomerPoints(this));
        }
    }

    protected void setCustomerPoints(CustomerPoints points) {
        this.customerPoints.set(points);
    }

    public synchronized void loyaltyPointTransactionAdded(LoyaltyPointTransaction txn) {
        if (txn != null && txn.getCustomer().equals(this)) {
            this.getCustomerPoints().addToPoints(txn.getAmount());
            this.getLoyaltyPointTransactions().add(txn);
        }
    }

    public synchronized void loyaltyPointTransactionRemoved(LoyaltyPointTransaction txn) {
        if (txn != null && txn.getCustomer().equals(this) && SystemState.ACTIVE_STATE.equals(txn.getSystemState())) {
            this.getCustomerPoints().addToPoints(-txn.getAmount());
            if (!txn.isPersistent()) {
                this.getLoyaltyPointTransactions().remove(txn);
            } else if (!this.getLoyaltyPointTransactions().contains(txn)) {
                this.getLoyaltyPointTransactions().add(txn);
            }
        }
    }

    @Transient
    private synchronized Set<LoyaltyPointTransaction> getLoyaltyPointTransactions() {
        if (this.loyaltyPointTransactions == null) {
            this.loyaltyPointTransactions = new HashSet<LoyaltyPointTransaction>();
        }
        return this.loyaltyPointTransactions;
    }

    @OneToOne(mappedBy="customer", cascade={CascadeType.ALL})
    public CustomerWebInfo getWebInfo() {
        return this.webInfo;
    }

    public void setWebInfo(CustomerWebInfo newWebInfo) {
        this.webInfo = newWebInfo;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="FK_config_customer_group")
    public CustomerGroup getCustomerGroup() {
        return this.customerGroup.get();
    }

    public void setCustomerGroup(CustomerGroup newCustomerGroup) {
        this.customerGroup.set(newCustomerGroup);
    }

    @Column(name="gender")
    @Enumerated(value=EnumType.STRING)
    @Basic(optional=true)
    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender newValue) {
        this.gender = newValue;
    }

    @Column(name="receive_debtor_invoice")
    public boolean isReceiveDebtorInvoice() {
        return this.receiveDebtorInvoice;
    }

    public void setReceiveDebtorInvoice(boolean value) {
        this.receiveDebtorInvoice = value;
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationTime() {
        return this.creationTime != null ? this.creationTime : this.localCreationTime;
    }

    protected void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Transient
    public ConfigSmallImage getImage() {
        return this.image.get();
    }

    public void setImage(ConfigSmallImage image) {
        this.image.set(image);
    }

    @Column(name="ext_web_ID")
    public String getExtWebId() {
        return this.extWebId;
    }

    public void setExtWebId(String extWebId) {
        this.extWebId = extWebId;
    }

    @Transient
    public String getExtOrigin() {
        return this.extOrigin;
    }

    public void setExtOrigin(String value) {
        this.extOrigin = value;
    }

    @OneToMany(mappedBy="customer", targetEntity=CustomerInterestLink.class, cascade={CascadeType.PERSIST})
    protected List<CustomerInterestLink> getInterestLinks() {
        return this.interestLinks;
    }

    protected void setInterestLinks(List<CustomerInterestLink> values) {
        this.interestLinks = this.interestLinks.clone();
        this.interestLinks.set(values);
    }

    public void addInterest(CustomerInterest interest) {
        if (this.isNewInterest(interest)) {
            CustomerInterestLink interestLink = new CustomerInterestLink(this, interest);
            this.interestLinks.add(interestLink);
        }
    }

    public void removeInterest(CustomerInterest interest) {
        CustomerInterestLink interestLink = this.getInterestLink(interest);
        if (interestLink != null) {
            this.interestLinks.remove(interestLink);
            interestLink.deleteChild();
        }
    }

    public void updateInterests(Set<CustomerInterest> newInterests) {
        Set<CustomerInterest> existingInterests = this.getInterests();
        for (CustomerInterest existingInterest : existingInterests) {
            if (newInterests.contains(existingInterest)) continue;
            this.removeInterest(existingInterest);
        }
        for (CustomerInterest interest : newInterests) {
            if (existingInterests.contains(interest)) continue;
            this.addInterest(interest);
        }
    }

    private boolean isNewInterest(CustomerInterest interest) {
        for (CustomerInterestLink interestLink : this.interestLinks) {
            if (!interestLink.getInterest().equals(interest)) continue;
            return false;
        }
        return true;
    }

    private CustomerInterestLink getInterestLink(CustomerInterest interest) {
        for (CustomerInterestLink interestLink : this.interestLinks) {
            if (!interestLink.getInterest().equals(interest)) continue;
            return interestLink;
        }
        return null;
    }

    @Transient
    public Set<CustomerInterest> getInterests() {
        HashSet<CustomerInterest> interests = new HashSet<CustomerInterest>();
        for (CustomerInterestLink link : this.interestLinks) {
            interests.add(link.getInterest());
        }
        return interests;
    }

    static {
        list.addAll(REQUIRE_ADDRESS);
        list.add(Customer.Properties.PRIMARY_PHONE_NUMBER);
        REQUIRE_BASIC_AND_ADDRESS = Collections.unmodifiableList(list);
    }

    public static class NULL_CUSTOMER
    extends Customer {
        @Override
        public Long getID() {
            return null;
        }

        @Override
        public void save() {
            OrderMate.LOG.warn("Cannot save a NULL_CUSTOMER.");
        }

        @Override
        public String getName() {
            return "INVALID CUSTOMER";
        }

        @Override
        public String getComments() {
            return null;
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> TITLE;
        public PropertiedObject.Property<String> FIRST_NAME;
        public PropertiedObject.Property<String> LAST_NAME;
        public PersistentObject.DerivedProperty<Customer> NAME_AND_TITLE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Customer.class), "nameAndTitle");
        public PropertiedObject.Property<String> PRIMARY_PHONE_NUMBER;
        public PropertiedObject.Property<String> SECONDARY_PHONE_NUMBER;
        public PropertiedObject.Property<String> E_MAIL;
        public PropertiedObject.Property RECEIVE_MARKETING;
        public PropertiedObject.Property<Date> DOB;
        public PropertiedObject.Property<Date> ANNIVERSARY;
        public PropertiedObject.Property<String> COMPANY;
        public PropertiedObject.Property<String> OCCUPATION;
        public PropertiedObject.Property ROOM_APT_NUMBER;
        public PropertiedObject.Property HOUSE_NUMBER;
        public PropertiedObject.Property<String> STREET_NAME;
        public PropertiedObject.Property<String> STREET_TYPE;
        public PropertiedObject.Property<String> SUBURB;
        public PropertiedObject.Property STATE;
        public PropertiedObject.Property POSTCODE;
        public PropertiedObject.Property STREET_DIR_REF;
        public PersistentObject.DerivedProperty<String> ADDRESS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Customer.class), "address");
        public PropertiedObject.Property<CustomerPoints> CUSTOMER_POINTS;
        public PropertiedObject.Property LOYALTY_POINTS;
        public PropertiedObject.Property CARD_ID;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property TYPE;
        public PropertiedObject.Property<InventoryPriceAdjustment> PRICE_ADJUSTMENT;
        public PropertiedObject.Property<BarTabAccount> TABS;
        public PropertiedObject.Property<CustomerCategory> CATEGORY;
        public PropertiedObject.Property<String> COMMENTS;
        public PropertiedObject.Property MOD;
        public PersistentObject.DerivedProperty<Customer> WEB_INFO = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Customer.class), "webInfo");
        public PropertiedObject.Property<CustomerGroup> CUSTOMER_GROUP;
        public PropertiedObject.Property<Gender> GENDER;
        public PropertiedObject.Property RECEIVE_DEBTOR_INVOICE;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<ConfigSmallImage> IMAGE;
        public PropertiedObject.Property<String> EXT_WEB_ID;
        public PropertiedObject.Property<String> EXT_ORIGIN;
        public PropertiedObject.Property<CustomerInterestLink> INTEREST_LINKS;
    }
}

