/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import ordermate.database.EventContext;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.SaveAccount;

public class CustomerCardHelper {
    private GuiHandler handler;
    private static String CUSTOMER_CARD = "Customer Card";
    private static String customerCardPrefix = null;

    public CustomerCardHelper() {
        this(null);
    }

    public CustomerCardHelper(GuiHandler handler) {
        this.handler = handler;
        BarcodePrefix prefix = PersistenceManager.getObject(BarcodePrefix.class, Query.select(BarcodePrefix.class).equals(BarcodePrefix.Properties.INTERNAL, Boolean.TRUE).equals(BarcodePrefix.Properties.NAME, CUSTOMER_CARD).toString());
        if (prefix != null && !prefix.getPrefix().isEmpty()) {
            customerCardPrefix = prefix.getPrefix();
        }
    }

    public BarTabAccount getBarTabForCard(CustomerCard card) {
        if (card == null || !SystemState.ACTIVE_STATE.equals(card.getSystemState())) {
            return null;
        }
        ObjectQuery query = Query.select(BarTabAccount.class).equals(BarTabAccount.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(BarTabAccount.Properties.CARD_ID, card.getCardId());
        return PersistenceManager.getObject(BarTabAccount.class, query.toString(), null);
    }

    public boolean isValidCardId(String input) {
        return input != null && input.trim().length() > 1 && StringUtils.isSwipeCardMarker(input.charAt(0));
    }

    public CustomerCard getCardByCardId(String input) {
        ObjectQuery query = Query.select(CustomerCard.class).equals(CustomerCard.Properties.CARD_ID, this.replaceCardMarker(input));
        return PersistenceManager.getObject(CustomerCard.class, query.toString(), null);
    }

    public Customer getCustomerByCard(String input) {
        return PersistenceManager.getObject(Customer.class, "SELECT sales_customer.* FROM sales_customer WHERE sales_customer.system_state = 'ACTIVE' AND card_id = ?", new Object[]{this.replaceCardMarker(input)});
    }

    public String replaceCardMarker(String value) {
        if (value != null && customerCardPrefix != null && value.indexOf(customerCardPrefix) <= 1) {
            return value.replaceFirst(customerCardPrefix, "");
        }
        return value;
    }

    public BarTabAccount createBarTabForCard(CustomerCard card, EventContext context) {
        BarTabAccount barTab = this.createBarTabForCardNoSave(card, context);
        barTab.lock(context.getUser());
        barTab.save();
        barTab.unlock();
        return barTab;
    }

    public BarTabAccount createBarTabForCardNoSave(CustomerCard card, EventContext context) {
        BarTabAccount barTab = new BarTabAccount(context.getUser(), context.getTerminal(), this.getNeatString(card));
        barTab.setCardId(card.getCardId());
        Customer theCustomer = Customer.getCustomerByCard(card.getCardId());
        if (theCustomer != null) {
            barTab.setCustomer(theCustomer);
        }
        if (SystemProperty.getInstance().isPromptNameBartab()) {
            String input = this.handler.getStringInput("Name:", "");
            if (input == null || input.trim().isEmpty()) {
                input = this.getNeatString(card);
            }
            barTab.setTabName(input);
        }
        return barTab;
    }

    public boolean transferToBarTab(CustomerCard card, Account account, EventContext context, SaveAccount saveAccount) {
        BarTabAccount barTab = this.getBarTabForCard(card);
        if (barTab == null) {
            barTab = this.createBarTabForCard(card, context);
            barTab.setCustomer(account.getCustomer(), context);
        }
        if (barTab.lock(context.getUser())) {
            saveAccount.saveAndTransferToBarTabAccount(barTab, account, account.getItemHelper().getUnpaidItems(), context, false);
            for (SalesLineItem item : account.getAllItems()) {
                item.markPrinted();
            }
            saveAccount.performTransfer(account, barTab, account.getAllItems(), context);
            return true;
        }
        return false;
    }

    public String getNeatString(CustomerCard card) {
        return this.getNeatString(card.getCardId());
    }

    public String getNeatString(String value) {
        return "#" + value.substring(1);
    }

    public CustomerCard makeCard(String cardId) {
        if (!this.isValidCardId(cardId)) {
            return null;
        }
        CustomerCard card = this.getCardByCardId(cardId);
        if (card == null) {
            card = new CustomerCard(cardId);
            card.save();
        }
        return card;
    }

    public BarTabAccount createOrGetBarTab(CustomerCard card, EventContext context) {
        BarTabAccount account = this.getBarTabForCard(card);
        if (account == null) {
            account = this.createBarTabForCardNoSave(card, context);
        }
        return account;
    }
}

