/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.queries.sales.CustomerCategoryQueries;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="sales_customer_category")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class CustomerCategory
extends PersistentDisplayableObject
implements Saveable,
ExportableObject {
    public static final Props Properties = new Props();
    private static LocalCacheListManager<CustomerCategory> allCategoryCache = new LocalCacheListManager<CustomerCategory>(Query.createQueryList(CustomerCategory.class, Query.select(CustomerCategory.class).active(CustomerCategory.class).orderByDesc(CustomerCategory.Properties.IS_DEFAULT)));
    private Boolean isDefault = null;
    private String systemState = "ACTIVE";
    private Long masterId;
    private boolean loyaltyPointsEnabled = true;

    public static List<CustomerCategory> getAllCategories() {
        return allCategoryCache.getList();
    }

    public static CustomerCategory getDefaultCategory() {
        return CustomerCategoryQueries.getDefaultCustomerCategory();
    }

    @Transient
    public boolean isDefaultPrimitive() {
        if (this.isDefault == null) {
            return false;
        }
        return this.isDefault;
    }

    @Column(name="is_default")
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean newDefault) {
        this.isDefault = newDefault == null || newDefault == false ? null : Boolean.TRUE;
    }

    @Override
    public void delete() {
        if (this.isDefaultPrimitive()) {
            throw new IllegalStateException("Cannot delete the default category");
        }
        this.setSystemState(SystemState.DELETED_STATE);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        boolean wasTheDefault = false;
        CustomerCategory currentDefault = CustomerCategory.getDefaultCategory();
        if (currentDefault != null && currentDefault.equals(this)) {
            wasTheDefault = true;
        }
        if (this.isDefaultPrimitive() && !wasTheDefault) {
            if (currentDefault != null) {
                currentDefault.setIsDefault(Boolean.FALSE);
                currentDefault.save();
            }
            this.clearCaches();
        } else if (!this.isDefaultPrimitive() && wasTheDefault) {
            this.clearCaches();
        }
        PersistenceManager.save(this);
    }

    public void clearCaches() {
        ((LocalCachedReference)CustomerCategoryQueries.defaultCustomerCategory).clearCache();
        allCategoryCache.clearCache();
    }

    public void setSystemState(SystemState newSystemState) {
        this.systemState = newSystemState.getSystemState();
    }

    protected void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Column(name="loyalty_points_enabled")
    public boolean isLoyaltyPointsEnabled() {
        return this.loyaltyPointsEnabled;
    }

    public void setLoyaltyPointsEnabled(boolean loyaltyPointsEnabled) {
        this.loyaltyPointsEnabled = loyaltyPointsEnabled;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Boolean> IS_DEFAULT;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property<Boolean> LOYALTY_POINTS_ENABLED;
    }
}

