/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="sales_customer_points")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class CustomerPoints
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private int totalPoints;
    private Reference<Customer> customer;

    public CustomerPoints() {
        this.customer = this.createReference(CustomerPoints.Properties.CUSTOMER);
    }

    public CustomerPoints(Customer yourCustomer) {
        this.customer = this.createReference(CustomerPoints.Properties.CUSTOMER);
        this.setCustomer(yourCustomer);
    }

    @Override
    @Version
    @Column(name="version")
    public int getVersion() {
        return super.getVersion();
    }

    @Column(name="total_points")
    public synchronized int getTotalPoints() {
        return this.totalPoints;
    }

    public synchronized void setTotalPoints(int value) {
        this.totalPoints = value;
    }

    public synchronized void addToPoints(int value) {
        this.totalPoints += value;
    }

    @OneToOne
    @JoinColumn(name="fk_sales_customer", referencedColumnName="ID")
    public Customer getCustomer() {
        return this.customer.get();
    }

    protected void setCustomer(Customer value) {
        this.customer.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TOTAL_POINTS;
        public PropertiedObject.Property<Customer> CUSTOMER;
    }
}

