/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.OrderBy;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.list.QueryList;
import au.com.ordermate.sql.queries.Literal;
import au.com.ordermate.sql.queries.Operator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.Data;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.delivery.StreetType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Customer;
import ordermate.gui.autosuggestor.PropertySearcherSuggestor;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.internationalization.Internationalization;

public class CustomerSearch {
    public static final String[] TITLES = new String[]{"Mr", "Mrs", "Miss", "Ms.", "Dr"};
    private static final LocalCacheListManager<StreetType> streetTypes = new LocalCacheListManager<StreetType>(QueryList.createQueryList(StreetType.class, Query.select(StreetType.class)));

    public static final List<String> makeStreetTypeList() {
        ArrayList<String> nameList = new ArrayList<String>();
        for (StreetType nextType : streetTypes.getList()) {
            nameList.add(nextType.getName());
        }
        return nameList;
    }

    public static final String convertStreetTypeToAbbreviation(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        for (StreetType type : streetTypes.getList()) {
            if (!type.getName().equals(name)) continue;
            return type.getAbbreviation();
        }
        return name;
    }

    public static final String convertStreetAbbreviationToName(String abb) {
        if (abb == null || abb.isEmpty()) {
            return abb;
        }
        for (StreetType type : streetTypes.getList()) {
            if (!type.getAbbreviation().equals(abb)) continue;
            return type.getName();
        }
        return abb;
    }

    public static String getReference(String streetName, String streetType, String suburb) {
        try {
            if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.MelwaysMapsEnabled)) {
                return null;
            }
            String streetReference = Data.database.searchStreetDirectory(streetName, streetType, suburb);
            return streetReference;
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return null;
        }
    }

    public static List newFieldSearch(PropertiedObject.Property prop, String searchString) {
        ObjectQuery query = Query.select(prop).startsWith(prop, searchString).orderBy(prop).active(Customer.class).distinct();
        if (searchString.equalsIgnoreCase("")) {
            query.limit(20);
        }
        String sql = query.toString();
        Object[][] resultsArray = PersistenceManager.getPersistenceDelegate().executeQuery(sql, new Object[0]);
        ArrayList<Object> results = new ArrayList<Object>(resultsArray.length);
        for (Object[] element : resultsArray) {
            results.add(element[0]);
        }
        return results;
    }

    public static List searchStreetNames(String streetName) {
        try {
            return Data.database.searchStreetDirectoryStreet(streetName);
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return new ArrayList();
        }
    }

    public static List searchSuburbNames(String suburbName) {
        try {
            return Data.database.searchStreetDirectorySuburb(suburbName);
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return new ArrayList();
        }
    }

    public static Suggestor<StreetDirectoryReference> makeStreetNameSuggestor() {
        PropertySearcherSuggestor<StreetDirectoryReference> streetNameSuggestor = new PropertySearcherSuggestor<StreetDirectoryReference>(StreetDirectoryReference.class, StreetDirectoryReference.Properties.STREET_NAME);
        ObjectQuery query = streetNameSuggestor.getBaseQuery();
        query.joinLeft(DeliveryZone.class, StreetDirectoryReference.Properties.ZONE);
        query.orderBy(new OrderBy(DeliveryZone.Properties.POLICY, Operator.EQUALS, Literal.get("'ALLOW'"), true));
        query.orderBy(new OrderBy(DeliveryZone.Properties.POLICY, Operator.EQUALS, Literal.get("'WARN'"), true));
        query.orderBy(new OrderBy(DeliveryZone.Properties.POLICY, Operator.IS_NULL, null, true));
        streetNameSuggestor.setBaseQuery(query);
        return streetNameSuggestor;
    }

    public static final String[] getStates() {
        List<String> states = Internationalization.getLocaleStates();
        return states.toArray(new String[states.size()]);
    }
}

