/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.FullTextSearch;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.CustomerPolyEmptyPropertySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.CustomerTenureSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FrequentCustomerSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FullTextJointSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.NewCustomerSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.PolyEmptyPropertySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.Gender;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class CustomerSearcher
extends PropertySearcher<Customer> {
    private final DateRangeSearchFilter createdDateRangeFilter;
    FullTextJointSearchFilter nameSearchFilter;
    FullTextJointSearchFilter addressSearchFilter;
    private TextSearchFilter emailFilter;
    private TextSearchFilter postcodeFilter;
    private TextSearchFilter firstNameFilter;
    private TextSearchFilter lastNameFilter;
    private TextSearchFilter cardIdFilter;
    private ObjectSearchFilter<Gender> genderFilter;
    TextSearchFilter phoneSearchFilter;
    ObjectSearchFilter<CustomerCategory> customerCategoryFilter;
    private ISingleValueSearchFilter<CustomerCategory> customerTypeFilter;
    NewCustomerSearchFilter newCustomerFilter;
    PolyEmptyPropertySearchFilter incompleteSearchFilter;
    FrequentCustomerSearchFilter frequentCustomerFilter;
    CustomerTenureSearchFilter tenureSearchFilter;
    private Integer limitation;

    public CustomerSearcher() {
        super(Customer.class);
        this.createdDateRangeFilter = new OptimisedDateRangeSearchFilter(Customer.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.nameSearchFilter = new FullTextJointSearchFilter(FullTextSearch.FullTextIndex.CUSTOMER_NAME_INDEX);
        this.addressSearchFilter = new FullTextJointSearchFilter(FullTextSearch.FullTextIndex.CUSTOMER_ADDRESS_INDEX);
        this.emailFilter = new TextSearchFilter(Customer.Properties.E_MAIL);
        this.postcodeFilter = new TextSearchFilter(Customer.Properties.POSTCODE);
        this.firstNameFilter = new TextSearchFilter(Customer.Properties.FIRST_NAME);
        this.lastNameFilter = new TextSearchFilter(Customer.Properties.LAST_NAME);
        this.cardIdFilter = new TextSearchFilter(Customer.Properties.CARD_ID, TextSearchFilter.TextSearchStrategy.StartsWith);
        this.genderFilter = new ObjectSearchFilter<Gender>(Customer.Properties.GENDER);
        this.phoneSearchFilter = new TextSearchFilter(Customer.Properties.PRIMARY_PHONE_NUMBER, TextSearchFilter.TextSearchStrategy.StartsWith);
        this.customerCategoryFilter = new ObjectSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY);
        this.customerTypeFilter = new ObjectJoinSearchFilter<CustomerCategory>(new PropertiedObject.Property[]{Account.Properties.CUSTOMER}, new ObjectSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY));
        this.newCustomerFilter = new NewCustomerSearchFilter(SalesItemQuantity.Properties.TRADING_DAY);
        this.incompleteSearchFilter = new CustomerPolyEmptyPropertySearchFilter(new PropertiedObject.Property[0]);
        this.frequentCustomerFilter = new FrequentCustomerSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.tenureSearchFilter = new CustomerTenureSearchFilter((PropertiedObject.Property)Customer.Properties.CREATION_TIME);
        this.limitation = null;
        this.addSearchFilter(this.createdDateRangeFilter);
        this.addSearchFilter(this.newCustomerFilter);
        this.addSearchFilter(this.tenureSearchFilter);
        this.addSearchFilter(this.incompleteSearchFilter);
        this.addSearchFilter(this.frequentCustomerFilter);
        this.addSearchFilter(this.emailFilter);
        this.addSearchFilter(this.postcodeFilter);
        this.addSearchFilter(this.firstNameFilter);
        this.addSearchFilter(this.lastNameFilter);
        this.addSearchFilter(this.genderFilter);
        this.addSearchFilter(this.nameSearchFilter);
        this.addSearchFilter(this.addressSearchFilter);
        this.addSearchFilter(this.phoneSearchFilter);
        this.addSearchFilter(this.customerCategoryFilter);
        this.addSearchFilter(this.customerTypeFilter);
        this.addSearchFilter(this.cardIdFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery customerQuery = Query.select(Customer.class);
        if (this.newCustomerFilter.hasSearchValue() || this.frequentCustomerFilter.hasSearchValue()) {
            customerQuery.linkUsing(Customer.Properties.ID, SalesItem.Properties.CUSTOMER).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).groupBy(Customer.Properties.ID);
            if (this.limitation != null) {
                customerQuery.limit(this.limitation);
            }
        }
        customerQuery.active(Customer.class);
        return customerQuery;
    }

    @FilterConfig(name="Tenure Greater Than", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=6)
    public CustomerTenureSearchFilter getCustomerTenureSearchFilter() {
        return this.tenureSearchFilter;
    }

    @FilterConfig(name="New Customer", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=false, sequence=5)
    public NewCustomerSearchFilter getNewCustomerFilter() {
        return this.newCustomerFilter;
    }

    @FilterConfig(name="Incomplete Fields", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=7)
    public PolyEmptyPropertySearchFilter getIncompleteFilter() {
        return this.incompleteSearchFilter;
    }

    @FilterConfig(name="Frequent customers", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=8)
    public FrequentCustomerSearchFilter getFrequencyFilter() {
        return this.frequentCustomerFilter;
    }

    public ObjectSearchFilter getCustomerCategoryFilter() {
        return this.customerCategoryFilter;
    }

    @FilterConfig(name="Customer Category", dataType=CustomerCategory.class, plural=FilterConfig.Plural.Single, priority=true, sequence=4)
    public ISingleValueSearchFilter<CustomerCategory> getCustomerTypeFilter() {
        return this.customerTypeFilter;
    }

    @FilterConfig(name="Primary Phone Number", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public TextSearchFilter getPhoneSearchFilter() {
        return this.phoneSearchFilter;
    }

    @FilterConfig(name="Address", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=3)
    public FullTextJointSearchFilter getAddressSearchFilter() {
        return this.addressSearchFilter;
    }

    @FilterConfig(name="Name", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=1)
    public FullTextJointSearchFilter getNameSearchFilter() {
        return this.nameSearchFilter;
    }

    public TextSearchFilter getCardIdFilter() {
        return this.cardIdFilter;
    }

    @FilterConfig(name="Email", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=5)
    public TextSearchFilter getEmailFilter() {
        return this.emailFilter;
    }

    public TextSearchFilter getPostcodeFilter() {
        return this.postcodeFilter;
    }

    public TextSearchFilter getFirstNameFilter() {
        return this.firstNameFilter;
    }

    public TextSearchFilter getLastNameFilter() {
        return this.lastNameFilter;
    }

    public ObjectSearchFilter<Gender> getGenderFilter() {
        return this.genderFilter;
    }

    public DateRangeSearchFilter getCreatedDateFilter() {
        return this.createdDateRangeFilter;
    }

    public Integer getLimitation() {
        return this.limitation;
    }

    public void setLimitation(Integer limitation) {
        this.limitation = limitation;
    }
}

