/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="sales_customer_stats")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class CustomerStats
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Integer totalOrders;
    private Price totalSpend;
    private Date firstOrder = null;
    private Date lastOrder = null;
    private String orderFrequency;
    private Price averageSpend;
    private Reference<Customer> customer;
    private String mostOrderedItem;
    private String mostOrderedSection;
    private String highestGrossingItem;
    private String highestGrossingSection;

    @Deprecated
    public CustomerStats() {
        this.customer = this.createReference(CustomerStats.Properties.CUSTOMER);
    }

    public CustomerStats(Customer newCustomer) {
        this.customer = this.createReference(CustomerStats.Properties.CUSTOMER);
        this.setCustomer(newCustomer);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static CustomerStats getStatsForCustomer(Long customerID) {
        return PersistenceManager.getObject(CustomerStats.class, Query.select(CustomerStats.class).equals(CustomerStats.Properties.CUSTOMER, customerID).toString());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="first_order")
    public Date getFirstOrder() {
        return this.firstOrder;
    }

    public void setFirstOrder(Date firstOrder) {
        this.firstOrder = firstOrder;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="last_order")
    public Date getLastOrder() {
        return this.lastOrder;
    }

    public void setLastOrder(Date lastOrder) {
        this.lastOrder = lastOrder;
    }

    @Column(name="order_frequency")
    public String getOrderFrequency() {
        return this.orderFrequency;
    }

    public void setOrderFrequency(String orderFrequency) {
        this.orderFrequency = orderFrequency;
    }

    @Column(name="average_spend")
    public Price getAverageSpend() {
        return this.averageSpend;
    }

    public void setAverageSpend(Price averageSpend) {
        this.averageSpend = averageSpend;
    }

    @OneToOne
    @JoinColumn(name="fk_sales_customer", referencedColumnName="ID")
    public Customer getCustomer() {
        return this.customer.get();
    }

    protected void setCustomer(Customer value) {
        this.customer.set(value);
    }

    @Column(name="total_orders")
    public Integer getTotalOrders() {
        return this.totalOrders;
    }

    public void setTotalOrders(Integer totalOrders) {
        this.totalOrders = totalOrders;
    }

    @Column(name="most_ordered_item")
    public String getMostOrderedItem() {
        return this.mostOrderedItem;
    }

    public void setMostOrderedItem(String mostOrderedItem) {
        this.mostOrderedItem = mostOrderedItem;
    }

    @Column(name="most_ordered_section")
    public String getMostOrderedSection() {
        return this.mostOrderedSection;
    }

    public void setMostOrderedSection(String mostOrderedSection) {
        this.mostOrderedSection = mostOrderedSection;
    }

    @Column(name="highest_grossing_item")
    public String getHighestGrossingItem() {
        return this.highestGrossingItem;
    }

    public void setHighestGrossingItem(String highestGrossingItem) {
        this.highestGrossingItem = highestGrossingItem;
    }

    @Column(name="highest_grossing_section")
    public String getHighestGrossingSection() {
        return this.highestGrossingSection;
    }

    public void setHighestGrossingSection(String highestGrossingSection) {
        this.highestGrossingSection = highestGrossingSection;
    }

    @Column(name="total_spend")
    public Price getTotalSpend() {
        return this.totalSpend;
    }

    public void setTotalSpend(Price totalSpend) {
        this.totalSpend = totalSpend;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Integer> TOTAL_ORDERS;
        public PropertiedObject.Property<Price> TOTAL_SPEND;
        public PropertiedObject.Property<Date> FIRST_ORDER;
        public PropertiedObject.Property<Date> LAST_ORDER;
        public PropertiedObject.Property<String> ORDER_FREQUENCY;
        public PropertiedObject.Property<Price> AVERAGE_SPEND;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<String> MOST_ORDERED_ITEM;
        public PropertiedObject.Property<String> MOST_ORDERED_SECTION;
        public PropertiedObject.Property<String> HIGHEST_GROSSING_ITEM;
        public PropertiedObject.Property<String> HIGHEST_GROSSING_SECTION;
    }
}

