/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import ordermate.dbconnection.DatabaseControl;

public class CustomerStatsUpdater {
    public void updateAllCustomerStats(DatabaseControl dbc) throws SQLException {
        this.addAllCustomersToStatsTable(dbc);
        this.addTemporaryTable(dbc);
        this.runUpdateQuery(dbc);
        dbc.closeConnection();
    }

    protected int addAllCustomersToStatsTable(DatabaseControl dbc) throws SQLException {
        PreparedStatement statement = dbc.createPreparedStatement("INSERT INTO sales_customer_stats (FK_sales_customer) SELECT sc.ID FROM sales_customer sc WHERE system_state = 'ACTIVE' ON DUPLICATE KEY UPDATE FK_sales_customer = sc.ID;");
        int rowResult = statement.executeUpdate();
        return rowResult;
    }

    protected void addTemporaryTable(DatabaseControl dbc) throws SQLException {
        PreparedStatement statement = dbc.createPreparedStatement(this.buildTemporaryTableForFirstLastOrder());
        statement.executeUpdate();
        statement = dbc.createPreparedStatement(this.buildTemporaryTableForMostOrderedItem());
        statement.executeUpdate();
        statement = dbc.createPreparedStatement(this.buildTemporaryTableForMostOrderedSection());
        statement.executeUpdate();
        statement = dbc.createPreparedStatement(this.buildTemporaryTableForHighestGrossingItemSection());
        statement.executeUpdate();
        statement = dbc.createPreparedStatement(this.buildTemporaryTableForFrequencySpendAverage());
        statement.executeUpdate();
    }

    protected void runUpdateQuery(DatabaseControl dbc) throws SQLException {
        PreparedStatement batch = dbc.createPreparedStatement("");
        batch.addBatch(this.updateFirstLastOrder());
        batch.addBatch(this.updateMostOrderedItem());
        batch.addBatch(this.updateMostOrderedSection());
        batch.addBatch(this.updateHighestGrossingItemSection());
        batch.addBatch(this.updateTotalFrequencySpendAverage());
        batch.executeBatch();
    }

    protected static int addCustomerToStatsTable(long customerID, DatabaseControl dbc) throws SQLException {
        int rowCount = dbc.createPreparedStatement("INSERT INTO sales_customer_stats (FK_sales_customer) VALUES (" + customerID + ")ON DUPLICATE KEY UPDATE FK_sales_customer = " + customerID + ";").executeUpdate();
        return rowCount;
    }

    protected String updateFirstLastOrder() {
        String statement = "UPDATE sales_customer_stats scs LEFT JOIN firsts   ON scs.FK_sales_customer = firsts.custID   SET scs.first_order = firsts.first_order, scs.last_order=firsts.last_order";
        return statement;
    }

    private String buildTemporaryTableForFirstLastOrder() {
        String statement = "CREATE TEMPORARY TABLE firsts(custID bigint(20),first_order timestamp,last_order timestamp, INDEX customer_idx(custID) )  select si.fk_sales_customer custID,  min(siq.creation_time) first_order, max(siq.creation_time) last_order  from sales_item si   join sales_item_quantity siq on siq.fk_sales_item=si.id   where si.fk_sales_customer is not null   group by si.fk_sales_customer ;";
        return statement;
    }

    protected String updateMostOrderedItem() {
        String statement = "update sales_customer_stats scs left join  max_item  on scs.fk_sales_customer=max_item.custID  set scs.most_ordered_item=max_item.item_name; ";
        return statement;
    }

    private String buildTemporaryTableForMostOrderedItem() {
        String statement = "CREATE TEMPORARY TABLE max_item(custID int,item_name varchar(100),item_count decimal(20,8), INDEX customer_idx(custID) ) select imm.custID custID, imm.item_name item_name , max(item_count) item_count  from  (select si.fk_sales_customer custID, ii.name 'item_name', count(*) 'item_count' from sales_item si  join sales_component sc on si.fk_sales_component=sc.id  join sales_item_quantity siq on siq.fk_sales_item=si.id  join inventory_item ii on sc.fk_inventory_item=ii.id  where     si.fk_sales_customer is not null     and siq.creation_time >=DATE_SUB(NOW(), INTERVAL 1 YEAR)  group by si.fk_sales_customer, ii.name  order by si.fk_sales_customer, item_count desc, ii.name) imm  group by imm.custID ;";
        return statement;
    }

    protected String updateMostOrderedSection() {
        String statement = "update sales_customer_stats scs left join  max_section     on scs.fk_sales_customer=max_section.custID  set scs.most_ordered_section=max_section.section_name; ";
        return statement;
    }

    private String buildTemporaryTableForMostOrderedSection() {
        String statement = "CREATE TEMPORARY TABLE max_section(custID int,section_name varchar(100),section_count decimal(20,8), INDEX customer_idx(custID) ) select igm.custID custID, igm.section_name section_name, max(section_count) section_count  from  (select si.fk_sales_customer custID, ig.name 'section_name', count(*) 'section_count'     from sales_item si     join sales_component sc on si.fk_sales_component=sc.id     join sales_item_quantity siq on siq.fk_sales_item=si.id     join inventory_item ii on sc.fk_inventory_item=ii.id     join inventory_group ig on ii.fk_inventory_group=ig.id  where     si.fk_sales_customer is not null   and siq.creation_time >=DATE_SUB(NOW(), INTERVAL 1 YEAR)  group by si.fk_sales_customer, ig.name  order by si.fk_sales_customer,  section_count desc, ig.name)igm   group by igm.custID ; ";
        return statement;
    }

    protected String updateHighestGrossingItemSection() {
        String statement = "update sales_customer_stats scs  left join  high_gross_items_per_customer     on scs.fk_sales_customer=high_gross_items_per_customer.custID  set scs.highest_grossing_item=high_gross_items_per_customer.item_name, scs.highest_grossing_section=high_gross_items_per_customer.Section; ";
        return statement;
    }

    private String buildTemporaryTableForHighestGrossingItemSection() {
        String statement = "CREATE TEMPORARY TABLE high_gross_items_per_customer(custID int,item_name varchar(100),Section varchar(100), max_gross_amount decimal(20,8), INDEX customer_idx(custID) ) select all_items_total_per_customer.custID custID, all_items_total_per_customer.item_name item_name, all_items_total_per_customer.Section Section,  max(all_items_total_per_customer.item_total) max_gross_amount  from  (select si.fk_sales_customer custID, ii.name 'item_name', ig.name 'Section', sum(sc.unit_price * siq.quantity) 'item_total'  from sales_item si  join sales_component sc on si.fk_sales_component=sc.id  join sales_item_quantity siq on siq.fk_sales_item=si.id  join inventory_item ii on sc.fk_inventory_item=ii.id  join inventory_group ig on ii.fk_inventory_group=ig.id  where si.fk_sales_customer is not null   and siq.creation_time >=DATE_SUB(NOW(), INTERVAL 1 YEAR)  group by si.fk_sales_customer, sc.fk_inventory_item  order by si.fk_sales_customer, item_total desc) all_items_total_per_customer  group by all_items_total_per_customer.custID; ";
        return statement;
    }

    protected String updateTotalFrequencySpendAverage() {
        String statement = "update sales_customer_stats scs  left join  total_average  on scs.fk_sales_customer=total_average.custID  set scs.total_orders = total_average.total_orders, scs.order_frequency=total_average.order_frequency, scs.total_spend=total_average.total_spend, scs.average_spend=total_average.average_spend ";
        return statement;
    }

    private String buildTemporaryTableForFrequencySpendAverage() {
        String statement = "CREATE TEMPORARY TABLE total_average(custID int,order_frequency varchar(100),total_orders decimal(20,8), average_spend decimal(20,8),total_spend decimal(20,8), INDEX customer_idx(custID) ) select total_per_account.custID 'custID', CONCAT(' Every ', ROUND(365/count(*),1), ' day(s)') 'order_frequency', count(*) 'total_orders', format(round(sum(total_per_account.total_spend)/count(*),2),2) 'average_spend',   sum(total_per_account.total_spend) 'total_spend' from  (select si.fk_sales_customer custID, round(sum(sc.unit_price * siq.quantity), 2) total_spend  from sales_item si  join sales_component sc on si.fk_sales_component=sc.id  join sales_item_quantity siq on siq.fk_sales_item=si.id  where fk_sales_customer is not null and siq.creation_time>=date_sub(now(), INTERVAL 1 YEAR)  group by si.fk_sales_customer, si.fk_sales_account) total_per_account  group by total_per_account.custID ;";
        return statement;
    }
}

