/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import ordermate.database.sales.Customer;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CustomerUpdateManager
implements GatewayProcessor<Customer>,
GatewayNotifier<Customer> {
    public final Signal<Customer, ?, ?, ?, ?> customerUpdated = Signals.createSignal(Customer.class, "customer");
    private static CustomerUpdateManager manager = new CustomerUpdateManager();
    private static Gateway<Customer> customerUpdateGateway = new Gateway<Customer>(manager, manager);

    public static CustomerUpdateManager getInstance() {
        return manager;
    }

    public void addCustomerToUpdate(Customer toUpdate) {
        if (toUpdate != null) {
            customerUpdateGateway.putIntoQueue(toUpdate);
        }
    }

    @Override
    public void notifyProcess(Customer processedValue, boolean processSuccessful) {
        if (processSuccessful) {
            this.customerUpdated.emit(processedValue);
        }
    }

    @Override
    public boolean processIncoming(Customer toProcess) {
        if (toProcess == null) {
            return false;
        }
        LoyaltyPointAdministrator.getInstance().updateCustomerInfoFromAuthority(toProcess);
        return true;
    }

    protected Gateway<Customer> getGateway() {
        return customerUpdateGateway;
    }

    static {
        customerUpdateGateway.startService();
    }
}

