/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Shift;
import ordermate.database.queries.sales.DeliveryState;
import ordermate.database.sales.Account;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_delivery")
@AccessType(value="property")
public class Delivery
extends PersistentObject
implements Saveable,
Lockable,
Displayable {
    public static final Props Properties = new Props();
    public static final String DELIVERY_ASSIGNED = DeliveryState.ASSIGNED.toString();
    public static final String DELIVERY_RETURNED = DeliveryState.RETURNED.toString();
    public static final String DELIVERY_PAID = DeliveryState.PAID.toString();
    public static final String DELIVERY_DELETED = DeliveryState.DELETED.toString();
    private static final Color LOCKED_COLOR = new Color(255, 0, 0);
    private Date timeCreated;
    private Date timeCompleted;
    private String status;
    private Reference<User> driver;
    private Reference<User> user;
    private PersistentWriteableList<Account> accounts;
    private SystemState systemState;
    private String extDriverName;
    private Long extDriverId;

    public Delivery() {
        this.accounts = (PersistentWriteableList)this.createList(Delivery.Properties.ACCOUNTS);
        this.systemState = SystemState.ACTIVE_STATE;
        this.driver = this.createReference(Delivery.Properties.DRIVER);
        this.user = this.createReference(Delivery.Properties.USER);
        this.status = DELIVERY_ASSIGNED;
    }

    @Override
    public void prepareForSave(SaveContext sc) {
    }

    @Override
    public void save() {
        if (this.timeCreated == null) {
            this.timeCreated = new Date();
        }
        PersistenceManager.save(this);
        this.accounts.saveChild();
    }

    @Override
    public void delete() {
        this.markAsDeleted();
        this.setSystemState(SystemState.DELETED_STATE);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="delivery_state")
    public String getStatus() {
        return this.status;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (this.isLocked()) {
            return LOCKED_COLOR;
        }
        return null;
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getID() + " - " + (this.getDriver() != null ? this.getDriver().getName() : "No Driver");
    }

    @Transient
    public String getDeliveryDetails() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Delivery ");
        buffer.append(this.intID());
        buffer.append(", Assigned at ");
        buffer.append(this.getTimeCreated());
        buffer.append(", Containing ");
        buffer.append(this.getAccounts().size());
        buffer.append(" accounts");
        return buffer.toString();
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_user_lock")
    public User getUser() {
        return this.user.get();
    }

    @Override
    @Transient
    public boolean isLocked() {
        return !this.user.isNull();
    }

    @Override
    public synchronized boolean isLocked(User byUser) {
        return !this.user.isNull() && this.user.getObjectID().equals(PersistenceManager.getID(byUser));
    }

    @Override
    public boolean lock(User newLockingUser) {
        Account account;
        if (this.getUser() != null && !newLockingUser.equals(this.getUser())) {
            return false;
        }
        boolean locked = true;
        Account marker = null;
        Iterator<PhoneAccount> iterator = this.getAccounts().iterator();
        while (iterator.hasNext() && locked) {
            account = iterator.next();
            locked = newLockingUser.equals(account.getUser()) || account.lock(newLockingUser);
            if (locked) continue;
            marker = account;
        }
        if (locked) {
            this.user.set(newLockingUser);
        } else {
            iterator = this.getAccounts().iterator();
            while (iterator.hasNext() && marker != null) {
                account = iterator.next();
                account.unlock();
                if (account != marker) continue;
                marker = null;
            }
        }
        return locked;
    }

    @Override
    public void unlock() {
        for (Account account : this.getAccounts()) {
            if (!account.isLocked()) continue;
            account.unlock();
        }
        this.user.set(null);
    }

    @Override
    public boolean relock(User newUser) {
        this.unlock();
        return this.lock(newUser);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user_driver")
    public User getDriver() {
        return this.driver.get();
    }

    public void setDriver(User newDriver) {
        if (newDriver == null) {
            String s = "Driver cannot be null!";
            throw new IllegalArgumentException(s);
        }
        this.driver.set(newDriver);
    }

    @OneToMany(mappedBy="delivery", targetEntity=PhoneAccount.class)
    public List<PhoneAccount> getAccounts() {
        return this.accounts.getUnmodifiable();
    }

    @Transient
    public List getOpenAccounts() {
        ArrayList<Account> openAccounts = new ArrayList<Account>();
        for (Account account : this.getAccounts()) {
            if (!account.isOpen()) continue;
            openAccounts.add(account);
        }
        return openAccounts;
    }

    @Transient
    public List<Account> getAssignedAccounts() {
        ArrayList<Account> accountList = new ArrayList<Account>();
        for (PhoneAccount account : this.getAccounts()) {
            if (!account.hasDelivery() || account.isDelivered()) continue;
            accountList.add(account);
        }
        return accountList;
    }

    @Transient
    public List<Account> getReturnedAccounts() {
        ArrayList<Account> accountList = new ArrayList<Account>();
        for (PhoneAccount account : this.getAccounts()) {
            if (!account.hasDelivery() || !account.isDelivered()) continue;
            accountList.add(account);
        }
        return accountList;
    }

    @Transient
    public List<Account> getUnsettledAccounts() {
        ArrayList<Account> accountList = new ArrayList<Account>();
        for (Account account : this.getReturnedAccounts()) {
            if (account.getPaidState() == Payable.PAID) continue;
            accountList.add(account);
        }
        return accountList;
    }

    public void addAccount(PhoneAccount toAdd) {
        if (!toAdd.isDeliverable()) {
            String s = "Cannot add an undeliverable PhoneAccount!";
            throw new IllegalArgumentException(s);
        }
        if (!this.isLocked()) {
            String s = "Delivery must be locked before adding an Account!";
            throw new IllegalStateException(s);
        }
        if (!toAdd.isLocked(this.getUser()) && !toAdd.lock(this.getUser())) {
            String s = "Unable to lock Account before adding it!";
            throw new IllegalStateException(s);
        }
        this.accounts.add(toAdd);
    }

    public void removeAccount(Account toRemove) {
        this.accounts.remove(toRemove);
    }

    public List<Account> removeAllAccounts() {
        ArrayList<Account> removed = new ArrayList<Account>(this.accounts);
        this.accounts.clear();
        return removed;
    }

    @Column(name="time_created")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeCreated() {
        return this.timeCreated == null ? null : new Date(this.timeCreated.getTime());
    }

    @Column(name="time_completed")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeCompleted() {
        return this.timeCompleted == null ? null : new Date(this.timeCompleted.getTime());
    }

    public void setTimeCompleted(Date completionTime) {
        this.timeCompleted = completionTime;
        this.status = DELIVERY_RETURNED;
    }

    public void markAsDeleted() {
        if (this.getAccounts().size() > 0) {
            String s = "Cannot close a Delivery that still has Accounts!";
            throw new IllegalStateException(s);
        }
        this.status = DELIVERY_DELETED;
    }

    public void markAsReturned() {
        this.status = DELIVERY_RETURNED;
    }

    public void markAsPaid() {
        this.status = DELIVERY_PAID;
    }

    public static Delivery createDelivery(User driver, User lockingUser, List accounts) {
        Delivery delivery = new Delivery();
        delivery.setDriver(driver);
        delivery.lock(lockingUser);
        for (Object obj : accounts) {
            if (!(obj instanceof PhoneAccount)) continue;
            delivery.addAccount((PhoneAccount)obj);
        }
        return delivery;
    }

    public static Delivery getCurrentDelivery(User driver) {
        return PersistenceManager.getObject(Delivery.class, "SELECT * FROM sales_delivery WHERE FK_config_user_driver = ? AND delivery_state = ?AND system_state = 'ACTIVE'", new Object[]{driver.getID(), DELIVERY_ASSIGNED});
    }

    public static List<Delivery> getReturnedDeliveries(User driver) {
        return PersistenceManager.getObjectList(Delivery.class, "SELECT * FROM sales_delivery WHERE FK_config_user_driver = ? AND delivery_state = ?AND system_state = 'ACTIVE'", new Object[]{driver.getID(), DELIVERY_RETURNED});
    }

    public static List getCompletedDeliveries(Shift shift) {
        return PersistenceManager.getObjectList(Delivery.class, "SELECT DISTINCT sales_delivery.* FROM sales_delivery, sales_account WHERE sales_delivery.ID = sales_account.FK_sales_delivery AND system_state = 'ACTIVE' AND sales_account.FK_finance_shift = ? AND sales_delivery.delivery_state = ?", new Object[]{shift.getID(), DELIVERY_PAID});
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    protected void setTimeCreated(Date timeCreated) {
        this.timeCreated = timeCreated;
    }

    protected void setAccounts(List<PhoneAccount> accounts) {
        this.accounts = this.accounts.clone();
        this.accounts.set(accounts);
    }

    protected void setStatus(String status) {
        this.status = status;
    }

    protected void setUser(User user) {
        this.user.set(user);
    }

    protected void setSystemState(SystemState state) {
        this.systemState = state;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Transient
    public int getNumberOfAccounts() {
        return this.accounts == null ? 0 : this.accounts.size();
    }

    @Transient
    public Price getDriverFeeForDelivery() {
        if (this.user == null || this.getUser().getPerDeliveryRate() == null) {
            return null;
        }
        return this.getUser().getPerDeliveryRate().multiply(this.getNumberOfAccounts());
    }

    @Transient
    public Price getPaidTotal() {
        Price totalPayments = Price.ZERO_DOLLAR;
        for (Account account : this.getAccounts()) {
            totalPayments = totalPayments.add(account.getPaid());
        }
        return totalPayments;
    }

    @Transient
    public Price getOutstandingTotal() {
        Price outstandingTotal = Price.ZERO_DOLLAR;
        for (Account account : this.getAccounts()) {
            if (!account.isOpen()) continue;
            outstandingTotal = outstandingTotal.add(account.getDue());
        }
        return outstandingTotal;
    }

    @Column(name="ext_driver_name")
    public String getExtDriverName() {
        return this.extDriverName;
    }

    public void setExtDriverName(String value) {
        this.extDriverName = value;
    }

    @Column(name="ext_driver_id")
    public Long getExtDriverId() {
        return this.extDriverId;
    }

    public void setExtDriverId(Long value) {
        this.extDriverId = value;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<User> DRIVER;
        public PropertiedObject.Property<Account> ACCOUNTS;
        public PropertiedObject.Property TIME_CREATED;
        public PropertiedObject.Property TIME_COMPLETED;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property STATUS;
        public PropertiedObject.Property<String> EXT_DRIVER_NAME;
        public PropertiedObject.Property<Long> EXT_DRIVER_ID;
    }
}

