/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemHelper;
import ordermate.database.sales.PriceAdjustmentHelper;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;

@MappedSuperclass
public abstract class ItemGroup
extends PersistentObject
implements Lockable,
Saveable,
Payable,
PriceAdjustable,
Displayable {
    public static final Props Properties = new Props();
    private String receiptPrintReason = null;
    private transient PriceAdjustmentHelper priceAdjHelper = null;
    private transient ItemHelper itemHelper = null;

    public ItemGroup() {
    }

    public ItemGroup(long newID) {
        PersistenceManager.setID(this, newID);
    }

    @Transient
    public abstract List<SalesLineItem> getItems();

    @Transient
    public abstract List<SalesLineItem> getActiveItemsModifiable();

    @Transient
    public abstract Account getAccount();

    @Transient
    public abstract String getType();

    @Transient
    public abstract boolean isAccount();

    @Transient
    public abstract int getOrderNumber();

    @Transient
    public abstract List getAllItems();

    @Transient
    public abstract List getAllItemsModifiable();

    @Transient
    public abstract List<GiftVoucherTransaction> getVoucherTxns();

    @Transient
    public List<GiftVoucherTransaction> getActiveVoucherTxns() {
        ArrayList<GiftVoucherTransaction> activeVoucherTxns = new ArrayList<GiftVoucherTransaction>();
        for (GiftVoucherTransaction vTxn : this.getVoucherTxns()) {
            if (!vTxn.isActive()) continue;
            activeVoucherTxns.add(vTxn);
        }
        return activeVoucherTxns;
    }

    public abstract void addFinanceTransaction(FinanceTransaction var1, List<SalesLineItem> var2);

    @Override
    @Transient
    public Payable.PaidState getPaidState() {
        double due = this.getDue(0.01).doubleValue();
        if (due != 0.0 && due >= -Price.EQUIVALENT_THRESHOLD && due <= Price.EQUIVALENT_THRESHOLD) {
            return UNPAYABLE_BY_ROUNDING;
        }
        if (due > 0.0) {
            return NOT_PAID;
        }
        if (this.getDue(Price.DEFAULT_ROUND_AMOUNT).doubleValue() < 0.0) {
            return CREDIT;
        }
        for (Sellable sellable : new SellableWrapperFactory().getSellables(this)) {
            GiftVoucherTransaction voucherTxn;
            if (sellable instanceof SalesLineItemWrapper) {
                SalesLineItem item = (SalesLineItem)sellable.getSellingObject();
                if (!item.getUnadjustedPrice().equals(Price.ZERO_DOLLAR)) {
                    return PAID;
                }
                Price itemPrice = item.getItemLevelPrice();
                Price discount = item.getAccountDiscountTotal();
                if (!(discount.doubleValue() > 0.0) || !itemPrice.equals(discount)) continue;
                return PAID;
            }
            if (!(sellable instanceof VoucherTransactionWrapper) || !(voucherTxn = (GiftVoucherTransaction)sellable.getSellingObject()).isActive() || !voucherTxn.getAmount().greaterThan(Price.ZERO_DOLLAR)) continue;
            return PAID;
        }
        return UNPAYABLE;
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction toAdd) {
        this.addFinanceTransaction(toAdd, this.getItems());
    }

    @Transient
    public abstract List<SalesPriceAdjustment> getPriceAdjustments();

    @Transient
    protected abstract boolean removeAdjustment(SalesPriceAdjustment var1, EventContext var2);

    @Transient
    public PriceAdjustmentHelper getPriceAdjHelper() {
        if (this.priceAdjHelper == null) {
            this.priceAdjHelper = new PriceAdjustmentHelper(this);
        }
        return this.priceAdjHelper;
    }

    @Transient
    public ItemHelper getItemHelper() {
        if (this.itemHelper == null) {
            this.itemHelper = new ItemHelper(this);
        }
        return this.itemHelper;
    }

    @Transient
    public boolean allowsAdvancedPriceAdjustments() {
        return true;
    }

    @Override
    @Transient
    public SalesPriceAdjustment getPriceAdjustment(InventoryPriceAdjustment adj) {
        return this.getPriceAdjHelper().getPriceAdjustment(adj);
    }

    @Override
    @Transient
    public final boolean hasPriceAdjustment(InventoryPriceAdjustment adjustment) {
        return this.getPriceAdjHelper().getPriceAdjustment(adjustment) != null;
    }

    @Override
    @Transient
    public boolean isDiscounted() {
        return this.getPriceAdjHelper().isDiscounted();
    }

    @Transient
    public Price getTotalRoundingAmt() {
        Price total = Price.ZERO_NO_ROUND;
        List<FinanceTransaction> txns = this.getFinanceTransactions();
        for (FinanceTransaction transaction : txns) {
            if (!transaction.isActive()) continue;
            total = total.add(transaction.getRoundingAmt());
        }
        return total;
    }

    @Transient
    protected Price getSummaryTotal() {
        Price total = this.getTotal(0.01).add(this.getTotalRoundingAmt());
        for (GiftVoucherTransaction txn : this.getVoucherTxns()) {
            if (txn.isRedeeming() || txn.isRedeemReversal() || !txn.isActive()) continue;
            total = total.add(txn.getAmount());
        }
        return total;
    }

    protected Price getTotal(double roundAmount) {
        double total = 0.0;
        for (SalesLineItem item : this.getItems()) {
            total += item.getPrice().doubleValue();
        }
        Price totalPrice = new Price(total, roundAmount);
        return totalPrice;
    }

    @Transient
    public Price getTax() {
        return this.getItemHelper().getItemTaxTotal();
    }

    @Transient
    public Price getCost() {
        Price cost = new Price(0.0, 0.0);
        for (SalesLineItem item : this.getItems()) {
            cost = cost.add(item.getIngredientCostExTax());
        }
        return cost;
    }

    @Override
    @Transient
    public synchronized Price getDue() {
        return this.getDue(0.01);
    }

    @Override
    @Transient
    public synchronized Price getDue(double roundAmt) {
        Price total = this.getTotal();
        Price paid = this.getPaid();
        return new Price(total.doubleValue() - paid.doubleValue(), roundAmt);
    }

    @Override
    @Transient
    public synchronized Price getPaid() {
        double paid = 0.0;
        List<FinanceTransaction> payments = this.getFinanceTransactions();
        for (FinanceTransaction payment : payments) {
            paid += payment.getPaid().doubleValue();
        }
        return new Price(paid, 0.01);
    }

    @Override
    @Transient
    public synchronized Price getTendered() {
        Price tendered = Price.ZERO_DOLLAR;
        List<FinanceTransaction> payments = this.getFinanceTransactions();
        for (FinanceTransaction payment : payments) {
            tendered = tendered.add(payment.getTendered());
        }
        return tendered;
    }

    @Transient
    public boolean isPaidWithMoney() {
        List<FinanceTransaction> payments = this.getFinanceTransactions();
        if (payments.size() < 1) {
            return false;
        }
        FinanceTransaction payment = payments.get(0);
        return payment.getSubType() != null && payment.getSubType().getAccountingGroup() != null;
    }

    public abstract List setCustomer(Customer var1, EventContext var2);

    @Transient
    public abstract Customer getCustomer();

    public boolean hasCustomer() {
        return this.getCustomer() != null;
    }

    public boolean usesSeatNums() {
        return false;
    }

    @Transient
    public int getNumPatrons() {
        return 0;
    }

    @Transient
    public abstract boolean isOpen();

    public abstract void close(EventContext var1);

    public void printReceiptDockets(User user, Terminal printedFrom) throws Exception {
        List<VirtualPrinter> receiptPrinters = printedFrom.getAvailableReceiptPrinters();
        if (receiptPrinters.isEmpty()) {
            String s = "No receipt printers defined for terminal " + printedFrom;
            throw new IOException(s);
        }
        this.printReceiptDockets(user, printedFrom, receiptPrinters);
    }

    public void printReceiptDockets(User user, Terminal printedFrom, List receiptPrinters) throws Exception {
        DocketProcessor.printReceiptDocket(receiptPrinters, this, user, printedFrom);
        TerminalEventLog.logPrintBill(user, printedFrom, this);
    }

    @Override
    public void pay() {
        this.save();
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        Color theColor = null;
        if (this.isLocked()) {
            theColor = ACCOUNT_LOCKED;
        }
        return theColor;
    }

    @Override
    @Transient
    public boolean isPaidModifiable() {
        return !SystemProperty.getInstance().isSinglePaymentMode();
    }

    public void setReceiptPrintReason(String value) {
        this.receiptPrintReason = value;
    }

    @Transient
    public String getReceiptPrintReason() {
        return this.receiptPrintReason;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Transient
    public String getBarcode() {
        if (this.getID() == null) {
            return null;
        }
        return BarcodeUtils.makeBarcodeString(this.getID(), BarcodeUtils.BarcodePrefixGroup.Account);
    }

    @Transient
    public EventContext getEventContext() {
        Terminal term = Terminal.isLocalHostSetup() ? Terminal.getLocalHost() : Terminal.getServerMateTerminal();
        User eventUser = this.getUser() != null ? this.getUser() : User.getSystemUser();
        return new EventContext(term, eventUser);
    }

    @Transient
    public Date getCreationDateTime() {
        return this.getAccount().getCreationDateTime();
    }

    public abstract void addOrderedItem(SalesLineItem var1);

    @Transient
    public void updateCustomerReference() {
    }

    public static class Props
    extends PersistentObject.Props {
    }
}

