/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.ListUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SalesAdjustmentsTransfer;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.itemfilter.CourseFilter;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.OrderableItemFilter;
import ordermate.database.sales.itemfilter.PaidFilter;
import ordermate.database.sales.itemfilter.SeatFilter;
import ordermate.database.sales.itemfilter.UnsavedFilter;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.gui.ordering.OrderComboHelper;

public class ItemHelper {
    private final ItemGroup itemGroup;

    public ItemHelper(ItemGroup theItemGroup) {
        this.itemGroup = theItemGroup;
    }

    public List<SalesItem> getSalesItems() {
        List<SalesLineItem> filterItems = this.itemGroup.getItems();
        ArrayList<SalesItem> salesItems = new ArrayList<SalesItem>();
        for (SalesLineItem currentItem : filterItems) {
            if (!(currentItem instanceof SalesItem)) continue;
            salesItems.add((SalesItem)currentItem);
        }
        return salesItems;
    }

    public List<SalesItem> getUnpaidSalesItems() {
        return ItemFilter.filterItems(this.getSalesItems(), new PaidFilter(false));
    }

    public void addItem(SalesLineItem newItem) {
        if (this.itemGroup instanceof PhoneAccount) {
            ((PhoneAccount)this.itemGroup).setAllowingUser(null);
            List<SalesPriceAdjustment> deliverySurcharges = PriceAdjustmentManager.getInstance().getMatching(this.itemGroup.getPriceAdjustments(), PriceAdjustmentType.DELIVERY_SURCHARGE);
            for (SalesPriceAdjustment adj : deliverySurcharges) {
                if (adj.getInventoryPriceAdjustment() == null || adj.getInventoryPriceAdjustment().equals(SystemProperty.getInstance().getDeliveryFee())) continue;
                this.itemGroup.removeAdjustment(adj, null);
            }
        }
        this.addItemBefore(null, newItem);
    }

    public void addItemBefore(SalesLineItem before, SalesLineItem ... itemsToAdd) {
        if (this.itemGroup instanceof BarTabAccount) {
            Payable.PaidState paidState = this.itemGroup.getPaidState();
            if (paidState == ItemGroup.CREDIT) {
                for (SalesLineItem newItem : itemsToAdd) {
                    newItem.addFinanceTransactions(this.itemGroup.getFinanceTransactions());
                }
            }
        }
        int indexBeforeItems = this.itemGroup.getAllItemsModifiable().indexOf(before);
        int indexBeforeActiveItems = this.itemGroup.getActiveItemsModifiable().indexOf(before);
        for (SalesLineItem toAdd : itemsToAdd) {
            this.removeSubItems(toAdd);
            if (this.itemGroup.hasCustomer() && toAdd.getCustomer() == null) {
                toAdd.setCustomer(this.itemGroup.getCustomer());
            }
            toAdd.setAccount(this.itemGroup.getAccount());
            ListUtils.safelyAddToList(toAdd, this.itemGroup.getActiveItemsModifiable(), indexBeforeActiveItems);
            ListUtils.safelyAddToList(toAdd, this.itemGroup.getAllItemsModifiable(), indexBeforeItems);
        }
        this.itemGroup.getPriceAdjHelper().checkItemsOrderedTriggerAdjustments();
        this.itemGroup.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        if (this.itemGroup instanceof TableAccount && SystemProperty.getInstance().isCustomerAssignmentPerSeat()) {
            for (SalesLineItem toAdd : itemsToAdd) {
                toAdd.setCustomer(((TableAccount)this.itemGroup).getCustomerForSeat(toAdd.getSeat()));
            }
        }
    }

    public void removeItem(SalesLineItem itemToRemove, EventContext context) {
        if (itemToRemove.getAccount() != this.itemGroup.getAccount()) {
            throw new IllegalArgumentException("Item " + itemToRemove + " did not come from this account.");
        }
        if (itemToRemove instanceof SalesCombo && !itemToRemove.isPersistent()) {
            boolean hasPersistedItem = false;
            for (SalesItem i : itemToRemove.getSalesItems()) {
                hasPersistedItem = hasPersistedItem || i.isPersistent();
            }
            if (hasPersistedItem) {
                OrderComboHelper h = new OrderComboHelper(new DummyGUIHandler());
                h.replaceCombo(itemToRemove.getAccount(), (SalesCombo)itemToRemove, context.getTerminal(), context.getUser());
                OrderMate.LOG.info("Combo has saved item, breaking the combo instead of deleting");
                return;
            }
        }
        if (itemToRemove.hasSavedItems()) {
            itemToRemove.markAsDeleted(context);
            if (this.itemGroup.getActiveItemsModifiable() != null) {
                this.itemGroup.getActiveItemsModifiable().remove(itemToRemove);
            }
        } else {
            TerminalEventLog.logCanceledItems(this.itemGroup.getUser(), Terminal.getLocalHost(), this.itemGroup, itemToRemove);
            LoyaltyPointAdministrator.getInstance().salesLineItemRemoved(itemToRemove, context);
            this.itemGroup.getAccount().unsafeRemove(itemToRemove);
            this.itemGroup.getActiveItemsModifiable().remove(itemToRemove);
            this.itemGroup.getAllItemsModifiable().remove(itemToRemove);
        }
        this.itemGroup.getPriceAdjHelper().checkItemsOrderedTriggerAdjustments();
        this.itemGroup.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
    }

    public void removeSubItems(SalesLineItem newItem) {
        for (SalesItem item : newItem.getSalesItems()) {
            if (this.itemGroup.getActiveItemsModifiable() == null || !this.itemGroup.getActiveItemsModifiable().remove(item)) continue;
            this.itemGroup.getAllItemsModifiable().remove(item);
        }
    }

    public List<SalesLineItem> getItems(int course) {
        return ItemFilter.filterItems(this.itemGroup.getItems(), new CourseFilter(course), new OrderableItemFilter());
    }

    public List<SalesLineItem> getItems(int course, int seat) {
        return ItemFilter.filterItems(this.itemGroup.getItems(), new CourseFilter(course), new SeatFilter(seat, this.itemGroup.getNumPatrons()), new OrderableItemFilter());
    }

    public List<? extends SalesLineItem> getUnpaidItems() {
        return ItemFilter.filterItems(this.itemGroup.getItems(), new PaidFilter(false));
    }

    public List<SalesLineItem> getAllItemsUnsaved() {
        return ItemFilter.filterItems(this.itemGroup.getAllItems(), new UnsavedFilter());
    }

    public List<SalesLineItem> getItemsForTransaction(FinanceTransaction toGetItems) {
        ArrayList<SalesLineItem> transactionItems = new ArrayList<SalesLineItem>();
        for (SalesLineItem item : this.itemGroup.getAllItems()) {
            if (!item.getFinanceTransactions().contains(toGetItems)) continue;
            transactionItems.add(item);
        }
        return transactionItems;
    }

    public Price getItemTotal() {
        double total = 0.0;
        for (SalesLineItem item : this.itemGroup.getItems()) {
            total += item.getItemLevelPrice().doubleValue();
        }
        return new Price(total, 0.01);
    }

    public Price getItemDefaultPriceTotal() {
        double total = 0.0;
        for (SalesLineItem item : this.itemGroup.getItems()) {
            total += item.getUnadjustedPrice().doubleValue();
        }
        return new Price(total, 0.01);
    }

    public Price getItemTaxTotal() {
        double totalTax = 0.0;
        for (SalesLineItem item : this.itemGroup.getItems()) {
            totalTax += item.getTax().doubleValue();
        }
        return new Price(totalTax, 0.01);
    }

    public void mergeItemIntoOrderedList(List<SalesLineItem> toMergeInto, SalesLineItem newItem, boolean increment, EventContext context) {
        SalesQuantity newQuantity = newItem.getQuantity();
        SalesLineItem equivalentItem = newItem.getEquivalentItem(toMergeInto);
        if (equivalentItem != null) {
            if (newQuantity.notEquals(SalesQuantity.ZERO)) {
                if (increment) {
                    SalesQuantity setQuantity = equivalentItem.getQuantity().add(SalesQuantity.ONE);
                    equivalentItem.setQuantity(setQuantity, context);
                } else {
                    equivalentItem.setQuantity(newQuantity, context);
                }
                toMergeInto.remove(equivalentItem);
                toMergeInto.add(equivalentItem);
            } else {
                toMergeInto.remove(equivalentItem);
            }
        } else if (newQuantity.notEquals(0)) {
            if (newQuantity.greaterThan(1L)) {
                newItem.setQuantity(newItem.getQuantity(), context);
            }
            toMergeInto.add(newItem);
        }
    }

    public List<SalesLineItem> transferItemsTo(Account target, List<? extends SalesLineItem> itemsToTransfer, boolean markPrinted, EventContext context) {
        if (this.itemGroup instanceof Account) {
            Account currentAccount = (Account)this.itemGroup;
            ArrayList<SalesLineItem> transferItems = new ArrayList<SalesLineItem>(itemsToTransfer);
            SalesAdjustmentsTransfer trf = new SalesAdjustmentsTransfer(SalesAdjustmentsTransfer.TRANSFER, currentAccount, target, transferItems, context);
            trf.transferAccountPercentageAdjustment();
            if (currentAccount.hasCustomer() && !target.hasCustomer()) {
                List<SalesLineItem> newItems = target.setCustomer(currentAccount.getCustomer(), context);
                for (SalesLineItem salesLineItem : newItems) {
                    target.getItemHelper().removeItem(salesLineItem, context);
                }
            }
            Map<SalesLineItem, Boolean> newItemsMap = target.copyItemsWithPrintState(transferItems, context, true);
            boolean printMove = target.allowsPrintMove() && currentAccount.allowsPrintMove();
            for (SalesLineItem toMove : transferItems) {
                if (toMove.hasSavedItems()) {
                    if (!toMove.getOriginalTerminal().equals(context.getTerminal())) {
                        toMove.markAsMoved(new EventContext(toMove.getOriginalTerminal(), target.getUser()), printMove);
                        continue;
                    }
                    toMove.markAsMoved(context, printMove);
                    continue;
                }
                currentAccount.unsafeRemove(toMove);
            }
            if (currentAccount.getActiveItemsModifiable() != null) {
                currentAccount.getActiveItemsModifiable().removeAll(transferItems);
            }
            if (markPrinted) {
                for (Map.Entry<SalesLineItem, Boolean> entry : newItemsMap.entrySet()) {
                    boolean isSourceItemPrinted = entry.getValue();
                    SalesLineItem salesLineItem = entry.getKey();
                    if (!isSourceItemPrinted) continue;
                    salesLineItem.markPrinted();
                }
            }
            if (currentAccount instanceof TableAccount && target instanceof TableAccount) {
                TableAccount tableAccount = (TableAccount)currentAccount;
                TableAccount targetTableAcc = (TableAccount)target;
                for (SalesLineItem salesLineItem : itemsToTransfer) {
                    targetTableAcc.getSalesAccountCourse(salesLineItem.getCourse()).setCoursePrintStatus(tableAccount.getSalesAccountCourse(salesLineItem.getCourse()).getCoursePrintStatus());
                }
            }
            if (currentAccount.getItems().isEmpty()) {
                trf.transferFullAccountAmountAdjustment(true);
            }
            currentAccount.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
            target.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
            currentAccount.getPriceAdjHelper().checkItemsOrderedTriggerAdjustments();
            target.getPriceAdjHelper().checkItemsOrderedTriggerAdjustments();
            ArrayList<SalesLineItem> arrayList = new ArrayList<SalesLineItem>();
            for (Map.Entry<SalesLineItem, Boolean> entry : newItemsMap.entrySet()) {
                arrayList.add(entry.getKey());
            }
            LoyaltyPointAdministrator.getInstance().itemsMoved(transferItems, arrayList);
            return arrayList;
        }
        return null;
    }

    public boolean checkUnitStillActive(SalesLineItem item) {
        List<SalesItem> allItems = item.getSalesItems();
        for (SalesItem salesItem : allItems) {
            for (SalesComponent component : salesItem.getComponentList()) {
                InventoryItemUnit unit = component.getUnit();
                if ((unit = (InventoryItemUnit)PersistenceManager.reacquire(unit)).isPubliclyAccessible()) continue;
                return false;
            }
        }
        return true;
    }

    public void setCustomerItems(Customer newCustomer) {
        for (SalesLineItem currentItem : this.itemGroup.getItems()) {
            if (currentItem.getCustomer() != null && newCustomer != null) continue;
            currentItem.setCustomer(newCustomer);
        }
    }
}

