/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.queries.sales.PhoneAccountQueries;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.tables.LogicalTable;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="ONLINE")
@AccessType(value="property")
public class OnlineAccount
extends PhoneAccount {
    public static final Props Properties = new Props();
    private Reference<LogicalTable> logicalTable;
    private boolean extPaidFlag;
    private Date acknowledgedTime;

    public OnlineAccount() {
        super(AccountType.onlinePickupType);
        this.logicalTable = this.createReference(OnlineAccount.Properties.LOGICAL_TABLE);
    }

    public OnlineAccount(EventContext context) {
        super(context, AccountType.onlinePickupType);
        this.logicalTable = this.createReference(OnlineAccount.Properties.LOGICAL_TABLE);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_table")
    public LogicalTable getLogicalTable() {
        return this.logicalTable.get();
    }

    public void setLogicalTable(LogicalTable value) {
        this.logicalTable.set(value);
    }

    @Column(name="ext_paid_flag")
    public boolean isExtPaidFlag() {
        return this.extPaidFlag;
    }

    public void setExtPaidFlag(boolean isPaid) {
        this.extPaidFlag = isPaid;
    }

    @Override
    @Transient
    protected AccountType getAccType() {
        if (this.isDeliverable()) {
            return AccountType.onlineDeliveryType;
        }
        return AccountType.onlinePickupType;
    }

    @Transient
    public Date getAcknowledgedTime() {
        return this.acknowledgedTime;
    }

    public void acknowledge() {
        if (this.getAcknowledgedTime() == null) {
            this.setAcknowledgedTime(new Date());
        }
    }

    protected void setAcknowledgedTime(Date time) {
        this.acknowledgedTime = time;
    }

    public static List<OnlineAccount> getOpenOnlineAccounts() {
        ObjectQuery getOpenDeliveries = PhoneAccountQueries.getUnassignedDeliveryAccountsForType(AccountType.onlineDeliveryType);
        ObjectQuery getOpenPickup = Query.select(OnlineAccount.class).equals(OnlineAccount.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(OnlineAccount.Properties.ACCOUNT_TYPE, AccountType.onlinePickupType);
        List<OnlineAccount> currentAccounts = PersistenceManager.getObjectList(OnlineAccount.class, getOpenDeliveries.toString(), null);
        currentAccounts.addAll(PersistenceManager.getObjectList(OnlineAccount.class, getOpenPickup.toString()));
        for (OnlineAccount acc : currentAccounts) {
            if (acc.getCustomer() == null || !acc.getCustomer().hasChanged()) continue;
            acc.updateCustomerReference();
        }
        return currentAccounts;
    }

    @Override
    @Transient
    public List<PropertiedObject.Property> getCustomerRequirements() {
        if (this.isDeliverable()) {
            return Customer.REQUIRE_ADDRESS_AND_EMAIL;
        }
        return Customer.REQUIRE_EMAIL;
    }

    @Transient
    public boolean isAcknowledged() {
        return this.getAcknowledgedTime() != null;
    }

    @Override
    @Transient
    public DriverAssignmentSettlementType getDriverAssignmentSettlementTypeForAccount() {
        return DriverAssignmentSettlementType.ONLINE;
    }

    @Override
    protected boolean needDeliveryZoneFee() {
        return false;
    }

    public static class Props
    extends PhoneAccount.Props {
        public PropertiedObject.Property<LogicalTable> LOGICAL_TABLE;
        public PropertiedObject.Property EXT_PAID_FLAG;
        public PropertiedObject.Property<Date> ACKNOWLEDGED_TIME;
    }
}

