/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.DeliveryPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.DollarPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.misc.enums.PhoneOrderForceContactStrategy;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.queries.sales.PhoneAccountQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.futureorder.FutureOrderManager;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="PHONE")
@AccessType(value="property")
public class PhoneAccount
extends Account {
    public static final Props Properties = new Props();
    public static final Color ACCOUNT_PAID = new Color(130, 130, 130);
    public static final AccountType TYPE = AccountType.phoneType;
    public static final AccountType DELIVERY_TYPE = AccountType.deliveryType;
    private boolean deliverable = false;
    private boolean delivered = false;
    private boolean deliveryZoneFeeSet = false;
    private Reference<Delivery> delivery;
    private Reference<User> allowingUser;
    private boolean deliverToWarnZone;
    private Reference<DeliveryZone> deliveryZone;

    @Deprecated
    public PhoneAccount() {
        super(TYPE);
        this.delivery = this.createReference(PhoneAccount.Properties.DELIVERY);
        this.allowingUser = this.createReference(PhoneAccount.Properties.ALLOWING_USER);
        this.deliveryZone = this.createReference(PhoneAccount.Properties.DELIVERY_ZONE);
    }

    protected PhoneAccount(AccountType accountType) {
        super(accountType);
        this.delivery = this.createReference(PhoneAccount.Properties.DELIVERY);
        this.allowingUser = this.createReference(PhoneAccount.Properties.ALLOWING_USER);
        this.deliveryZone = this.createReference(PhoneAccount.Properties.DELIVERY_ZONE);
    }

    public PhoneAccount(EventContext context, AccountType accountType) {
        super(context, accountType);
        this.delivery = this.createReference(PhoneAccount.Properties.DELIVERY);
        this.allowingUser = this.createReference(PhoneAccount.Properties.ALLOWING_USER);
        this.deliveryZone = this.createReference(PhoneAccount.Properties.DELIVERY_ZONE);
    }

    public PhoneAccount(EventContext context) {
        super(context, TYPE);
        this.delivery = this.createReference(PhoneAccount.Properties.DELIVERY);
        this.allowingUser = this.createReference(PhoneAccount.Properties.ALLOWING_USER);
        this.deliveryZone = this.createReference(PhoneAccount.Properties.DELIVERY_ZONE);
    }

    @Override
    @Transient
    public List<PropertiedObject.Property> getCustomerRequirements() {
        ArrayList<PropertiedObject.Property> requiredProps = new ArrayList<PropertiedObject.Property>();
        PhoneOrderForceContactStrategy phoneOrderRequirements = SystemProperty.getInstance().getPhoneOrderForceStrategy();
        if (phoneOrderRequirements.equals(PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_BOTH) || phoneOrderRequirements.equals(PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_PHONE)) {
            requiredProps.addAll(Customer.REQUIRE_PHONE);
        }
        if (phoneOrderRequirements.equals(PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_BOTH) || phoneOrderRequirements.equals(PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_EMAIL)) {
            requiredProps.addAll(Customer.REQUIRE_EMAIL_ONLY);
        }
        if (this.isDeliverable()) {
            requiredProps.addAll(Customer.REQUIRE_ADDRESS);
        } else {
            requiredProps.addAll(Customer.REQUIRE_BASIC);
        }
        return requiredProps;
    }

    @Override
    @Transient
    public boolean getRequiresCustomer() {
        return true;
    }

    @Transient
    protected AccountType getAccType() {
        if (this.isDeliverable()) {
            return DELIVERY_TYPE;
        }
        return TYPE;
    }

    @Override
    @Transient
    public String getLabel() {
        String label = this.hasCustomer() ? this.getAccountType().getLabel() + " Account for " + this.getCustomer().getName() : "New " + this.getAccountType().getLabel() + " Account";
        return label;
    }

    @Override
    @Column(name="deliverable")
    public boolean isDeliverable() {
        return this.deliverable;
    }

    private boolean applyDeliveryZoneFee(EventContext context) {
        StreetDirectoryReference ref;
        if (this.getDeliveryZone() == null && this.getCustomer() != null && this.getCustomer().getStreetDirRef() != null && (ref = StreetDirectoryReference.findStreetDir(this.getCustomer().getStreetName(), this.getCustomer().getStreetType(), this.getCustomer().getSuburb())) != null) {
            this.setDeliveryZone(ref.getZone());
        }
        if (this.getDeliveryZone() != null) {
            if (Price.ZERO_DOLLAR.equals(this.getDeliveryZone().getDeliveryFee())) {
                return true;
            }
            DollarPriceAdjustment adj = new DollarPriceAdjustment(PriceAdjustmentManager.getInstance().getDeliveryFee(), this.getDeliveryZone().getDeliveryFee(), context);
            adj.setLabel("Delivery Fee (" + this.getDeliveryZone().getDeliveryFee().toString(true) + ")");
            this.addSalesPriceAdjustment(adj, context);
            return true;
        }
        this.getPriceAdjHelper().applySingleAutomaticAdjustment(context, DeliveryPriceAdjustment.class);
        return true;
    }

    protected boolean needDeliveryZoneFee() {
        if (!SystemProperty.getInstance().isUseDeliveryZones()) {
            return false;
        }
        if (!this.hasDeliverySurcharge()) {
            this.deliveryZoneFeeSet = false;
        }
        return this.deliverable && !this.deliveryZoneFeeSet;
    }

    private boolean hasDeliverySurcharge() {
        return PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentType.DELIVERY_SURCHARGE).size() > 0;
    }

    public void setDeliverable(boolean isDeliverable, EventContext context) {
        boolean wasDeliverable = this.deliverable;
        this.deliverable = isDeliverable;
        this.setAccountType(this.getAccType());
        if (isDeliverable != wasDeliverable) {
            if (!SystemProperty.getInstance().isUseDeliveryZones()) {
                this.getPriceAdjHelper().applySingleAutomaticAdjustment(context, DeliveryPriceAdjustment.class);
            }
            if (this.needDeliveryZoneFee()) {
                this.getPriceAdjHelper().addTriggeredPriceAdjustmentbyTrigger(AbstractTrigger.getTriggersByType(AbstractTrigger.Types.DELIVERY_ZONE_TYPE), context);
            }
            this.getPriceAdjHelper().useHighestActivePriceLevel(new HashSet<PriceLevel>(PriceLevel.getAllPriceLevels()), true, context, "Account changed from pickup to delivery");
        }
        if (this.needDeliveryZoneFee() && !this.hasDeliverySurcharge()) {
            this.deliveryZoneFeeSet = this.applyDeliveryZoneFee(context);
        } else if (!this.deliverable && this.deliveryZoneFeeSet) {
            if (this.hasDeliverySurcharge()) {
                ArrayList<SalesPriceAdjustment> filteredAdjustments = new ArrayList<SalesPriceAdjustment>();
                for (SalesPriceAdjustment s : this.getPriceAdjustments()) {
                    if (!s.getType().equals(PriceAdjustmentType.DELIVERY_SURCHARGE)) continue;
                    filteredAdjustments.add(s);
                }
                this.getPriceAdjHelper().removePriceAdjustments(filteredAdjustments, context);
            }
            this.deliveryZoneFeeSet = false;
        }
    }

    @Override
    @Transient
    public Date getCreationDateTime() {
        return super.getCreationDateTime();
    }

    @Transient
    public Price getDeliveryFee() {
        List<SalesPriceAdjustment> adjs = PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentType.DELIVERY_SURCHARGE);
        if (adjs.size() == 0) {
            return Price.ZERO_DOLLAR;
        }
        Price feeTotal = Price.ZERO_DOLLAR;
        for (SalesPriceAdjustment adj : adjs) {
            feeTotal = feeTotal.add(adj.getSavedValue());
        }
        return feeTotal.multiply(-1);
    }

    @Override
    public boolean needsInfo() {
        return !this.hasCustomer();
    }

    @Override
    public List<SalesLineItem> setCustomer(Customer customer, EventContext context) {
        PhoneAccount previous;
        List<SalesLineItem> newItems = super.setCustomer(customer, context);
        if (customer == null) {
            return new ArrayList<SalesLineItem>();
        }
        SystemProperty props = SystemProperty.getInstance();
        if (props.isAutoFillLastComment() && !this.hasComment() && (previous = (PhoneAccount)AccountQueries.getLastAccountForCustomer(this, customer)) != null && previous.hasComment()) {
            this.setComment(previous.getComment());
        }
        return newItems;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (!this.getFinanceTransactions().isEmpty() && !this.isLocked()) {
            return ACCOUNT_PAID;
        }
        return super.getBackgroundColor();
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_delivery")
    public Delivery getDelivery() {
        return this.delivery.get();
    }

    public void setDelivery(Delivery newDelivery) {
        this.delivery.set(newDelivery);
    }

    public boolean hasDelivery() {
        return this.getDelivery() != null;
    }

    @Column(name="delivered")
    public boolean isDelivered() {
        return this.delivered;
    }

    public void setDelivered() {
        this.delivered = true;
    }

    @Column(name="deliv_warn_zone")
    public boolean isDeliverToWarnZone() {
        return this.deliverToWarnZone;
    }

    public void setDeliverToWarnZone(boolean sendToWarn) {
        this.deliverToWarnZone = sendToWarn;
    }

    public static List<Account> getAccountsForDriver(User driver, String deliveryState) {
        List<Account> accounts = PersistenceManager.getObjectList(Account.class, "SELECT sales_account.* FROM sales_account, sales_delivery WHERE sales_delivery.FK_config_user_driver = ? AND sales_account.FK_sales_delivery = sales_delivery.ID AND sales_account.delivered = ? AND sales_delivery.delivery_state = ? AND sales_delivery.system_state = 'ACTIVE' ", new Object[]{driver.getID(), Boolean.TRUE, deliveryState});
        accounts.addAll(PersistenceManager.getObjectList(Account.class, "SELECT sales_account.* FROM sales_account, sales_delivery WHERE sales_delivery.FK_config_user_driver = ? AND sales_account.FK_sales_delivery = sales_delivery.ID AND sales_account.delivered = ? AND sales_delivery.delivery_state = ? AND sales_delivery.system_state = 'ACTIVE' ", new Object[]{driver.getID(), Boolean.FALSE, deliveryState}));
        return accounts;
    }

    public static List<PhoneAccount> getUndeliveredAccountsForDriver(User driver) {
        return PersistenceManager.getObjectList(PhoneAccount.class, Query.select(PhoneAccount.class).linkUsing(PhoneAccount.Properties.DELIVERY, Delivery.Properties.ID).equals(Delivery.Properties.DRIVER, driver).equals(PhoneAccount.Properties.DELIVERED, Boolean.FALSE).equals(PhoneAccount.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).toString());
    }

    public static List<Account> getUnassignedDeliveryAccounts() {
        return PersistenceManager.getObjectList(Account.class, PhoneAccountQueries.GET_UNASSIGNED_DELIVERY_ACCOUNTS, null);
    }

    public static List<PhoneAccount> getCurrentAccounts() {
        ArrayList<PhoneAccount> accounts = new ArrayList<PhoneAccount>();
        accounts.addAll(PersistenceManager.getObjectList(PhoneAccount.class, "SELECT sales_account.* FROM sales_account WHERE sales_account.account_type = 'PHONE' AND sales_account.deliverable = 0 AND sales_account.account_state = 'OPEN'", null));
        accounts.addAll(PersistenceManager.getObjectList(PhoneAccount.class, PhoneAccountQueries.getUnassignedDeliveryAccountsForType(DELIVERY_TYPE).toString(), null));
        return accounts;
    }

    @Override
    public void close(EventContext context) {
        super.close(context);
        if (this.isDeliverable() && this.getItems().isEmpty()) {
            this.setDelivered();
        }
    }

    @Override
    @Transient
    public Customer getCustomer() {
        Customer theCustomer = super.getCustomer();
        if (this.isPersistent() && theCustomer == null) {
            OrderMate.LOG.warn("The PHONE account " + this.getID() + "has a null customer.");
            theCustomer = new Customer.NULL_CUSTOMER();
        }
        return theCustomer;
    }

    @Override
    protected String createRendererLabel() {
        String toReturn = this.hasCustomer() ? this.getCustomer().getName() : "No customer";
        return toReturn;
    }

    @Override
    @Transient
    public boolean isClosePossible() {
        if (!SystemProperty.getInstance().canAssignDriver(this.getDriverAssignmentSettlementTypeForAccount())) {
            return super.isClosePossible();
        }
        return (!this.isDeliverable() || this.isDelivered() || this.getItems().isEmpty()) && super.isClosePossible();
    }

    protected void setDelivered(boolean value) {
        this.delivered = value;
    }

    protected void setDeliverable(boolean value) {
        this.deliverable = value;
        this.setAccountType(this.getAccType());
    }

    public void setAllowingUser(User user) {
        this.allowingUser.set(user);
    }

    @ManyToOne
    @JoinColumn(name="FK_allowing_user")
    public User getAllowingUser() {
        return this.allowingUser.get();
    }

    @Transient
    public boolean isMinimumDeliveryOverriden() {
        return !this.allowingUser.isNull();
    }

    public boolean requireMinimumOrderPrompt(Terminal terminal) {
        Price minDelivery = terminal.getMinimumDeliveryOrder();
        Price total = this.getTotalForMinOrderPrompt();
        return minDelivery.greaterThan(Price.ZERO_DOLLAR) && this.isOpen() && this.isTotalChanged() && this.isDeliverable() && total.lessThan(minDelivery) && this.hasItems();
    }

    @Transient
    public Price getTotalForMinOrderPrompt() {
        boolean incDeliveryFee = SystemProperty.getInstance().isDeliveryFeeCountsToMinOrderAmount();
        Price total = this.getTotal();
        if (!incDeliveryFee) {
            total = total.subtract(SystemProperty.getInstance().getDeliveryFee().getDollarAmount());
        }
        return total;
    }

    @Override
    public void save() {
        this.initCurrentSaveContext();
        if (this.isTotalChanged() && this.isMinimumDeliveryOverriden() && this.isOpen()) {
            Price minDelivery = this.currentSaveContext.getTerminal().getMinimumDeliveryOrder();
            if (!this.getTotal().lessThan(minDelivery)) {
                this.setAllowingUser(null);
            }
        }
        super.save();
    }

    @Override
    @Transient
    public boolean isWastageCheckNeeded() {
        return super.isWastageCheckNeeded() && !FutureOrderManager.getInstance().checkInterceptPrintConditions(this);
    }

    @Override
    public boolean shouldAutoFillAccount() {
        return SystemProperty.getInstance().isAutoFillLastItemsPhone();
    }

    @Transient
    public DriverAssignmentSettlementType getDriverAssignmentSettlementTypeForAccount() {
        return DriverAssignmentSettlementType.PHONE;
    }

    @Transient
    public DeliveryZone getDeliveryZone() {
        return this.deliveryZone.get();
    }

    public void setDeliveryZone(DeliveryZone deliveryZone) {
        this.deliveryZone.set(deliveryZone);
    }

    public static class Props
    extends Account.Props {
        public PropertiedObject.Property<Delivery> DELIVERY;
        public PropertiedObject.Property DELIVERED;
        public PropertiedObject.Property DELIVERABLE;
        public PropertiedObject.Property<User> ALLOWING_USER;
        public PropertiedObject.Property DELIVER_TO_WARN_ZONE;
        public PropertiedObject.Property<DeliveryZone> DELIVERY_ZONE;
    }
}

