/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.FlatPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.PercentagePriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.PriceLevelSalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesAdjustmentCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesItemSummaryCreator;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.users.User;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class PriceAdjustmentCalculator {
    private static final Price ZERO = new Price(0.0, 1.0E-7);
    private final ItemGroup itemGroup;
    private List<SalesItem> items = new ArrayList<SalesItem>();
    private List<SalesComponent> components = new ArrayList<SalesComponent>();
    private Collection<SalesPriceAdjustment> itemGroupPriceAdjustments;
    private Map<SalesItem, List<SalesPriceAdjustment>> salesItemsPriceAdjustments = new HashMap<SalesItem, List<SalesPriceAdjustment>>();
    private Map<SalesItem, List<SalesComponent>> salesItemsComponents = new HashMap<SalesItem, List<SalesComponent>>();

    public PriceAdjustmentCalculator(ItemGroup itemGpToPriceAdj) {
        this.itemGroup = itemGpToPriceAdj;
        this.cacheSalesItems();
        this.itemGroupPriceAdjustments = new HashSet<SalesPriceAdjustment>(this.itemGroup.getPriceAdjustments());
    }

    void calcSalesPriceAdjustmentUsages() {
        if (!this.itemGroup.isLocked()) {
            OrderMate.LOG.warn("Calculating price adjustments on an unlocked item group.");
        }
        this.resetPriceAdjustmentUsages();
        Price runningTotal = this.calcSalesItemPriceAdjustmentUsages();
        runningTotal = this.calcDollarAdjustmentUsages(runningTotal);
        runningTotal = this.calcPercentagePriceAdjustmentUsages(runningTotal);
        runningTotal = this.calcFinalPriceAdjustmentUsages(runningTotal);
        this.removeOrphanedPriceAdjUsages();
    }

    private void removeOrphanedPriceAdjUsages() {
        boolean isExTax = SystemProperty.getInstance().isExTax();
        HashSet<SalesPriceAdjustment> adjustments = new HashSet<SalesPriceAdjustment>();
        adjustments.addAll(this.itemGroup.getPriceAdjustments());
        for (SalesLineItem lineItem : this.itemGroup.getItems()) {
            for (SalesItem item : lineItem.getSalesItems()) {
                HashSet<SalesPriceAdjustment> itemAdj = new HashSet<SalesPriceAdjustment>();
                itemAdj.addAll(item.getPriceAdjustments());
                for (SalesComponent comp : item.getComponentList()) {
                    HashSet<SalesPriceAdjustmentUsage> removeSet = new HashSet<SalesPriceAdjustmentUsage>();
                    for (SalesPriceAdjustmentUsage usage : comp.getPriceAdjustmentUsages()) {
                        if (adjustments.contains(usage.getSalesPriceAdjustment()) || itemAdj.contains(usage.getSalesPriceAdjustment())) continue;
                        removeSet.add(usage);
                    }
                    for (SalesPriceAdjustmentUsage usage : removeSet) {
                        comp.removePriceAdjustmentUsage(usage);
                    }
                    if (!isExTax) continue;
                    comp.recalculateTax();
                }
            }
        }
    }

    private Price calcSalesItemPriceAdjustmentUsages() {
        Price totalBeforeItemGroupAdjs = ZERO;
        for (SalesItem item : this.items) {
            PriceAdjustmentCalculator.calcPriceAdjustmentUsages(item);
            totalBeforeItemGroupAdjs = totalBeforeItemGroupAdjs.add(item.getItemLevelPrice());
        }
        return totalBeforeItemGroupAdjs;
    }

    private Price calcDollarAdjustmentUsages(Price totalBeforeItemGroupAdjs) {
        return this.calculateDollarBasedItemGroupAdjustment(totalBeforeItemGroupAdjs, PriceAdjustmentUnit.DOLLAR_UNIT);
    }

    private Price calcFinalPriceAdjustmentUsages(Price runningTotal) {
        return this.calculateDollarBasedItemGroupAdjustmentNew(runningTotal, PriceAdjustmentUnit.FINAL_UNIT);
    }

    private Price calculateDollarBasedItemGroupAdjustment(Price totalBeforeItemGroupAdjs, PriceAdjustmentUnit unit) {
        Price runningTotal = totalBeforeItemGroupAdjs;
        List<SalesPriceAdjustment> dollarAdjustments = PriceAdjustmentManager.getInstance().getMatching(this.itemGroupPriceAdjustments, unit);
        for (SalesPriceAdjustment dollarAdj : dollarAdjustments) {
            Price actualAdjustment = ZERO;
            Price difference = ZERO;
            Price calculatedAmount = new Price(dollarAdj.calcValue(runningTotal), 0.01);
            for (SalesItem item : this.items) {
                if (!this.itemGroup.getPriceAdjHelper().isPriceAdjApplicable(dollarAdj, item)) continue;
                actualAdjustment = actualAdjustment.add(this.applyDollarPriceAdjustment(item, totalBeforeItemGroupAdjs, dollarAdj, calculatedAmount));
                difference = calculatedAmount.subtract(actualAdjustment);
            }
            runningTotal = runningTotal.subtract(actualAdjustment);
            if (difference == null || difference.equals(ZERO)) continue;
            Price distributedDifference = this.distributeAdjustmentDifference(difference, dollarAdj);
            runningTotal = runningTotal.subtract(distributedDifference);
        }
        return runningTotal;
    }

    private Price calculateDollarBasedItemGroupAdjustmentNew(Price totalBeforeItemGroupAdjs, PriceAdjustmentUnit unit) {
        Price runningTotal = totalBeforeItemGroupAdjs;
        List<SalesPriceAdjustment> dollarAdjustments = PriceAdjustmentManager.getInstance().getMatching(this.itemGroupPriceAdjustments, unit);
        for (SalesPriceAdjustment dollarAdj : dollarAdjustments) {
            BigDecimal remainingAdjustment;
            ArrayList<SalesItem> applicableItems = new ArrayList<SalesItem>();
            for (SalesItem item : this.items) {
                if (!this.itemGroup.getPriceAdjHelper().isPriceAdjApplicable(dollarAdj, item)) continue;
                applicableItems.add(item);
            }
            BigDecimal adjustmentTotal = dollarAdj.calcValue(runningTotal).toBigDecimal().setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal appliedAdjustment = BigDecimal.ZERO;
            for (int i = 0; i < applicableItems.size() && !(remainingAdjustment = adjustmentTotal.subtract(appliedAdjustment).setScale(2, RoundingMode.HALF_EVEN)).equals(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN)); ++i) {
                BigDecimal toApply;
                SalesItem item = (SalesItem)applicableItems.get(i);
                if (i == applicableItems.size() - 1) {
                    toApply = remainingAdjustment;
                } else {
                    BigDecimal itemProportion = item.getPrice().toBigDecimal().divide(runningTotal.toBigDecimal(), RoundingMode.HALF_EVEN);
                    toApply = adjustmentTotal.multiply(itemProportion).setScale(2, RoundingMode.HALF_EVEN);
                    if (adjustmentTotal.subtract(appliedAdjustment.add(toApply)).setScale(2, RoundingMode.HALF_EVEN).signum() != adjustmentTotal.signum()) {
                        toApply = remainingAdjustment;
                    }
                }
                BigDecimal appliedItemAmount = this.applyDollarPriceAdjustmentNew(item, runningTotal.toBigDecimal(), dollarAdj, toApply);
                runningTotal = runningTotal.subtract(new Price(appliedItemAmount, 0.01));
                appliedAdjustment = appliedAdjustment.add(appliedItemAmount).setScale(2, RoundingMode.HALF_EVEN);
            }
        }
        return new Price(runningTotal, 0.01);
    }

    private Price applyDollarPriceAdjustment(SalesItem currentItem, Price totalBeforeItemGroupAdjs, SalesPriceAdjustment dollarAdj, Price adjValue) {
        Price itemPrice = currentItem.getItemLevelPrice();
        Price itemPricePerUnit = currentItem.getItemLevelPricePerItem();
        Price actualAdjustment = ZERO;
        for (SalesComponent currentComponent : this.salesItemsComponents.get(currentItem)) {
            double compRatio = 0.0;
            if (!itemPricePerUnit.isZero()) {
                compRatio = currentComponent.getItemLevelPrice().divide(itemPricePerUnit).doubleValue();
            }
            double itemRatio = 0.0;
            if (!totalBeforeItemGroupAdjs.isZero()) {
                itemRatio = itemPrice.divide(totalBeforeItemGroupAdjs).doubleValue();
            }
            BigDecimal usageValueBD = BigDecimal.ZERO;
            if (currentItem.getQuantity().notEquals(0)) {
                usageValueBD = usageValueBD.add(adjValue.toBigDecimal().multiply(new BigDecimal(itemRatio)).multiply(new BigDecimal(compRatio)).divide(currentItem.getQuantity().getValue(), 4, RoundingMode.HALF_UP));
            }
            Price usageValue = new Price(usageValueBD, 1.0E-4);
            SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(dollarAdj, dollarAdj.getCreationContext());
            usage.setUnitValue(usageValue);
            actualAdjustment = actualAdjustment.add(usageValue.multiply(currentItem.getQuantity().getValue()));
        }
        return actualAdjustment;
    }

    private BigDecimal applyDollarPriceAdjustmentNew(SalesItem currentItem, BigDecimal totalBeforeItemGroupAdjs, SalesPriceAdjustment dollarAdj, BigDecimal adjValue) {
        BigDecimal remainingAdjustment = adjValue.setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal appliedAdjustment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN);
        List<SalesComponent> components = this.salesItemsComponents.get(currentItem);
        for (int i = 0; i < components.size(); ++i) {
            BigDecimal componentAdjustment;
            SalesComponent component = components.get(i);
            if (i == components.size() - 1) {
                componentAdjustment = remainingAdjustment;
            } else {
                BigDecimal adjustmentProportion = component.getItemLevelPrice().toBigDecimal().divide(totalBeforeItemGroupAdjs, RoundingMode.HALF_EVEN);
                componentAdjustment = adjValue.multiply(adjustmentProportion);
                if (adjValue.subtract(appliedAdjustment.add(componentAdjustment)).setScale(2, RoundingMode.HALF_EVEN).signum() != adjValue.signum()) {
                    componentAdjustment = remainingAdjustment;
                }
            }
            BigDecimal usageAdjustment = currentItem.getQuantity().notEquals(0) ? componentAdjustment.setScale(5, RoundingMode.UNNECESSARY).divide(currentItem.getQuantity().getValue(), RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
            SalesPriceAdjustmentUsage usage = component.getPriceAdjustmentUsage(dollarAdj, dollarAdj.getCreationContext());
            usage.setUnitValue(new Price(usageAdjustment, 1.0E-5));
            remainingAdjustment = remainingAdjustment.subtract(usageAdjustment.multiply(currentItem.getQuantity().getValue()));
            appliedAdjustment = appliedAdjustment.add(usageAdjustment.multiply(currentItem.getQuantity().getValue()));
        }
        return appliedAdjustment.setScale(2, RoundingMode.HALF_EVEN);
    }

    private boolean isAllItemsLessThanOneQuantity(List<SalesItemSummary> summaries) {
        for (SalesItemSummary summary : summaries) {
            for (SalesItem item : summary.getSalesItems()) {
                if (!item.getQuantity().greaterThanOrEquals(1L)) continue;
                return false;
            }
        }
        return true;
    }

    private Price distributeAdjustmentDifference(Price difference, SalesPriceAdjustment dollarAdj) {
        Price distributedPrice = ZERO;
        List<SalesItemSummary> summaries = new SalesItemSummaryCreator().getSummaries(this.items);
        Collections.sort(summaries, new Comparator<SalesItemSummary>(){

            @Override
            public int compare(SalesItemSummary arg0, SalesItemSummary arg1) {
                return arg0.getSalesItem().getPrice().compareTo(arg1.getSalesItem().getPrice());
            }
        });
        if (summaries.size() > 0) {
            SalesItemSummary targetSummary = null;
            if (this.isAllItemsLessThanOneQuantity(summaries) && difference.equals(distributedPrice = this.distributeAdjustmentDiffToDecimalQty(summaries, difference, dollarAdj))) {
                return distributedPrice;
            }
            for (SalesItemSummary summary : summaries) {
                boolean hasUnOrderableItem;
                boolean bl = hasUnOrderableItem = summary.getSalesItems().get(0) != null && summary.getSalesItems().get(0).getLabel().contains("!Unorderable Item!");
                if (!summary.getTotalQuantity().equals(1L) || !summary.getTotalPrice().greaterThan(difference) || !summary.getTotalPrice().greaterThan(Price.ZERO_DOLLAR) && !hasUnOrderableItem) continue;
                targetSummary = summary;
                break;
            }
            if (targetSummary != null) {
                distributedPrice = this.applyAdjustmentDifferenceToUsage(this.salesItemsComponents.get(targetSummary.getSalesItem()).get(0), dollarAdj, difference, SalesQuantity.ONE);
            } else {
                SalesComponent theComponent = null;
                block1: for (SalesItemSummary summary : summaries) {
                    for (SalesItem item : summary.getSalesItems()) {
                        if (!item.getQuantity().equals(1L) || !difference.lessThan(Price.ZERO_DOLLAR) && !item.getPrice().greaterThan(Price.ZERO_DOLLAR) && !item.getLabel().contains("!Unorderable Item!")) continue;
                        theComponent = this.salesItemsComponents.get(item).get(0);
                        continue block1;
                    }
                }
                if (theComponent == null) {
                    if (Terminal.isLocalHostSetup()) {
                        OrderMateLog.LOG.warn("Cannot distribute the dollar adjustment cleanly, splitting an item.");
                        theComponent = this.splitComponentForDifference(summaries);
                    } else {
                        OrderMateLog.LOG.warn("Cannot distribute and adjustment difference without a local Terminal setup.");
                    }
                } else {
                    distributedPrice = this.applyAdjustmentDifferenceToUsage(theComponent, dollarAdj, difference, SalesQuantity.ONE);
                }
            }
        } else {
            OrderMateLog.LOG.warn("Cannot distribute and adjustment difference on no components.");
        }
        return distributedPrice;
    }

    private Price distributeAdjustmentDiffToDecimalQty(List<SalesItemSummary> summaries, Price difference, SalesPriceAdjustment dollarAdj) {
        Price distributedPrice = ZERO;
        SalesItemSummary targetSummary = null;
        for (SalesItemSummary summary : summaries) {
            boolean hasUnOrderableItem;
            boolean bl = hasUnOrderableItem = summary.getSalesItems().get(0) != null && summary.getSalesItems().get(0).getLabel().contains("!Unorderable Item!");
            if (!summary.getTotalPrice().greaterThan(difference) || !summary.getTotalPrice().greaterThan(Price.ZERO_DOLLAR) && !hasUnOrderableItem) continue;
            targetSummary = summary;
            break;
        }
        if (targetSummary != null) {
            distributedPrice = this.applyAdjustmentDifferenceToUsage(this.salesItemsComponents.get(targetSummary.getSalesItem()).get(0), dollarAdj, difference, targetSummary.getTotalQuantity());
        }
        return distributedPrice;
    }

    private Price applyAdjustmentDifferenceToUsage(SalesComponent theComponent, SalesPriceAdjustment dollarAdj, Price difference, SalesQuantity quantity) {
        SalesPriceAdjustmentUsage usage = theComponent.getPriceAdjustmentUsage(dollarAdj, dollarAdj.getCreationContext());
        usage.setUnitValue(usage.getUnitValue().add(difference.divide(quantity.getValue())));
        Price distributedPrice = difference;
        OrderMateLog.LOG.info("Distributing difference in applied adjustments: " + difference + " to item group: " + this.itemGroup.getLabel() + " on component: " + theComponent);
        return distributedPrice;
    }

    private Price calcPercentagePriceAdjustmentUsages(Price runningTotal) {
        boolean isExTax = SystemProperty.getInstance().isExTax();
        Price total = runningTotal;
        List<SalesPriceAdjustment> percItemAdjustments = PriceAdjustmentManager.getInstance().getMatching(this.itemGroupPriceAdjustments, PriceAdjustmentUnit.PERCENTAGE_UNIT);
        for (SalesPriceAdjustment percAdj : percItemAdjustments) {
            Price cap = null;
            if (percAdj instanceof PercentagePriceAdjustment) {
                cap = ((PercentagePriceAdjustment)percAdj).getCap();
            }
            for (SalesComponent currentComponent : this.components) {
                if (!this.itemGroup.getPriceAdjHelper().isPriceAdjApplicable(percAdj, currentComponent.getSalesItem())) continue;
                SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(percAdj, percAdj.getCreationContext());
                Price unadjustedTotal = isExTax ? currentComponent.getUnadjustedTotalExTax() : currentComponent.getUnadjustedTotal();
                Price value = percAdj.calcValue(unadjustedTotal.subtract(currentComponent.getPriceAdjustmentUsageUnitTotal()));
                if (cap != null) {
                    SalesQuantity qty = currentComponent.getSalesItem().getQuantity();
                    Price totalValue = value.multiply(qty).abs();
                    if (totalValue.greaterThan(cap)) {
                        if (value.lessThan(Price.ZERO_DOLLAR)) {
                            value = cap.negate();
                            totalValue = totalValue.negate();
                        } else {
                            value = cap;
                        }
                        value = value.divide(qty.getValue());
                        cap = Price.ZERO_DOLLAR;
                    } else if ((cap = cap.subtract(totalValue)).lessThan(Price.ZERO_DOLLAR)) {
                        cap = Price.ZERO_DOLLAR;
                    }
                    if (!Price.ZERO_DOLLAR.equals(value)) {
                        total = total.subtract(totalValue);
                        usage.setUnitValue(value);
                    }
                } else {
                    usage.setUnitValue(value);
                }
                total = total.subtract(usage.getValue());
            }
        }
        return total;
    }

    private void resetPriceAdjustmentUsages() {
        for (SalesComponent sc : this.components) {
            for (SalesPriceAdjustmentUsage componentUsage : sc.getPriceAdjustmentUsages()) {
                componentUsage.setUnitValue(ZERO);
            }
        }
        for (SalesPriceAdjustment adj : this.itemGroupPriceAdjustments) {
            for (SalesPriceAdjustmentUsage usage : adj.getPriceAdjustmentUsages()) {
                usage.setUnitValue(ZERO);
            }
        }
    }

    protected static void calcPriceAdjustmentUsages(SalesItem item) {
        boolean isExTax = SystemProperty.getInstance().isExTax();
        Price workingTotal = PriceAdjustmentCalculator.calcPriceLevelAdjustments(item, isExTax);
        workingTotal = PriceAdjustmentCalculator.calcFlatPriceAdjustments(item, workingTotal, isExTax);
        PriceAdjustmentCalculator.calcDollarPriceAdjustments(item, workingTotal, isExTax);
        PriceAdjustmentCalculator.calcPercentagePriceAdjustments(item, isExTax);
        PriceAdjustmentCalculator.calcFinalPriceAdjustments(item, isExTax);
    }

    private static void calcPercentagePriceAdjustments(SalesItem item, boolean isExTax) {
        List<SalesPriceAdjustment> percItemAdjustments = PriceAdjustmentManager.getInstance().getMatching(item.getPriceAdjustments(), PriceAdjustmentUnit.PERCENTAGE_UNIT);
        for (PercentagePriceAdjustment percentagePriceAdjustment : percItemAdjustments) {
            Price cap = percentagePriceAdjustment.getCap();
            for (SalesComponent currentComponent : item.getComponentList()) {
                SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(percentagePriceAdjustment, percentagePriceAdjustment.getCreationContext());
                currentComponent.removePriceAdjustmentUsage(usage);
                Price unadjustedTotal = isExTax ? currentComponent.getUnadjustedTotalExTax() : currentComponent.getUnadjustedTotal();
                Price currentAdjTotal = new Price(unadjustedTotal.add(PriceAdjustmentCalculator.getSalesComponentPriceAdd(currentComponent)).subtract(currentComponent.getPriceAdjustmentUsageUnitTotal()), 1.0E-5);
                Price value = percentagePriceAdjustment.calcValue(currentAdjTotal);
                if (cap != null) {
                    SalesQuantity qty = item.getQuantity();
                    Price totalValue = value.multiply(qty).abs();
                    if (totalValue.greaterThan(cap)) {
                        if (value.lessThan(Price.ZERO_DOLLAR)) {
                            value = cap.negate();
                            totalValue = totalValue.negate();
                        } else {
                            value = cap;
                        }
                        value = value.divide(qty.getValue());
                        cap = Price.ZERO_DOLLAR;
                    } else if ((cap = cap.subtract(totalValue)).lessThan(Price.ZERO_DOLLAR)) {
                        cap = Price.ZERO_DOLLAR;
                    }
                    if (!Price.ZERO_DOLLAR.equals(value)) {
                        usage.setUnitValue(value);
                    }
                }
                if (Price.ZERO_DOLLAR.equals(value)) continue;
                usage.setUnitValue(value);
                currentComponent.addPriceAdjustmentUsage(usage);
            }
        }
    }

    private static Price getSalesComponentPriceAdd(SalesComponent currentComponent) {
        Price toAdd = Price.ZERO_DOLLAR;
        if (currentComponent.getSalesItem().getInventoryComboGroup() == null) {
            return toAdd;
        }
        List<InventoryComboGroup> comboGroups = Arrays.asList(currentComponent.getSalesItem().getInventoryComboGroup());
        for (InventoryComboGroup comboGroup : comboGroups) {
            for (InventoryComboGroupItemUnitLink unitLink : comboGroup.getGroupUnitLink()) {
                try {
                    if (!unitLink.getItemUnit().equals(currentComponent.getUnit()) || Price.ZERO_DOLLAR.equals(unitLink.getPriceAdd())) continue;
                    return unitLink.getPriceAdd().multiply(currentComponent.getSalesItem().getQuantity());
                }
                catch (NullPointerException e) {
                    if (Config.isDebuging()) {
                        OrderMate.LOG.error(ReflectionToStringBuilder.toString((Object)unitLink));
                        throw e;
                    }
                    OrderMate.LOG.error("#Freya# checkPriceAdds encountered an issue for InventoryComboGroupItemUnitLink id = " + unitLink.getID() + "\nCombo id = " + comboGroups.get(0).getID() + "\nComboGroup id = " + comboGroup.getID(), (Throwable)e);
                    OrderMate.LOG.error(ReflectionToStringBuilder.toString((Object)unitLink));
                }
            }
        }
        return toAdd;
    }

    private static Price calcDollarPriceAdjustments(SalesItem item, Price workingTotal, boolean isExTax) {
        if (workingTotal.equals(ZERO)) {
            return ZERO;
        }
        Price componentTotal = workingTotal;
        List<SalesComponent> componentsList = item.getComponentList();
        Collection<SalesPriceAdjustment> itemPriceAdjustments = item.getPriceAdjustments();
        List<SalesPriceAdjustment> dollarAdjustments = PriceAdjustmentManager.getInstance().getMatching(itemPriceAdjustments, PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.SURCHARGE);
        dollarAdjustments.addAll(PriceAdjustmentManager.getInstance().getMatching(itemPriceAdjustments, PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentDirection.DISCOUNT));
        InventoryPriceAdjustment comboAdjustment = null;
        if (item.isComboItem() && item.getParentCombo() instanceof SalesAdjustmentCombo) {
            comboAdjustment = ((SalesAdjustmentCombo)item.getParentCombo()).getPriceAdjustment();
        }
        for (SalesPriceAdjustment dollarAdj : dollarAdjustments) {
            boolean isComboDiscount = dollarAdj.getInventoryPriceAdjustment().equals(comboAdjustment);
            Price adjValue = isComboDiscount ? dollarAdj.calcValue(componentTotal) : dollarAdj.calcValue(componentTotal.multiply(item.getQuantity()));
            for (SalesComponent currentComponent : componentsList) {
                Price componentPrice = currentComponent.getUnadjustedTotalAfterPriceLevelAndFlatPriceAdjustments();
                if (isExTax) {
                    componentPrice = componentPrice.subtract(currentComponent.getUnadjustedTax());
                }
                if (!isComboDiscount) {
                    componentPrice = componentPrice.divide(item.getQuantity().getValue());
                }
                SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(dollarAdj, dollarAdj.getCreationContext());
                if (!componentTotal.equals(ZERO)) {
                    usage.setUnitValue(adjValue.multiply(componentPrice).divide(componentTotal));
                    continue;
                }
                usage.setUnitValue(adjValue.multiply(componentPrice).divide(componentsList.size()));
            }
        }
        return componentTotal;
    }

    private static void calcFinalPriceAdjustments(SalesItem item, boolean isExTax) {
        Price componentTotal = item.getPrice();
        Collection<SalesPriceAdjustment> itemPriceAdjustments = item.getPriceAdjustments();
        List<SalesComponent> itemComponents = item.getComponentList();
        List<SalesPriceAdjustment> addAdjustments = PriceAdjustmentManager.getInstance().getMatching(itemPriceAdjustments, PriceAdjustmentUnit.FINAL_UNIT, PriceAdjustmentDirection.SURCHARGE);
        addAdjustments.addAll(PriceAdjustmentManager.getInstance().getMatching(itemPriceAdjustments, PriceAdjustmentUnit.FINAL_UNIT, PriceAdjustmentDirection.DISCOUNT));
        for (FinalSalesPriceAdjustment finalSalesPriceAdjustment : addAdjustments) {
            Price adjValue = finalSalesPriceAdjustment.calcValue(componentTotal);
            for (SalesComponent currentComponent : itemComponents) {
                Price unadjustedTotal = isExTax ? currentComponent.getUnadjustedTotalExTax() : currentComponent.getUnadjustedTotal();
                Price componentPrice = unadjustedTotal.subtract(currentComponent.getPriceAdjustmentUsageUnitTotal());
                SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(finalSalesPriceAdjustment, finalSalesPriceAdjustment.getCreationContext());
                if (!componentTotal.equals(ZERO)) {
                    usage.setUnitValue(adjValue.multiply(componentPrice).divide(componentTotal));
                    continue;
                }
                usage.setUnitValue(adjValue.divide(itemComponents.size()).divide(item.getQuantity().getValue()));
            }
        }
    }

    public static Price calcPriceLevelAdjustments(SalesItem item, boolean isExTax) {
        Price componentTotal;
        SalesQuantity itemQuantity = item.getQuantity();
        List<SalesComponent> componentsList = item.getComponentList();
        Price price = componentTotal = itemQuantity.notEquals(0) ? item.getUnadjustedPrice().divide(itemQuantity.getValue()) : ZERO;
        if (isExTax && !componentTotal.isZero()) {
            componentTotal = componentTotal.subtract(item.getUnadjustedTax().divide(itemQuantity.getValue()));
        }
        Price runningTotal = componentTotal;
        List<SalesPriceAdjustment> priceLevelAdustmentList = PriceAdjustmentManager.getInstance().getMatching(item.getPriceAdjustments(), PriceAdjustmentUnit.PRICE_LEVEL_UNIT);
        PriceLevelSalesPriceAdjustment priceLevelAdustment = null;
        if (!priceLevelAdustmentList.isEmpty()) {
            priceLevelAdustment = (PriceLevelSalesPriceAdjustment)priceLevelAdustmentList.get(0);
        }
        for (SalesComponent currentComponent : componentsList) {
            if (priceLevelAdustment == null) continue;
            Price componentPrice = isExTax ? currentComponent.getUnadjustedTotalExTax() : currentComponent.getUnadjustedTotal();
            SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(priceLevelAdustment, priceLevelAdustment.getCreationContext());
            double componentRatio = 1.0 / (double)componentsList.size();
            if (!componentTotal.equals(ZERO)) {
                componentRatio = componentPrice.divide(componentTotal).doubleValue();
            }
            Price proportionalUsageValue = priceLevelAdustment.calcValue(componentTotal).multiply(componentRatio);
            usage.setUnitValue(proportionalUsageValue);
            priceLevelAdustment.addPriceAdjustmentUsage(usage);
        }
        if (priceLevelAdustment != null) {
            runningTotal = runningTotal.subtract(priceLevelAdustment.getValue().divide(itemQuantity.getValue()));
        }
        return runningTotal;
    }

    private static Price getPriceAdd(SalesItem salesItem) {
        Price toAdd = Price.ZERO_DOLLAR;
        if (salesItem.getInventoryComboGroup() == null) {
            return toAdd;
        }
        List<InventoryComboGroup> comboGroups = Arrays.asList(salesItem.getInventoryComboGroup());
        for (SalesComponent component : salesItem.getComponentList()) {
            for (InventoryComboGroup comboGroup : comboGroups) {
                for (InventoryComboGroupItemUnitLink unitLink : comboGroup.getGroupUnitLink()) {
                    try {
                        if (!unitLink.getItemUnit().equals(component.getUnit()) || Price.ZERO_DOLLAR.equals(unitLink.getPriceAdd())) continue;
                        return unitLink.getPriceAdd().multiply(component.getSalesItem().getQuantity());
                    }
                    catch (NullPointerException e) {
                        if (Config.isDebuging()) {
                            OrderMate.LOG.error(ReflectionToStringBuilder.toString((Object)unitLink));
                            throw e;
                        }
                        OrderMate.LOG.error("#Freya# checkPriceAdds encountered an issue for InventoryComboGroupItemUnitLink id = " + unitLink.getID() + "\nCombo id = " + comboGroups.get(0).getID() + "\nComboGroup id = " + comboGroup.getID(), (Throwable)e);
                        OrderMate.LOG.error(ReflectionToStringBuilder.toString((Object)unitLink));
                    }
                }
            }
        }
        return toAdd;
    }

    private static Price calcFlatPriceAdjustments(SalesItem item, Price currentTotal, boolean isExTax) {
        Price componentTotal = currentTotal;
        Price runningTotal = currentTotal;
        SalesPriceAdjustment flatPriceAdustment = item.getFlatPriceAdjustment();
        List<SalesComponent> componentsList = item.getComponentList();
        for (SalesComponent currentComponent : componentsList) {
            if (flatPriceAdustment == null) continue;
            Price componentPrice = currentComponent.getPrice();
            if (isExTax) {
                componentPrice = componentPrice.subtract(currentComponent.getUnadjustedTax());
            }
            SalesPriceAdjustmentUsage usage = currentComponent.getPriceAdjustmentUsage(flatPriceAdustment, flatPriceAdustment.getCreationContext());
            if (SalesQuantity.ZERO.equals(currentComponent.getSalesItem().getQuantity())) {
                usage.setUnitValue(currentComponent.getBasePrice().subtract(((FlatPriceAdjustment)flatPriceAdustment).getFlatPriceValue()));
            } else {
                double componentRatio = 1.0 / (double)componentsList.size();
                if (!componentTotal.equals(ZERO)) {
                    componentRatio = componentPrice.divide(componentTotal).doubleValue();
                }
                Price proportionalUsageValue = flatPriceAdustment.calcValue(componentTotal).multiply(componentRatio);
                usage.setUnitValue(proportionalUsageValue);
            }
            flatPriceAdustment.addPriceAdjustmentUsage(usage);
        }
        if (flatPriceAdustment != null) {
            runningTotal = runningTotal.subtract(flatPriceAdustment.getValue().divide(item.getQuantity().getValue()));
        }
        return runningTotal;
    }

    private SalesComponent splitComponentForDifference(List<SalesItemSummary> summaries) {
        SalesComponent toReturn = null;
        SalesItem theItem = null;
        Price highestRatio = Price.ZERO_DOLLAR;
        for (SalesItemSummary summary : summaries) {
            SalesItem item = summary.getSalesItem();
            SalesQuantity qty = item.getQuantity();
            Price price = item.getPrice();
            if (!item.isSplittable() || !highestRatio.lessThan(price.divide(qty.getValue()))) continue;
            highestRatio = price.divide(qty.getValue());
            theItem = item;
        }
        if (theItem != null) {
            User user = this.itemGroup.getUser();
            if (user == null) {
                user = User.getSystemUser();
            }
            SalesLineItem newItem = theItem.getParentCombo() != null ? theItem.getParentCombo().splitItem(theItem, SalesQuantity.ONE, new EventContext(user)) : theItem.split(SalesQuantity.ONE, new EventContext(user));
            List<SalesComponent> newItemComponents = this.salesItemsComponents.get(newItem.getSalesItems().get(0));
            toReturn = newItemComponents != null && newItemComponents.size() > 0 ? newItemComponents.get(0) : newItem.getSalesItems().get(0).getComponentList().get(0);
        }
        return toReturn;
    }

    private void cacheSalesItems() {
        for (SalesLineItem currentItem : this.itemGroup.getItems()) {
            List<SalesItem> salesItems = currentItem.getSalesItems();
            for (SalesItem item : salesItems) {
                List<SalesComponent> itemComponents = item.getComponentList();
                this.components.addAll(itemComponents);
                this.salesItemsComponents.put(item, itemComponents);
                this.salesItemsPriceAdjustments.put(item, new ArrayList<SalesPriceAdjustment>(item.getPriceAdjustments()));
            }
            this.items.addAll(salesItems);
        }
    }
}

