/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.TriggeredPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.CustomerCategoryTrigger;
import ordermate.database.inventory.triggers.ItemsOrderedTypeTrigger;
import ordermate.database.inventory.triggers.LimitedPurchaseTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PriceAdjustmentCalculator;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.services.sales.ItemGroupPriceLevelPolicy;

public class PriceAdjustmentHelper {
    private final ItemGroup itemGroup;

    public PriceAdjustmentHelper(ItemGroup theItemGroup) {
        this.itemGroup = theItemGroup;
    }

    public SalesPriceAdjustment getPriceAdjustment(InventoryPriceAdjustment adj) {
        for (SalesPriceAdjustment salesAdj : this.itemGroup.getPriceAdjustments()) {
            if (!salesAdj.getInventoryPriceAdjustment().equals(adj)) continue;
            return salesAdj;
        }
        return null;
    }

    public ItemGroupPriceLevelPolicy getPriceLevelPolicy() {
        return new ItemGroupPriceLevelPolicy(this.itemGroup);
    }

    public void addTriggeredPriceAdjustmentbyTrigger(Collection<AbstractTrigger> triggers, EventContext context) {
        ArrayList<TriggeredPriceAdjustment> potentialAdjustments = new ArrayList<TriggeredPriceAdjustment>();
        for (TriggeredPriceAdjustment nextAdjustment : PriceAdjustmentManager.getInstance().getAutomaticAdjustments()) {
            for (AbstractTrigger nextTrigger : nextAdjustment.getTriggers()) {
                if (!triggers.contains(nextTrigger)) continue;
                potentialAdjustments.add(nextAdjustment);
            }
        }
        if (!potentialAdjustments.isEmpty()) {
            this.removeInactiveAdjustments(context);
            this.addActiveAdjustments(context, potentialAdjustments);
        }
    }

    public void removeInactiveAdjustments(EventContext context) {
        HashSet<SalesPriceAdjustment> adjustmentsToRemove = new HashSet<SalesPriceAdjustment>();
        for (SalesPriceAdjustment adj : this.itemGroup.getPriceAdjustments()) {
            TriggeredPriceAdjustment trigAdj;
            if (!(adj.getInventoryPriceAdjustment() instanceof TriggeredPriceAdjustment) || !(trigAdj = (TriggeredPriceAdjustment)adj.getInventoryPriceAdjustment()).isAutomatic() || trigAdj.isActive(new TriggerActivationContext(context, this.itemGroup))) continue;
            adjustmentsToRemove.add(adj);
        }
        this.removePriceAdjustments(adjustmentsToRemove, context);
        adjustmentsToRemove.clear();
    }

    public void addActiveAdjustments(EventContext context, List<TriggeredPriceAdjustment> autoAdjustments) {
        for (TriggeredPriceAdjustment adj : autoAdjustments) {
            if (!adj.isActive(new TriggerActivationContext(context, this.itemGroup))) continue;
            boolean found = false;
            for (SalesPriceAdjustment existingAdj : this.itemGroup.getPriceAdjustments()) {
                if (!existingAdj.getInventoryPriceAdjustment().getType().equals(adj.getType())) continue;
                found = true;
            }
            if (found) continue;
            adj.createSalesPriceAdjustment(this.itemGroup, context);
        }
    }

    public void removePriceAdjustments(Collection salesPriceAdjs, EventContext context) {
        Iterator it = salesPriceAdjs.iterator();
        while (it.hasNext()) {
            this.itemGroup.removeAdjustment((SalesPriceAdjustment)it.next(), context);
        }
        this.calcSalesPriceAdjustmentUsages();
    }

    public void calcSalesPriceAdjustmentUsages() {
        new PriceAdjustmentCalculator(this.itemGroup).calcSalesPriceAdjustmentUsages();
    }

    public void checkItemsOrderedTriggerAdjustments() {
        if (this.itemGroup.getUser() != null) {
            Collection<AbstractTrigger> itemAddedTriggers = AbstractTrigger.getTriggersByType(AbstractTrigger.Types.ITEMS_ORDERED_TRIGGER);
            ArrayList<TriggeredPriceAdjustment> potentialAdjustments = new ArrayList<TriggeredPriceAdjustment>();
            for (TriggeredPriceAdjustment nextAdjustment : PriceAdjustmentManager.getInstance().getAutomaticAdjustments()) {
                for (AbstractTrigger nextTrigger : nextAdjustment.getTriggers()) {
                    if (!itemAddedTriggers.contains(nextTrigger)) continue;
                    potentialAdjustments.add(nextAdjustment);
                }
            }
            EventContext context = this.itemGroup.getEventContext();
            if (!potentialAdjustments.isEmpty()) {
                this.removeInactiveAdjustments(context);
                this.addActiveAdjustments(context, potentialAdjustments);
            }
            if (SystemProperty.getInstance().isRetroCustPriceUpdates()) {
                List<PriceLevel> priceLevels = PriceLevel.getWithTriggerType(ItemsOrderedTypeTrigger.class);
                if (this.itemGroup.getCustomer() != null) {
                    priceLevels.addAll(PriceLevel.getWithTriggerType(CustomerCategoryTrigger.class));
                    priceLevels.addAll(PriceLevel.getWithTriggerType(LimitedPurchaseTrigger.class));
                }
                this.useHighestActivePriceLevel(new HashSet<PriceLevel>(priceLevels), false, context, "Updating to customer price levels");
            }
        } else {
            OrderMate.LOG.warn("Cannot check ItemsOrderedTypeTrigger adjustments without a user. Cannot create EventContext.");
        }
    }

    public Set<PriceLevel> getPossiblePriceLevels(boolean onlyActive, EventContext context) {
        return this.getPriceLevelPolicy().getPossiblePriceLevels(onlyActive, context);
    }

    public List<SalesItem> usePriceLevel(PriceLevel toUse, boolean ignoreSequence, EventContext context) {
        return this.getPriceLevelPolicy().usePriceLevel(toUse, ignoreSequence, context);
    }

    public List<SalesItem> useCheapestPriceLevel(boolean increasePrices, EventContext context) {
        return this.getPriceLevelPolicy().useCheapestPriceLevel(increasePrices, context);
    }

    public List<SalesItem> useHighestActivePriceLevel(Set priceLevels, boolean ignoreSequence, EventContext context, String reason) {
        return this.getPriceLevelPolicy().useHighestActivePriceLevel(priceLevels, ignoreSequence, context, reason);
    }

    public void applyAutomaticAdjustment(EventContext context, List<Class<? extends TriggeredPriceAdjustment>> applicableAdjustments) {
        boolean isOnline;
        boolean bl = isOnline = this.itemGroup instanceof Account && AccountType.isOnline((Account)this.itemGroup);
        if (this.itemGroup instanceof TableAccount) {
            boolean bl2 = isOnline = isOnline || !StringUtils.isEmpty(((TableAccount)this.itemGroup).getSource());
        }
        if (!isOnline) {
            List<TriggeredPriceAdjustment> autoAdjustments = PriceAdjustmentManager.getInstance().getAutomaticAdjustments();
            if (applicableAdjustments != null && !applicableAdjustments.isEmpty()) {
                ArrayList<TriggeredPriceAdjustment> filteredAdjustments = new ArrayList<TriggeredPriceAdjustment>();
                for (TriggeredPriceAdjustment nextAdj : autoAdjustments) {
                    if (!applicableAdjustments.contains(nextAdj.getClass())) continue;
                    filteredAdjustments.add(nextAdj);
                }
                autoAdjustments = filteredAdjustments;
            }
            this.removeInactiveAdjustments(context);
            this.addActiveAdjustments(context, autoAdjustments);
        }
    }

    public boolean isUnprintedAdjustment() {
        List<SalesPriceAdjustment> priceAdjForGroup = this.itemGroup.getPriceAdjustments();
        for (SalesPriceAdjustment nextAdj : priceAdjForGroup) {
            if (nextAdj.isPersistent()) continue;
            return true;
        }
        if (priceAdjForGroup.size() > 0) {
            for (SalesLineItem nextItem : this.itemGroup.getItems()) {
                if (nextItem.isPrinted()) continue;
                return true;
            }
        }
        for (SalesPriceAdjustment nextAdj : this.getItemPriceAdjustments()) {
            if (nextAdj.isPersistent()) continue;
            return true;
        }
        return false;
    }

    public Collection<SalesPriceAdjustment> getItemPriceAdjustments() {
        List<SalesLineItem> salesItems = this.itemGroup.getItems();
        LinkedHashSet<SalesPriceAdjustment> itemAdjs = new LinkedHashSet<SalesPriceAdjustment>(salesItems.size());
        for (SalesLineItem item : salesItems) {
            for (SalesPriceAdjustment adj : item.getPriceAdjustments()) {
                itemAdjs.add(adj);
            }
        }
        return itemAdjs;
    }

    public void applySingleAutomaticAdjustment(EventContext context, Class<? extends TriggeredPriceAdjustment> toApply) {
        ArrayList<Class<? extends TriggeredPriceAdjustment>> autoAdjustments = new ArrayList<Class<? extends TriggeredPriceAdjustment>>();
        autoAdjustments.add(toApply);
        this.applyAutomaticAdjustment(context, autoAdjustments);
    }

    public boolean isPriceAdjApplicable(SalesPriceAdjustment priceAdj, SalesItem item) {
        String SOURCE;
        ExperimentalFeature feature = ExperimentalFeature.find("HH Order Always Apply Adjustment");
        if (feature != null && feature.getBooleanValue(false).booleanValue() && (SOURCE = "OrderMate Online").equals(this.itemGroup.getAccount().getSource())) {
            return true;
        }
        if (PriceAdjustmentType.FINAL.equals(priceAdj.getType()) || PriceAdjustmentType.FINAL_PAYMENT.equals(priceAdj.getType())) {
            return true;
        }
        if (this.itemGroup.getAccount() instanceof TableAccount) {
            if (!SystemProperty.getInstance().isCustomerAssignmentPerSeat()) {
                return true;
            }
            if (priceAdj.getCustomer() != null) {
                return item.getCustomer() == null && priceAdj.getCustomer().equals(this.itemGroup.getCustomer()) || priceAdj.getCustomer().equals(item.getCustomer());
            }
            return true;
        }
        return true;
    }

    public List<SalesPriceAdjustment> getDiscounts() {
        return PriceAdjustmentManager.getInstance().getMatching(this.itemGroup.getPriceAdjustments(), PriceAdjustmentDirection.DISCOUNT);
    }

    public boolean isAnyItemDiscounted(boolean includePriceLevelAdj) {
        for (SalesLineItem item : this.itemGroup.getItems()) {
            if (!item.isDiscounted()) continue;
            if (!includePriceLevelAdj) {
                for (SalesPriceAdjustment salesAdj : item.getDiscounts()) {
                    if (PriceAdjustmentType.PRICE_LEVEL.equals(salesAdj.getType())) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean isDiscounted() {
        return !this.getDiscounts().isEmpty();
    }

    public Price getDiscountTotal() {
        Price total = Price.ZERO_DOLLAR;
        for (SalesPriceAdjustment discount : this.getDiscounts()) {
            total = total.add(discount.getValue());
        }
        return new Price(total, 0.01);
    }

    public Price getDiscountIncludingItems() {
        Price accountDiscount = this.getDiscountTotal();
        Price itemDiscount = PriceAdjustmentManager.getInstance().getUsageValueForItems(this.itemGroup.getItems(), false);
        return accountDiscount.add(itemDiscount).negate();
    }

    public String stringifyDiscounts() {
        if (!this.isDiscounted()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (SalesPriceAdjustment discount : this.getDiscounts()) {
            buffer.append(discount.getLabel());
            if (discount.getUnit().equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
                buffer.append(" ").append(discount.getValue().negate());
            }
            buffer.append(", ");
        }
        String discountsStr = buffer.toString();
        return discountsStr.substring(0, discountsStr.length() - 2);
    }

    public String stringifyDiscountSummary() {
        if (!this.isDiscounted()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getDiscounts().size());
        buffer.append(" Discount");
        if (this.getDiscounts().size() > 1) {
            buffer.append("s, -");
        } else {
            buffer.append(", -");
        }
        return buffer.append(this.getDiscountTotal()).toString();
    }

    public String stringfyItemDiscountsSummary() {
        SalesQuantity numDiscountedItems = SalesQuantity.ZERO;
        HashSet<SalesPriceAdjustment> discounts = new HashSet<SalesPriceAdjustment>();
        for (SalesLineItem item : this.itemGroup.getItems()) {
            if (!item.isDiscounted()) continue;
            List<SalesPriceAdjustment> allAdj = item.getDiscounts();
            List<SalesPriceAdjustment> priceAdj = PriceAdjustmentManager.getInstance().getMatching(item.getDiscounts(), PriceAdjustmentUnit.PRICE_LEVEL_UNIT);
            allAdj.removeAll(priceAdj);
            if (allAdj.isEmpty()) continue;
            discounts.addAll(priceAdj);
            numDiscountedItems = numDiscountedItems.add(item.getQuantity());
        }
        Price totalDiscount = PriceAdjustmentManager.getInstance().getUsageValueForItems(this.itemGroup.getItems(), false);
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(numDiscountedItems).append(" discounted item");
        sBuilder.append(numDiscountedItems.equals(1L) ? " - " : "s - ").append(totalDiscount);
        return sBuilder.toString();
    }

    public List<SalesPriceAdjustment> getSurcharges() {
        return PriceAdjustmentManager.getInstance().getMatching(this.itemGroup.getPriceAdjustments(), PriceAdjustmentDirection.SURCHARGE);
    }

    public boolean isSurcharged() {
        return !this.getSurcharges().isEmpty();
    }

    public String stringifySurcharges() {
        if (!this.isSurcharged()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (SalesPriceAdjustment surcharge : this.getSurcharges()) {
            buffer.append(surcharge.getLabel());
            if (surcharge.getUnit().equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
                buffer.append(" " + surcharge.getValue().abs());
            }
            buffer.append(", ");
        }
        String surchargesStr = buffer.toString();
        return surchargesStr.substring(0, surchargesStr.length() - 2);
    }

    public String stringifySurchargeSummary() {
        if (!this.isSurcharged()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int surchargesCount = this.getSurcharges().size();
        Price surchargeTotal = this.getSurchargeTotal();
        if (surchargesCount > 0 && surchargeTotal != null && !surchargeTotal.equals(Price.ZERO_DOLLAR)) {
            buffer.append(surchargesCount);
            buffer.append(" Surcharge");
            if (surchargesCount > 1) {
                buffer.append("s, ");
            } else {
                buffer.append(", ");
            }
        }
        return buffer.append(surchargeTotal).toString();
    }

    public Price getSurchargeTotal() {
        Price total = new Price(0.0, 1.0E-5);
        for (SalesPriceAdjustment surcharge : this.getSurcharges()) {
            total = total.add(surcharge.getValue());
        }
        return total.abs();
    }

    public Map<String, Price> getPriceLevelAdjustmentTotal(boolean isSurcharge) {
        HashMap<String, Price> priceLevelSurchargeMap = new HashMap<String, Price>();
        List<SalesLineItem> salesItems = this.itemGroup.getItems();
        Price runningTotal = new Price(Price.ZERO_DOLLAR, 0.01);
        String priceLevelName = null;
        for (SalesLineItem salesLineItem : salesItems) {
            List<SalesPriceAdjustment> salesPriceAdjustments = null;
            salesPriceAdjustments = isSurcharge ? salesLineItem.getSurcharges() : salesLineItem.getDiscounts();
            if (salesPriceAdjustments == null) continue;
            for (SalesPriceAdjustment adj : salesPriceAdjustments) {
                if (!(adj.getType() instanceof PriceAdjustmentType.PriceLevelAdjustmentType)) continue;
                priceLevelName = adj.getLabel();
                runningTotal = runningTotal.add(adj.getValue());
            }
        }
        if (priceLevelName != null) {
            priceLevelSurchargeMap.put(priceLevelName, runningTotal.abs());
            return priceLevelSurchargeMap;
        }
        return null;
    }

    public boolean hasPriceLevelSurcharge() {
        return this.getPriceLevelAdjustmentTotal(true) != null;
    }

    public String getPriceLevelSurchargeAsString() {
        Map<String, Price> priceLevelSurchargeMap = this.getPriceLevelAdjustmentTotal(true);
        String toReturn = "";
        if (priceLevelSurchargeMap != null) {
            Object[] keyArray = priceLevelSurchargeMap.keySet().toArray();
            toReturn = keyArray[0].toString().concat(":");
            toReturn = toReturn.concat(priceLevelSurchargeMap.get(keyArray[0]).toString());
        }
        return toReturn;
    }

    public boolean hasPriceLevelDiscount() {
        return this.getPriceLevelAdjustmentTotal(false) != null;
    }

    public String getPriceLevelDiscountAsString() {
        Map<String, Price> priceLevelDiscountMap = this.getPriceLevelAdjustmentTotal(false);
        String toReturn = "";
        if (priceLevelDiscountMap != null) {
            Object[] keyArray = priceLevelDiscountMap.keySet().toArray();
            toReturn = keyArray[0].toString().concat(":");
            toReturn = toReturn.concat(priceLevelDiscountMap.get(keyArray[0]).negate().toString());
        }
        return toReturn;
    }
}

