/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.inventory.PriceLevelPriceInvAdjustment;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryFreeItemCombo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.users.User;

public class PriceLevelPriceAdjustmentMaster {
    private final SalesItem salesItem;
    private final boolean comboItem;
    private final List<SalesComponent> salesComponents;

    public PriceLevelPriceAdjustmentMaster(SalesItem itemToPA) {
        this.salesItem = itemToPA;
        this.comboItem = this.salesItem.isComboItem();
        this.salesComponents = this.salesItem.getComponentList();
    }

    private boolean checkAddPriceLevelAdjustments(SalesComponent comp, UnitPriceLevel level, UnitPriceLevel defaultPriceLevel) {
        return this.componentIsAdjustable(comp) && (!SystemProperty.getInstance().isPriceByDearest() || this.salesComponents.size() <= 1) && !level.getPriceLevel().isDefaultLevel() && defaultPriceLevel != null && !this.salesItem.isOpenPriceItem();
    }

    private boolean componentIsAdjustable(SalesComponent comp) {
        boolean isAjustable;
        boolean bl = isAjustable = !this.comboItem;
        if (!isAjustable) {
            SalesCombo combo = this.salesItem.getParentCombo();
            isAjustable |= combo.componentIsAdjustable(comp);
        }
        return isAjustable;
    }

    private Price getCurrentPriceAdjustmentTotal(SalesComponent compToIgnore) {
        Price total = new Price(0.0, 0.01);
        for (SalesComponent comp : this.salesComponents) {
            UnitPriceLevel unitPriceLevel;
            if (comp.equals(compToIgnore) || comp.getMenuPrice() == null || comp.getPriceLevel() == null || comp.getPriceLevel().isDefaultLevel() || (unitPriceLevel = comp.getUnit().getUnitPriceLevel(comp.getPriceLevel())) == null) continue;
            total = total.add(comp.getBasePrice().subtract(unitPriceLevel.getPrice()));
        }
        return total;
    }

    void priceComponentsByDearest() {
        Price dearestCompPrice = new Price(0.0, 0.01);
        Price unadjustedDearestCompPrice = new Price(0.0, 0.01);
        InventoryItemPortion whole = InventoryItemPortion.getPortion("Whole");
        for (SalesComponent currentComponent : this.salesComponents) {
            Price priceToAddAjustmentOf;
            UnitPriceLevel priceLevel;
            if (currentComponent.getPriceLevel() == null) continue;
            double priceForWhole = 0.0;
            Price defaultWholePrice = null;
            Price defaultPortionPrice = null;
            InventoryItem item = currentComponent.getInventoryItem();
            if (item.getLabel().equals("!Unknown Online Item!")) continue;
            InventoryItemUnit unit = item.getUnit(currentComponent.getUnit().getSize(), whole);
            UnitPriceLevel unitPriceLevel = priceLevel = unit == null ? null : unit.getUnitPriceLevel(currentComponent.getPriceLevel());
            if (priceLevel != null) {
                priceForWhole = priceLevel.getPrice().doubleValue();
                defaultWholePrice = this.getDefaultPriceLevelPrice(unit, priceLevel);
            }
            double priceFromPortion = 0.0;
            InventoryItemUnit currentComponentUnit = currentComponent.getUnit();
            unit = item.getUnit(currentComponentUnit.getSize(), currentComponentUnit.getPortion());
            if (unit == null) {
                unit = currentComponentUnit;
                OrderMate.LOG.error("Failed to get InventoryItemUnit for item: " + item.getLabel() + " [Portion: " + currentComponentUnit.getPortion() + "] [Size: " + currentComponentUnit.getSize() + "]");
            }
            if ((priceLevel = unit.getUnitPriceLevel(currentComponent.getPriceLevel())) != null) {
                priceFromPortion = priceLevel.getPrice().doubleValue();
                defaultPortionPrice = this.getDefaultPriceLevelPrice(unit, priceLevel);
            }
            if (!new Price(priceForWhole = Math.max(priceForWhole, priceFromPortion)).greaterThan(dearestCompPrice)) continue;
            dearestCompPrice = new Price(priceForWhole, 0.01);
            unadjustedDearestCompPrice = new Price(priceForWhole, 0.01);
            if (priceForWhole > priceFromPortion && defaultWholePrice != null && priceLevel != null) {
                priceToAddAjustmentOf = defaultWholePrice.subtract(new Price(priceForWhole, 0.01));
                if (priceToAddAjustmentOf.isZero()) continue;
                this.addPriceLevelPriceAdjustment(priceToAddAjustmentOf, priceLevel.getPriceLevel());
                unadjustedDearestCompPrice = new Price(defaultWholePrice, 0.01);
                continue;
            }
            if (defaultPortionPrice == null || priceLevel == null || (priceToAddAjustmentOf = defaultPortionPrice.subtract(new Price(priceForWhole, 0.01))).isZero()) continue;
            this.addPriceLevelPriceAdjustment(defaultPortionPrice.subtract(new Price(priceForWhole, 0.01)), priceLevel.getPriceLevel());
            unadjustedDearestCompPrice = new Price(defaultPortionPrice, 0.01);
        }
        this.salesItem.adjustComponentPrices(unadjustedDearestCompPrice);
    }

    private void addPriceLevelPriceAdjustment(Price totalAdj, PriceLevel priceLevel) {
        PriceLevelPriceInvAdjustment adj = PriceAdjustmentManager.getInstance().getPriceLevelAdjustment();
        adj.setAmount(totalAdj);
        EventContext context = this.salesItem.getAccount() != null ? new EventContext(this.salesItem.getAccount().getUser()) : new EventContext(User.getSystemUser());
        adj.createSalesPriceAdjustment(this.salesItem, context, priceLevel);
    }

    private Price getDefaultPriceLevelPrice(InventoryItemUnit unit, UnitPriceLevel priceLevel) {
        UnitPriceLevel defaultLevel;
        if (!priceLevel.getPriceLevel().isDefaultLevel() && (defaultLevel = unit.getUnitPriceLevel(PriceLevel.getDefaultPriceLevel())) != null) {
            return defaultLevel.getPrice();
        }
        return null;
    }

    public void setComponentPriceLevel(SalesComponent comp, UnitPriceLevel level) {
        Price priceToAddAjustmentOf;
        if (!this.salesComponents.contains(comp)) {
            throw new IllegalArgumentException("Item " + this.salesItem.getLabel() + " doesn't contain component " + comp.getLabel());
        }
        this.salesItem.removePriceLevelAdjustment();
        UnitPriceLevel defaultPriceLevel = comp.getUnit().getUnitPriceLevel(PriceLevel.getDefaultPriceLevel());
        if (this.checkAddPriceLevelAdjustments(comp, level, defaultPriceLevel) && !(priceToAddAjustmentOf = this.getCurrentPriceAdjustmentTotal(comp).add(comp.getBasePrice().subtract(level.getPrice()))).isZero()) {
            this.addPriceLevelPriceAdjustment(priceToAddAjustmentOf, level.getPriceLevel());
        }
        comp.setPriceLevel(level);
        if ((!this.comboItem || this.applyComboItemPriceLevelAdjustments()) && SystemProperty.getInstance().isPriceByDearest() && this.salesComponents.size() > 1) {
            this.priceComponentsByDearest();
        }
    }

    private boolean applyComboItemPriceLevelAdjustments() {
        return this.salesItem.getParentCombo().getCombo().applyPriceLevelAdjustments() && !this.isFreeItemInCombo();
    }

    private boolean isFreeItemInCombo() {
        if (this.comboItem) {
            InventoryComboGroup group = this.salesItem.getInventoryComboGroup();
            InventoryCombo combo = this.salesItem.getParentCombo().getCombo();
            if (combo != null && combo.getType().equals((Object)ComboType.FREE_ITEM)) {
                InventoryFreeItemCombo freeItemCombo = (InventoryFreeItemCombo)combo;
                if (group != null && group.equals(freeItemCombo.getFreeItemGroup())) {
                    return true;
                }
            }
        }
        return false;
    }
}

