/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.TableAccount;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;

public abstract class PrintAccount {
    public final void printClosingReceipts(Account toClose) {
        List printers;
        if (toClose.isPersistent() && !toClose.isOpen() && !(printers = this.getAvailablePayoffPrinters(toClose)).isEmpty()) {
            this.printClosingReceipts(toClose, printers);
        }
    }

    private List getAvailablePayoffPrinters(Account account) {
        List<VirtualPrinter> printers = account.isDebtorSale() ? Terminal.getLocalHost().getAvailableAccountPayoffPrinters() : (!account.getFinanceTransactions().isEmpty() || !account.getItems().isEmpty() ? Terminal.getLocalHost().getAvailablePayoffPrinters(account.getFinanceTransactions()) : new ArrayList<VirtualPrinter>());
        return printers;
    }

    public void printClosingReceipts(Account toClose, List printers) {
        if (printers.isEmpty()) {
            throw new IllegalStateException("List is empty, trying to print with no printers.");
        }
        ArrayList<VirtualPrinter> printersToAsk = new ArrayList<VirtualPrinter>();
        ArrayList<VirtualPrinter> printersToAutoPrint = new ArrayList<VirtualPrinter>();
        for (VirtualPrinter printer : printers) {
            if (!printer.isAutoPrintPayoff()) {
                printersToAsk.add(printer);
                continue;
            }
            printersToAutoPrint.add(printer);
        }
        if (printersToAsk.size() > 1) {
            VirtualPrinter selectedPrinter = this.selectPrinter("Select Payoff Printer", printersToAsk);
            printersToAutoPrint.add(selectedPrinter);
        } else if (printersToAsk.size() == 1) {
            printersToAutoPrint.add((VirtualPrinter)printersToAsk.get(0));
        }
        for (VirtualPrinter printer : printersToAutoPrint) {
            try {
                toClose.printClosingReceiptDockets(Terminal.getLocalHost(), Collections.singletonList(printer));
            }
            catch (Exception e) {
                this.handlePrinterError(e, "account " + toClose.getLabel());
            }
        }
    }

    public void printReceiptDockets(ItemGroup toPrint) {
        this.printReceiptDockets(Collections.singletonList(toPrint));
    }

    public void printReceiptDockets(List itemGroupsToPrint) {
        this.printReceiptDockets(itemGroupsToPrint, null);
    }

    public void printReceiptDockets(List itemGroupsToPrint, EventContext context) {
        if (itemGroupsToPrint.size() > 1 && !this.confirm("Print " + itemGroupsToPrint.size() + " invoices.", "You have chosen to print " + itemGroupsToPrint.size() + " invoices.  Is this correct?")) {
            return;
        }
        Iterator it = itemGroupsToPrint.iterator();
        boolean doneChecking = false;
        while (it.hasNext() && !doneChecking) {
            ItemGroup toPrint = (ItemGroup)it.next();
            boolean saved = !toPrint.hasChanged();
            if (saved || !(toPrint instanceof Account)) continue;
            boolean save = this.confirm("Save Changes?", "The account has unsaved changes. Would you like to save?");
            if (save) {
                doneChecking = true;
                continue;
            }
            return;
        }
        it = itemGroupsToPrint.iterator();
        while (it.hasNext()) {
            List<VirtualPrinter> availableReceiptPrinters;
            ArrayList<VirtualPrinter> printers;
            boolean hasVoucherTxns = false;
            ItemGroup toPrint = (ItemGroup)it.next();
            if (toPrint instanceof Account) {
                Account account = toPrint.getAccount();
                hasVoucherTxns = account.getVoucherTxns() != null && !account.getVoucherTxns().isEmpty();
            }
            Terminal toPrintTerminal = Terminal.getLocalHost();
            if (context != null && context.getTerminal() != null) {
                toPrintTerminal = context.getTerminal();
            }
            if ((printers = new ArrayList<VirtualPrinter>(availableReceiptPrinters = toPrintTerminal.getAvailableReceiptPrinters())).size() > 1) {
                printers.clear();
                printers.add(this.selectPrinter("Select Receipt Printer", availableReceiptPrinters));
            }
            if (toPrint.getItems().isEmpty() && toPrint.getFinanceTransactions().isEmpty() && !hasVoucherTxns) continue;
            if (printers != null && printers.size() >= 1) {
                this.doPrintReceipt(toPrint, printers, context);
                continue;
            }
            OrderMate.LOG.warn("Receipt Docket could not be printed since receipt printers not available for : " + toPrintTerminal);
        }
    }

    public void doPrintReceipt(ItemGroup toPrint, List printers) {
        this.doPrintReceipt(toPrint, printers, null);
    }

    public void doPrintReceipt(ItemGroup toPrint, List printers, EventContext context) {
        try {
            if (toPrint.hasChanged()) {
                OrderMate.LOG.info("Account has changed, saving account");
                boolean needsUnlocking = false;
                if (!toPrint.isLocked()) {
                    toPrint.lock(this.getUser());
                    needsUnlocking = true;
                }
                toPrint.save();
                if (needsUnlocking) {
                    toPrint.unlock();
                }
            }
            Terminal terminal = Terminal.getLocalHost();
            if (context != null && context.getTerminal() != null) {
                terminal = context.getTerminal();
            }
            toPrint.printReceiptDockets(this.getUser(), terminal, printers);
        }
        catch (Exception e) {
            this.handlePrinterError(e, "account " + toPrint.getLabel());
        }
    }

    public void printCourseIfNecessary(Course currentCourse, Course newCourse, EventContext context, TableAccount account) {
        if (newCourse != null) {
            if (!SystemProperty.getInstance().isSingleCoursePrinting()) {
                try {
                    DocketProcessor.printCourseDocket(account, newCourse, context.getUser(), context.getTerminal());
                }
                catch (IOException ex) {
                    this.handlePrinterError(ex, "Course Docket " + account.getLabel());
                }
            } else {
                try {
                    DocketProcessor.printPrepDocketForCourse(account, context.getUser(), context.getTerminal(), newCourse.getCourseIndex());
                }
                catch (Exception ex) {
                    this.handlePrinterError(ex, "Course Prep Docket " + account.getLabel());
                }
            }
        }
    }

    public abstract void handlePrinterError(Exception var1, String var2);

    protected abstract VirtualPrinter selectPrinter(String var1, List<VirtualPrinter> var2);

    protected abstract User getUser();

    protected abstract boolean confirm(String var1, String var2);
}

