/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.sales.AbstractTakeawayAccount;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="REFUND")
@AccessType(value="property")
public class RefundAccount
extends AbstractTakeawayAccount {
    public static final AccountType TYPE = AccountType.refundType;
    public static final Props Properties = new Props();
    private String reinstatedItemUsage = "NORMAL";

    public RefundAccount() {
        super(TYPE);
    }

    public RefundAccount(EventContext context) {
        super(context.getUser(), context.getTerminal(), TYPE);
        this.setUser(context.getUser());
    }

    @Override
    @Transient
    public String getLabel() {
        SimpleDateFormat formatter = new SimpleDateFormat(" h:mm a");
        String timeString = formatter.format(this.getCreationDateTime());
        return this.getDescription() + timeString;
    }

    @Override
    @Transient
    public String getDescription() {
        if (this.isReinstatingRefund()) {
            return "Refund Reversal";
        }
        return "Refund";
    }

    @Override
    public boolean needsInfo() {
        return false;
    }

    @Override
    @Transient
    public List<PropertiedObject.Property> getCustomerRequirements() {
        return new ArrayList<PropertiedObject.Property>();
    }

    public void setReason(String text) {
        this.addToTicketData(text);
    }

    public void addItems(List<SalesLineItem> items, EventContext context) {
        for (SalesLineItem item : items) {
            this.addItem(item, context);
        }
    }

    private void addItem(SalesLineItem toRefund, EventContext context) {
        if (toRefund.getAccount().getAccountType().equals(TYPE)) {
            throw new IllegalStateException("Cannot refund an already refunded item");
        }
        SalesLineItem copiedItem = toRefund.copy(context, true);
        if (copiedItem instanceof SalesCombo) {
            toRefund.setQuantity(toRefund.getQuantity().negate(), context);
            for (SalesItem item : copiedItem.getSalesItems()) {
                item.setQuantity(item.getQuantity().negate(), context);
                for (SalesItemQuantity qty : item.getSalesItemQuantities()) {
                    qty.changeItemState("REFUNDED");
                    qty.saveChild();
                }
            }
        } else {
            copiedItem.setQuantity(copiedItem.getQuantity().negate(), context);
        }
        for (SalesItemQuantity qty : toRefund.getSalesItemQuantities()) {
            qty.changeItemState("REFUNDED");
            qty.saveChild();
        }
        super.getItemHelper().addItem(copiedItem);
    }

    @Override
    @Transient
    public List<SalesLineItem> getItems() {
        return this.getAllItems();
    }

    @Transient
    protected boolean isReinstatingRefund() {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesLineItem currentItem : this.getAllItems()) {
            quantity = quantity.add(currentItem.getQuantity());
        }
        return quantity.greaterThan(0L);
    }

    @Transient
    public String getUsage() {
        if (this.isReinstatingRefund()) {
            return this.reinstatedItemUsage;
        }
        return "NORMAL";
    }

    public static class Props
    extends AbstractTakeawayAccount.Props {
    }
}

