/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesMod;
import ordermate.database.stock.usagelink.StockUsageAddLink;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_add")
@AccessType(value="property")
public class SalesAdd
extends SalesMod
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryAdd> inventoryAdd;
    private Reference<ModificationSize> modificationSize;
    private double quantity;

    public SalesAdd() {
        this.inventoryAdd = this.createReference(SalesAdd.Properties.INVENTORY_ADD);
        this.modificationSize = this.createReference(SalesAdd.Properties.MODIFICATION_SIZE);
    }

    SalesAdd(SalesAdd copy) {
        super(copy);
        this.inventoryAdd = this.createReference(SalesAdd.Properties.INVENTORY_ADD);
        this.modificationSize = this.createReference(SalesAdd.Properties.MODIFICATION_SIZE);
        this.inventoryAdd.set(copy.getInventoryAdd());
        this.modificationSize.set(copy.getModificationSize());
        this.quantity = copy.quantity;
    }

    public SalesAdd(SalesComponent newComponent, InventoryAdd add) {
        this();
        this.setLabel(add.getLabel());
        this.setBackgroundColor(add.getBackgroundColor());
        this.setForegroundColor(add.getForegroundColor());
        this.setIcon(add.getIcon());
        this.setComponent(newComponent);
        this.setInventoryAdd(add);
        this.setModificationSize(add.getModificationSize());
        this.setPrice(add.getPrice());
        this.setQuantity(1.0);
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_add")
    public InventoryAdd getInventoryAdd() {
        return this.inventoryAdd.get();
    }

    private void setInventoryAdd(InventoryAdd add) {
        this.inventoryAdd.set(add);
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_inventory_add_remove_type")
    public ModificationSize getModificationSize() {
        return this.modificationSize.get();
    }

    @Override
    public void setModificationSize(ModificationSize size) {
        this.modificationSize.set(size);
    }

    @Override
    public boolean isEquivalentTo(Modification mod) {
        if (!(mod instanceof SalesAdd)) {
            return false;
        }
        SalesAdd add = (SalesAdd)mod;
        return add.getInventoryAdd().equals(this.getInventoryAdd()) && add.getModificationSize().equals(this.getModificationSize());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Column(name="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    protected void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @Override
    @Transient
    public int getSequence() {
        return 0;
    }

    @Transient
    public List<StockUsageAddLink> getStockUsage() {
        return this.getInventoryAdd().getStockLinks();
    }

    public static class Props
    extends SalesMod.Props {
        public PropertiedObject.Property<InventoryAdd> INVENTORY_ADD;
        public PropertiedObject.Property<ModificationSize> MODIFICATION_SIZE;
        public PropertiedObject.Property QUANTITY;
    }
}

