/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.PercentagePriceAdjustment;
import ordermate.database.inventory.combos.InventoryAdjustmentCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="SalesAdjustmentCombo")
@AccessType(value="property")
public class SalesAdjustmentCombo
extends SalesCombo {
    public static final String TYPE = "SalesAdjustmentCombo";
    public static final Props Properties = new Props();

    @Deprecated
    public SalesAdjustmentCombo() {
    }

    public SalesAdjustmentCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryAdjustmentCombo invCombo, EventContext context) {
        super(salesItems, quantity, invCombo, context, "NOT_PRINTED");
        this.applyAdjustment(invCombo.getPriceAdjustment(), context);
    }

    private SalesAdjustmentCombo(SalesAdjustmentCombo toCopy, EventContext context, boolean deep) {
        super(toCopy, context, deep);
        InventoryPriceAdjustment discount = this.getPriceAdjustment();
        this.applyAdjustment(discount, context);
    }

    @Override
    public SalesAdjustmentCombo copy(EventContext context, boolean deep) {
        return new SalesAdjustmentCombo(this, context, deep);
    }

    private void applyAdjustment(InventoryPriceAdjustment adjustment, EventContext context) {
        if (adjustment.getUnit().equals(PriceAdjustmentUnit.DOLLAR_UNIT)) {
            this.applyDollarAdjustment(adjustment, context);
        } else if (adjustment.getUnit().equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
            this.applyPercentageAdjustment(adjustment, context);
        } else {
            for (SalesItem item : this.getSalesItems()) {
                adjustment.createSalesPriceAdjustment(item, context);
                item.calcPriceAdjustmentUsages();
            }
        }
    }

    private void applyPercentageAdjustment(InventoryPriceAdjustment adjustment, EventContext context) {
        Price cap = adjustment.getCapAmount();
        if (cap != null) {
            cap = cap.multiply(this.getQuantity());
        }
        for (SalesItem item : this.getSalesItems()) {
            PercentagePriceAdjustment adj = (PercentagePriceAdjustment)adjustment.createSalesPriceAdjustment(item, context);
            if (cap != null) {
                adj.setCap(cap);
            }
            item.calcPriceAdjustmentUsages();
            if (cap == null || !Price.ZERO_DOLLAR.greaterThan(cap = cap.subtract(adj.getSavedValue())) && !Price.ZERO_DOLLAR.equals(cap)) continue;
            break;
        }
    }

    private void applyDollarAdjustment(InventoryPriceAdjustment adjustment, EventContext context) {
        if (!adjustment.getUnit().equals(PriceAdjustmentUnit.DOLLAR_UNIT)) {
            throw new IllegalArgumentException("Cannot apply dollar adjustment with adjustment that is not a dollar value: " + adjustment);
        }
        InventoryPriceAdjustment invAdj = (InventoryPriceAdjustment)PersistenceManager.reacquire(adjustment);
        SalesQuantity itemQty = SalesQuantity.ZERO;
        SalesQuantity comboQty = this.getQuantity();
        for (SalesItem item : this.getSalesItems()) {
            itemQty = itemQty.add(item.getQuantity());
        }
        SalesQuantity numItems = itemQty.divide(comboQty.notEquals(0) ? comboQty : SalesQuantity.ONE);
        invAdj.setDollarAmount(new Price(invAdj.getDollarAmount().divide(numItems.getValue()), 1.0E-5));
        Price difference = Price.ZERO_DOLLAR;
        for (SalesItem item : this.getSalesItems()) {
            Price pricePerItem = item.getPricePerItemUnadjusted();
            SalesPriceAdjustment salesAdj = invAdj.createSalesPriceAdjustment(item, context);
            Price appliedValue = salesAdj.calcValue(pricePerItem);
            difference = invAdj.getDollarAmount().subtract(appliedValue);
            invAdj.setDollarAmount(invAdj.getDollarAmount().add(difference));
            item.calcPriceAdjustmentUsages();
        }
    }

    @Transient
    InventoryPriceAdjustment getPriceAdjustment() {
        return ((InventoryAdjustmentCombo)this.getCombo()).getPriceAdjustment();
    }

    @Override
    protected void addSalesItem(SalesItem item, EventContext context) {
        super.addSalesItem(item, context);
        this.applyAdjustment(this.getPriceAdjustment(), context);
    }

    @Override
    public boolean componentIsAdjustable(SalesComponent component) {
        return true;
    }

    @Override
    @Transient
    public Price getMenuPriceDiff() {
        Price tally = Price.ZERO_NO_ROUND;
        InventoryPriceAdjustment adj = this.getPriceAdjustment();
        SalesQuantity qty = this.getQuantity();
        for (SalesItem item : this.getSalesItems()) {
            block1: for (SalesComponent component : item.getComponents()) {
                for (SalesPriceAdjustmentUsage usage : component.getPriceAdjustmentUsages()) {
                    if (!adj.equals(usage.getSalesPriceAdjustment().getInventoryPriceAdjustment())) continue;
                    tally = tally.add(usage.getValue());
                    continue block1;
                }
            }
        }
        tally = tally.divide(qty.getValue());
        return tally;
    }

    @Override
    public void setQuantity(SalesQuantity newQuantity, EventContext context) {
        super.setQuantity(newQuantity, context);
        if (this.getPriceAdjustment().getCapAmount() != null) {
            InventoryPriceAdjustment adj = this.getPriceAdjustment();
            for (SalesItem item : this.getSalesItems()) {
                block1: for (SalesComponent component : item.getComponents()) {
                    for (SalesPriceAdjustmentUsage usage : component.getPriceAdjustmentUsages()) {
                        if (!adj.equals(usage.getSalesPriceAdjustment().getInventoryPriceAdjustment())) continue;
                        component.removePriceAdjustmentUsage(usage);
                        continue block1;
                    }
                }
            }
            this.applyAdjustment(adj, context);
        }
    }

    public static class Props
    extends SalesCombo.Props {
    }
}

