/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;

public class SalesAdjustmentsTransfer {
    public static final Direction TRANSFER = new Direction("Transfer", false);
    public static final Direction REFUND = new Direction("Refund", true);
    private final Direction direction;
    private final Account source;
    private final Account target;
    private final List transferItems = new ArrayList();
    private final EventContext context;

    public SalesAdjustmentsTransfer(Direction trnsDirection, Account sourceAccount, Account targetAccount, List itemsToTransfer, EventContext eventCtx) {
        this.direction = trnsDirection;
        this.source = sourceAccount;
        this.target = targetAccount;
        this.context = eventCtx;
        for (SalesLineItem lineItem : itemsToTransfer) {
            if (!lineItem.getAccount().equals(this.source)) continue;
            this.transferItems.add(lineItem);
        }
    }

    public void transferAccountPercentageAdjustment() {
        Price totalAccountPercAdj = PriceAdjustmentManager.getInstance().getSalesItemUsageValueForAccountLevelAdjustments(this.transferItems, PriceAdjustmentUnit.PERCENTAGE_UNIT);
        SalesPriceAdjustment salesAdj = null;
        if (!totalAccountPercAdj.equals(Price.ZERO_DOLLAR)) {
            if ((totalAccountPercAdj = this.direction.getPrice(totalAccountPercAdj)).compareTo(Price.ZERO_DOLLAR) > 0) {
                salesAdj = this.createCustomDiscountForPrice(totalAccountPercAdj);
            } else if (totalAccountPercAdj.compareTo(Price.ZERO_DOLLAR) < 0) {
                salesAdj = this.createCustomSurchargeForPrice(totalAccountPercAdj);
            }
            if (salesAdj != null) {
                salesAdj.setLabel("Transferred % adjustment : " + salesAdj.getValue());
            }
        }
    }

    private SalesPriceAdjustment createCustomSurchargeForPrice(Price total) {
        InventoryPriceAdjustment adj = PriceAdjustmentFactory.getInstance().createCustomSurcharge(total.doubleValue() * -1.0, PriceAdjustmentUnit.DOLLAR_UNIT);
        return adj.createSalesPriceAdjustment(this.target, this.context);
    }

    private SalesPriceAdjustment createCustomDiscountForPrice(Price total) {
        InventoryPriceAdjustment adj = PriceAdjustmentFactory.getInstance().createCustomDiscount(total.doubleValue(), PriceAdjustmentUnit.DOLLAR_UNIT);
        return adj.createSalesPriceAdjustment(this.target, this.context);
    }

    public void transferAccountAmountAdjustment() {
        Price totalAccountPercAdj = PriceAdjustmentManager.getInstance().getSalesItemUsageValueForAccountLevelAdjustments(this.transferItems, PriceAdjustmentUnit.DOLLAR_UNIT);
        SalesPriceAdjustment salesAdj = null;
        if (!totalAccountPercAdj.equals(Price.ZERO_DOLLAR)) {
            if ((totalAccountPercAdj = this.direction.getPrice(totalAccountPercAdj)).compareTo(Price.ZERO) > 0) {
                salesAdj = this.createCustomDiscountForPrice(totalAccountPercAdj);
            } else if (totalAccountPercAdj.compareTo(Price.ZERO) < 0) {
                salesAdj = this.createCustomSurchargeForPrice(totalAccountPercAdj);
            }
            if (salesAdj != null) {
                salesAdj.setLabel("Transferred dollar adjustment : " + salesAdj.getValue());
            }
        }
    }

    public void transferFullAccountAmountAdjustment(boolean remove) {
        List dollarAccountAdjs = PriceAdjustmentManager.getInstance().getMatching(this.source.getPriceAdjustments(), PriceAdjustmentUnit.DOLLAR_UNIT, PriceAdjustmentLevel.ACCOUNT_LEVEL);
        for (SalesPriceAdjustment adj : dollarAccountAdjs) {
            SalesPriceAdjustment copy = adj.copy();
            this.target.addSalesPriceAdjustment(copy, this.context);
            if (!remove) continue;
            this.source.removeAdjustment(adj, this.context);
        }
    }

    public static class Direction {
        private final String name;
        private final boolean remove;

        private Direction(String name, boolean remove) {
            this.name = name;
            this.remove = remove;
        }

        public Price getPrice(Price price) {
            if (this.remove) {
                return price.multiply(-1);
            }
            return price;
        }
    }
}

