/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.inventory.combos.ComboStrategy;
import ordermate.database.inventory.combos.InventoryBuyXGetYFreeCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="SalesBuyXGetYFreeCombo")
@AccessType(value="property")
public class SalesBuyXGetYFreeCombo
extends SalesCombo {
    public static final String TYPE = "SalesBuyXGetYFreeCombo";
    public static final Props Properties = new Props();
    private List<SalesItem> freeItems = new ArrayList<SalesItem>();

    public SalesBuyXGetYFreeCombo() {
    }

    public SalesBuyXGetYFreeCombo(List salesItems, SalesQuantity quantity, InventoryBuyXGetYFreeCombo invCombo, EventContext context) {
        this(salesItems, quantity, invCombo, context, "NOT_PRINTED");
    }

    private SalesBuyXGetYFreeCombo(List salesItems, SalesQuantity quantity, InventoryBuyXGetYFreeCombo invCombo, EventContext context, String printState) {
        super(salesItems, quantity, invCombo, context, printState);
        this.setCheapestItem(context);
    }

    protected SalesBuyXGetYFreeCombo(SalesBuyXGetYFreeCombo toCopy, EventContext context, boolean deep) {
        super(toCopy, context, deep);
    }

    @Override
    protected void addInitialSalesItems(List<SalesItem> salesItems, EventContext context) {
        super.addInitialSalesItems(salesItems, context);
        this.resetPrices(context);
        this.setCheapestItem(context);
    }

    @Override
    public void addItem(SalesItem toAdd, EventContext context) {
        super.addItem(toAdd, context);
        this.resetPrices(context);
        this.setCheapestItem(context);
    }

    private void setCheapestItem(EventContext context) {
        ArrayList<SalesItem> items = new ArrayList<SalesItem>();
        items.addAll(this.getSalesItems());
        Collections.sort(items, SalesItem.getSortByPriceComparator());
        this.freeItems.add((SalesItem)items.get(0));
        for (SalesItem item : this.freeItems) {
            item.setPrice(Price.ZERO, context);
        }
    }

    private void resetPrices(EventContext context) {
        this.freeItems = new ArrayList<SalesItem>();
        for (SalesItem item : this.getSalesItems()) {
            item.resetToOriginalPrice();
        }
    }

    @Override
    public SalesBuyXGetYFreeCombo copy(EventContext context, boolean deep) {
        return new SalesBuyXGetYFreeCombo(this, context, deep);
    }

    @Transient
    public ComboStrategy getComboStrategy() {
        return ((InventoryBuyXGetYFreeCombo)this.getCombo()).getComboStrategy();
    }

    @Transient
    public List<SalesItem> getFreeItemList() {
        return this.freeItems;
    }

    @Override
    public boolean componentIsAdjustable(SalesComponent component) {
        return !this.getFreeItemList().contains(component.getSalesItem());
    }

    @Override
    @Transient
    public Price getMenuPriceDiff() {
        Price tally = Price.ZERO_NO_ROUND;
        for (SalesItem item : this.getSalesItems()) {
            if (!Price.ZERO_DOLLAR.equals(item.getPrice())) continue;
            for (SalesComponent comp : item.getComponents()) {
                tally = tally.add(comp.getMenuPrice());
            }
        }
        return tally;
    }

    @Override
    protected SalesItem findSupplementaryItem(List<SalesItem> itemList, SalesItem currentSingletonItem) {
        for (SalesItem item : itemList) {
            if (item == currentSingletonItem || !item.isEquivalentTo(currentSingletonItem, false, false, true) || !item.getQuantity("ACTIVE").greaterThanOrEquals(SalesQuantity.ONE)) continue;
            return item;
        }
        return null;
    }

    public static class Props
    extends SalesCombo.Props {
    }
}

