/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.glazedlists.PropertyAccessorComparator;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxMan;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPriceInvAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComboHelper;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemList;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.users.User;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public abstract class SalesCombo
extends SalesLineItem {
    public static final Props Properties = new Props();
    private PersistentWriteableList<SalesItem> items;
    private SalesItem singletonItem;
    private SalesItem singletonItemSupplement;
    private Reference<InventoryCombo> combo;
    private Price savedTotalPrice;
    private Price comboDiscount;
    private transient SalesComboHelper helper;

    @Deprecated
    public SalesCombo() {
        this.items = (PersistentWriteableList)this.createList(SalesCombo.Properties.ITEMS);
        this.combo = this.createReference(SalesCombo.Properties.COMBO);
        this.savedTotalPrice = null;
    }

    public SalesCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryCombo invCombo, EventContext context) {
        this(salesItems, quantity, invCombo, context, "NOT_PRINTED");
    }

    public SalesCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryCombo invCombo, EventContext context, String printState) {
        super(null, 0, context, printState);
        this.items = (PersistentWriteableList)this.createList(SalesCombo.Properties.ITEMS);
        this.combo = this.createReference(SalesCombo.Properties.COMBO);
        this.savedTotalPrice = null;
        this.combo.set(invCombo);
        this.addInitialSalesItems(salesItems, context);
        this.setQuantity(quantity, context);
        if (this.isPriceEdited()) {
            this.adjustItemPrices(this.getPrice(), context);
        }
        for (SalesItem item : salesItems) {
            this.checkPriceAdds(item, context);
        }
    }

    protected SalesCombo(SalesCombo copy, EventContext context, boolean deep) {
        super(copy, context, deep);
        this.items = (PersistentWriteableList)this.createList(SalesCombo.Properties.ITEMS);
        this.combo = this.createReference(SalesCombo.Properties.COMBO);
        this.savedTotalPrice = null;
        if (deep) {
            for (SalesItem item : copy.items) {
                SalesLineItem copyItem = item.copy(context, deep);
                this.items.add((SalesItem)copyItem);
            }
        }
        this.combo.set(copy.getCombo());
    }

    @Override
    public void expandQuantities() {
        super.expandQuantities();
        for (SalesItem item : this.getSalesItems()) {
            item.expandQuantities();
        }
    }

    @Override
    protected void setAccount(Account acct) {
        super.setAccount(acct);
        for (SalesItem item : this.getSalesItems()) {
            item.setAccount(acct);
        }
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getCombo() != null ? this.getCombo().getLabel() : "Sales Combo: No combo, ID:" + this.getID();
    }

    @Transient
    public String getShortName() {
        int accountPosition = this.getAccountPosition();
        if (accountPosition != 0) {
            return this.getCombo().getShortName() + accountPosition;
        }
        return this.getCombo().getShortName();
    }

    @Column(name="saved_total_price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getSavedTotalPrice() {
        return this.savedTotalPrice;
    }

    protected void setSavedTotalPrice(Price newSavedTotalPrice) {
        this.savedTotalPrice = newSavedTotalPrice;
    }

    @Column(name="combo_discount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getComboDiscount() {
        if (this.comboDiscount == null) {
            this.setComboDiscount(this.getMenuPriceDiff());
        }
        return this.comboDiscount;
    }

    protected void setComboDiscount(Price newComboDiscount) {
        this.comboDiscount = newComboDiscount;
    }

    @Transient
    public int getAccountPosition() {
        if (this.getAccount() == null) {
            return 0;
        }
        int sequence = 1;
        Iterator<SalesCombo> it = this.getAccount().getSalesCombos().iterator();
        while (it.hasNext()) {
            SalesCombo saleCombo = it.next();
            if (!saleCombo.equals(this) && saleCombo.getCombo().equals(this.getCombo())) {
                ++sequence;
                continue;
            }
            if (!saleCombo.equals(this)) continue;
            while (it.hasNext()) {
                saleCombo = it.next();
                if (saleCombo.equals(this) || !saleCombo.getCombo().equals(this.getCombo())) continue;
                return sequence;
            }
        }
        if (sequence > 1) {
            return sequence;
        }
        return 0;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_combo")
    public InventoryCombo getCombo() {
        return this.combo.get();
    }

    @Override
    @Transient
    public InventoryGroup getMenuGroup() {
        return this.getCombo().getMenuGroup();
    }

    protected void addInitialSalesItems(List<SalesItem> salesItems, EventContext context) {
        this.items.addAll(salesItems);
        for (SalesItem item : salesItems) {
            if (item.getSeat() <= 0) continue;
            this.setSeat(item.getSeat());
            break;
        }
    }

    protected void addSalesItem(SalesItem item, EventContext context) {
        if (item.getAccount() != null) {
            item.getAccount().unsafeRemove(item);
        }
        this.items.add(item);
        if (item.getParentCombo() == null) {
            item.setParentCombo(this);
        }
        item.setAccount(this.getAccount());
        this.checkPriceAdds(item, context);
    }

    public void addItem(SalesItem item, EventContext context) {
        ArrayList<SalesItem> newItems = new ArrayList<SalesItem>(this.items);
        newItems.add(item);
        if (!this.getCombo().matchesItems(newItems)) {
            throw new IllegalArgumentException("Cannot add item " + item + " to combo " + this.getLabel() + " as it would mean the combo would become invalid");
        }
        this.addSalesItem(item, context);
        if (this.isPriceEdited()) {
            this.adjustItemPrices(this.getPrice(), context);
        }
    }

    public void addItems(List<SalesItem> itemsToAdd, EventContext context) {
        ArrayList<SalesItem> newItems = new ArrayList<SalesItem>(this.items);
        newItems.addAll(itemsToAdd);
        if (!this.getCombo().matchesItems(newItems)) {
            throw new IllegalArgumentException("Cannot add items " + itemsToAdd + " to combo " + this.getLabel() + " as it would mean the combo would become invalid");
        }
        for (SalesItem item : itemsToAdd) {
            this.addSalesItem(item, context);
        }
        if (this.isPriceEdited()) {
            this.adjustItemPrices(this.getPrice(), context);
        }
    }

    @Transient
    protected SalesItem getSingletonItemSupplement() {
        return this.singletonItemSupplement;
    }

    public void removeAllItems() {
        this.items.clear();
    }

    @Override
    @Transient
    public List<SalesItem> getSalesItems() {
        return this.items.getUnmodifiable();
    }

    @Override
    public Collection<VirtualPrinter> getDocketPrinters(Terminal forTerminal) {
        LinkedHashSet<VirtualPrinter> printers = new LinkedHashSet<VirtualPrinter>();
        for (SalesItem item : this.getSalesItems()) {
            printers.addAll(item.getDocketPrinters(forTerminal));
        }
        return printers;
    }

    public boolean checkValid() {
        if (this.isValid()) {
            return true;
        }
        throw new IllegalStateException("Combo is not valid " + this.getLabel());
    }

    @Transient
    public boolean isValid() {
        return this.getCombo().matchSalesCombo(this);
    }

    @Override
    public boolean isPrintableThrough(Terminal terminal, VirtualPrinter printer) {
        boolean printable = false;
        Iterator<SalesItem> iterator = this.getSalesItems().iterator();
        while (iterator.hasNext() && !printable) {
            SalesItem item = iterator.next();
            printable = item.isPrintableThrough(terminal, printer);
        }
        return printable;
    }

    @Override
    public void setQuantity(SalesQuantity newQuantity, EventContext context) {
        this.checkAndCreateSingleQuantitySalesItem(context);
        Map<SalesItem, SalesQuantity> itemQuantities = this.calculateNewItemQuantities(newQuantity);
        super.setQuantity(newQuantity, context);
        for (Map.Entry<SalesItem, SalesQuantity> entry : itemQuantities.entrySet()) {
            SalesItem item = entry.getKey();
            SalesQuantity newQty = entry.getValue();
            item.setQuantity(newQty, context);
            this.checkPriceAdds(item, context);
        }
        this.cleanupSupplementItem();
        if (this.getAccount() != null) {
            this.getAccount().getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        }
    }

    private Map<SalesItem, SalesQuantity> calculateNewItemQuantities(SalesQuantity newQuantity) {
        HashMap<SalesItem, SalesQuantity> itemQuantities = new HashMap<SalesItem, SalesQuantity>();
        SalesQuantity singletonQuantity = SalesQuantity.valueOf(newQuantity.getValue().signum());
        for (SalesItem item : this.items) {
            if (item == this.singletonItem) {
                itemQuantities.put(item, singletonQuantity);
                continue;
            }
            if (item == this.singletonItemSupplement) {
                itemQuantities.put(item, this.calculateQuantityRatio(item.getQuantity().add(singletonQuantity)).multiply(newQuantity).subtract(singletonQuantity));
                continue;
            }
            itemQuantities.put(item, this.calculateQuantityRatio(item.getQuantity()).multiply(newQuantity));
        }
        return itemQuantities;
    }

    private SalesQuantity calculateQuantityRatio(SalesQuantity itemQuantity) {
        if (!this.getQuantity().equals(SalesQuantity.ZERO)) {
            return itemQuantity.divide(this.getQuantity());
        }
        return SalesQuantity.ZERO;
    }

    @Override
    protected void mergeQuantity(SalesLineItem comboToMerge, EventContext context) {
        if (Config.isDebuging() && !this.getLocalQuantities().isEmpty() && !comboToMerge.getLocalQuantities().isEmpty()) {
            for (SalesItemQuantity localQty : this.getLocalQuantities()) {
                if (localQty.getPrintState().equals(comboToMerge.getLocalQuantities().get(0).getPrintState()) && localQty.getItemState().equals(comboToMerge.getLocalQuantities().get(0).getItemState())) continue;
                throw new IllegalStateException("The combo [" + this + "] local quantity as a different state than the merged combo [" + comboToMerge + "].");
            }
        }
        SalesQuantity newQty = this.getQuantity().add(comboToMerge.getQuantity());
        Price newTotalOpenPrice = null;
        if (this.getOpenPrice() != null) {
            newTotalOpenPrice = new Price(this.getOpenPrice().doubleValue() / this.getQuantity().getValue().doubleValue() * newQty.getValue().doubleValue(), 0.01);
        }
        super.setQuantity(newQty, context);
        if (newTotalOpenPrice != null) {
            this.setOpenPrice(newTotalOpenPrice);
        }
    }

    @Override
    @Transient
    public Price getTax() {
        double tax = 0.0;
        for (SalesLineItem salesLineItem : this.items) {
            tax += salesLineItem.getTax().doubleValue();
        }
        return new Price(tax, 0.0);
    }

    @Override
    @Transient
    public Price getUnitTax() {
        double tax = 0.0;
        for (SalesLineItem salesLineItem : this.items) {
            tax += salesLineItem.getUnitTax().doubleValue();
        }
        return new Price(tax, 0.0);
    }

    @Override
    @Transient
    public Price getUnadjustedTax() {
        double tax = 0.0;
        for (SalesLineItem salesLineItem : this.items) {
            tax += salesLineItem.getUnadjustedTax().doubleValue();
        }
        return new Price(tax, 0.0);
    }

    @Override
    @Transient
    public Price getIngredientCostExTax() {
        Price cost = new Price(0.0, 0.0);
        for (SalesLineItem salesLineItem : this.items) {
            cost = cost.add(salesLineItem.getIngredientCostExTax());
        }
        return cost;
    }

    @Override
    @Transient
    public Price getBasePrice() {
        if (this.isPriceEdited()) {
            return this.getOpenPrice();
        }
        Price basePrice = Price.ZERO_NO_ROUND;
        for (SalesItem item : this.getSalesItems()) {
            basePrice = basePrice.add(item.getBasePrice());
        }
        return basePrice;
    }

    @Override
    @Transient
    public Price getPrice() {
        Price price = new Price(0.0, 1.0E-4);
        for (SalesLineItem salesLineItem : this.items) {
            price = price.add(salesLineItem.getPrice());
        }
        return price;
    }

    @Override
    protected Price getPrice(SalesQuantity quantity) {
        return this.getQuantity().notEquals(0) ? this.getPrice().multiply(quantity.divide(this.getQuantity())) : Price.ZERO_DOLLAR;
    }

    @Override
    @Transient
    public Price getItemLevelPricePerItem() {
        Price pricePerItem = new Price(0.0, 1.0E-6);
        for (SalesLineItem salesLineItem : this.items) {
            pricePerItem = pricePerItem.add(salesLineItem.getItemLevelPrice());
        }
        return new Price(pricePerItem.divide(this.getQuantity().getValue()), 0.0);
    }

    @Override
    @Transient
    public Price getItemLevelPrice() {
        Price itemPrice = this.getItemLevelPricePerItem();
        double pricePerItem = itemPrice.doubleValue();
        return new Price(this.getQuantity().getValue().multiply(BigDecimal.valueOf(pricePerItem)), 1.0E-5);
    }

    @Override
    @Transient
    public Price getSubtotalPrice() {
        if (SystemProperty.getInstance().isExTax()) {
            Price pricePerItem = new Price(0.0, 1.0E-6);
            for (SalesLineItem salesLineItem : this.items) {
                pricePerItem = pricePerItem.add(salesLineItem.getSubtotalPrice());
            }
            return new Price(pricePerItem, 1.0E-5);
        }
        return this.getPrice();
    }

    @Override
    public void setPrice(Price newPrice, EventContext context) {
        this.setOpenPrice(newPrice);
        Price openPrice = SystemProperty.getInstance().isExTax() ? this.getIncTaxPrice(newPrice) : newPrice;
        this.adjustItemPrices(openPrice, context);
    }

    private Price getIncTaxPrice(Price newPrice) {
        Price newPriceIncTax = Price.ZERO_NO_ROUND;
        newPriceIncTax = newPriceIncTax.add(TaxMan.getInstance().getPriceIncTax(newPrice, this.getTaxCodes()));
        return newPriceIncTax;
    }

    @Transient
    protected List<TaxCode> getTaxCodes() {
        return this.getTaxCodes(this.getSalesItems());
    }

    @Transient
    protected List<TaxCode> getTaxCodes(List<SalesItem> salesItems) {
        HashSet<TaxCode> uniqueTaxCodes = new HashSet<TaxCode>();
        for (SalesItem item : salesItems) {
            for (SalesComponent salesComponent : item.getComponents()) {
                uniqueTaxCodes.addAll(salesComponent.getUnit().getTaxCodes());
            }
        }
        return new ArrayList<TaxCode>(uniqueTaxCodes);
    }

    @Override
    public void setCustomer(Customer newCustomer) {
        super.setCustomer(newCustomer);
        for (SalesItem currentItem : this.getSalesItems()) {
            currentItem.setCustomer(newCustomer);
        }
    }

    private void adjustItemPrices(Price price, EventContext context) {
        Price finalPrice = new Price(price, 0.01);
        AtomicReference<Price> unadjusted = new AtomicReference<Price>(new Price(0.0, 0.01));
        Price oldTotal = Price.ZERO_DOLLAR;
        SalesQuantity totalNumItems = SalesQuantity.ZERO;
        List<SalesItem> apportionableItems = this.getApportionableItems(unadjusted);
        finalPrice = finalPrice.subtract(unadjusted.get());
        for (SalesItem currentItem : apportionableItems) {
            if (SystemProperty.getInstance().isComboByCost()) {
                for (SalesComponent component : currentItem.getComponents()) {
                    oldTotal = oldTotal.add(component.getUnit().getIngredientCostExTax());
                }
            } else {
                oldTotal = oldTotal.add(currentItem.getUnadjustedPrice());
            }
            totalNumItems = totalNumItems.add(currentItem.getQuantity());
        }
        if (oldTotal.equals(Price.ZERO_DOLLAR)) {
            for (SalesItem currentItem : apportionableItems) {
                BigDecimal newPriceBD = finalPrice.toBigDecimal().multiply(SalesQuantity.ONE.getValue());
                if (!SalesQuantity.ZERO.equals(totalNumItems)) {
                    newPriceBD = finalPrice.toBigDecimal().multiply(SalesQuantity.ONE.getValue().divide(totalNumItems.getValue(), 10, RoundingMode.HALF_UP));
                }
                Price newPrice = new Price(newPriceBD, 1.0E-4);
                currentItem.setPrice(newPrice, context);
            }
        } else if (!this.isRefund() && finalPrice.lessThan(Price.ZERO_DOLLAR)) {
            this.apportionPriceAcrossItems(apportionableItems, Price.ZERO_DOLLAR, oldTotal, context, SystemProperty.getInstance().isComboByCost());
            ArrayList<SalesItem> unapportionedItems = new ArrayList<SalesItem>(this.items);
            unapportionedItems.removeAll(apportionableItems);
            this.apportionPriceAcrossItems(unapportionedItems, unadjusted.get().add(finalPrice), unadjusted.get(), context, SystemProperty.getInstance().isComboByCost());
        } else {
            this.apportionPriceAcrossItems(apportionableItems, finalPrice, oldTotal, context, SystemProperty.getInstance().isComboByCost());
        }
        Price difference = this.getDiff(finalPrice, this.getUnadjustedPrice(), unadjusted.get());
        if (!SystemProperty.getInstance().isPriceOverrideMods()) {
            difference = difference.add(this.getApportionedMods(apportionableItems));
        }
        if (difference.abs().doubleValue() != 0.0) {
            for (SalesItem currentItem : apportionableItems) {
                if (currentItem.getPrice().isZero() || !currentItem.getQuantity().equals(1L)) continue;
                if (Math.abs(difference.doubleValue()) > 0.05) {
                    StringBuilder SB = new StringBuilder("Adjusting for rounding of ").append(this).append(" is greater than 0.05 :").append(difference).append("  Final price : ").append(finalPrice).append("  Unadjusted price ").append(this.getUnadjustedPrice().subtract(unadjusted.get())).append("  Old Total:").append(oldTotal);
                    OrderMate.LOG.warn(SB.toString());
                }
                Price currentPrice = currentItem.getUnadjustedPrice();
                if (!SystemProperty.getInstance().isPriceOverrideMods()) {
                    currentPrice = currentPrice.subtract(currentItem.getPriceOfMods());
                }
                currentItem.setPrice(currentPrice.add(difference), context);
                break;
            }
        }
    }

    Price getDiff(Price finalPrice, Price unadjustedPrice, Price unadjusted) {
        BigDecimal finalPriceBD = BigDecimal.valueOf(finalPrice.doubleValue());
        BigDecimal unadjustedPriceBD = BigDecimal.valueOf(unadjustedPrice.doubleValue());
        BigDecimal unadjustedBD = BigDecimal.valueOf(unadjusted.doubleValue());
        Price difference = new Price(finalPriceBD.subtract(unadjustedPriceBD.subtract(unadjustedBD)), 1.0E-4);
        return difference;
    }

    List<SalesItem> getApportionableItems(AtomicReference<Price> unadjusted) {
        ArrayList<SalesItem> apportionableItems = new ArrayList<SalesItem>();
        if (!this.getCombo().isApportioned()) {
            apportionableItems.addAll(this.items);
            unadjusted.set(Price.ZERO_DOLLAR);
        } else {
            for (SalesItem currentItem : this.items) {
                boolean found = false;
                for (InventoryComboGroup group : this.getCombo().getGroups()) {
                    for (SalesComponent component : currentItem.getComponents()) {
                        if (!group.isApportionable() || !this.checkGroupStrategy(group, currentItem, component)) continue;
                        apportionableItems.add(currentItem);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                unadjusted.set(unadjusted.get().add(currentItem.getUnadjustedPrice()));
            }
        }
        return apportionableItems;
    }

    private boolean checkGroupStrategy(InventoryComboGroup group, SalesItem currentItem, SalesComponent component) {
        boolean result = currentItem.getInventoryComboGroup() == null ? group.getAllItemUnits().contains(component.getUnit()) : currentItem.getInventoryComboGroup().equals(group);
        return result;
    }

    Price getApportionedMods(List<SalesItem> apportionableItems) {
        Price apportionableMods = Price.ZERO_DOLLAR;
        for (SalesLineItem salesLineItem : apportionableItems) {
            apportionableMods = apportionableMods.add(salesLineItem.getPriceOfMods().multiply(salesLineItem.getQuantity()));
        }
        return apportionableMods;
    }

    private void apportionPriceAcrossItems(List<SalesItem> apportionableItems, Price finalPrice, Price oldTotal, EventContext context, boolean byCost) {
        for (SalesItem currentItem : apportionableItems) {
            Price currentPrice;
            if (!byCost) {
                currentPrice = new Price(currentItem.getUnadjustedPrice(), 1.0E-4);
            } else {
                currentPrice = new Price(0.0, 1.0E-4);
                for (SalesComponent component : currentItem.getComponents()) {
                    currentPrice = currentPrice.add(component.getUnit().getIngredientCostExTax());
                }
            }
            BigDecimal newPriceBD = currentPrice.toBigDecimal().multiply(finalPrice.toBigDecimal()).divide(oldTotal.toBigDecimal(), 10, RoundingMode.HALF_UP);
            newPriceBD = newPriceBD.divide(currentItem.getQuantity().getValue(), 10, RoundingMode.HALF_UP);
            Price newPrice = new Price(newPriceBD, 1.0E-4);
            currentItem.setPrice(newPrice, context);
        }
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        if (!this.getPriceAdjustments().contains(adjustment)) {
            for (SalesItem item : this.items) {
                item.addSalesPriceAdjustment(adjustment, context);
            }
        }
    }

    @Override
    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        super.removePriceAdjustment(adjustment, context);
        boolean foundAllAdjustments = true;
        for (SalesLineItem salesLineItem : this.items) {
            foundAllAdjustments &= salesLineItem.removePriceAdjustment(adjustment, context);
        }
        return foundAllAdjustments;
    }

    @Override
    @Transient
    public Price getUnadjustedPrice() {
        double priceOfItems = 0.0;
        for (SalesLineItem salesLineItem : this.items) {
            priceOfItems += salesLineItem.getUnadjustedPrice().doubleValue();
        }
        return new Price(priceOfItems, 0.0);
    }

    @Override
    @Transient
    public Price getAccountDiscountTotal() {
        double total = 0.0;
        for (SalesItem item : this.getSalesItems()) {
            total += item.getAccountDiscountTotal().doubleValue();
        }
        return new Price(total, 0.01);
    }

    @Override
    @Transient
    public int getLoyaltyPointsCost() {
        int points = 0;
        for (SalesLineItem salesLineItem : this.items) {
            points += salesLineItem.getLoyaltyPointsCost();
        }
        return points;
    }

    @Override
    @Transient
    public int getLoyaltyPointsEarned() {
        int points = 0;
        for (SalesLineItem salesLineItem : this.items) {
            points += salesLineItem.getLoyaltyPointsCount();
        }
        return points;
    }

    @Override
    public boolean hasUnsavedDeletedQuantity() {
        boolean hasUnsaved = false;
        if (super.hasUnsavedDeletedQuantity()) {
            Iterator it = this.items.iterator();
            while (it.hasNext() && !hasUnsaved) {
                SalesLineItem item = (SalesLineItem)it.next();
                hasUnsaved = item.hasUnsavedDeletedQuantity();
            }
        }
        return hasUnsaved;
    }

    @Override
    public void markPrinted() {
        super.markPrinted();
        for (SalesLineItem salesLineItem : this.items) {
            if (this.isItemCourseOnHold(salesLineItem)) continue;
            salesLineItem.markPrinted();
        }
    }

    @Override
    public void markAsWasted() {
        super.markAsWasted();
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.markAsWasted();
        }
    }

    @Override
    public void markAsDeleted(EventContext context) {
        super.markAsDeleted(context);
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.markAsDeleted(context);
        }
    }

    @Override
    public void markAsRefunded(EventContext context) {
        super.markAsRefunded(context);
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.markAsRefunded(context);
        }
    }

    @Override
    void markAsQuickRefundState(EventContext context, String state) {
        super.markAsQuickRefundState(context, state);
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.setQuantity(salesLineItem.getQuantity().negate(), context, state);
        }
    }

    @Override
    public void markAsMoved(EventContext context, boolean printMove) {
        super.markAsMoved(context, printMove);
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.markAsMoved(context, printMove);
        }
    }

    @Override
    public void markAsLoyaltyPointsRedeemed() {
        this.setLoyaltyPointsAvailable(false);
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.markAsLoyaltyPointsRedeemed();
        }
    }

    @Override
    public void markAsLoyaltyPointsNotRedeemed() {
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.markAsLoyaltyPointsNotRedeemed();
        }
        this.setLoyaltyPointsAvailable(true);
    }

    @Override
    public void setSeat(int newSeat) {
        super.setSeat(newSeat);
        for (SalesLineItem salesLineItem : this.items) {
            salesLineItem.setSeat(newSeat);
        }
    }

    @Override
    public void setCourse(int newCourse) {
        super.setCourse(newCourse);
    }

    public void courseChanged() {
        int newCourse = this.getCourse();
        for (SalesItem item : this.items) {
            Course groupCourse = null;
            InventoryComboGroup comboGroup = item.getInventoryComboGroup();
            if (comboGroup != null) {
                groupCourse = comboGroup.getItemCourse(item.getFirstInventoryItem());
            }
            if (groupCourse != null) {
                item.setCourse(groupCourse);
                break;
            }
            item.setCourse(newCourse);
        }
    }

    @Override
    public void setCourse(Course theCourse) {
        int newCourse = 0;
        if (theCourse != null) {
            newCourse = theCourse.getCourseIndex();
        }
        this.setCourse(newCourse);
        this.courseChanged();
    }

    @Override
    public boolean isEquivalentTo(SalesLineItem other) {
        return this.isEquivalentTo(other, true, false);
    }

    @Override
    public boolean isEquivalentTo(SalesLineItem other, boolean ignorePrice, boolean ignoreSeat) {
        return this.isEquivalentTo(other, ignorePrice, ignoreSeat, false, false);
    }

    public boolean isEquivalentTo(SalesLineItem other, boolean ignorePrice, boolean ignoreSeat, boolean ignoreItems, boolean ignoreAccountPosition) {
        if (!(other instanceof SalesCombo)) {
            return false;
        }
        SalesCombo toCompare = (SalesCombo)other;
        if (this.equals(toCompare)) {
            return true;
        }
        if (!this.getCombo().equals(toCompare.getCombo())) {
            return false;
        }
        if (ignoreItems) {
            return true;
        }
        if (this.getItems().size() == toCompare.getItems().size()) {
            if (!this.itemListsAreExactMatch(toCompare, ignoreSeat)) {
                return false;
            }
            return ignoreAccountPosition || this.getAccountPosition() == toCompare.getAccountPosition();
        }
        return false;
    }

    private boolean itemListsAreExactMatch(SalesCombo toCompare, boolean ignoreSeat) {
        HashSet<SalesItem> unmatchedItems = new HashSet<SalesItem>(this.getItems());
        block0: for (SalesLineItem salesLineItem : toCompare.getItems()) {
            for (SalesLineItem salesLineItem2 : unmatchedItems) {
                if (!salesLineItem2.isEquivalentTo(salesLineItem, true, ignoreSeat)) continue;
                unmatchedItems.remove(salesLineItem2);
                continue block0;
            }
        }
        return unmatchedItems.isEmpty();
    }

    public static List<SalesCombo> generateAutoSalesComboList(SalesItemList itemList, SalesItemList mustIncludeOne, Terminal term, User user, ItemGroup theItemGp) {
        ArrayList<SalesCombo> returnList = new ArrayList<SalesCombo>();
        if (!itemList.isEmpty()) {
            List<InventoryCombo> autoCombos = InventoryCombo.getTriggeredAutoCombos(new TriggerActivationContext(new EventContext(term, user), new Date(), theItemGp));
            for (InventoryCombo autoCombo : autoCombos) {
                SalesCombo newCombo;
                ArrayList<SalesItem> salesItems;
                if (!autoCombo.matchesItems(itemList, mustIncludeOne, false) || (salesItems = autoCombo.getAnItemListMatch(itemList, term, user)) == null || salesItems.size() == 0 || (newCombo = autoCombo.createSalesCombo(salesItems, SalesQuantity.ONE, term, user)) == null) continue;
                returnList.add(newCombo);
            }
        }
        Collections.sort(returnList, new PropertyAccessorComparator(SalesCombo.Properties.MENU_PRICE_DIFF, true));
        return returnList;
    }

    public static SalesCombo generateSingleAutoCombo(SalesItemList itemList, SalesItemList mustIncludeOne, Terminal term, User user, ItemGroup itemGroup) {
        if (!itemList.isEmpty()) {
            List<InventoryCombo> autoCombos = InventoryCombo.getTriggeredAutoCombos(new TriggerActivationContext(new EventContext(term, user), new Date(), itemGroup));
            for (InventoryCombo autoCombo : autoCombos) {
                SalesCombo newCombo;
                ArrayList<SalesItem> salesItems;
                if (!autoCombo.matchesItems(itemList, mustIncludeOne, false) || (salesItems = autoCombo.getAnItemListMatch(itemList, term, user)) == null || salesItems.size() == 0 || (newCombo = autoCombo.createSalesCombo(salesItems, SalesQuantity.ONE, term, user)) == null) continue;
                return newCombo;
            }
        }
        return null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        super.prepareForSave(context);
        this.items.prepareForSave(context);
    }

    @Override
    public void consumeStockIfLegal(SalesItemQuantity componentQty, User user, String reason, String usage, StockControlProperty props, Terminal thisTerminal) {
    }

    @Override
    public void saveChild() {
        if (this.getAccount() == null) {
            throw new IllegalStateException("Cannot save a combo that doesnt belong to either an account");
        }
        this.setSavedTotalPrice(this.getPrice());
        Price discount = this.getMenuPriceDiff();
        this.setComboDiscount(discount);
        super.saveChild();
        this.items.saveChild();
        this.saveDone();
    }

    @Override
    public boolean hasChildChanged() {
        return super.hasChildChanged() || this.items.hasChildChanged();
    }

    @Override
    public SalesLineItem split(SalesQuantity qty, EventContext context) {
        SalesQuantity oldQty = this.getQuantity();
        Price oldPrice = this.getPrice();
        SalesCombo splitCombo = (SalesCombo)super.split(qty, context);
        SalesItem toRemove = null;
        this.checkAndCreateSingleQuantitySalesItem(context);
        for (SalesItem salesItem : this.getSalesItems()) {
            SalesQuantity itemQuantity = salesItem.getQuantity();
            if (salesItem == this.singletonItemSupplement) {
                itemQuantity = itemQuantity.add(SalesQuantity.ONE);
            }
            SalesQuantity qtyToSplit = qty.multiply(itemQuantity.divide(oldQty));
            if (salesItem.equals(this.singletonItemSupplement) && qtyToSplit.subtract(salesItem.getQuantity()).equals(SalesQuantity.ZERO)) {
                splitCombo.addSalesItem(salesItem, context);
                salesItem.setParentCombo(splitCombo);
                toRemove = salesItem;
                this.singletonItemSupplement = null;
                continue;
            }
            if (salesItem == this.singletonItem) continue;
            SalesItem splitItem = (SalesItem)salesItem.split(qtyToSplit, context);
            SalesPriceAdjustment existingAdj = salesItem.getPriceAdjustment(PriceAdjustmentManager.getInstance().getPriceLevelAdjustment());
            SalesPriceAdjustment adj = splitItem.getPriceAdjustment(PriceAdjustmentManager.getInstance().getPriceLevelAdjustment());
            if (adj != null && existingAdj == null) {
                splitItem.removePriceAdjustment(adj, context);
            }
            splitCombo.addSalesItem(splitItem, context);
            this.checkPriceAdds(salesItem, context);
        }
        if (toRemove != null) {
            this.items.remove(toRemove);
        }
        if (this.isPriceEdited()) {
            Price newPrice = new Price(oldPrice.multiply(oldQty.subtract(qty).divide(oldQty)), 0.01);
            Price splitComboPrice = new Price(oldPrice.subtract(newPrice), 0.0);
            if (this.getUnadjustedPrice().equals(this.getPrice()) && !this.getPrice().equals(newPrice)) {
                this.setPrice(newPrice, context);
            } else {
                this.setOpenPrice(this.getUnadjustedPrice());
            }
            if (splitCombo.getUnadjustedPrice().equals(splitCombo.getPrice()) && !splitCombo.getPrice().equals(splitComboPrice)) {
                if (!splitCombo.hasSingleQuantityItem()) {
                    splitCombo.checkAndCreateSingleQuantitySalesItem(context);
                }
                splitCombo.setPrice(splitComboPrice, context);
            } else {
                splitCombo.setOpenPrice(splitCombo.getUnadjustedPrice());
            }
        }
        for (SalesItem item : splitCombo.getItems()) {
            if (item.getParentCombo() != null) continue;
            item.setParentCombo(splitCombo);
        }
        return splitCombo;
    }

    private boolean hasSingleQuantityItem() {
        for (SalesItem item : this.items) {
            if (!item.getQuantity().equals(SalesQuantity.ONE)) continue;
            return true;
        }
        return false;
    }

    protected SalesItem splitItem(SalesItem item, SalesQuantity quantity, EventContext context) {
        if (!this.items.contains(item)) {
            throw new IllegalArgumentException("Cannot split SalesItem from Combo when it is not already part of our combo");
        }
        if (quantity.equals(item.getQuantity())) {
            return item;
        }
        SalesItem splitItem = (SalesItem)item.split(quantity, context);
        this.addSalesItem(splitItem, context);
        return splitItem;
    }

    @Override
    @Transient
    public Collection<SalesPriceAdjustment> getPriceAdjustments() {
        HashSet<SalesPriceAdjustment> adjs = new HashSet<SalesPriceAdjustment>();
        for (SalesItem item : this.items) {
            adjs.addAll(item.getPriceAdjustments());
        }
        return adjs;
    }

    @Override
    @Transient
    protected Price getPriceOfMods() {
        Price mods = Price.ZERO_DOLLAR;
        for (SalesItem item : this.getSalesItems()) {
            mods = mods.add(item.getPriceOfMods());
        }
        return mods;
    }

    protected void setCombo(InventoryCombo combo) {
        this.combo.set(combo);
    }

    @OneToMany(mappedBy="parentCombo", targetEntity=SalesItem.class, fetch=FetchType.LAZY)
    protected List<SalesItem> getItems() {
        return this.items;
    }

    protected void setItems(List<SalesItem> newItems) {
        this.items = this.items.clone();
        this.items.set(newItems);
    }

    @Override
    protected boolean hasSavedItems() {
        if (this.isPersistent()) {
            return true;
        }
        for (SalesItem item : this.getSalesItems()) {
            if (!item.isPersistent()) continue;
            return true;
        }
        return false;
    }

    public static void updateCourse(SalesLineItem item) {
        if (item instanceof SalesCombo) {
            ((SalesCombo)item).courseChanged();
        }
    }

    private Price getPriceAdd(SalesItem salesItem) {
        Price toAdd = Price.ZERO_DOLLAR;
        List<InventoryComboGroup> comboGroups = salesItem.getInventoryComboGroup() != null ? Arrays.asList(salesItem.getInventoryComboGroup()) : this.combo.get().getGroups();
        for (SalesComponent component : salesItem.getComponentList()) {
            for (InventoryComboGroup comboGroup : comboGroups) {
                for (InventoryComboGroupItemUnitLink unitLink : comboGroup.getGroupUnitLink()) {
                    try {
                        if (!unitLink.getItemUnit().equals(component.getUnit()) || Price.ZERO_DOLLAR.equals(unitLink.getPriceAdd())) continue;
                        return unitLink.getPriceAdd().multiply(component.getSalesItem().getQuantity());
                    }
                    catch (NullPointerException e) {
                        if (Config.isDebuging()) {
                            OrderMate.LOG.error(ReflectionToStringBuilder.toString((Object)unitLink));
                            throw e;
                        }
                        OrderMate.LOG.error("#Freya# checkPriceAdds encountered an issue for InventoryComboGroupItemUnitLink id = " + unitLink.getID() + "\nCombo id = " + this.combo.getID() + "\nComboGroup id = " + comboGroup.getID(), (Throwable)e);
                        OrderMate.LOG.error(ReflectionToStringBuilder.toString((Object)unitLink));
                    }
                }
            }
        }
        return toAdd;
    }

    private void checkPriceAdds(SalesItem salesItem, EventContext context) {
        Account account;
        salesItem.removeAllFinalPriceAdjustments(FinalPriceAdjustmentIdentifier.COMBO);
        Price toAdd = this.getPriceAdd(salesItem);
        if (!Price.ZERO_DOLLAR.equals(toAdd)) {
            this.addPriceAddFinalPriceAdjustment(salesItem, toAdd, context);
        }
        if ((account = this.getAccount()) != null) {
            account.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        }
    }

    private void addPriceAddFinalPriceAdjustment(SalesItem salesItem, Price priceAdd, EventContext context) {
        FinalPriceInvAdjustment adj = PriceAdjustmentManager.getInstance().getFinalPriceAdjustment(FinalPriceAdjustmentIdentifier.COMBO, null);
        adj.setAmount(priceAdd);
        adj.createSalesPriceAdjustment(salesItem, context);
    }

    private void checkAndCreateSingleQuantitySalesItem(EventContext context) {
        if (this.singletonItem == null) {
            List<SalesItem> sortedItems = this.sortItemsByName();
            this.singletonItem = this.findSingleQuantityItem(sortedItems);
            if (this.singletonItem == null) {
                this.createSingleQuantityItem(sortedItems, context);
            } else {
                this.singletonItemSupplement = this.findSupplementaryItem(sortedItems, this.singletonItem);
            }
        }
        if (this.singletonItem != null && this.singletonItemSupplement == null) {
            this.singletonItemSupplement = (SalesItem)this.singletonItem.copy(context, false);
            this.addSalesItem(this.singletonItemSupplement, context);
        }
    }

    private List<SalesItem> sortItemsByName() {
        ArrayList<SalesItem> sortedItems = new ArrayList<SalesItem>(this.items);
        Collections.sort(sortedItems, new Comparator<SalesItem>(){

            @Override
            public int compare(SalesItem first, SalesItem second) {
                return first.getLabel().compareTo(second.getLabel());
            }
        });
        return sortedItems;
    }

    private void cleanupSupplementItem() {
        if (this.singletonItemSupplement != null && this.singletonItemSupplement.getQuantity().equals(SalesQuantity.ZERO) && !this.singletonItemSupplement.isPersistent()) {
            this.items.remove(this.singletonItemSupplement);
            this.singletonItemSupplement = null;
        }
    }

    private SalesItem findSingleQuantityItem(List<SalesItem> itemList) {
        for (SalesItem item : itemList) {
            if (!item.getPrice().greaterThan(Price.ZERO_DOLLAR) || !item.getQuantity().equals(1L)) continue;
            InventoryComboGroup group = item.getInventoryComboGroup();
            if (group == null) {
                return item;
            }
            SalesQuantity minQty = group.getMinQuantity();
            SalesQuantity maxQty = group.getMaxQuantity();
            if (!minQty.greaterThanOrEquals(1L) || !maxQty.greaterThanOrEquals(1L)) continue;
            return item;
        }
        return null;
    }

    protected SalesItem findSupplementaryItem(List<SalesItem> itemList, SalesItem currentSingletonItem) {
        for (SalesItem item : itemList) {
            if (item == currentSingletonItem || !item.isEquivalentTo(currentSingletonItem, true, false, true) || !item.getQuantity("ACTIVE").greaterThanOrEquals(SalesQuantity.ONE)) continue;
            return item;
        }
        return null;
    }

    private void createSingleQuantityItem(List<SalesItem> itemList, EventContext context) {
        for (SalesItem item : itemList) {
            if (!item.getPrice().greaterThan(Price.ZERO_DOLLAR)) continue;
            this.singletonItemSupplement = item;
            this.singletonItem = this.splitItem(item, SalesQuantity.ONE, context);
            break;
        }
    }

    public abstract boolean componentIsAdjustable(SalesComponent var1);

    @Transient
    public SalesComboHelper getHelper() {
        if (this.helper == null) {
            this.helper = new SalesComboHelper(this);
        }
        return this.helper;
    }

    @Transient
    protected SalesItem getSingletonItem() {
        if (this.singletonItem == null) {
            List<SalesItem> sortedItems = this.sortItemsByName();
            this.singletonItem = this.findSingleQuantityItem(sortedItems);
        }
        return this.singletonItem;
    }

    @Transient
    protected SalesItem findSingletonItem() {
        if (this.singletonItem == null) {
            List<SalesItem> sortedItems = this.sortItemsByName();
            return this.findSingleQuantityItem(sortedItems);
        }
        return this.singletonItem;
    }

    @Transient
    public abstract Price getMenuPriceDiff();

    public static class Props
    extends SalesLineItem.Props {
        public PropertiedObject.Property<InventoryCombo> COMBO;
        public PropertiedObject.Property<SalesItem> ITEMS;
        public PropertiedObject.Property<Price> SAVED_TOTAL_PRICE;
        public PropertiedObject.Property<Price> COMBO_DISCOUNT;
        public PersistentObject.DerivedProperty<Price> MENU_PRICE_DIFF = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesCombo.class), "menuPriceDiff");
    }
}

