/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.reports.Summary;
import ordermate.database.sales.SalesAdjustmentCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;

public class SalesComboHelper {
    private SalesCombo salesCombo;
    private Summary adjSummary;

    SalesComboHelper(SalesCombo combo) {
        this.salesCombo = combo;
    }

    public InventoryPriceAdjustment getAppliedPriceAdjustment() {
        if (this.salesCombo instanceof SalesAdjustmentCombo) {
            return ((SalesAdjustmentCombo)this.salesCombo).getPriceAdjustment();
        }
        return null;
    }

    public Summary getPriceAdjustmentSummary() {
        if (this.adjSummary == null) {
            List<SalesItem> items = this.salesCombo.getApportionableItems(new AtomicReference<Price>(Price.ZERO_DOLLAR));
            long qty = 0L;
            for (SalesItem item : items) {
                qty += item.getQuantity().getValue().longValue();
            }
            this.adjSummary = new Summary(this.salesCombo.getCombo().getLabel(), SalesQuantity.valueOf(qty), this.salesCombo.getComboDiscount().multiply(this.salesCombo.getQuantity()).negate());
        }
        return this.adjSummary;
    }

    public String getComboIdentifier() {
        ArrayList<String> components = new ArrayList<String>();
        for (SalesItem item : this.salesCombo.getSalesItems()) {
            components.add(item.toString());
        }
        Collections.sort(components);
        return ((Object)components).toString();
    }
}

