/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.database.sales.SalesCombo;
import ordermate.internationalization.Internationalization;

public class SalesComboSummary
implements Serializable {
    private final List<SalesCombo> salesCombos = new ArrayList<SalesCombo>();
    private Price combinedTotal = Price.ZERO_DOLLAR;
    private boolean isPrinted = false;

    public boolean absorbCombo(SalesCombo salesComboToAbsorb) {
        boolean absorbed = false;
        if (this.salesCombos.isEmpty()) {
            this.salesCombos.add(salesComboToAbsorb);
            this.combinedTotal = salesComboToAbsorb.getItemLevelPrice();
            absorbed = true;
        } else {
            boolean addCombo = true;
            for (SalesCombo initialCombo : this.salesCombos) {
                if (!initialCombo.equals(salesComboToAbsorb) && initialCombo.isEquivalentTo(salesComboToAbsorb, true, true, true, false)) continue;
                addCombo = false;
                break;
            }
            if (addCombo) {
                this.salesCombos.add(salesComboToAbsorb);
                this.combinedTotal = this.combinedTotal.add(salesComboToAbsorb.getItemLevelPrice());
                absorbed = true;
            }
        }
        return absorbed;
    }

    public Price getCombinedTotal() {
        return this.combinedTotal;
    }

    private Set<Integer> getSeatNumbers() {
        HashSet<Integer> seats = new HashSet<Integer>();
        for (SalesCombo sc : this.salesCombos) {
            seats.add(sc.getSeat());
        }
        return seats;
    }

    public String seatNumbersAsString() {
        ArrayList<Integer> seats = new ArrayList<Integer>();
        seats.addAll(this.getSeatNumbers());
        if (seats.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String prefix = Internationalization.getLiteralFor("COVER") + " (";
        int value = (Integer)seats.get(0);
        if (value == 0) {
            sb.append("ALL");
        } else {
            sb.append(value);
        }
        for (int i = 1; i < seats.size(); ++i) {
            prefix = Internationalization.getLiteralFor("COVERS") + " (";
            sb.append(", ");
            value = (Integer)seats.get(i);
            if (value == 0) {
                sb.append("ALL");
                continue;
            }
            sb.append(value);
        }
        return prefix + sb.toString() + ")";
    }

    public List<SalesCombo> getSalesCombos() {
        return this.salesCombos;
    }

    public int getSalesComboCount() {
        SalesQuantity numOfCombos = SalesQuantity.ZERO;
        for (SalesCombo sc : this.salesCombos) {
            numOfCombos = numOfCombos.add(sc.getQuantity());
        }
        return numOfCombos.getValue().intValue();
    }

    public void markAsPrinted() {
        this.isPrinted = true;
    }

    public boolean isPrinted() {
        return this.isPrinted;
    }
}

