/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.ServiceLocator;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxAmount;
import au.com.ordermate.util.finance.tax.TaxMan;
import java.awt.Color;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.EventContext;
import ordermate.database.finance.CostedItem;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponentHelper;
import ordermate.database.sales.SalesComponentSaveContext;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesMod;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.SalesRemove;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.usage.PersistentStockUsage;
import ordermate.database.stock.usage.StockUsage;
import ordermate.database.users.User;
import ordermate.services.sales.RemoteSalesComponentUsageService;
import ordermate.services.sales.SalesComponentUsageService;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_component")
@AccessType(value="property")
public class SalesComponent
extends PersistentObject
implements SaveableChild,
CostedItem,
Displayable {
    public static final Props Properties = new Props();
    private Reference<InventoryItem> inventoryItem;
    private Reference<InventoryItemUnit> unit;
    private Reference<SalesItem> salesItem;
    private Reference<PriceLevel> priceLevel;
    private PersistentWriteableList<SalesAdd> adds;
    private PersistentWriteableList<AbstractSalesRemove> removes;
    private PersistentWriteableList<SalesOption> options;
    private PersistentWriteableList<SalesPriceAdjustmentUsage> priceAdjustmentUsages;
    private PersistentList<PersistentStockUsage> stockUsage;
    private PersistentWriteableList<SalesComponentTax> taxes;
    private Price savedUnitPrice;
    private Price savedTotalPrice;
    private Price savedTotalTax;
    private Price savedTotalCost;
    private Price menuPrice;
    private Price ingredientCostExTax;
    private Price unitTaxAmount;
    private Price menuTaxAmount;
    private Price openPrice;
    private Price itemDiscountTotal;
    private Price itemSurchargeTotal;
    private Price accountDiscountTotal;
    private Price accountSurchargeTotal;
    private BigDecimal portion;
    private int menuLoyaltyAdd;
    private int menuLoyaltyRedeem;
    private boolean loyaltyRedeemed;
    private Boolean hasOptions;
    private Boolean hasPlusses;
    private Boolean hasMinuses;
    private SalesComponent cloneUsageComponent;
    private boolean stealUsage;
    private transient SalesComponentSaveContext currentSaveContext;
    private transient LoyaltyPointTransaction loyaltyPointTransaction;
    private transient SalesComponentHelper helper;

    protected SalesComponent getCloneUsageComponent() {
        return this.cloneUsageComponent;
    }

    protected void setCloneUsageComponent(SalesComponent cloneUsageComponent) {
        this.cloneUsageComponent = cloneUsageComponent;
    }

    protected boolean isStealUsage() {
        return this.stealUsage;
    }

    protected void setStealUsage(boolean stealUsage) {
        this.stealUsage = stealUsage;
    }

    @Transient
    protected SalesComponentSaveContext getCurrentSaveContext() {
        return this.currentSaveContext;
    }

    @Transient
    protected void setCurrentSaveContext(SalesComponentSaveContext currentSaveContext) {
        this.currentSaveContext = currentSaveContext;
    }

    protected void setInventoryItem(Reference<InventoryItem> inventoryItem) {
        this.inventoryItem = inventoryItem;
    }

    protected void setUnit(Reference<InventoryItemUnit> unit) {
        this.unit = unit;
    }

    protected void setSalesItem(Reference<SalesItem> salesItem) {
        this.salesItem = salesItem;
    }

    protected void setPriceLevel(Reference<PriceLevel> priceLevel) {
        this.priceLevel = priceLevel;
    }

    protected void setAdds(PersistentWriteableList<SalesAdd> adds) {
        this.adds = adds;
    }

    protected void setRemoves(PersistentWriteableList<AbstractSalesRemove> removes) {
        this.removes = removes;
    }

    protected void setOptions(PersistentWriteableList<SalesOption> options) {
        this.options = options;
    }

    protected void setPriceAdjustmentUsages(PersistentWriteableList<SalesPriceAdjustmentUsage> priceAdjustmentUsages) {
        this.priceAdjustmentUsages = priceAdjustmentUsages;
    }

    protected void setStockUsage(PersistentList<PersistentStockUsage> stockUsage) {
        this.stockUsage = stockUsage;
    }

    protected void setTaxes(PersistentWriteableList<SalesComponentTax> taxes) {
        this.taxes = taxes;
    }

    @Transient
    protected void setHelper(SalesComponentHelper helper) {
        this.helper = helper;
    }

    public SalesComponent() {
        this.inventoryItem = this.createReference(SalesComponent.Properties.INVENTORY_ITEM);
        this.unit = this.createReference(SalesComponent.Properties.UNIT);
        this.salesItem = this.createReference(SalesComponent.Properties.SALES_ITEM);
        this.priceLevel = this.createReference(SalesComponent.Properties.PRICE_LEVEL);
        this.adds = this.createWriteableList(SalesComponent.Properties.ADDS);
        this.removes = this.createWriteableList(SalesComponent.Properties.REMOVES);
        this.options = this.createWriteableList(SalesComponent.Properties.OPTIONS);
        this.priceAdjustmentUsages = this.createWriteableList(SalesComponent.Properties.PRICE_ADJUSTMENT_USAGES);
        this.stockUsage = this.createList(SalesComponent.Properties.STOCK_USAGE);
        this.taxes = this.createWriteableList(SalesComponent.Properties.TAXES);
        this.savedUnitPrice = new Price(0.0, 0.01);
        this.savedTotalPrice = new Price(0.0, 0.01);
        this.savedTotalTax = new Price(0.0, 0.01);
        this.savedTotalCost = new Price(0.0, 0.01);
        this.menuPrice = new Price(0.0, 0.01);
        this.unitTaxAmount = Price.ZERO_NO_ROUND;
        this.menuTaxAmount = Price.ZERO_NO_ROUND;
        this.itemDiscountTotal = new Price(0.0, 0.01);
        this.itemSurchargeTotal = new Price(0.0, 0.01);
        this.accountDiscountTotal = new Price(0.0, 0.01);
        this.accountSurchargeTotal = new Price(0.0, 0.01);
        this.portion = BigDecimal.ONE;
        this.menuLoyaltyAdd = 0;
        this.menuLoyaltyRedeem = 0;
        this.loyaltyRedeemed = false;
        this.hasOptions = Boolean.FALSE;
        this.hasPlusses = Boolean.FALSE;
        this.hasMinuses = Boolean.FALSE;
        this.stealUsage = false;
        this.unitTaxAmount = new Price(0.0, 0.0);
    }

    protected SalesComponent(SalesComponent copy, boolean deep) {
        this();
        if (copy.hasPlusses()) {
            for (SalesAdd copyAdd : copy.adds) {
                this.adds.add(new SalesAdd(copyAdd));
                this.hasPlusses = Boolean.TRUE;
            }
        }
        if (copy.hasMinuses()) {
            for (AbstractSalesRemove salesRemove : copy.removes) {
                AbstractSalesRemove removeCopy = salesRemove.copy();
                removeCopy.setComponent(this);
                this.addMinus(removeCopy);
            }
        }
        if (copy.hasOption()) {
            for (SalesOption copyOption : copy.options) {
                this.options.add(new SalesOption(copyOption));
                this.hasOptions = Boolean.TRUE;
            }
        }
        for (SalesComponentTax tax : copy.taxes) {
            SalesComponentTax newTax = new SalesComponentTax(this, tax.getValue(), tax.getTaxCode());
            this.taxes.add(newTax);
        }
        this.setInventoryItem(copy.getInventoryItem());
        this.unit.set(copy.unit.get());
        this.priceLevel.set(copy.priceLevel.get());
        this.inventoryItem.set(copy.inventoryItem.get());
        this.setSalesItem(copy.getSalesItem());
        this.savedUnitPrice = copy.savedUnitPrice;
        this.menuPrice = copy.menuPrice;
        this.ingredientCostExTax = copy.ingredientCostExTax;
        this.openPrice = copy.openPrice;
        this.unitTaxAmount = copy.unitTaxAmount;
        this.menuTaxAmount = copy.menuTaxAmount;
        this.menuLoyaltyAdd = copy.menuLoyaltyAdd;
        this.menuLoyaltyRedeem = copy.menuLoyaltyRedeem;
        this.loyaltyRedeemed = copy.loyaltyRedeemed;
        this.itemDiscountTotal = copy.itemDiscountTotal;
        this.itemSurchargeTotal = copy.itemSurchargeTotal;
        this.accountDiscountTotal = copy.accountDiscountTotal;
        this.accountSurchargeTotal = copy.accountSurchargeTotal;
        this.portion = copy.portion;
        if (deep) {
            this.cloneStockUsageFrom(copy);
        }
    }

    protected SalesComponent(SalesLineItem parent, InventoryItemUnit theUnit, UnitPriceLevel unitPrice) {
        this();
        this.setSalesItem((SalesItem)parent);
        this.inventoryItem.set(theUnit.getItem());
        this.unit.set(theUnit);
        this.portion = theUnit.getPortion() != null ? BigDecimal.valueOf(theUnit.getPortion().getSize()) : BigDecimal.ONE;
        List<TaxAmount> appliedTaxes = TaxMan.getInstance().getTaxAmounts(this.savedUnitPrice, this.getUnit().getTaxCodes());
        for (TaxAmount tax : appliedTaxes) {
            this.addTax(tax.amount, (TaxCode)tax.taxCode);
            this.unitTaxAmount.add(tax.amount);
        }
        if (unitPrice != null) {
            this.setPriceLevel(unitPrice, true);
        }
        if (!theUnit.getDefaultMods().isEmpty()) {
            this.getHelper().applyDefaultMods(theUnit);
        }
        this.getHelper().applyForcedMods(theUnit);
    }

    void cloneStockUsage(SalesComponent other) {
        try {
            Data.database.cloneComponentStockUsage(other.intID(), this.intID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    @Transient
    public SalesComponentHelper getHelper() {
        if (this.helper == null) {
            this.helper = new SalesComponentHelper(this);
        }
        return this.helper;
    }

    @Override
    public void saveChild() {
        this.updateSummaryValues();
        this.options.prepareForSave(this.currentSaveContext);
        this.savedUnitPrice = this.getAdjustedPrice(SalesQuantity.ONE);
        this.savedTotalPrice = this.getPrice(this.getSalesItem().getQuantity());
        this.savedTotalTax = this.getTax().multiply(this.getSalesItem().getQuantity());
        this.portion = BigDecimal.valueOf(this.getUnit().getPortion().getSize());
        if (this.cloneUsageComponent != null) {
            this.ingredientCostExTax = this.cloneUsageComponent.getIngredientCostExTax();
        }
        Price newUnitPrice = new Price(this.getUnit().getAverageCost(this.currentSaveContext.decrementArea), 1.0E-4).add(this.calculateOptionCost(this.currentSaveContext));
        if (this.ingredientCostExTax == null) {
            this.ingredientCostExTax = newUnitPrice;
        } else {
            double unitCost = newUnitPrice.doubleValue();
            SalesQuantity newQty = this.currentSaveContext.unsavedQuantity;
            SalesQuantity existingQty = this.currentSaveContext.savedQuantity;
            if (!MathsUtils.approxEquals(this.ingredientCostExTax.doubleValue(), unitCost) && newQty.greaterThan(0L) && existingQty.greaterThan(0L)) {
                double existingCost = this.ingredientCostExTax.doubleValue() * existingQty.getValue().doubleValue();
                double newCost = unitCost * newQty.getValue().doubleValue();
                double totalCost = Math.abs(existingCost) + Math.abs(newCost);
                double totalQty = Math.abs(existingQty.getValue().doubleValue()) + Math.abs(newQty.getValue().doubleValue());
                if (!MathsUtils.approxEquals(0.0, totalQty)) {
                    double newAverageCost = totalCost / totalQty;
                    this.ingredientCostExTax = new Price(newAverageCost, 1.0E-4).add(this.calculateOptionCost(this.currentSaveContext));
                }
            }
        }
        this.savedTotalCost = this.getIngredientCostExTax().multiply(this.getSalesItem().getQuantity());
        this.hasOption();
        PersistenceManager.saveChild(this);
        this.adds.saveChild();
        this.removes.saveChild();
        this.options.saveChild();
        this.taxes.saveChild();
        if (this.loyaltyPointTransaction != null) {
            if (this.loyaltyPointTransaction.isPersistent()) {
                this.loyaltyPointTransaction.setSystemState(PersistenceManager.getByID(this.loyaltyPointTransaction.getID(), LoyaltyPointTransaction.class).getSystemState());
            }
            this.loyaltyPointTransaction.saveChild();
        }
        this.validatePriceAdjustmentUsages();
        HashSet<SalesPriceAdjustmentUsage> usagesToDelete = new HashSet<SalesPriceAdjustmentUsage>();
        Iterator it = this.priceAdjustmentUsages.iterator();
        while (it.hasNext()) {
            SalesPriceAdjustmentUsage usage = (SalesPriceAdjustmentUsage)it.next();
            if (!usage.getUnitValue().equals(Price.ZERO_DOLLAR)) continue;
            if (usage.isPersistent()) {
                usagesToDelete.add(usage);
            }
            it.remove();
        }
        for (SalesPriceAdjustmentUsage usage : usagesToDelete) {
            usage.deleteChild();
        }
        this.priceAdjustmentUsages.saveChild();
        if (this.cloneUsageComponent != null) {
            if (!this.stealUsage) {
                this.cloneStockUsage(this.cloneUsageComponent);
            } else {
                try {
                    Data.database.swapStockUsageComponent(this.cloneUsageComponent.intID(), this.intID());
                }
                catch (RemoteException e) {
                    Data.handleException(e);
                }
            }
            this.cloneUsageComponent = null;
        }
    }

    private void validatePriceAdjustmentUsages() {
        SalesItem theSalesItem = this.getSalesItem();
        Account theSalesItemAccount = theSalesItem.getAccount();
        List<SalesPriceAdjustment> priceAdjustments = theSalesItemAccount.getPriceAdjustments();
        if (theSalesItem.getQuantity().notEquals(0)) {
            for (SalesPriceAdjustment adj : priceAdjustments) {
                if (!theSalesItemAccount.getPriceAdjHelper().isPriceAdjApplicable(adj, theSalesItem)) continue;
                boolean foundIt = false;
                for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
                    if (!usage.getSalesPriceAdjustment().equals(adj)) continue;
                    foundIt = true;
                    break;
                }
                if (foundIt) continue;
                String errorMessage = "Sales item has price adjustments but component does not have usages. No usage found for:  " + adj + " in usages: " + this.priceAdjustmentUsages + " for item : " + theSalesItem.getLabel() + " with quantity : " + theSalesItem.getQuantity();
                if (Config.isDebuging()) {
                    throw new IllegalStateException(errorMessage);
                }
                OrderMate.LOG.error(errorMessage);
            }
        }
    }

    private void cloneStockUsageFrom(SalesComponent comp) {
        if (this.isPersistent()) {
            throw new IllegalStateException("Cannot clone stock usage on the component " + this + " that has already been saved.");
        }
        this.cloneUsageComponent = comp;
        this.stealUsage = false;
    }

    public void setLoyaltyRedeemed(boolean redeemed) {
        this.loyaltyRedeemed = redeemed;
    }

    @Column(name="loyalty_redeemed")
    public boolean isLoyaltyRedeemed() {
        return this.loyaltyRedeemed;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.currentSaveContext = (SalesComponentSaveContext)context;
        if (this.hasOption()) {
            this.options.prepareForSave(context);
        }
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
        this.priceAdjustmentUsages.deleteChild();
        this.adds.deleteChild();
        this.removes.deleteChild();
        this.options.deleteChild();
    }

    @Override
    @Transient
    public String getLabel() {
        InventoryItem invItem;
        String portionLabel = "" + this.portion;
        String size = "";
        if (this.getUnit() != null) {
            if (this.getUnit().getPortion() != null) {
                portionLabel = this.getUnit().getPortion().getLabel();
            }
            if (this.getUnit().getSize() != null) {
                size = this.getUnit().getSize().getLabel();
            }
        }
        String itemLabel = (invItem = this.getInventoryItem()) != null ? invItem.getLabel() : "";
        return itemLabel + " (" + portionLabel + " " + size + ")";
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_inventory_item")
    public InventoryItem getInventoryItem() {
        return this.inventoryItem.get();
    }

    private void setInventoryItem(InventoryItem item) {
        this.inventoryItem.set(item);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_item_unit")
    public InventoryItemUnit getUnit() {
        if (null == this.unit || null == this.unit.get()) {
            OrderMate.LOG.error("SalesComponent " + this.getID() + " has null unit! ALARM! ALARM!");
            return null == this.inventoryItem || null == this.getInventoryItem() ? null : this.getInventoryItem().getUnits().get(0);
        }
        return this.unit.get();
    }

    void setPriceLevel(UnitPriceLevel newPriceLevel) {
        this.setPriceLevel(newPriceLevel, false);
    }

    private void setPriceLevel(UnitPriceLevel newPriceLevel, boolean isConstructing) {
        UnitPriceLevel defaultPriceLevel;
        this.priceLevel.set(newPriceLevel.getPriceLevel());
        this.menuPrice = newPriceLevel.getPrice();
        this.menuTaxAmount = newPriceLevel.getTaxAmount();
        if (!newPriceLevel.getPriceLevel().isDefaultLevel() && (defaultPriceLevel = this.getUnit().getUnitPriceLevel(PriceLevel.getDefaultPriceLevel())) != null) {
            this.menuPrice = defaultPriceLevel.getPrice();
            this.menuTaxAmount = defaultPriceLevel.getTaxAmount();
        }
        if (!isConstructing) {
            this.updateSummaryValues();
        } else {
            this.savedUnitPrice = this.menuPrice;
            this.unitTaxAmount = this.menuTaxAmount;
        }
        this.getHelper().calculateLoyalty(newPriceLevel, this.priceLevel.get());
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_sales_item")
    public SalesItem getSalesItem() {
        return this.salesItem.get();
    }

    protected void setSalesItem(SalesItem item) {
        this.salesItem.set(item);
    }

    @Transient
    public List<SalesAdd> getCurrentPluses() {
        return this.adds.getUnmodifiable();
    }

    public boolean hasPlusses() {
        if (this.hasPlusses == null) {
            this.hasPlusses = this.adds.getLocalObjects().size() > 0 || this.adds.size() > 0;
        }
        return this.hasPlusses;
    }

    public void addPlus(InventoryAdd add) {
        boolean found = false;
        this.hasPlusses = Boolean.TRUE;
        for (SalesAdd currentAdd : this.adds) {
            if (!add.equals(currentAdd.getInventoryAdd())) continue;
            found = true;
            currentAdd.setQuantity(currentAdd.getQuantity() + 1.0);
            currentAdd.setPrice(currentAdd.getPrice().add(add.getPrice()));
            break;
        }
        if (!found) {
            SalesAdd salesAdd = new SalesAdd(this, add);
            this.adds.add(salesAdd);
            if (SystemProperty.getInstance().isPriceOverrideMods() && this.isPriceEdited()) {
                this.adjustPriceForModification(salesAdd, true);
            }
        }
        this.updatePriceAdjustments();
    }

    public void removePlus(SalesAdd add) {
        this.adds.remove(add);
        if (this.adds.size() == 0) {
            this.hasPlusses = Boolean.FALSE;
        }
        if (SystemProperty.getInstance().isPriceOverrideMods() && this.isPriceEdited()) {
            this.adjustPriceForModification(add, false);
        }
        this.updatePriceAdjustments();
    }

    @Transient
    public List<AbstractSalesRemove> getCurrentMinuses() {
        return this.removes.getUnmodifiable();
    }

    public boolean hasMinuses() {
        if (this.hasMinuses == null) {
            this.hasMinuses = this.removes.getLocalObjects().size() > 0 || this.removes.size() > 0;
        }
        return this.hasMinuses;
    }

    public void addMinus(AbstractSalesRemove remove) {
        AbstractSalesRemove existing;
        if (remove.getComponent() != this) {
            throw new IllegalArgumentException("Attempt to add a minus that does not reference this component" + remove + " : comp :" + this);
        }
        this.hasMinuses = Boolean.TRUE;
        boolean found = false;
        Iterator iterator = this.removes.iterator();
        while (iterator.hasNext() && !(found = remove.matches(existing = (AbstractSalesRemove)iterator.next()) && !remove.getLabel().equals("!Unknown Online Remove!"))) {
        }
        if (!found) {
            this.removes.add(remove);
            if (SystemProperty.getInstance().isPriceOverrideMods() && this.isPriceEdited()) {
                this.adjustPriceForModification(remove, true);
            }
            this.updatePriceAdjustments();
        }
    }

    public void removeMinus(AbstractSalesRemove remove) {
        this.removes.remove(remove);
        if (this.removes.size() == 0) {
            this.hasMinuses = Boolean.FALSE;
        }
        if (SystemProperty.getInstance().isPriceOverrideMods() && this.isPriceEdited()) {
            this.adjustPriceForModification(remove, false);
        }
        this.updatePriceAdjustments();
    }

    @Transient
    public List<SalesOption> getCurrentOptions() {
        return this.options.getUnmodifiable();
    }

    @Transient
    public int getCurrentOptionsSize() {
        return this.options.size();
    }

    public boolean hasOption() {
        if (this.hasOptions == null) {
            this.hasOptions = this.options.getLocalObjects().size() > 0 || this.options.size() > 0;
        }
        return this.hasOptions;
    }

    public SalesOption addOption(InventoryOption option) {
        SalesOption salesOption = new SalesOption(this, option);
        this.options.add(salesOption);
        this.getHelper().adjustForOptionAdded(salesOption);
        if (SystemProperty.getInstance().isPriceOverrideMods() && this.isPriceEdited()) {
            this.adjustPriceForModification(salesOption, true);
        }
        this.hasOptions = Boolean.TRUE;
        this.updatePriceAdjustments();
        return salesOption;
    }

    public void addOptions(List theOptions) {
        Iterator iterator = theOptions.iterator();
        while (iterator.hasNext()) {
            this.addOption((InventoryOption)iterator.next());
        }
    }

    public void removeOption(SalesOption option) {
        this.options.remove(option);
        this.getHelper().adjustForRemovedOption(option);
        if (SystemProperty.getInstance().isPriceOverrideMods() && this.isPriceEdited()) {
            this.adjustPriceForModification(option, false);
        }
        if (this.options.size() == 0) {
            this.hasOptions = Boolean.FALSE;
        }
        this.updatePriceAdjustments();
    }

    public void removeAllOptions() {
        for (SalesOption option : new ArrayList<SalesOption>(this.options)) {
            this.removeOption(option);
        }
    }

    @Transient
    public List getBarcodes() {
        return this.getUnit().getBarcodes();
    }

    protected final void updatePriceAdjustments() {
        if (this.priceLevel.isNull()) {
            return;
        }
        Account theAccount = this.getSalesItem().getAccount();
        if (theAccount != null) {
            theAccount.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        }
        this.updateSummaryValues();
        this.getHelper().calculateLoyalty(null, this.priceLevel.get());
    }

    private void updateSummaryValues() {
        this.accountDiscountTotal = this.calcAdjustmentTotal(PriceAdjustmentLevel.ACCOUNT_LEVEL, PriceAdjustmentDirection.DISCOUNT);
        this.accountSurchargeTotal = this.calcAdjustmentTotal(PriceAdjustmentLevel.ACCOUNT_LEVEL, PriceAdjustmentDirection.SURCHARGE);
        this.itemDiscountTotal = this.calcAdjustmentTotal(PriceAdjustmentLevel.ITEM_LEVEL, PriceAdjustmentDirection.DISCOUNT);
        this.itemSurchargeTotal = this.calcAdjustmentTotal(PriceAdjustmentLevel.ITEM_LEVEL, PriceAdjustmentDirection.SURCHARGE);
        this.savedUnitPrice = this.getPrice();
        try {
            this.updateTaxes(this.savedUnitPrice);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem with my taxes " + this.getLabel(), (Throwable)ex);
            this.handleBadTaxes();
        }
    }

    private void updateTaxes(Price unitPrice) {
        this.unitTaxAmount = Price.ZERO_NO_ROUND;
        double totalUnitTax = 0.0;
        List<TaxAmount> appliedTaxes = TaxMan.getInstance().getTaxAmounts(unitPrice, this.getUnit().getTaxCodes());
        for (TaxAmount nextTax : appliedTaxes) {
            totalUnitTax += nextTax.amount.doubleValue();
            this.addTax(nextTax.amount, (TaxCode)nextTax.taxCode);
        }
        if (totalUnitTax > 0.0) {
            this.unitTaxAmount = new Price(totalUnitTax, 0.0);
        }
    }

    private void handleBadTaxes() {
        HashSet<SalesComponentTax> dodgyCodes = new HashSet<SalesComponentTax>();
        for (SalesComponentTax tax : this.getTaxes()) {
            if (tax != null && tax.getTaxCode() != null) continue;
            dodgyCodes.add(tax);
        }
        this.taxes.removeAll(dodgyCodes);
        try {
            this.updateTaxes(this.savedUnitPrice);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot update taxes after cleanup", (Throwable)ex);
        }
    }

    private Price getAdjustedPrice(SalesQuantity quantity) {
        boolean isExTax = SystemProperty.getInstance().isExTax();
        Price adjustedPrice = isExTax ? this.getUnadjustedTotalExTax() : this.getUnadjustedTotal();
        adjustedPrice = adjustedPrice.multiply(quantity);
        for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
            Price adjustmentAmount = new Price(usage.getUnitValue().multiply(quantity), 1.0E-5);
            adjustedPrice = adjustedPrice.subtract(adjustmentAmount);
        }
        if (isExTax) {
            return TaxMan.getInstance().getPriceIncTax(adjustedPrice, this.getUnit().getTaxCodes());
        }
        return adjustedPrice;
    }

    private Price calcAdjustmentTotal(PriceAdjustmentLevel level, PriceAdjustmentDirection direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Price adjustment direction should not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Price adjustment level should not be null");
        }
        Price adjustmentAmount = Price.ZERO;
        for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
            SalesPriceAdjustment adj = usage.getSalesPriceAdjustment();
            if (!direction.equals(adj.getDirection()) || !adj.getLevel().equals(level)) continue;
            adjustmentAmount = adjustmentAmount.add(usage.getUnitValue());
        }
        return adjustmentAmount;
    }

    @Transient
    public boolean isOpenPriceItem() {
        return this.getInventoryItem().isOpenPrice();
    }

    @Transient
    public int getTotalOptionsMinusesAndAdds() {
        return this.getCurrentMinuses().size() + this.getCurrentPluses().size() + this.getCurrentOptions().size();
    }

    @Transient
    public boolean isPriceEdited() {
        return this.openPrice != null;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_price_level")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    protected void setPriceLevel(PriceLevel newPriceLevel) {
        this.priceLevel.set(newPriceLevel);
    }

    public Price getPrice(SalesQuantity quantity) {
        return this.getAdjustedPrice(quantity);
    }

    @Override
    @Transient
    public Price getPrice() {
        return this.getPrice(SalesQuantity.ONE);
    }

    @Transient
    public Price getBasePriceWithoutSurcharges() {
        Price basePrice = this.getPrice(SalesQuantity.ONE);
        for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
            if (!PriceAdjustmentDirection.SURCHARGE.equals(usage.getSalesPriceAdjustment().getDirection())) continue;
            basePrice = basePrice.subtract(usage.getUnitValue().abs());
        }
        return basePrice;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="unit_price")
    public Price getSavedUnitPrice() {
        return this.savedUnitPrice;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="saved_total_price")
    public Price getSavedTotalPrice() {
        if (!this.isPersistent()) {
            this.savedTotalPrice = this.getTotalPrice();
        }
        return this.savedTotalPrice;
    }

    @Transient
    public Price getTotalPrice() {
        return this.getPrice(this.getSalesItem().getQuantity());
    }

    @Transient
    public Price getBasePrice() {
        if (this.isPriceEdited()) {
            return this.openPrice;
        }
        return this.menuPrice;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="menu_price")
    public Price getMenuPrice() {
        return this.menuPrice;
    }

    @Column(name="menu_loyalty_add")
    public int getMenuLoyaltyAdd() {
        return this.menuLoyaltyAdd;
    }

    @Column(name="menu_loyalty_redeem")
    public int getMenuLoyaltyRedeem() {
        return this.menuLoyaltyRedeem;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="unit_cost")
    public Price getIngredientCostExTax() {
        return this.ingredientCostExTax;
    }

    protected void setIngredientCostExTax(Price value) {
        this.ingredientCostExTax = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="saved_total_cost")
    public Price getSavedTotalCost() {
        return this.savedTotalCost;
    }

    protected void setSavedTotalCost(Price savedTotalCost) {
        this.savedTotalCost = savedTotalCost;
    }

    @Transient
    public Price getTax() {
        return this.unitTaxAmount;
    }

    @Transient
    public Price getUnadjustedTax() {
        return TaxMan.getInstance().getTotalTax(this.getUnadjustedTotal(), this.getUnit().getTaxCodes());
    }

    @Transient
    public Price getMenuTax() {
        return this.menuTaxAmount;
    }

    void setPrice(Price thePrice) {
        this.openPrice = thePrice;
        SystemProperty sysProp = SystemProperty.getInstance();
        if (sysProp.isPriceOverrideMods() && this.isPriceEdited()) {
            this.openPrice = this.openPrice.subtract(new Price(this.getPriceOfMods(), 0.01));
        }
        double redeemRatio = sysProp.getLoyaltyRedeemRatio();
        double addRatio = sysProp.getLoyaltyAddRatio();
        if (redeemRatio > 0.0) {
            this.menuLoyaltyRedeem = (int)(thePrice.doubleValue() * redeemRatio * 100.0);
        }
        if (addRatio > 0.0) {
            this.menuLoyaltyAdd = (int)(thePrice.doubleValue() * addRatio * 100.0);
        }
        this.updatePriceAdjustments();
    }

    @Transient
    public Price getUnadjustedTotal() {
        Price mods = this.getPriceOfMods();
        double tmpPrice = this.getBasePrice().doubleValue();
        return this.getHelper().enforcePriceBoundaries(new Price(tmpPrice += mods.doubleValue(), 0.0));
    }

    @Transient
    public Price getUnadjustedTotalExTax() {
        Price total = this.getUnadjustedTotal().subtract(this.getUnadjustedTax());
        return this.getHelper().enforcePriceBoundaries(total);
    }

    @Transient
    public Price getUnadjustedTotalAfterPriceLevelAndFlatPriceAdjustments() {
        Price toReturn = this.getUnadjustedTotal();
        for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
            PriceAdjustmentType theType = usage.getSalesPriceAdjustment().getType();
            if (!PriceAdjustmentType.PRICE_LEVEL.equals(theType) && !PriceAdjustmentType.OPEN_PRICE.equals(theType)) continue;
            toReturn = toReturn.subtract(usage.getUnitValue());
        }
        return toReturn;
    }

    @Transient
    public Price getItemLevelPrice() {
        Price total = SystemProperty.getInstance().isExTax() ? this.getUnadjustedTotalExTax() : this.getUnadjustedTotal();
        PriceAdjustmentLevel adjLevel = null;
        for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
            if (usage.getSalesPriceAdjustment() == null || (adjLevel = usage.getSalesPriceAdjustment().getLevel()) == null || !adjLevel.equals(PriceAdjustmentLevel.ITEM_LEVEL)) continue;
            total = total.subtract(usage.getUnitValue());
        }
        return total;
    }

    @OneToMany(mappedBy="salesComponent", targetEntity=SalesPriceAdjustmentUsage.class, fetch=FetchType.LAZY)
    public List<SalesPriceAdjustmentUsage> getPriceAdjustmentUsages() {
        return this.priceAdjustmentUsages.getUnmodifiable();
    }

    public SalesPriceAdjustmentUsage getPriceAdjustmentUsage(SalesPriceAdjustment adj, EventContext context) {
        Iterator<Object> it = this.priceAdjustmentUsages.iterator();
        while (it.hasNext()) {
            SalesPriceAdjustmentUsage usage = (SalesPriceAdjustmentUsage)it.next();
            if (usage == null || usage.getSalesPriceAdjustment() == null) {
                it.remove();
                continue;
            }
            if (!usage.getSalesPriceAdjustment().isEquals(adj)) continue;
            OrderMate.LOG.debug("found usage for : " + adj);
            return usage;
        }
        for (SalesPriceAdjustmentUsage usage : adj.getPriceAdjustmentUsagesSafe()) {
            if (!this.equals(usage.getSalesComponent())) continue;
            this.priceAdjustmentUsages.add(usage);
            return usage;
        }
        OrderMate.LOG.debug("Usage not found, creating a new one : " + adj);
        return this.addSalesPriceAdjustmentUsage(adj, context);
    }

    private SalesPriceAdjustmentUsage addSalesPriceAdjustmentUsage(SalesPriceAdjustment adj, EventContext context) {
        SalesPriceAdjustmentUsage usage = new SalesPriceAdjustmentUsage(this, adj, context);
        this.priceAdjustmentUsages.add(usage);
        return usage;
    }

    public void removePriceAdjustmentUsage(SalesPriceAdjustmentUsage usage) {
        this.priceAdjustmentUsages.remove(usage);
    }

    public void removeAllPriceAdjustmentUsage() {
        this.priceAdjustmentUsages.clear();
    }

    protected void addPriceAdjustmentUsage(SalesPriceAdjustmentUsage usage) {
        if (this.priceAdjustmentUsages.contains(usage)) {
            throw new IllegalArgumentException("Usages already contains " + usage + " in component " + this);
        }
        this.priceAdjustmentUsages.add(usage);
    }

    public void resetToOriginalPrice() {
        this.priceAdjustmentUsages.clear();
        if (!this.isOpenPriceItem()) {
            this.openPrice = null;
        }
        this.updatePriceAdjustments();
    }

    @Column(name="account_discount_total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0")})
    public Price getAccountDiscountTotal() {
        return this.accountDiscountTotal;
    }

    public boolean isEquivalentTo(SalesComponent comp) {
        return this.isEquivalentTo(comp, false);
    }

    public boolean isEquivalentTo(SalesComponent comp, boolean ignorePrice) {
        return this.isEquivalentTo(comp, ignorePrice, false);
    }

    public boolean isEquivalentTo(SalesComponent comp, boolean ignorePrice, boolean ignoreZeroPricedOptions) {
        if (comp == null || comp.getInventoryItem() == null || comp.getUnit() == null) {
            return false;
        }
        boolean initialCheck = false;
        boolean plusCheck = true;
        boolean minusCheck = true;
        boolean optionsCheck = true;
        boolean priceCheck = true;
        boolean bl = initialCheck = comp.getInventoryItem().equals(this.getInventoryItem()) && comp.getUnit().equals(this.getUnit());
        if (!initialCheck) {
            return false;
        }
        boolean bl2 = priceCheck = ignorePrice || this.getPriceLevel().equals(comp.getPriceLevel()) && this.menuPrice.equals(comp.menuPrice) && this.menuTaxAmount.equals(comp.menuTaxAmount);
        if (this.hasOption() || comp.hasOption()) {
            List<SalesOption> thisOptions = this.getCurrentOptions();
            List<SalesOption> otherOptions = comp.getCurrentOptions();
            if (ignoreZeroPricedOptions) {
                thisOptions = this.filterZeroPricedOptions(thisOptions);
                otherOptions = this.filterZeroPricedOptions(otherOptions);
            }
            optionsCheck = this.optionsEquivalent(thisOptions, otherOptions);
        }
        if (this.hasPlusses() || comp.hasPlusses()) {
            List<SalesAdd> thisPluses = this.getCurrentPluses();
            List<SalesAdd> otherPluses = comp.getCurrentPluses();
            plusCheck = this.modificationsEquivalent(thisPluses, otherPluses);
        }
        if (this.hasMinuses() || comp.hasMinuses()) {
            List<AbstractSalesRemove> thisMinuses = this.getCurrentMinuses();
            List<AbstractSalesRemove> otherMinuses = comp.getCurrentMinuses();
            minusCheck = this.modificationsEquivalent(thisMinuses, otherMinuses);
        }
        return initialCheck && priceCheck && plusCheck && minusCheck && optionsCheck;
    }

    private List<SalesOption> filterZeroPricedOptions(List<SalesOption> options) {
        ArrayList<SalesOption> toRemove = new ArrayList<SalesOption>();
        for (SalesOption option : options) {
            if (!option.getPrice().isZero()) continue;
            toRemove.add(option);
        }
        ArrayList<SalesOption> filteredList = new ArrayList<SalesOption>(options);
        filteredList.removeAll(toRemove);
        return filteredList;
    }

    private boolean optionsEquivalent(List options1, List options2) {
        boolean equivalent = options1.size() == options2.size();
        Iterator iterator1 = options1.iterator();
        Iterator iterator2 = options2.iterator();
        while (iterator1.hasNext() && equivalent) {
            SalesOption option1 = (SalesOption)iterator1.next();
            SalesOption option2 = (SalesOption)iterator2.next();
            equivalent = option1.isEquivalentTo(option2);
        }
        return equivalent;
    }

    private boolean modificationsEquivalent(List mods1, List mods2) {
        boolean equivalent;
        boolean found;
        Iterator iterator1 = mods1.iterator();
        for (equivalent = mods1.size() == mods2.size() ? true : false; iterator1.hasNext() && equivalent; equivalent &= found) {
            Modification mod1 = (Modification)iterator1.next();
            found = false;
            Iterator iterator2 = mods2.iterator();
            while (iterator2.hasNext() && !found) {
                Modification mod2 = (Modification)iterator2.next();
                found = mod1.isEquivalentTo(mod2);
            }
        }
        return equivalent;
    }

    public void consumeStockIfLegal(SalesQuantity componentQty, User user, String reason, String usage, StockArea decrementArea, EventContext context) {
        String usageType = usage;
        StockControlProperty props = StockControlProperty.getInstance();
        if (props.isStockCountDownEnabled() && usageType != null && !usageType.equals("NONE") && !usageType.equals("WASTED")) {
            this.getUnit().decrementStockCount(componentQty, context);
        }
        if (props.isStockControlEnabled()) {
            if (usageType != null && !usageType.equals("NONE") && !usageType.equals("NORMAL")) {
                usageType = "NORMAL";
            }
            this.useLinkedStock(componentQty, user, reason, usageType, decrementArea);
        }
    }

    public List<StockUsage> useLinkedStock(SalesQuantity componentQty, User user, String reason, String usage, StockArea decrementArea) {
        List<StockUsage> allUsages = null;
        try {
            RemoteSalesComponentUsageService service = ServiceLocator.locate(RemoteSalesComponentUsageService.class);
            if (service == null) {
                OrderMate.LOG.warn("Could not load stock usage service, using local service");
                service = new SalesComponentUsageService();
            }
            if (!usage.equals("WASTED")) {
                service.useLinkedStock(new PersistentObjDescriptor<SalesComponent>(this), componentQty, user, reason, usage, decrementArea);
            } else {
                allUsages = service.useLinkedStock(this, componentQty, user, reason, usage, decrementArea);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return allUsages;
    }

    private void adjustPriceForModification(SalesMod mod, boolean added) {
        if (!this.isPriceEdited()) {
            throw new IllegalStateException("The price of mods can only be included when then the component is price edited.");
        }
        double priceOfMod = mod.getModificationPrice().doubleValue();
        if (!added) {
            priceOfMod = -priceOfMod;
        }
        if (mod instanceof SalesAdd || mod instanceof SalesOption) {
            this.openPrice = new Price(this.openPrice.doubleValue() - priceOfMod, 0.01);
        } else if (mod instanceof SalesRemove || mod instanceof SalesRemoveStocked) {
            this.openPrice = new Price(this.openPrice.doubleValue() + priceOfMod, 0.01);
        } else {
            throw new IllegalArgumentException("Mod is none of the expected types : " + mod);
        }
    }

    @Transient
    protected Price getPriceOfMods() {
        Price total = new Price(0.0, 0.01);
        if (this.hasPlusses()) {
            for (Modification modification : this.adds) {
                total = total.add(modification.getModificationPrice());
            }
        }
        if (this.hasMinuses()) {
            for (Modification modification : this.removes) {
                total = total.subtract(modification.getModificationPrice());
            }
        }
        if (this.hasOption()) {
            for (Modification modification : this.options) {
                total = total.add(modification.getModificationPrice());
            }
        }
        if (SystemProperty.getInstance().isExTax()) {
            total = TaxMan.getInstance().getPriceIncTax(total, this.getUnit().getTaxCodes());
        }
        return total;
    }

    @Transient
    protected InventoryItemPortion getInventoryPortion() {
        return this.getUnit().getPortion();
    }

    @Transient
    public List<PersistentStockUsage> getStockUsage() {
        return this.stockUsage.getUnmodifiable();
    }

    @Transient
    public void refreshStockUsages() {
        this.stockUsage.collapse();
        this.stockUsage.clone();
    }

    protected void collapseInventoryReferences() {
        this.inventoryItem.collapse();
        this.unit.collapse();
        this.priceLevel.collapse();
    }

    @Transient
    public boolean isWastageCheckNeeded() {
        return this.getUnit().isStockUsed() || this.getUnit().isStockCountDownEnabled();
    }

    @Deprecated
    protected void clearSalesPriceAdjustmentUsages() {
        ArrayList<SalesPriceAdjustmentUsage> changeList = new ArrayList<SalesPriceAdjustmentUsage>(this.priceAdjustmentUsages);
        for (SalesPriceAdjustmentUsage usage : changeList) {
            usage.setPriceAdjustment(null);
        }
        this.priceAdjustmentUsages.clear();
    }

    @Transient
    public Price getPriceAdjustmentUsageUnitTotal() {
        Price total = new Price(0.0, 1.0E-6);
        for (SalesPriceAdjustmentUsage usage : this.priceAdjustmentUsages) {
            total = total.add(usage.getUnitValue());
        }
        return total;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    protected void setAccountDiscountTotal(Price total) {
        this.accountDiscountTotal = total;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="open_price")
    public Price getOpenPrice() {
        return this.openPrice;
    }

    protected void setOpenPrice(Price price) {
        this.openPrice = price;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="saved_total_tax")
    protected Price getSavedTotalTax() {
        return this.savedTotalTax;
    }

    protected void setSavedTotalTax(Price totalTax) {
        this.savedTotalTax = totalTax;
    }

    @OneToMany(mappedBy="component", targetEntity=AbstractSalesRemove.class, fetch=FetchType.LAZY)
    protected List<AbstractSalesRemove> getRemoves() {
        return this.removes;
    }

    protected void setRemoves(List<SalesRemove> salesRemoves) {
        this.removes = this.removes.clone();
        this.removes.set(salesRemoves);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="item_discount_total")
    protected Price getItemDiscountTotal() {
        return this.itemDiscountTotal;
    }

    protected void setItemDiscountTotal(Price total) {
        this.itemDiscountTotal = total;
    }

    @Column(name="has_plusses")
    protected Boolean getHasPlusses() {
        return this.hasPlusses;
    }

    protected void setHasPlusses(Boolean hasPlus) {
        this.hasPlusses = hasPlus;
    }

    protected void setPriceAdjustmentUsages(List<SalesPriceAdjustmentUsage> usages) {
        this.priceAdjustmentUsages = this.priceAdjustmentUsages.clone();
        this.priceAdjustmentUsages.set(usages);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="menu_tax")
    protected Price getMenuTaxAmount() {
        return this.menuTaxAmount;
    }

    protected void setMenuTaxAmount(Price taxAmount) {
        this.menuTaxAmount = taxAmount;
    }

    @Column(name="has_options")
    protected Boolean getHasOptions() {
        return this.hasOptions;
    }

    protected void setHasOptions(Boolean hasOption) {
        this.hasOptions = hasOption;
    }

    protected void setSavedTotalPrice(Price totalPrice) {
        this.savedTotalPrice = totalPrice;
    }

    @Column(name="has_minuses")
    protected Boolean getHasMinuses() {
        return this.hasMinuses;
    }

    protected void setHasMinuses(Boolean hasMinus) {
        this.hasMinuses = hasMinus;
    }

    protected void setMenuLoyaltyRedeem(int loyaltyRedeem) {
        this.menuLoyaltyRedeem = loyaltyRedeem;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="unit_tax")
    protected Price getUnitTaxAmount() {
        return this.unitTaxAmount;
    }

    protected void setUnitTaxAmount(Price taxAmount) {
        this.unitTaxAmount = taxAmount;
    }

    protected void setMenuLoyaltyAdd(int loyaltyAdd) {
        this.menuLoyaltyAdd = loyaltyAdd;
    }

    @OneToMany(mappedBy="component", targetEntity=SalesAdd.class, fetch=FetchType.LAZY)
    protected List<SalesAdd> getAdds() {
        return this.adds;
    }

    protected void setAdds(List<SalesAdd> salesAdds) {
        this.adds = this.adds.clone();
        this.adds.set(salesAdds);
    }

    protected void setUnit(InventoryItemUnit invUnit) {
        this.unit.set(invUnit);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="account_surcharge_total")
    protected Price getAccountSurchargeTotal() {
        return this.accountSurchargeTotal;
    }

    protected void setAccountSurchargeTotal(Price total) {
        this.accountSurchargeTotal = total;
    }

    protected void setMenuPrice(Price price) {
        this.menuPrice = price;
    }

    protected void setSavedUnitPrice(Price price) {
        this.savedUnitPrice = price;
    }

    protected void setStockUsage(List<PersistentStockUsage> usages) {
        this.stockUsage = this.stockUsage.clone();
        this.stockUsage.set(usages);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0")})
    @Column(name="item_surcharge_total")
    protected Price getItemSurchargeTotal() {
        return this.itemSurchargeTotal;
    }

    @Transient
    public String getShortNameSafely() {
        InventoryItem invItem = this.getInventoryItem();
        String shortName = invItem.getShortName();
        if (shortName == null || shortName.equals("")) {
            return invItem.getLabel();
        }
        return shortName;
    }

    protected void setItemSurchargeTotal(Price total) {
        this.itemSurchargeTotal = total;
    }

    @OneToMany(mappedBy="component", targetEntity=SalesOption.class, fetch=FetchType.LAZY)
    protected List<SalesOption> getOptions() {
        return this.options;
    }

    protected void setOptions(List<SalesOption> salesOptions) {
        this.options = this.options.clone();
        this.options.set(salesOptions);
    }

    private Price calculateOptionCost(SalesComponentSaveContext context) {
        Price optionCost = new Price(0.0, 1.0E-4);
        if (this.hasOption()) {
            for (SalesOption option : this.getOptions()) {
                optionCost = optionCost.add(option.calculateIngredientCost(context));
            }
        }
        return optionCost;
    }

    @Column(name="portion")
    public BigDecimal getPortion() {
        return this.portion;
    }

    protected void setPortion(BigDecimal newPortion) {
        this.portion = newPortion;
    }

    public void setLoyaltyPointTransaction(LoyaltyPointTransaction txn) {
        this.loyaltyPointTransaction = txn;
    }

    public void addTax(Price amount, TaxCode theTaxCode) {
        for (SalesComponentTax tax : this.taxes) {
            if (!tax.getTaxCode().equals(theTaxCode)) continue;
            tax.setValue(amount);
            return;
        }
        this.taxes.add(new SalesComponentTax(this, amount, theTaxCode));
    }

    public void removeTax(TaxCode theCode) {
        SalesComponentTax tax = null;
        for (SalesComponentTax nextTax : this.taxes) {
            if (!theCode.equals(nextTax.getTaxCode())) continue;
            tax = nextTax;
        }
        if (tax != null) {
            this.taxes.remove(tax);
        }
    }

    @OneToMany(cascade={CascadeType.ALL}, targetEntity=SalesComponentTax.class, mappedBy="salesComponent", fetch=FetchType.LAZY)
    public List<SalesComponentTax> getTaxes() {
        return this.taxes;
    }

    protected void setTaxes(List<SalesComponentTax> value) {
        this.taxes = this.taxes.clone();
        this.taxes.set(value);
    }

    @Transient
    public LoyaltyPointTransaction getLoyaltyPointTransaction() {
        return this.loyaltyPointTransaction;
    }

    @Transient
    public List<InventoryRemovable<?>> getRemovables() {
        ArrayList removeables = new ArrayList(this.getInventoryItem().getMinuses());
        removeables.addAll(this.getUnit().getRemoveableIngredients());
        return removeables;
    }

    @Transient
    public boolean isBasePriceEnforced() {
        Price mods = this.getPriceOfMods();
        Price rawPrice = mods.add(this.getBasePrice());
        return !this.getHelper().enforcePriceBoundaries(rawPrice).equals(rawPrice);
    }

    public void recalculateTax() {
        this.updateTaxes(this.getPrice(SalesQuantity.ONE));
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryItem> INVENTORY_ITEM;
        public PropertiedObject.Property<InventoryItemUnit> UNIT;
        public PropertiedObject.Property<SalesItem> SALES_ITEM;
        public PropertiedObject.Property<SalesAdd> ADDS;
        public PropertiedObject.Property<AbstractSalesRemove> REMOVES;
        public PropertiedObject.Property<SalesOption> OPTIONS;
        public PropertiedObject.Property OPEN_PRICE;
        public PropertiedObject.Property SAVED_UNIT_PRICE;
        public PropertiedObject.Property SAVED_TOTAL_PRICE;
        public PropertiedObject.Property SAVED_TOTAL_TAX;
        public PropertiedObject.Property SAVED_TOTAL_COST;
        public PropertiedObject.Property INGREDIENT_COST_EX_TAX;
        public PropertiedObject.Property PORTION;
        public PropertiedObject.Property UNIT_TAX_AMOUNT;
        public PropertiedObject.Property ITEM_DISCOUNT_TOTAL;
        public PropertiedObject.Property ITEM_SURCHARGE_TOTAL;
        public PropertiedObject.Property ACCOUNT_DISCOUNT_TOTAL;
        public PropertiedObject.Property ACCOUNT_SURCHARGE_TOTAL;
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
        public PropertiedObject.Property MENU_PRICE;
        public PropertiedObject.Property MENU_TAX_AMOUNT;
        public PropertiedObject.Property MENU_LOYALTY_ADD;
        public PropertiedObject.Property MENU_LOYALTY_REDEEM;
        public PropertiedObject.Property LOYALTY_REDEEMED;
        public PropertiedObject.Property HAS_OPTIONS;
        public PropertiedObject.Property HAS_PLUSSES;
        public PropertiedObject.Property HAS_MINUSES;
        public PropertiedObject.Property<PersistentStockUsage> STOCK_USAGE;
        public PropertiedObject.Property<SalesPriceAdjustmentUsage> PRICE_ADJUSTMENT_USAGES;
        public PropertiedObject.Property<SalesComponentTax> TAXES;
        public PersistentObject.DerivedProperty<Price> PRICE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesComponent.class), "price");
    }
}

