/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesOption;
import ordermate.integration.onlinesales.unknownitem.UnknownItemResolver;

public class SalesComponentHelper {
    private final SalesComponent component;
    private Map<InventoryOptionGroupLink, List<SalesOption>> optionMap;
    private UnknownItemResolver unknownItemResolver;

    SalesComponentHelper(SalesComponent yourComponent) {
        this.component = yourComponent;
    }

    public void calculateLoyalty(UnitPriceLevel unitPL, PriceLevel priceLevel) {
        int menuLoyaltyAdd = 0;
        int menuLoyaltyRedeem = 0;
        if (priceLevel.isForceLoyaltyFactor()) {
            menuLoyaltyAdd = this.calculateEarnLoyaltyFromSavedUnitPrice(priceLevel);
            menuLoyaltyRedeem = this.calculateRedeemLoyaltyFromSavedUnitPrice(priceLevel);
            this.component.setMenuLoyaltyAdd(menuLoyaltyAdd);
            this.component.setMenuLoyaltyRedeem(menuLoyaltyRedeem);
        } else if (unitPL != null) {
            menuLoyaltyAdd = unitPL.getLoyaltyAdd();
            menuLoyaltyRedeem = unitPL.getLoyaltyRedeem();
            this.component.setMenuLoyaltyAdd(menuLoyaltyAdd);
            this.component.setMenuLoyaltyRedeem(menuLoyaltyRedeem);
        }
    }

    int calculateEarnLoyaltyFromSavedUnitPrice(PriceLevel priceLevel) {
        int toReturn = (int)(this.component.getPrice().doubleValue() * priceLevel.getLoyaltyEarnFactor());
        return toReturn;
    }

    int calculateRedeemLoyaltyFromSavedUnitPrice(PriceLevel priceLevel) {
        int toReturn = (int)(this.component.getSavedUnitPrice().doubleValue() * priceLevel.getLoyaltyRedeemFactor());
        return toReturn;
    }

    void applyDefaultMods(InventoryItemUnit unit) {
        this.primeOptionMap();
        ArrayList<InventoryDefaultMod> mods = new ArrayList<InventoryDefaultMod>(unit.getDefaultMods());
        Collections.sort(mods, new PropertyComparator((PropertiedObject.Property<? extends Comparable>)InventoryDefaultMod.Properties.SEQUENCE));
        for (InventoryDefaultMod mod : mods) {
            if (mod instanceof InventoryDefaultOption) {
                this.applyDefaultOption((InventoryDefaultOption)mod);
                continue;
            }
            if (!(mod instanceof InventoryDefaultAdd)) continue;
            this.applyDefaultAdd((InventoryDefaultAdd)mod);
        }
    }

    void applyForcedMods(InventoryItemUnit unit) {
        this.primeOptionMap();
        EventContext eContext = new EventContext(this.component.getSalesItem().getAccount() == null ? null : this.component.getSalesItem().getAccount().getUser());
        TriggerActivationContext tContext = new TriggerActivationContext(eContext, this.component.getSalesItem().getAccount());
        for (InventoryOptionGroupLink link : unit.getActiveOptionGroupLinks(tContext)) {
            if (!link.isForcedChoice() || !this.optionMap.get(link).isEmpty()) continue;
            this.component.addOption(link.getOptionGroup().getOptions().get(0));
        }
        for (InventoryOptionGroupLink link : unit.getActiveOptionGroupLinks(tContext)) {
            if (!this.optionMap.get(link).isEmpty() || link.getOptionGroup().getDefaultOption() == null) continue;
            this.component.addOption(link.getOptionGroup().getDefaultOption());
        }
    }

    private void applyDefaultOption(InventoryDefaultOption defOption) {
        if ("ACTIVE".equals(defOption.getOption().getSystemState())) {
            if (!this.component.getCurrentOptions().contains(defOption.getOption())) {
                for (InventoryOptionGroupLink link : this.component.getUnit().getOptionGroupLinks()) {
                    if (!link.getOptionGroup().equals(defOption.getOption().getOptionGroup())) continue;
                    if (!link.hasRealMaximum() || this.optionMap.get(link).size() < link.getMaxQty()) {
                        this.component.addOption(defOption.getOption());
                    } else {
                        OrderMate.LOG.warn("Cannot order past the maximum options for " + link.getOptionGroup());
                    }
                    break;
                }
            }
        } else {
            OrderMate.LOG.warn("Deleted option cannot be added by default:" + defOption);
        }
    }

    private void applyDefaultAdd(InventoryDefaultAdd add) {
        if ("ACTIVE".equals(add.getAdd().getSystemState())) {
            if (!this.component.getCurrentPluses().contains(add.getAdd())) {
                this.component.addPlus(add.getAdd());
            }
        } else {
            OrderMate.LOG.warn("Deleted plus cannot be added by default:" + add);
        }
    }

    void adjustForOptionAdded(SalesOption salesOption) {
        int index;
        if (salesOption.getOption().getReducedFactor() == 0.0) {
            return;
        }
        InventoryOptionGroupLink groupLink = null;
        for (InventoryOptionGroupLink link : this.component.getUnit().getOptionGroupLinks()) {
            if (!link.getOptionGroup().equals(salesOption.getOption().getOptionGroup())) continue;
            groupLink = link;
            break;
        }
        this.primeOptionMap();
        if (!this.optionMap.containsKey(groupLink)) {
            this.optionMap.put(groupLink, new ArrayList());
        }
        if ((index = this.optionMap.get(groupLink).indexOf(salesOption)) == -1) {
            this.optionMap.get(groupLink).add(salesOption);
            index = this.optionMap.get(groupLink).indexOf(salesOption);
        }
        if (groupLink == null || groupLink.getReducedZone() == 0) {
            return;
        }
        if (index < groupLink.getReducedZone()) {
            salesOption.setPrice(salesOption.getOption().getReducedPrice());
        }
    }

    public void reset() {
        this.optionMap = null;
    }

    private void primeOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap<InventoryOptionGroupLink, List<SalesOption>>();
            List<SalesOption> allOptions = this.component.getOptions();
            for (InventoryOptionGroupLink link : this.component.getUnit().getOptionGroupLinks()) {
                ArrayList<SalesOption> optionList = new ArrayList<SalesOption>();
                for (SalesOption nextOption : allOptions) {
                    InventoryOption inventoryOption = nextOption.getOption();
                    InventoryOptionGroup inventoryOptionGroup = inventoryOption.getOptionGroup();
                    if (inventoryOptionGroup == null) {
                        if (this.unknownItemResolver == null) {
                            this.unknownItemResolver = new UnknownItemResolver();
                        }
                        inventoryOptionGroup = this.unknownItemResolver.handleUnknownOptionGroup();
                        inventoryOption.setOptionGroup(inventoryOptionGroup);
                        inventoryOption.saveChild();
                    }
                    if (!nextOption.getOption().getOptionGroup().equals(link.getOptionGroup())) continue;
                    optionList.add(nextOption);
                }
                this.optionMap.put(link, optionList);
            }
        }
    }

    void adjustForRemovedOption(SalesOption option) {
        this.primeOptionMap();
        InventoryOptionGroupLink link = null;
        for (InventoryOptionGroupLink nextLink : this.component.getUnit().getOptionGroupLinks()) {
            if (!nextLink.getOptionGroup().equals(option.getOption().getOptionGroup())) continue;
            link = nextLink;
        }
        if (link == null) {
            OrderMate.LOG.warn("Cannot find the option group link to which this sales component is connected. No adjustment.");
            return;
        }
        this.optionMap.get(link).remove(option);
        if (link.getReducedZone() <= 0) {
            return;
        }
        List<SalesOption> currentOptions = this.optionMap.get(link);
        int currentIndex = currentOptions.indexOf(option);
        if (currentIndex >= 0) {
            currentOptions.remove(option);
            for (int i = currentIndex; i < currentOptions.size(); ++i) {
                if (i >= link.getReducedZone()) continue;
                currentOptions.get(i).setPrice(currentOptions.get(i).getOption().getReducedPrice());
            }
        } else {
            OrderMate.LOG.warn("Cannot find option in sales component, never added? " + option + " in " + this.component);
        }
    }

    public List<InventoryOptionGroupLink> getInvalidOptionGroups(TriggerActivationContext context) {
        this.primeOptionMap();
        ArrayList<InventoryOptionGroupLink> dudLinks = new ArrayList<InventoryOptionGroupLink>();
        for (InventoryOptionGroupLink nextLink : this.optionMap.keySet()) {
            if (nextLink.isSatisfied(false, this.optionMap.get(nextLink)) || !nextLink.getOptionGroup().isActive(context)) continue;
            dudLinks.add(nextLink);
        }
        return dudLinks;
    }

    public Price enforcePriceBoundaries(Price price) {
        Price basePrice;
        boolean priceAlreadyOverridesMods;
        Price boundedPrice = price;
        boolean bl = priceAlreadyOverridesMods = this.component.isPriceEdited() && SystemProperty.getInstance().isPriceOverrideMods();
        if (SystemProperty.getInstance().isEnforceBasePricesEnabled() && !priceAlreadyOverridesMods && price.lessThan(basePrice = this.component.getBasePrice())) {
            boundedPrice = basePrice;
        }
        return boundedPrice;
    }

    public void attemptToSatisfyOption(InventoryOptionGroupLink dudOption) {
        if (!dudOption.hasRealMaximum()) {
            return;
        }
        if (dudOption.isForcedChoice()) {
            return;
        }
        this.primeOptionMap();
        List<SalesOption> options = this.optionMap.get(dudOption);
        if (dudOption.getMaxQty() < options.size()) {
            ArrayList<SalesOption> toRemove = new ArrayList<SalesOption>();
            for (SalesOption option : options) {
                if (!option.getOption().isDefault()) continue;
                toRemove.add(option);
                break;
            }
            block1: for (InventoryDefaultMod defMod : this.component.getUnit().getDefaultMods()) {
                if (!(defMod instanceof InventoryDefaultOption) || !((InventoryDefaultOption)defMod).getOption().getOptionGroup().equals(options.get(0).getOption().getOptionGroup())) continue;
                for (SalesOption option : options) {
                    if (!option.getOption().equals(((InventoryDefaultOption)defMod).getOption())) continue;
                    toRemove.add(option);
                    continue block1;
                }
            }
            if (!toRemove.isEmpty()) {
                OrderMate.LOG.warn("Removing default options to attept to satify min/max. Please use Exclude next time.");
                for (SalesOption option : toRemove) {
                    this.component.removeOption(option);
                    if (!dudOption.isSatisfied(false, this.optionMap.get(dudOption))) continue;
                    break;
                }
            } else {
                OrderMate.LOG.warn("Couldn't find a default option to remove to satisfy the option group link " + dudOption.getOptionGroup());
            }
        }
    }
}

