/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.sales.SalesComponent;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_component_tax")
public class SalesComponentTax
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<SalesComponent> salesComponent;
    private Reference<TaxCode> taxCode;
    private Price value;

    public SalesComponentTax() {
        this.salesComponent = this.createReference(SalesComponentTax.Properties.SALES_COMPONENT);
        this.taxCode = this.createReference(SalesComponentTax.Properties.TAX_CODE);
    }

    public SalesComponentTax(SalesComponent component, Price amount, TaxCode theTaxCode) {
        this.salesComponent = this.createReference(SalesComponentTax.Properties.SALES_COMPONENT);
        this.taxCode = this.createReference(SalesComponentTax.Properties.TAX_CODE);
        this.setSalesComponent(component);
        this.setValue(amount);
        this.setTaxCode(theTaxCode);
    }

    @Column(name="value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.000001")})
    public Price getValue() {
        return this.value;
    }

    public void setValue(Price newValue) {
        this.value = newValue;
    }

    @ManyToOne(optional=false)
    @JoinColumn(referencedColumnName="ID", name="fk_sales_component")
    public SalesComponent getSalesComponent() {
        return this.salesComponent.get();
    }

    protected void setSalesComponent(SalesComponent value) {
        this.salesComponent.set(value);
    }

    @ManyToOne(optional=false)
    @JoinColumn(referencedColumnName="ID", name="fk_system_tax_code")
    public TaxCode getTaxCode() {
        return this.taxCode.get();
    }

    protected void setTaxCode(TaxCode value) {
        if (value == null) {
            OrderMate.LOG.error("Cannot have a null tax code for sales component " + this.getSalesComponent().getLabel());
        }
        this.taxCode.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SalesComponent> SALES_COMPONENT;
        public PropertiedObject.Property<TaxCode> TAX_CODE;
        public PropertiedObject.Property<Price> VALUE;
    }
}

