/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.combos.InventoryFlatPriceCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="SalesFlatPriceCombo")
@AccessType(value="property")
public class SalesFlatPriceCombo
extends SalesCombo {
    public static final String TYPE = "SalesFlatPriceCombo";
    public static final Props Properties = new Props();

    public SalesFlatPriceCombo() {
    }

    public SalesFlatPriceCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryFlatPriceCombo invCombo, EventContext context) {
        this(salesItems, quantity, invCombo, context, "NOT_PRINTED");
    }

    public SalesFlatPriceCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryFlatPriceCombo invCombo, EventContext context, String printState) {
        super(salesItems, quantity, invCombo, context, printState);
        this.dropExistingFlatPriceAdjustments(context);
        this.setPrice(this.calculateUnitPrice().multiply(quantity), context);
    }

    private SalesFlatPriceCombo(SalesFlatPriceCombo toCopy, EventContext context, boolean deep) {
        super(toCopy, context, deep);
        Price toCopyPrice;
        this.dropExistingFlatPriceAdjustments(context);
        Price price = toCopyPrice = toCopy.getQuantity().notEquals(0) ? toCopy.getPrice().divide(toCopy.getQuantity().getValue()) : Price.ZERO_DOLLAR;
        if (!deep) {
            this.setPrice(toCopyPrice, context);
        }
    }

    private void dropExistingFlatPriceAdjustments(EventContext context) {
        for (SalesItem item : this.getSalesItems()) {
            SalesPriceAdjustment adjustment = item.getFlatPriceAdjustment();
            if (adjustment != null) {
                item.removePriceAdjustment(adjustment, context);
            }
            item.removePriceLevelAdjustment();
        }
    }

    private Price calculateUnitPrice() {
        AtomicReference<Price> unadjusted = new AtomicReference<Price>(new Price(0.0, 0.01));
        this.getApportionableItems(unadjusted);
        Price unitPrice = unadjusted.get().add(((InventoryFlatPriceCombo)this.getCombo()).getFlatPrice());
        return unitPrice;
    }

    @Override
    public SalesFlatPriceCombo copy(EventContext context, boolean deep) {
        return new SalesFlatPriceCombo(this, context, deep);
    }

    @Override
    public void setQuantity(SalesQuantity newQuantity, EventContext context) {
        SalesQuantity oldQuantity = this.getQuantity();
        super.setQuantity(newQuantity, context);
        if (this.getOpenPrice() != null) {
            if (oldQuantity.equals(SalesQuantity.ZERO)) {
                oldQuantity = SalesQuantity.ONE;
            }
            Price price = this.getOpenPrice().multiply(newQuantity.divide(oldQuantity)).abs();
            if (this.isRefund()) {
                price = price.negate();
            }
            this.setPrice(price, context);
        }
    }

    @Override
    public boolean componentIsAdjustable(SalesComponent component) {
        return !this.getApportionableItems(new AtomicReference<Price>(Price.ZERO_DOLLAR)).contains(component.getSalesItem());
    }

    @Override
    @Transient
    public Price getMenuPriceDiff() {
        Price tally = Price.ZERO_NO_ROUND;
        AtomicReference<Price> unadjusted = new AtomicReference<Price>(Price.ZERO_NO_ROUND);
        List<SalesItem> apportionableItems = this.getApportionableItems(unadjusted);
        SalesQuantity quantity = this.getQuantity();
        SalesItem singletonItem = this.findSingletonItem();
        for (SalesItem item : apportionableItems) {
            if (SalesQuantity.ONE.lessThan(quantity) && singletonItem != null && singletonItem.equals(item)) continue;
            for (SalesComponent comp : item.getComponents()) {
                tally = tally.add(comp.getMenuPrice().subtract(comp.getOpenPrice()));
            }
        }
        return tally;
    }

    @Override
    @Transient
    protected List<TaxCode> getTaxCodes() {
        return this.getTaxCodes(this.getApportionableItems(new AtomicReference<Price>(Price.ZERO_NO_ROUND)));
    }

    public static class Props
    extends SalesCombo.Props {
    }
}

