/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryFreeItemCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.itemfilter.ComboGroupFilter;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="SalesFreeItemCombo")
@AccessType(value="property")
public class SalesFreeItemCombo
extends SalesCombo {
    public static final String TYPE = "SalesFreeItemCombo";
    public static final Props Properties = new Props();
    private List<SalesItem> freeList = null;

    public SalesFreeItemCombo() {
    }

    public SalesFreeItemCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryFreeItemCombo invCombo, EventContext context) {
        this(salesItems, quantity, invCombo, context, "NOT_PRINTED");
    }

    private SalesFreeItemCombo(List<SalesItem> salesItems, SalesQuantity quantity, InventoryFreeItemCombo invCombo, EventContext context, String printState) {
        super(salesItems, quantity, invCombo, context, printState);
        for (SalesItem toFree : salesItems) {
            if (!this.shouldItemBeFree(toFree)) continue;
            toFree.setPrice(Price.ZERO_DOLLAR, context);
        }
    }

    private SalesFreeItemCombo(SalesFreeItemCombo copy, EventContext context, boolean deep) {
        super(copy, context, deep);
    }

    @Override
    public SalesFreeItemCombo copy(EventContext context, boolean deep) {
        return new SalesFreeItemCombo(this, context, deep);
    }

    @Override
    public void addItem(SalesItem toAdd, EventContext context) {
        super.addItem(toAdd, context);
        if (this.shouldItemBeFree(toAdd)) {
            toAdd.setPrice(Price.ZERO_DOLLAR, context);
        }
    }

    @Override
    public void addItems(List<SalesItem> itemsToAdd, EventContext context) {
        super.addItems(itemsToAdd, context);
        for (SalesItem toCheck : itemsToAdd) {
            if (!this.shouldItemBeFree(toCheck)) continue;
            toCheck.setPrice(Price.ZERO, context);
        }
    }

    private boolean shouldItemBeFree(SalesItem toCheck) {
        InventoryFreeItemCombo combo = (InventoryFreeItemCombo)this.getCombo();
        if (this.freeList != null) {
            return this.freeList.contains(toCheck);
        }
        if (toCheck.getInventoryComboGroup() != null) {
            return toCheck.getInventoryComboGroup().equals(combo.getFreeItemGroup());
        }
        InventoryComboGroup theComboGroup = combo.getFreeItemGroup();
        ComboGroupFilter filter = new ComboGroupFilter(theComboGroup);
        return filter.itemBelongs(toCheck);
    }

    @Transient
    public List<SalesItem> getFreeItems() {
        ArrayList<SalesItem> freeItems = new ArrayList<SalesItem>();
        for (SalesItem item : this.getSalesItems()) {
            if (!this.shouldItemBeFree(item)) continue;
            freeItems.add(item);
        }
        return freeItems;
    }

    public void setFreeItemList(List<SalesItem> list) {
        this.freeList = list;
    }

    @Transient
    public List<SalesItem> getFreeItemList() {
        if (this.freeList == null) {
            this.freeList = this.getFreeItems();
        }
        return this.freeList;
    }

    @Override
    public boolean componentIsAdjustable(SalesComponent component) {
        return !this.getFreeItemList().contains(component.getSalesItem());
    }

    @Override
    @Transient
    public Price getMenuPriceDiff() {
        Price tally = Price.ZERO_NO_ROUND;
        for (SalesItem freeItem : this.getFreeItemList()) {
            for (SalesComponent comp : freeItem.getComponents()) {
                tally = tally.add(comp.getMenuPrice());
            }
        }
        return tally;
    }

    public static class Props
    extends SalesCombo.Props {
    }
}

