/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxMan;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.CostedItem;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.OpenPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.PriceAdjustmentCalculator;
import ordermate.database.sales.PriceLevelPriceAdjustmentMaster;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentSaveContext;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@DiscriminatorValue(value="SalesItem")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class SalesItem
extends SalesLineItem
implements CostedItem,
PriceAdjustable {
    public static final String TYPE = "SalesItem";
    public static final Props Properties = new Props();
    private static Boolean ignoreCombosExp = null;
    private Reference<SalesCombo> parentCombo;
    private Reference<SalesComponent> component;
    private PersistentWriteableList<SalesComponent> components;
    private Reference<InventoryComboGroup> inventoryComboGroup;
    private transient Map<PropertiedObject.Property, String> labelCache;

    protected static String getType() {
        return TYPE;
    }

    protected void setParentCombo(Reference<SalesCombo> parentCombo) {
        this.parentCombo = parentCombo;
    }

    protected void setComponent(Reference<SalesComponent> component) {
        this.component = component;
    }

    protected void setComponents(PersistentWriteableList<SalesComponent> components) {
        this.components = components;
    }

    protected void setInventoryComboGroup(Reference<InventoryComboGroup> inventoryComboGroup) {
        this.inventoryComboGroup = inventoryComboGroup;
    }

    protected void setLabelCache(Map<PropertiedObject.Property, String> labelCache) {
        this.labelCache = labelCache;
    }

    public SalesItem() {
        this.parentCombo = this.createReference(SalesItem.Properties.PARENT_COMBO);
        this.component = this.createReference(SalesItem.Properties.COMPONENT);
        this.components = (PersistentWriteableList)this.createList(SalesItem.Properties.COMPONENTS);
        this.inventoryComboGroup = this.createReference(SalesItem.Properties.INVENTORY_COMBO_GROUP);
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
    }

    public SalesItem(Terminal localhost, User createUser) {
        this(0, 0, localhost, createUser);
    }

    public SalesItem(int newCourse, int newSeat, Terminal localhost, User createUser) {
        super(newCourse, newSeat, new EventContext(localhost, createUser));
        this.parentCombo = this.createReference(SalesItem.Properties.PARENT_COMBO);
        this.component = this.createReference(SalesItem.Properties.COMPONENT);
        this.components = (PersistentWriteableList)this.createList(SalesItem.Properties.COMPONENTS);
        this.inventoryComboGroup = this.createReference(SalesItem.Properties.INVENTORY_COMBO_GROUP);
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
    }

    public SalesItem(InventoryItemUnit unit, UnitPriceLevel priceLevel, int newCourse, int newSeat, Terminal localhost, User createUser) {
        super(newCourse, newSeat, new EventContext(localhost, createUser));
        this.parentCombo = this.createReference(SalesItem.Properties.PARENT_COMBO);
        this.component = this.createReference(SalesItem.Properties.COMPONENT);
        this.components = (PersistentWriteableList)this.createList(SalesItem.Properties.COMPONENTS);
        this.inventoryComboGroup = this.createReference(SalesItem.Properties.INVENTORY_COMBO_GROUP);
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
        SalesComponent initialComponent = new SalesComponent(this, unit, priceLevel);
        this.addComponent(initialComponent);
    }

    @Override
    public SalesLineItem copy(EventContext context, boolean deep) {
        return new SalesItem(this, context.getTerminal(), context.getUser(), deep);
    }

    private SalesItem(SalesItem copy, Terminal localTerminal, User createUser, boolean deep) {
        super(copy, new EventContext(localTerminal, createUser), deep);
        this.parentCombo = this.createReference(SalesItem.Properties.PARENT_COMBO);
        this.component = this.createReference(SalesItem.Properties.COMPONENT);
        this.components = (PersistentWriteableList)this.createList(SalesItem.Properties.COMPONENTS);
        this.inventoryComboGroup = this.createReference(SalesItem.Properties.INVENTORY_COMBO_GROUP);
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
        this.setInventoryComboGroup(copy.getInventoryComboGroup());
        for (SalesComponent comp : copy.getComponentList()) {
            this.components.add(new SalesComponent(comp, deep));
        }
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
    }

    @Override
    @Transient
    public List<SalesItem> getSalesItems() {
        return Collections.singletonList(this);
    }

    @Override
    @Transient
    public InventoryGroup getMenuGroup() {
        SalesComponent comp = this.getComponentList().get(0);
        return comp.getInventoryItem().getMenuGroup();
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getFullLabel(InventoryItem.Properties.LABEL);
    }

    @Transient
    public String getShortName() {
        return this.getFullLabel(InventoryItem.Properties.SHORT_NAME);
    }

    @Transient
    public String getLabel(PropertiedObject.Property<String> property, boolean shortSize) {
        StringBuilder SB = this.createGeneralLabel(property);
        InventoryItemSize size = this.getSize();
        if (size != null) {
            SB.append("(");
            if (!shortSize || size.getShortName().trim().isEmpty()) {
                SB.append(size.getLabel());
            } else {
                SB.append(size.getShortName());
            }
            SB.append(")");
        }
        return SB.toString();
    }

    private String getFullLabel(PropertiedObject.Property<String> invItemLabelProp) {
        String cachedLabel = this.getLabelCache().get(invItemLabelProp);
        if (cachedLabel == null) {
            cachedLabel = this.getLabel(invItemLabelProp, false);
            this.getLabelCache().put(invItemLabelProp, cachedLabel);
        }
        return cachedLabel;
    }

    @Transient
    private InventoryItemSize getSize() {
        List<SalesComponent> componentList = this.getComponentList();
        if (componentList.isEmpty() || componentList.get(0).getUnit() == null) {
            return null;
        }
        return componentList.get(0).getUnit().getSize();
    }

    private StringBuilder createGeneralLabel(PropertiedObject.Property<String> invItemLabelProp) {
        StringBuilder SB = new StringBuilder();
        Iterator<SalesComponent> iter = this.getComponentList().iterator();
        while (iter.hasNext()) {
            SalesComponent currentComponent = iter.next();
            String itemLabel = null;
            if (currentComponent.getInventoryItem() != null) {
                itemLabel = currentComponent.getInventoryItem().getPropertyValue(invItemLabelProp) + "";
                if (itemLabel == null || itemLabel.equals("null") || itemLabel.equals("")) {
                    itemLabel = currentComponent.getInventoryItem().getLabel();
                }
            } else {
                itemLabel = "No Item";
            }
            SB.append(itemLabel);
            if (iter.hasNext()) {
                SB.append(" / ");
                continue;
            }
            SB.append(" ");
        }
        return SB;
    }

    @Transient
    private Map<PropertiedObject.Property, String> getLabelCache() {
        if (this.labelCache == null) {
            this.labelCache = new HashMap<PropertiedObject.Property, String>();
        }
        return this.labelCache;
    }

    @Transient
    public String getLongLabel() {
        StringBuffer buffer = new StringBuffer();
        PersistentDisplayableObject size = null;
        Iterator<SalesComponent> iterator = this.getComponentList().iterator();
        while (iterator.hasNext()) {
            SalesComponent currentComponent = iterator.next();
            buffer.append(currentComponent.getInventoryItem().getLabel());
            if (!currentComponent.getCurrentOptions().isEmpty()) {
                buffer.append(' ');
                buffer.append(currentComponent.getCurrentOptions());
            }
            size = currentComponent.getUnit().getSize();
            if (iterator.hasNext()) {
                buffer.append(" / ");
                continue;
            }
            buffer.append(" ");
        }
        if (size != null) {
            buffer.append("(");
            buffer.append(size.getLabel());
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Transient
    public List<SalesComponent> getComponentList() {
        if (this.getComponent() != null) {
            return Collections.singletonList(this.component.get());
        }
        if (this.components.size() != 0) {
            return this.components.getUnmodifiable();
        }
        return Collections.emptyList();
    }

    @OneToMany(mappedBy="salesItem", targetEntity=SalesComponent.class, fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected List<SalesComponent> getComponents() {
        return this.components;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_sales_component")
    protected SalesComponent getComponent() {
        return this.component.get();
    }

    public SalesComponent createComponent(InventoryItemUnit unit, UnitPriceLevel price) {
        if (this.isPersistent()) {
            String s = "Cannot create a component if the item is saved!";
            throw new IllegalStateException(s);
        }
        SalesComponent newComponent = new SalesComponent(this, unit, price);
        this.addComponent(newComponent);
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
        if (SystemProperty.getInstance().isPriceByDearest() && this.getComponentList().size() > 1) {
            new PriceLevelPriceAdjustmentMaster(this).priceComponentsByDearest();
        }
        return newComponent;
    }

    @Override
    @Transient
    protected Price getPriceOfMods() {
        Price retValue = Price.ZERO_DOLLAR;
        for (SalesComponent comp : this.getComponentList()) {
            Price mods = comp.getPriceOfMods();
            retValue = retValue.add(mods);
        }
        return retValue;
    }

    private void addComponent(SalesComponent newComponent) {
        this.components.add(newComponent);
        if (this.components.size() > 1) {
            this.ensureComponentTax();
        }
    }

    private void ensureComponentTax() {
        HashSet<TaxCode> codes = new HashSet<TaxCode>();
        for (SalesComponent comp : this.components) {
            for (SalesComponentTax tax : comp.getTaxes()) {
                codes.add(tax.getTaxCode());
            }
        }
        codes.remove(TaxCode.getFreeCode());
        if (!codes.isEmpty()) {
            for (SalesComponent comp : this.components) {
                comp.removeTax(TaxCode.getFreeCode());
                for (TaxCode code : codes) {
                    comp.addTax(Price.ZERO_DOLLAR, code);
                }
            }
        }
    }

    public void removeComponent(SalesComponent toRemove) {
        if (!this.components.remove(toRemove)) {
            throw new IllegalArgumentException("Item " + this.getLabel() + " doesn't contain component " + toRemove.getLabel());
        }
        if (toRemove.equals(this.component.get())) {
            this.component.set(null);
        }
        this.labelCache = new HashMap<PropertiedObject.Property, String>();
        if (SystemProperty.getInstance().isPriceByDearest() && this.components.size() > 1) {
            new PriceLevelPriceAdjustmentMaster(this).priceComponentsByDearest();
        }
    }

    public void setComponentPriceLevel(SalesComponent comp, UnitPriceLevel level) {
        new PriceLevelPriceAdjustmentMaster(this).setComponentPriceLevel(comp, level);
    }

    /*
     * WARNING - void declaration
     */
    void adjustComponentPrices(Price price) {
        void var6_13;
        Price finalPrice = new Price(price, 1.0E-4);
        Price oldTotal = new Price(0.0, 0.01);
        List<SalesComponent> componentsList = this.getComponentList();
        for (SalesComponent salesComponent : componentsList) {
            oldTotal = oldTotal.add(salesComponent.getUnadjustedTotal());
        }
        for (SalesComponent salesComponent : componentsList) {
            double newPriceValue = 0.0;
            newPriceValue = oldTotal.doubleValue() == 0.0 ? finalPrice.doubleValue() / (double)componentsList.size() : salesComponent.getUnadjustedTotal().doubleValue() * finalPrice.doubleValue() / oldTotal.doubleValue();
            Price newPrice = new Price(newPriceValue, 1.0E-4);
            salesComponent.setPrice(newPrice);
        }
        Price difference = finalPrice.subtract(this.getUnadjustedUnitPrice());
        if (!SystemProperty.getInstance().isPriceOverrideMods()) {
            difference = difference.add(this.getPriceOfMods());
        }
        if (Math.abs(difference.doubleValue()) > 0.05) {
            if (Config.isDebuging()) {
                throw new IllegalStateException("Attempting to round sales item : " + this + " by more than 5 cents: Difference" + difference + " Price : " + this.getPrice() + " Final Price : " + finalPrice);
            }
            OrderMate.LOG.info("Adjustment for rounding of " + this + " is greater than 5 cents : " + difference);
        }
        if (difference.doubleValue() != 0.0) {
            for (SalesComponent currentComponent : componentsList) {
                if (currentComponent.getBasePrice().doubleValue() == 0.0) continue;
                if (!SystemProperty.getInstance().isPriceOverrideMods()) {
                    currentComponent.setPrice(currentComponent.getBasePrice().add(difference));
                    break;
                }
                currentComponent.setPrice(currentComponent.getUnadjustedTotal().add(difference));
                break;
            }
        }
        Price price2 = finalPrice;
        if (!SystemProperty.getInstance().isPriceOverrideMods()) {
            Price price3 = finalPrice.add(this.getPriceOfMods());
        }
        if (Config.isDebuging() && !(this.getUnadjustedUnitPrice().subtract((Price)var6_13).abs().doubleValue() < 0.01)) {
            throw new IllegalStateException("Could not adjust price, expected:" + var6_13 + " but was : " + this.getUnadjustedPrice());
        }
    }

    protected final void calcPriceAdjustmentUsages() {
        PriceAdjustmentCalculator.calcPriceAdjustmentUsages(this);
    }

    @Transient
    protected final SalesPriceAdjustment getFlatPriceAdjustment() {
        List<SalesPriceAdjustment> adjs = PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentUnit.FLAT_PRICE_UNIT);
        if (adjs.size() > 1) {
            throw new IllegalStateException("an item cannot have more than one flat price adjustment");
        }
        if (adjs.size() == 1) {
            return adjs.get(0);
        }
        return null;
    }

    @Transient
    protected final SalesPriceAdjustment getPriceLevelAdjustment() {
        List<SalesPriceAdjustment> adjs = PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentUnit.PRICE_LEVEL_UNIT);
        if (adjs.size() > 1) {
            throw new IllegalStateException("SalesItem should not have more than one price level adjustment");
        }
        if (adjs.size() == 1) {
            return adjs.get(0);
        }
        return null;
    }

    protected final void removePriceLevelAdjustment() {
        List<SalesPriceAdjustment> adjs = PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentUnit.PRICE_LEVEL_UNIT);
        if (!adjs.isEmpty()) {
            this.removePriceAdjustments(adjs);
        }
    }

    protected final void removeAllFinalPriceAdjustments(FinalPriceAdjustmentIdentifier adjustmentType) {
        List<SalesPriceAdjustment> adjs = PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentUnit.FINAL_UNIT);
        ArrayList<SalesPriceAdjustment> toRemove = new ArrayList<SalesPriceAdjustment>();
        for (SalesPriceAdjustment adjustment : adjs) {
            if (!adjustmentType.equals((Object)((FinalSalesPriceAdjustment)adjustment).getPriceAdjustmentIdentifier())) continue;
            toRemove.add(adjustment);
        }
        this.removePriceAdjustments(toRemove);
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        if (adjustment.getUnit().equals(PriceAdjustmentUnit.FLAT_PRICE_UNIT) && this.getFlatPriceAdjustment() != null) {
            this.removePriceAdjustment(this.getFlatPriceAdjustment(), false, context);
        }
        if (adjustment.getUnit().equals(PriceAdjustmentUnit.PRICE_LEVEL_UNIT) && this.getPriceLevelAdjustment() != null) {
            this.removePriceAdjustment(this.getPriceLevelAdjustment(), false, context);
        }
        super.addSalesPriceAdjustment(adjustment, context);
    }

    public void resetToOriginalPrice() {
        this.removePriceAdjustments(this.getPriceAdjustments());
        this.setOpenPrice(null);
        for (SalesComponent currentComponent : this.getComponentList()) {
            currentComponent.resetToOriginalPrice();
        }
        if (SystemProperty.getInstance().isPriceByDearest()) {
            new PriceLevelPriceAdjustmentMaster(this).priceComponentsByDearest();
        }
    }

    @Override
    public void setPrice(Price inputPrice, EventContext context) {
        Price newPrice = inputPrice;
        if (SystemProperty.getInstance().isExTax() && this.isOpenPriceItem()) {
            Price newPriceIncTax = Price.ZERO_NO_ROUND;
            for (SalesComponent salesComponent : this.getComponents()) {
                List<TaxCode> taxCodes = salesComponent.getUnit().getTaxCodes();
                newPriceIncTax = newPriceIncTax.add(TaxMan.getInstance().getPriceIncTax(inputPrice, taxCodes));
            }
            newPrice = newPriceIncTax;
        }
        if (!this.isOpenPriceItem() && !this.isComboItem()) {
            TerminalEventLog.logPriceChange(context, this, newPrice, false);
        } else if (!this.isComboItem()) {
            TerminalEventLog.logOpenPrice(context, this, newPrice);
        }
        this.setOpenPrice(newPrice);
        if (!this.isOpenPriceItem() && !this.isComboItem() || this.getFlatPriceAdjustment() != null) {
            OpenPriceAdjustment adjustment = PriceAdjustmentType.OPEN_PRICE.createOpenPriceAdjustment(newPrice, this.getUnadjustedUnitPrice());
            adjustment.createSalesPriceAdjustment(this, context);
        } else {
            this.adjustComponentPrices(newPrice);
        }
    }

    @Transient
    public boolean isOpenPriceItem() {
        boolean found = false;
        Iterator<SalesComponent> iterator = this.getComponentList().iterator();
        while (iterator.hasNext() && !found) {
            SalesComponent currentComponent = iterator.next();
            found = currentComponent.isOpenPriceItem();
        }
        return found;
    }

    @Override
    @Transient
    public Price getUnadjustedPrice() {
        return new Price(this.getUnadjustedUnitPrice().multiply(this.getQuantity().getValue()), 0.0);
    }

    @Override
    @Transient
    public Price getBasePrice() {
        if (this.isPriceEdited()) {
            return this.getOpenPrice();
        }
        Price basePrice = Price.ZERO_NO_ROUND;
        for (SalesComponent comp : this.getComponentList()) {
            basePrice = basePrice.add(comp.getBasePrice());
        }
        return basePrice;
    }

    @Transient
    private Price getUnadjustedUnitPrice() {
        Price pricePerItem = Price.ZERO_NO_ROUND;
        for (SalesComponent currentComponent : this.getComponentList()) {
            pricePerItem = pricePerItem.add(currentComponent.getUnadjustedTotal());
        }
        return pricePerItem;
    }

    @Override
    @Transient
    public Price getItemLevelPricePerItem() {
        Price pricePerItem = new Price(0.0, 0.0);
        for (SalesComponent currentComponent : this.getComponentList()) {
            pricePerItem = pricePerItem.add(currentComponent.getItemLevelPrice());
        }
        return new Price(pricePerItem, 0.0);
    }

    @Override
    @Transient
    public Price getItemLevelPrice() {
        Price itemPrice = this.getItemLevelPricePerItem();
        double pricePerItem = itemPrice.doubleValue();
        return new Price(this.getQuantity().getValue().multiply(BigDecimal.valueOf(pricePerItem)), 1.0E-5);
    }

    @Override
    @Transient
    public Price getSubtotalPrice() {
        return SystemProperty.getInstance().isExTax() ? this.getItemLevelPrice() : this.getPrice();
    }

    @Override
    @Transient
    public Price getAccountDiscountTotal() {
        double total = 0.0;
        for (SalesComponent currentComponent : this.getComponentList()) {
            total += currentComponent.getAccountDiscountTotal().doubleValue();
        }
        return new Price(total, 1.0E-5);
    }

    @Override
    @Transient
    public Price getTax() {
        return this.getUnitTax().multiply(this.getQuantity().getValue());
    }

    @Override
    @Transient
    public Price getUnitTax() {
        BigDecimal tax = BigDecimal.ZERO;
        for (SalesComponent currentComponent : this.getComponentList()) {
            tax = tax.add(BigDecimal.valueOf(currentComponent.getTax().doubleValue()));
        }
        return new Price(tax, 0.0);
    }

    @Override
    @Transient
    public Price getUnadjustedTax() {
        BigDecimal tax = BigDecimal.ZERO;
        for (SalesComponent currentComponent : this.getComponentList()) {
            tax = tax.add(BigDecimal.valueOf(currentComponent.getUnadjustedTax().doubleValue()));
        }
        BigDecimal result = tax.multiply(this.getQuantity().getValue());
        return new Price(result, 0.0);
    }

    @Override
    @Transient
    public Price getIngredientCostExTax() {
        Price cost = new Price(0.0, 0.0);
        for (SalesComponent currentComponent : this.getComponentList()) {
            cost = cost.add(currentComponent.getIngredientCostExTax());
        }
        return cost;
    }

    @Override
    @Transient
    public int getLoyaltyPointsCost() {
        int points = 0;
        for (SalesComponent currentComponent : this.getComponentList()) {
            points += currentComponent.getMenuLoyaltyRedeem();
        }
        return (int)Math.ceil((double)points * this.getQuantity().getValue().doubleValue());
    }

    @Override
    @Transient
    public int getLoyaltyPointsEarned() {
        int points = 0;
        for (SalesComponent currentComponent : this.getComponentList()) {
            points += currentComponent.getMenuLoyaltyAdd();
        }
        return (int)Math.floor((double)points * this.getQuantity().getValue().doubleValue());
    }

    @Transient
    public InventoryItem getInventoryItemIfSingle() {
        return this.getFirstInventoryItem();
    }

    @Transient
    public Integer getFirstInventoryItemSequence() {
        if (this.getFirstInventoryItem() != null) {
            return this.getFirstInventoryItem().getSequence();
        }
        return null;
    }

    @Transient
    public InventoryItem getFirstInventoryItem() {
        List<SalesComponent> componentsList = this.getComponentList();
        if (componentsList.size() > 0) {
            return componentsList.get(0).getInventoryItem();
        }
        return null;
    }

    @Transient
    public double getTotalPortion() {
        double total = 0.0;
        for (SalesComponent currentComponent : this.getComponentList()) {
            total += currentComponent.getUnit().getPortion().getSize();
        }
        return total;
    }

    @Override
    public boolean isEquivalentTo(SalesLineItem item) {
        return this.isEquivalentTo(item, false, false);
    }

    private static boolean findIgnoreCombos() {
        if (ignoreCombosExp == null) {
            ExperimentalFeature f = ExperimentalFeature.find("Docket Grouping Ignore Combos All");
            ignoreCombosExp = f != null && f.getBooleanValue(false) != false;
        }
        return ignoreCombosExp;
    }

    public boolean isEquivalentTo(SalesLineItem item, boolean ignorePrice, boolean ignoreSeat, boolean ignoreZeroPricedOptions, boolean ignoreCombo) {
        if (SalesItem.findIgnoreCombos()) {
            return this.isEquivalentTo(item, true, true, ignoreZeroPricedOptions);
        }
        if (ignoreCombo) {
            return this.isEquivalentTo(item, ignorePrice, ignoreSeat, ignoreZeroPricedOptions);
        }
        if (item instanceof SalesItem) {
            SalesItem otherSalesItem = (SalesItem)item;
            if (this.isComboItem() && this.isEquivalentTo(otherSalesItem, ignorePrice, ignoreSeat)) {
                return this.getParentCombo().isEquivalentTo(otherSalesItem.getParentCombo(), ignorePrice, ignoreSeat, false, true);
            }
            if (!this.isComboItem() && otherSalesItem.isComboItem()) {
                return false;
            }
            return this.isEquivalentTo(otherSalesItem, ignorePrice, ignoreSeat, ignoreZeroPricedOptions);
        }
        return false;
    }

    public boolean isEquivalentTo(SalesLineItem item, boolean ignorePrice, boolean ignoreSeat, boolean ignoreZeroPricedOptions) {
        boolean equivalent;
        SalesComponent comp2;
        SalesComponent comp1;
        if (!(item instanceof SalesItem)) {
            return false;
        }
        SalesItem toCompare = (SalesItem)item;
        if (this == toCompare) {
            return true;
        }
        Iterator<SalesComponent> iterator1 = this.getComponentList().iterator();
        Iterator<SalesComponent> iterator2 = toCompare.getComponentList().iterator();
        for (equivalent = true; iterator1.hasNext() && iterator2.hasNext() && equivalent; equivalent &= comp1.isEquivalentTo(comp2, ignorePrice, ignoreZeroPricedOptions)) {
            comp1 = iterator1.next();
            comp2 = iterator2.next();
        }
        if (!equivalent) {
            return false;
        }
        if (!ignorePrice && !this.getPricePerItem().approximatelyEquals(toCompare.getPricePerItem())) {
            return false;
        }
        if (!ignoreSeat && this.getSeat() != toCompare.getSeat()) {
            return false;
        }
        if (this.getComponentList().size() != toCompare.getComponentList().size()) {
            return false;
        }
        if (this.getHoldTime() != toCompare.getHoldTime()) {
            return false;
        }
        if (!ignorePrice && (this.isOpenPriceItem() || this.isPriceEdited() || toCompare.isOpenPriceItem() || toCompare.isPriceEdited()) && !toCompare.getPricePerItem().equals(this.getPricePerItem())) {
            return false;
        }
        if (this.getNotes() != null && !this.getNotes().equals(toCompare.getNotes()) || toCompare.getNotes() != null && this.getNotes() == null) {
            return false;
        }
        if (!ignorePrice && (this.isPriceAdjusted() || toCompare.isPriceAdjusted()) && equivalent) {
            ArrayList<SalesPriceAdjustment> theAdjustments;
            Iterator<SalesPriceAdjustment> iterator;
            if (this.isPriceAdjusted()) {
                iterator = this.getPriceAdjustments().iterator();
                theAdjustments = new ArrayList<SalesPriceAdjustment>(toCompare.getPriceAdjustments());
            } else {
                iterator = toCompare.getPriceAdjustments().iterator();
                theAdjustments = new ArrayList<SalesPriceAdjustment>(this.getPriceAdjustments());
            }
            while (iterator.hasNext() && equivalent) {
                SalesPriceAdjustment current = iterator.next();
                boolean found = false;
                Iterator it = theAdjustments.iterator();
                while (it.hasNext() && !found) {
                    SalesPriceAdjustment other = (SalesPriceAdjustment)it.next();
                    if (!current.getValue().equals(other.getValue())) continue;
                    found = true;
                    theAdjustments.remove(other);
                }
                equivalent &= found;
            }
        }
        return equivalent;
    }

    @Override
    public boolean isEquivalentTo(SalesLineItem item, boolean ignorePrice, boolean ignoreSeat) {
        return this.isEquivalentTo(item, ignorePrice, ignoreSeat, false);
    }

    @Override
    public boolean isPrintableThrough(Terminal terminal, VirtualPrinter printer) {
        boolean printable = false;
        for (SalesComponent comp : this.getComponentList()) {
            printable = comp.getInventoryItem().isPrintableThrough(terminal, printer, this.getAccount());
        }
        return printable;
    }

    @Override
    @Transient
    public Account getAccount() {
        SalesCombo comboParent = this.getParentCombo();
        if (comboParent != null) {
            return comboParent.getAccount() != null ? comboParent.getAccount() : super.getAccount();
        }
        return super.getAccount();
    }

    @Override
    public Collection<VirtualPrinter> getDocketPrinters(Terminal forTerminal) {
        if (forTerminal == null) {
            throw new NullPointerException("The terminal is null, cannot get the docket printers for " + this);
        }
        if (this.getAccount() == null) {
            throw new IllegalStateException("Cannot call get docket printer on salesItem that has not been added to account.");
        }
        LinkedHashSet<VirtualPrinter> printers = new LinkedHashSet<VirtualPrinter>();
        for (SalesComponent comp : this.getComponentList()) {
            InventoryItem inventoryitem = comp.getInventoryItem();
            if (inventoryitem == null) {
                OrderMate.LOG.warn("the inventory item in the sale component:" + comp + " is null ");
                if (comp.getUnit() != null) {
                    inventoryitem = comp.getUnit().getItem();
                } else {
                    OrderMate.LOG.warn("the inventory item unit in the sale component:" + comp + " is null ");
                    continue;
                }
            }
            List<VirtualPrinter> printerList = inventoryitem.getPrinters(forTerminal, this.getAccount());
            for (VirtualPrinter printer : printerList) {
                printers.add(printer);
            }
        }
        return printers;
    }

    public static List<SalesItem> getItemsPrintableThrough(List items, int course, VirtualPrinter printer, Terminal terminal) {
        ArrayList<SalesItem> printableItems = new ArrayList<SalesItem>();
        for (SalesLineItem lineItem : items) {
            for (SalesItem item : lineItem.getSalesItems()) {
                if (course != -1 && item.getCourse() != course || !item.getDocketPrinters(terminal).contains(printer)) continue;
                printableItems.add(item);
            }
        }
        return printableItems;
    }

    public void useLinkedStock(SalesItemQuantity salesItemQty, User user, String reason, String usage, Terminal thisTerminal) {
        String theUsage = usage;
        if (usage.equals("WASTED") && !salesItemQty.isReversed()) {
            theUsage = "NORMAL";
        }
        for (SalesComponent comp : this.getComponentList()) {
            StockArea decrementArea = comp.getInventoryItem().getDecrementStockArea(thisTerminal);
            SalesQuantity qty = salesItemQty.getQuantity();
            if (theUsage.equals("WASTED")) {
                comp.useLinkedStock(qty.negate(), user, reason, "WASTED", decrementArea);
                comp.useLinkedStock(qty, user, reason, "NORMAL", decrementArea);
                continue;
            }
            comp.useLinkedStock(qty, user, reason, theUsage, decrementArea);
        }
    }

    public void decrementStockCount(SalesQuantity amount, EventContext context) {
        for (SalesComponent comp : this.getComponentList()) {
            comp.getUnit().decrementStockCount(amount, context);
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_combo")
    public SalesCombo getParentCombo() {
        return this.parentCombo != null ? this.parentCombo.get() : null;
    }

    public void setCombo(SalesCombo combo) {
        this.parentCombo.set(combo);
    }

    @Transient
    public boolean isComboItem() {
        return this.getParentCombo() != null;
    }

    @Override
    public void saveChild() {
        if (this.getAccount() == null && this.getParentCombo() == null) {
            throw new IllegalStateException("Cannot save an item that doesnt belong to either an account or a combo");
        }
        if (this.getComponentList().size() == 0) {
            throw new IllegalStateException("Cannot save sales item data is invalid.  Sales Item must have a sales component, but does not.  Sales Item ID : " + this.getID() + " in account " + (this.getAccount() != null ? this.getAccount().getID() : null));
        }
        super.saveChild();
        SalesQuantity unsavedQty = this.getUnsavedQuantity();
        SalesQuantity savedQty = SalesItemQuantity.getTotalQuantity(this.getSavedQuantities());
        if (this.component.get() != null) {
            if (Config.isDebuging() && (!this.components.contains(this.component.get()) || this.components.size() > 1)) {
                throw new IllegalStateException("Component list and component reference should be in sync");
            }
            this.components.clear();
            this.components.add(this.component.get());
        }
        for (SalesComponent currentComponent : this.getComponentList()) {
            StockArea decrementArea = null;
            if (StockControlProperty.getInstance().isStockControlEnabled()) {
                decrementArea = currentComponent.getInventoryItem().getDecrementStockArea(this.getOriginalTerminal());
            }
            SalesComponentSaveContext context = new SalesComponentSaveContext(decrementArea, savedQty, unsavedQty);
            currentComponent.prepareForSave(context);
            currentComponent.saveChild();
        }
        if (this.components.size() == 1) {
            this.component.set((SalesComponent)((PersistentObjectI)this.components.get(0)));
            PersistenceManager.saveChild(this);
        }
        this.saveDone();
    }

    @Override
    public void consumeStockIfLegal(SalesItemQuantity componentQty, User user, String reason, String usage, StockControlProperty props, Terminal thisTerminal) {
        if (props.isStockCountDownEnabled() && usage != null && !usage.equals("NONE") && !usage.equals("WASTED")) {
            EventContext context = new EventContext(thisTerminal, user);
            this.decrementStockCount(componentQty.getQuantity(), context);
        }
        if (props.isStockControlEnabled()) {
            this.useLinkedStock(componentQty, user, reason, usage, thisTerminal);
        }
    }

    @Override
    public boolean hasChildChanged() {
        return super.hasChildChanged() || this.components.hasChildChanged();
    }

    public List<SalesLineItem> splitItem(Terminal theTerminal, User theUser) {
        ArrayList<SalesLineItem> singleItems = new ArrayList<SalesLineItem>();
        singleItems.add(this);
        if (this.hasUnsavedQuantity() && !this.getSavedQuantities().isEmpty()) {
            return singleItems;
        }
        while (this.getQuantity().greaterThan(1L)) {
            singleItems.add(this.split(SalesQuantity.ONE, new EventContext(theTerminal, theUser)));
        }
        return singleItems;
    }

    @Override
    @Transient
    public boolean isSplittable() {
        InventoryComboGroup group;
        SalesQuantity minQty;
        if (this.getQuantity().greaterThan(1L)) {
            return true;
        }
        return this.getParentCombo() != null && (minQty = (group = this.getInventoryComboGroup()).getMinQuantity()).lessThan(1L);
    }

    public List<SalesItem> regroupItems(List<SalesItem> itemsToRegroup, Terminal terminal, User user) {
        if (!itemsToRegroup.contains(this)) {
            throw new IllegalStateException("This item was not found in the list");
        }
        if (itemsToRegroup.indexOf(this) != 0) {
            itemsToRegroup.remove(this);
            itemsToRegroup.add(0, this);
        }
        if (itemsToRegroup.size() == 1) {
            return itemsToRegroup;
        }
        ArrayList<SalesItem> regroupedItems = new ArrayList<SalesItem>();
        ArrayList<SalesItem> similarItems = new ArrayList<SalesItem>();
        Iterator<SalesItem> it = itemsToRegroup.iterator();
        while (it.hasNext()) {
            SalesItem item = it.next();
            it.remove();
            if (similarItems.contains(item)) continue;
            List<SalesItem> equivItems = item.getEquivalentItems(itemsToRegroup);
            for (SalesLineItem salesLineItem : equivItems) {
                if (salesLineItem.getQuantity().equals(0L)) continue;
                item.mergeQuantity(salesLineItem, new EventContext(terminal, user));
            }
            regroupedItems.add(item);
            similarItems.addAll(equivItems);
        }
        return regroupedItems;
    }

    @Override
    @Transient
    public Price getPrice() {
        return this.getPrice(this.getQuantity());
    }

    @Override
    @Transient
    public Price getPricePerItem() {
        return this.getPrice(SalesQuantity.ONE);
    }

    @Transient
    public Price getBasePriceWithoutSurcharges() {
        Price pricePerItem = Price.ZERO_NO_ROUND;
        for (SalesComponent currentComponent : this.getComponentList()) {
            pricePerItem = pricePerItem.add(currentComponent.getBasePriceWithoutSurcharges());
        }
        return pricePerItem;
    }

    @Transient
    public Price getPricePerItemUnadjusted() {
        return this.getUnadjustedUnitPrice();
    }

    @Override
    protected Price getPrice(SalesQuantity quantity) {
        Price price = new Price(0.0, 0.0);
        for (SalesComponent currentComponent : this.getComponentList()) {
            price = price.add(currentComponent.getPrice(quantity));
        }
        return new Price(price, 1.0E-5);
    }

    public void resetPrice() {
        Account account = this.getAccount();
        if (account != null && !account.isOpen()) {
            throw new IllegalStateException("Cannot reaquire the price on a closed account.");
        }
        for (SalesComponent comp : this.getComponentList()) {
            this.setComponentPriceLevel(comp, comp.getUnit().getUnitPriceLevel(comp.getPriceLevel()));
        }
        if (account != null) {
            account.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        }
    }

    @Override
    public SalesPriceAdjustment getPriceAdjustment(InventoryPriceAdjustment adj) {
        for (SalesPriceAdjustment salesAdj : this.getPriceAdjustments()) {
            if (!salesAdj.getInventoryPriceAdjustment().equals(adj)) continue;
            return salesAdj;
        }
        return null;
    }

    @Override
    public final boolean hasPriceAdjustment(InventoryPriceAdjustment adjustment) {
        return this.getPriceAdjustment(adjustment) != null;
    }

    protected void setParentCombo(SalesCombo newParentCombo) {
        this.parentCombo.set(newParentCombo);
    }

    protected void setComponents(List<SalesComponent> newComponents) {
        this.components = this.components.clone();
        this.components.set(newComponents);
    }

    protected void setComponent(SalesComponent newComponent) {
        this.component.set(newComponent);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_combo_group")
    public InventoryComboGroup getInventoryComboGroup() {
        return this.inventoryComboGroup.get();
    }

    public void setInventoryComboGroup(InventoryComboGroup toSet) {
        this.inventoryComboGroup.set(toSet);
    }

    @Override
    protected boolean hasSavedItems() {
        return this.isPersistent();
    }

    @Transient
    public boolean isBasePriceEnforced() {
        for (SalesComponent comp : this.getComponentList()) {
            if (!comp.isBasePriceEnforced()) continue;
            return true;
        }
        return false;
    }

    public static Comparator<SalesItem> getSortByPriceComparator() {
        return new Comparator<SalesItem>(){

            @Override
            public int compare(SalesItem o1, SalesItem o2) {
                return o1.getPrice().compareTo(o2.getPrice());
            }
        };
    }

    public static Comparator<SalesItem> getSortBySequenceComparator() {
        return new Comparator<SalesItem>(){

            @Override
            public int compare(SalesItem o1, SalesItem o2) {
                if (o1.getInventoryComboGroup() == null || o2.getInventoryComboGroup() == null || o1.getInventoryComboGroup().getSequence().equals(o2.getInventoryComboGroup().getSequence())) {
                    return o1.getLabel().compareTo(o2.getLabel());
                }
                return o1.getInventoryComboGroup().getSequence().compareTo(o2.getInventoryComboGroup().getSequence());
            }
        };
    }

    public static class Props
    extends SalesLineItem.Props {
        public PropertiedObject.Property<SalesComponent> COMPONENTS;
        public PropertiedObject.Property<SalesComponent> COMPONENT;
        public PropertiedObject.Property<InventoryComboGroup> INVENTORY_COMBO_GROUP;
        public PropertiedObject.Property<SalesCombo> PARENT_COMBO;
    }
}

