/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class SalesItemList
implements List<SalesItem> {
    private List<SalesItem> wrappedList = Collections.synchronizedList(new ArrayList());
    public static final SalesItemList EMPTY_LIST = new SalesItemList(){

        @Override
        public boolean add(SalesItem item) {
            throw new UnsupportedOperationException("Cannot add to empty list");
        }
    };

    public SalesItemList() {
    }

    public SalesItemList(List<? extends SalesItem> items) {
        this();
        this.addAll(items);
    }

    public Set getItemGroups() {
        HashSet<InventoryGroup> groupSet = new HashSet<InventoryGroup>();
        for (SalesItem currentItem : this) {
            List<SalesComponent> components = currentItem.getComponentList();
            for (SalesComponent currentComponent : components) {
                InventoryGroup group = currentComponent.getInventoryItem().getMenuGroup();
                groupSet.add(group);
                for (group = group.getParentGroup(); group != null; group = group.getParentGroup()) {
                    groupSet.add(group);
                }
            }
        }
        return groupSet;
    }

    public List<InventoryItemUnit> getItemUnits() {
        ArrayList<InventoryItemUnit> units = new ArrayList<InventoryItemUnit>();
        for (SalesItem currentItem : this) {
            List<SalesComponent> components = currentItem.getComponentList();
            for (SalesComponent currentComponent : components) {
                InventoryItemUnit unit = currentComponent.getUnit();
                units.add(unit);
            }
        }
        return units;
    }

    @Override
    public boolean addAll(Collection salesLineItems) {
        if (salesLineItems == null) {
            return false;
        }
        boolean listChanged = false;
        for (SalesLineItem item : salesLineItems) {
            if (!(item instanceof SalesItem)) continue;
            listChanged = true;
            this.add((SalesItem)item);
        }
        return listChanged;
    }

    @Override
    public boolean addAll(int i, Collection c) {
        throw new UnsupportedOperationException("optional method addAll(int index, Collect c) not implemented in SalesItemList");
    }

    public void copyList(List copyList, EventContext context) {
        this.clear();
        for (SalesLineItem currentItem : copyList) {
            if (!(currentItem instanceof SalesItem)) continue;
            SalesItem currentSalesItem = (SalesItem)currentItem;
            this.add((SalesItem)currentSalesItem.copy(context, true));
        }
    }

    public boolean subtractItem(SalesItem itemToSubtract, Terminal term, User user) {
        SalesLineItem currentItem;
        Iterator<SalesItem> itemIt = this.iterator();
        SalesQuantity quantity = SalesQuantity.ZERO;
        while (!(!itemIt.hasNext() || (currentItem = (SalesLineItem)itemIt.next()).isEquivalentTo(itemToSubtract, true, false) && (quantity = quantity.add(currentItem.getQuantity())).greaterThanOrEquals(itemToSubtract.getQuantity()))) {
        }
        if (quantity.greaterThanOrEquals(itemToSubtract.getQuantity())) {
            SalesQuantity quantityRemaining = itemToSubtract.getQuantity();
            itemIt = this.iterator();
            while (itemIt.hasNext() && quantityRemaining.greaterThan(0L)) {
                SalesLineItem currentItem2 = itemIt.next();
                if (!currentItem2.isEquivalentTo(itemToSubtract, true, false)) continue;
                if (currentItem2.getQuantity().lessThanOrEquals(quantityRemaining)) {
                    quantityRemaining = quantityRemaining.subtract(currentItem2.getQuantity());
                    this.remove(currentItem2);
                    continue;
                }
                currentItem2.setQuantity(currentItem2.getQuantity().subtract(quantityRemaining), new EventContext(term, user));
                break;
            }
            return true;
        }
        return false;
    }

    public SalesQuantity getEquivalentItemQuantity(SalesItem item) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesItem currentItem : this) {
            if (!currentItem.isEquivalentTo(item)) continue;
            quantity = quantity.add(currentItem.getQuantity());
        }
        return quantity;
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedList.contains(o);
    }

    @Override
    public Iterator<SalesItem> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrappedList.toArray(a);
    }

    @Override
    public boolean add(SalesItem e) {
        return this.wrappedList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedList.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrappedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrappedList.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrappedList.clear();
    }

    @Override
    public SalesItem get(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public SalesItem set(int index, SalesItem element) {
        return this.wrappedList.set(index, element);
    }

    @Override
    public void add(int index, SalesItem element) {
        this.wrappedList.add(index, element);
    }

    @Override
    public SalesItem remove(int index) {
        return this.wrappedList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.wrappedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<SalesItem> listIterator() {
        return this.wrappedList.listIterator();
    }

    @Override
    public ListIterator<SalesItem> listIterator(int index) {
        return this.wrappedList.listIterator(index);
    }

    @Override
    public List<SalesItem> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }
}

