/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_item_quantity")
@AccessType(value="property")
public class SalesItemQuantity
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    public static final String ITEM_ACTIVE = "ACTIVE";
    public static final String ITEM_DELETED = "DELETED";
    public static final String ITEM_DELETED_WASTED = "DELETED_WASTED";
    public static final String ITEM_MOVED = "MOVED";
    public static final String ITEM_REFUNDED = "REFUNDED";
    public static final String ITEM_REFUNDED_WASTED = "REFUNDED_WASTED";
    public static final String[] ALL_STATES = new String[]{"ACTIVE", "DELETED", "DELETED_WASTED", "MOVED", "REFUNDED", "REFUNDED_WASTED"};
    private static final Set<String> ALL_REVERSAL_STATES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("DELETED", "DELETED_WASTED", "REFUNDED", "REFUNDED_WASTED")));
    public static final String NOT_PRINTED = "NOT_PRINTED";
    public static final String PRINTED = "PRINTED";
    private SalesQuantity quantity = SalesQuantity.ZERO;
    private String itemState;
    private String printState;
    private Date creationTime;
    private Reference<SalesLineItem> salesLineItem;
    private Reference<User> user;
    private Reference<Terminal> terminal;
    private Reference<TradingDay> tradingDay;
    private Reference<Shift> shift;
    private Date localCreationTime = new Date();
    private Reference<TerminalLocation> location;
    private Reference<SalesLocation> salesLocation;

    public SalesItemQuantity() {
        this.salesLineItem = this.createReference(SalesItemQuantity.Properties.SALES_LINE_ITEM);
        this.user = this.createReference(SalesItemQuantity.Properties.USER);
        this.terminal = this.createReference(SalesItemQuantity.Properties.TERMINAL);
        this.tradingDay = this.createReference(SalesItemQuantity.Properties.TRADING_DAY);
        this.shift = this.createReference(SalesItemQuantity.Properties.SHIFT);
        this.location = this.createReference(SalesItemQuantity.Properties.LOCATION);
        this.salesLocation = this.createReference(SalesItemQuantity.Properties.SALES_LOCATION);
    }

    public SalesItemQuantity(SalesQuantity qty, String newItemState, String thePrintState, SalesLineItem item, EventContext context) {
        this();
        Terminal theTerminal = context.getTerminal();
        this.setTerminal(theTerminal);
        this.quantity = qty;
        this.printState = thePrintState;
        this.changeItemState(newItemState);
        this.setSalesLineItem(item);
        this.setUser(context.getUser());
        this.tradingDay.set(TradingDay.getCurrentTradingDay());
        this.shift.set(theTerminal.getShift());
        this.setLocation(theTerminal.getLocation());
        this.setSalesLocation(theTerminal.getSalesLocation());
    }

    SalesItemQuantity(SalesQuantity qty, SalesItemQuantity original, SalesLineItem targetSaleItem) {
        this();
        this.quantity = qty;
        original.quantity = original.quantity.subtract(qty);
        this.changeItemState(original.getItemState());
        this.printState = original.printState;
        this.creationTime = original.creationTime;
        this.setSalesLineItem(targetSaleItem);
        this.setUser(original.getUser());
        this.setTerminal(original.getTerminal());
        this.setLocation(original.getLocation());
        this.setSalesLocation(original.getSalesLocation());
        this.tradingDay.set(original.tradingDay.get());
        this.shift.set(original.shift.get());
    }

    @Override
    public void saveChild() {
        if (!this.isPersistent()) {
            this.localCreationTime = new Date();
        }
        PersistenceManager.saveChild(this);
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationTime() {
        return this.creationTime != null ? this.creationTime : this.localCreationTime;
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void deleteChild() {
    }

    public void markAsPrinted() {
        if (this.getPrintState().equals(NOT_PRINTED)) {
            this.printState = PRINTED;
        }
    }

    public void markAsNotPrinted() {
        this.printState = NOT_PRINTED;
    }

    @AttributeOverride(column=@Column(name="quantity", precision=20, scale=8), name="number")
    public SalesQuantity getQuantity() {
        return this.quantity != null ? this.quantity : SalesQuantity.ZERO;
    }

    @Override
    public String toString() {
        return this.getQuantity().toString();
    }

    @Column(name="item_state")
    public String getItemState() {
        return this.itemState;
    }

    void changeItemState(String newState) {
        SalesItemQuantity.isValidItemState(newState);
        if (SystemProperty.getInstance().isNeverPrintTransferred() && newState.equals(ITEM_MOVED)) {
            this.markAsPrinted();
        } else if (SystemProperty.getInstance().isNeverPrintDeleted() && ALL_REVERSAL_STATES.contains(newState)) {
            this.markAsPrinted();
        }
        this.itemState = newState;
    }

    protected void setItemState(String state) {
        this.itemState = state;
    }

    protected static void isValidItemState(String newState) {
        boolean foundIt = false;
        for (int i = 0; i < ALL_STATES.length && !foundIt; ++i) {
            foundIt = newState.equals(ALL_STATES[i]);
        }
        if (!foundIt) {
            throw new IllegalArgumentException(newState + " is not a valid state");
        }
    }

    @Transient
    public boolean isRefunded() {
        return this.getItemState().equals(ITEM_REFUNDED) || this.getItemState().equals(ITEM_REFUNDED_WASTED);
    }

    @Transient
    public boolean isReversed() {
        return ALL_REVERSAL_STATES.contains(this.getItemState());
    }

    @Column(name="print_state")
    public String getPrintState() {
        return this.printState;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_sales_item")
    public SalesLineItem getSalesLineItem() {
        return this.salesLineItem.get();
    }

    protected void setSalesLineItem(SalesLineItem item) {
        this.salesLineItem.set(item);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    private void setUser(User theUser) {
        this.user.set(theUser);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    private void setTerminal(Terminal theTerminal) {
        this.terminal.set(theTerminal);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getLocation() {
        if (this.location.get() == null) {
            if (this.getTerminal() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getTerminal().getLocation());
            }
        }
        return this.location.get();
    }

    public void setLocation(TerminalLocation value) {
        if (value == null) {
            if (this.getTerminal() == null) {
                this.location.set(TerminalLocation.getDefaultLocation());
            } else {
                this.location.set(this.getTerminal().getLocation());
            }
        } else {
            this.location.set(value);
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_config_sales_location")
    public SalesLocation getSalesLocation() {
        if (this.salesLocation.get() == null) {
            if (this.getTerminal() == null) {
                this.salesLocation.set(SalesLocation.getDefaultSalesLocation());
            } else {
                this.salesLocation.set(this.getTerminal().getSalesLocation());
            }
        }
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation value) {
        if (value == null) {
            if (this.getTerminal() == null) {
                this.salesLocation.set(SalesLocation.getDefaultSalesLocation());
            } else {
                this.salesLocation.set(this.getTerminal().getSalesLocation());
            }
        } else {
            this.salesLocation.set(value);
        }
    }

    static SalesQuantity getTotalQuantity(List<SalesItemQuantity> quantities) {
        SalesQuantity total = SalesQuantity.ZERO;
        for (SalesItemQuantity siq : quantities) {
            total = total.add(siq.getQuantity());
        }
        return total;
    }

    static List<SalesItemQuantity> getMatchingQuantities(List<SalesItemQuantity> quantities, QuantityComparator[] comparators) {
        ArrayList<SalesItemQuantity> matches = null;
        List<SalesItemQuantity> source = quantities;
        for (int i = 0; i < comparators.length; ++i) {
            matches = new ArrayList<SalesItemQuantity>();
            for (SalesItemQuantity siq : source) {
                if (!comparators[i].compare(siq)) continue;
                matches.add(siq);
            }
            source = matches;
            if (source.isEmpty()) break;
        }
        return matches;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    protected void setShift(Shift theShift) {
        this.shift.set(theShift);
    }

    protected void setCreationTime(Date time) {
        this.creationTime = time;
    }

    protected void setTradingDay(TradingDay day) {
        this.tradingDay.set(day);
    }

    protected void setQuantity(SalesQuantity qty) {
        this.quantity = qty;
    }

    protected void setPrintState(String state) {
        this.printState = state;
    }

    static class PersistentQuantityComparator
    implements QuantityComparator {
        private boolean persistent;

        public PersistentQuantityComparator(boolean isPersistent) {
            this.persistent = isPersistent;
        }

        @Override
        public boolean compare(SalesItemQuantity siq) {
            return siq.isPersistent() == this.persistent;
        }
    }

    static class StateQuantityComparator
    implements QuantityComparator {
        private String itemState;

        public StateQuantityComparator(String state) {
            SalesItemQuantity.isValidItemState(state);
            this.itemState = state;
        }

        @Override
        public boolean compare(SalesItemQuantity siq) {
            return siq.getItemState().equals(this.itemState);
        }
    }

    static class PrintQuantityComparator
    implements QuantityComparator {
        private String printState;
        private boolean persistent;

        public PrintQuantityComparator(boolean printed, boolean isPersistent) {
            this.printState = printed ? SalesItemQuantity.PRINTED : SalesItemQuantity.NOT_PRINTED;
            this.persistent = isPersistent;
        }

        @Override
        public boolean compare(SalesItemQuantity siq) {
            return siq.isPersistent() == this.persistent && siq.getPrintState().equals(this.printState);
        }
    }

    static interface QuantityComparator {
        public boolean compare(SalesItemQuantity var1);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SalesQuantity> QUANTITY;
        public PropertiedObject.Property<String> ITEM_STATE;
        public PropertiedObject.Property<String> PRINT_STATE;
        public PropertiedObject.Property<SalesLineItem> SALES_LINE_ITEM;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<TerminalLocation> LOCATION;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
    }
}

