/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.internationalization.Internationalization;

public class SalesItemSummary
implements Serializable,
PropertiedObject {
    public static final Props Properties = new Props();
    private Set<Integer> seatNumbers = new HashSet<Integer>();
    private List<SalesItem> salesItems = new ArrayList<SalesItem>();
    private InventoryWeightUnit weightUnit = InventoryWeightUnit.NA;
    private boolean sortingItemName = false;
    private transient Integer lowestSeat;
    private boolean showComboName = true;

    @Deprecated
    public SalesItemSummary() {
    }

    protected SalesItemSummary(SalesItemSummary summary) {
        this.seatNumbers.addAll(summary.seatNumbers);
        this.salesItems.addAll(summary.salesItems);
        this.weightUnit = summary.weightUnit;
        this.sortingItemName = summary.sortingItemName;
        this.lowestSeat = summary.lowestSeat;
        this.showComboName = summary.showComboName;
    }

    public SalesItem getSalesItem() {
        return this.salesItems.get(0);
    }

    public List<SalesItem> getSalesItems() {
        return Collections.unmodifiableList(this.salesItems);
    }

    public Set<SalesCombo> getUniqueCombos() {
        HashSet<SalesCombo> combos = new HashSet<SalesCombo>();
        for (SalesItem item : this.salesItems) {
            if (!item.isComboItem()) continue;
            combos.add(item.getParentCombo());
        }
        return combos;
    }

    public SalesQuantity getTotalQuantity() {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : this.salesItems) {
            quantity = quantity.add(salesLineItem.getQuantity());
        }
        return quantity;
    }

    public SalesQuantity getTotalQuantity(String itemState) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : this.salesItems) {
            quantity = quantity.add(salesLineItem.getQuantity(itemState));
        }
        return quantity;
    }

    public SalesQuantity getTotalCommittedQuantity(boolean printed, String itemState, int seat) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesItem item : this.salesItems) {
            if (item.getSeat() != seat) continue;
            quantity = quantity.add(item.getSavedQuantity(printed, itemState));
        }
        return quantity;
    }

    public SalesQuantity getTotalCommittedQuantity(boolean printed, String itemState) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesItem item : this.salesItems) {
            quantity = quantity.add(item.getSavedQuantity(printed, itemState));
        }
        return quantity;
    }

    public SalesQuantity getTotalCommittedQuantity(String itemState) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : this.salesItems) {
            quantity = quantity.add(salesLineItem.getSavedQuantity(itemState));
        }
        return quantity;
    }

    public Price getTotalPrice() {
        SalesItem item = this.salesItems.get(0);
        Price total = new Price(this.getSalesItemPrice(item).multiply(this.getTotalQuantity()), 0.01);
        return total;
    }

    public Price getTotalPriceForReceipt() {
        SalesItem item = this.salesItems.get(0);
        Price total = new Price(this.getSalesItemPrice(item).multiply(this.getTotalQuantity()), 0.01);
        if ("1".equals(ReportProperty.find(ReportGroup.General, "Items in Receipt Docket show default price").getValue())) {
            total = new Price(item.getUnadjustedPrice().multiply(this.getTotalQuantity()), 0.01);
        }
        return total;
    }

    public Price getSalesItemPrice(SalesItem item) {
        return item.getItemLevelPricePerItem();
    }

    public Set<Integer> getSeatNumbers() {
        return this.seatNumbers;
    }

    public Map<Integer, Integer> getSeatNumbersWithCount(boolean printed, String state) {
        HashMap<Integer, Integer> seatNumsToCount = new HashMap<Integer, Integer>();
        for (Integer seatNum : this.seatNumbers) {
            seatNumsToCount.put(seatNum, new Integer(this.getTotalCommittedQuantity(printed, state, seatNum).getValue().intValue()));
        }
        return seatNumsToCount;
    }

    public String getSeatNumbersAsString() {
        return this.getSeatNumbersAsString(false, true, null);
    }

    public String getSeatNumbersAsString(boolean printed, String state) {
        return this.getSeatNumbersAsString(true, printed, state);
    }

    public String getSeatNumbersAsString(boolean incQty, boolean printed, String state) {
        return this.getSeatNumbersAsString(incQty, incQty, printed, state);
    }

    public String getSeatNumbersAsString(boolean incQty, boolean incOnlyMultipleSeats, boolean printed, String state) {
        if (!incQty && incOnlyMultipleSeats) {
            throw new IllegalArgumentException("invOnlyMultipleSeats cannot be true unless incQty is true");
        }
        StringBuffer seatString = new StringBuffer();
        if (this.seatNumbers.size() > 1) {
            seatString.append(Internationalization.getLiteralFor("COVERS") + " (");
        } else {
            seatString.append(Internationalization.getLiteralFor("COVER") + " (");
        }
        Iterator<Integer> seatIterator = this.seatNumbers.iterator();
        while (seatIterator.hasNext()) {
            Integer seatNumber = seatIterator.next();
            boolean existsForThisSeat = state == null || this.getTotalCommittedQuantity(printed, state, seatNumber).greaterThan(0L);
            if (!existsForThisSeat) continue;
            if (seatNumber == 0) {
                seatString.append("ALL");
            } else {
                seatString.append(seatNumber);
            }
            SalesQuantity totalCommitedQuantity = this.getTotalCommittedQuantity(printed, state, seatNumber);
            if (incQty && (incOnlyMultipleSeats && totalCommitedQuantity.greaterThan(1L) || !incOnlyMultipleSeats)) {
                seatString.append("x");
                seatString.append(totalCommitedQuantity);
            }
            if (!seatIterator.hasNext()) continue;
            seatString.append(',');
        }
        seatString.append(')');
        return seatString.toString();
    }

    public boolean hasDiscount() {
        SalesItem item = this.salesItems.get(0);
        for (SalesPriceAdjustment adj : item.getDiscounts()) {
            if (!adj.getType().isDisplayOnReceipt()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSurcharge() {
        SalesItem item = this.salesItems.get(0);
        for (SalesPriceAdjustment adj : item.getSurcharges()) {
            if (!adj.getType().isDisplayOnReceipt()) continue;
            return true;
        }
        return false;
    }

    public List getDiscounts() {
        SalesItem item = this.salesItems.get(0);
        return item.getDiscounts();
    }

    public List<SalesPriceAdjustment> getAdjustments() {
        SalesItem item = this.salesItems.get(0);
        return new ArrayList<SalesPriceAdjustment>(item.getPriceAdjustments());
    }

    public String getDiscountsAsString() {
        SalesItem item = this.salesItems.get(0);
        return item.getDiscountsAsString();
    }

    public String getSurchargesAsString() {
        SalesItem item = this.salesItems.get(0);
        return item.getSurchargesAsString();
    }

    public InventoryCategory getCategory() {
        SalesItem item = this.getSalesItem();
        return item.getComponents().get(0).getInventoryItem().getCategory();
    }

    public boolean showOnReceipt() {
        SalesItem item = this.salesItems.get(0);
        if (item.getComponentList().size() == 1) {
            boolean zeroPrice;
            SalesComponent component = item.getComponentList().get(0);
            boolean bl = zeroPrice = component.getBasePrice().equals(Price.ZERO_DOLLAR) && !component.isOpenPriceItem() && component.getPrice().equals(Price.ZERO_DOLLAR);
            if (SystemProperty.getInstance().isPrintZeroDollarItems()) {
                zeroPrice = false;
            }
            return this.hasDiscount() || component.isPriceEdited() || !zeroPrice;
        }
        return true;
    }

    public String toString() {
        SalesItem item = this.salesItems.get(0);
        return this.getTotalQuantity() + " " + item.getLabel();
    }

    public String getLabel() {
        SalesItem item = this.salesItems.get(0);
        List<SalesComponent> components = item.getComponentList();
        if (components != null && !components.isEmpty()) {
            SalesComponent component = item.getComponentList().get(0);
            if (components.size() == 1) {
                StringBuilder label = new StringBuilder();
                label.append(component.getUnit().getSize().getShortName());
                label.append(" ");
                String name = component.getInventoryItem().getShortName();
                if (name == null || name.equals("")) {
                    name = component.getInventoryItem().getLabel();
                }
                label.append(name);
                if (component.getSalesItem() == null) {
                    OrderMate.LOG.warn("The component has a null SalesItem " + component);
                }
                return label.toString();
            }
            return component.getUnit().getSize().getShortName() + " " + component.getUnit().getPortionLabel() + " " + component.getInventoryItem().getMenuGroup().getLabel();
        }
        return item.getShortName();
    }

    public String getComboID() {
        SalesComponent component;
        SalesItem salesItem;
        SalesItem item = this.salesItems.get(0);
        List<SalesComponent> components = item.getComponentList();
        if (components != null && !components.isEmpty() && (salesItem = (component = item.getComponentList().get(0)).getSalesItem()).isComboItem()) {
            SalesCombo parentCombo = salesItem.getParentCombo();
            return this.sortingItemName ? parentCombo.getCombo().getShortName() : parentCombo.getShortName();
        }
        return "";
    }

    public String getNotes() {
        return this.salesItems.get(0).getNotes();
    }

    public InventoryWeightUnit getInventoryWeightUnit() {
        return this.weightUnit;
    }

    boolean absorbSalesItem(SalesItem equivalentItem, boolean ignoreZeroPricedOptions, boolean ignorePrice, boolean ignoreCombos, boolean ignoreSeats) {
        boolean absorbed = false;
        if (this.salesItems.isEmpty()) {
            this.salesItems.add(equivalentItem);
            this.seatNumbers.add(equivalentItem.getSeat());
            InventoryItem item = equivalentItem.getInventoryItemIfSingle();
            if (item != null) {
                this.weightUnit = item.getInventoryWeightUnit();
            }
            absorbed = true;
        } else {
            SalesItem initialItem = this.salesItems.get(0);
            if (initialItem.isEquivalentTo(equivalentItem, ignorePrice, ignoreSeats, ignoreZeroPricedOptions, ignoreCombos) && InventoryWeightUnit.NA.equals((Object)this.weightUnit) && (SalesQuantity.ZERO.equals(equivalentItem.getQuantity()) || this.checkIsInteger(initialItem) && this.checkIsInteger(equivalentItem) || initialItem.getQuantity().equals(equivalentItem.getQuantity()) || ExperimentalFeatureHelper.isComboDecimalEnabled())) {
                this.salesItems.add(equivalentItem);
                this.seatNumbers.add(equivalentItem.getSeat());
                absorbed = true;
            }
        }
        return absorbed;
    }

    public boolean absorbSalesItem(SalesItem equivalentItem) {
        return this.absorbSalesItem(equivalentItem, false, false, false, false);
    }

    private boolean checkIsInteger(SalesItem initialItem) {
        return MathsUtils.checkIsInteger(initialItem.getQuantity().getValue().doubleValue());
    }

    public void setSortingItemName(boolean newSortingItemName) {
        this.sortingItemName = newSortingItemName;
    }

    public List getRefunds() {
        return null;
    }

    public boolean hasItemLevelDiscount() {
        SalesItem item = null;
        if (this.salesItems.isEmpty()) {
            return false;
        }
        item = this.salesItems.get(0);
        return !item.getPriceAdjustmentsNotIncludingPriceLevelAdjs().isEmpty();
    }

    public boolean hasPriceLevelDiscount() {
        SalesItem item = null;
        if (this.salesItems.isEmpty()) {
            return false;
        }
        item = this.salesItems.get(0);
        for (SalesPriceAdjustment adj : item.getDiscounts()) {
            if (!(adj.getType() instanceof PriceAdjustmentType.PriceLevelAdjustmentType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPriceLevelSurcharge() {
        SalesItem item = null;
        if (this.salesItems.isEmpty()) {
            return false;
        }
        item = this.salesItems.get(0);
        for (SalesPriceAdjustment adj : item.getSurcharges()) {
            if (!(adj.getType() instanceof PriceAdjustmentType.PriceLevelAdjustmentType)) continue;
            return true;
        }
        return false;
    }

    public String getItemLevelDiscountAsString() {
        SalesItem item = null;
        if (this.salesItems.isEmpty()) {
            return Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00";
        }
        item = this.salesItems.get(0);
        ArrayList<SalesPriceAdjustment> adjs = new ArrayList<SalesPriceAdjustment>(item.getPriceAdjustmentsNotIncludingPriceLevelAdjs());
        StringBuilder SB = new StringBuilder();
        for (SalesPriceAdjustment adj : adjs) {
            if (PriceAdjustmentType.OPEN_PRICE.equals(adj.getType())) {
                SB.append(adj.getValue().negate().toString(true));
            } else if (PriceAdjustmentUnit.PERCENTAGE_UNIT.equals(adj.getUnit())) {
                SB.append(adj.getLabel()).append(" ").append(adj.getValue().negate().toString(true));
            } else {
                SB.append(adj.getLabel());
            }
            if (adjs.indexOf(adj) == adjs.size() - 1) continue;
            SB.append(", ");
        }
        return SB.toString();
    }

    public String getPriceLevelDiscountAsString() {
        SalesItem item = null;
        if (this.salesItems.isEmpty()) {
            return Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00";
        }
        item = this.salesItems.get(0);
        Price runningTotal = new Price(Price.ZERO_DOLLAR, 0.01);
        for (SalesPriceAdjustment adj : item.getDiscounts()) {
            if (!(adj.getType() instanceof PriceAdjustmentType.PriceLevelAdjustmentType)) continue;
            runningTotal = runningTotal.add(adj.getValue());
        }
        String toReturn = "";
        SalesPriceAdjustment priceLevelAdj = item.getPriceLevelAdjustment();
        if (priceLevelAdj != null) {
            toReturn = priceLevelAdj.getLabel().concat(":");
        }
        toReturn = toReturn.concat(runningTotal.negate().toString(true));
        return toReturn;
    }

    public String getPriceLevelSurchargeAsString() {
        SalesItem item = null;
        if (this.salesItems.isEmpty()) {
            return Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00";
        }
        item = this.salesItems.get(0);
        Price runningTotal = new Price(Price.ZERO_DOLLAR, 0.01);
        for (SalesPriceAdjustment adj : item.getSurcharges()) {
            if (!(adj.getType() instanceof PriceAdjustmentType.PriceLevelAdjustmentType)) continue;
            runningTotal = runningTotal.add(adj.getValue());
        }
        String toReturn = "";
        SalesPriceAdjustment priceLevelAdj = item.getPriceLevelAdjustment();
        if (priceLevelAdj != null) {
            toReturn = priceLevelAdj.getLabel().concat(":");
        }
        toReturn = toReturn.concat(runningTotal.abs().toString(true));
        return toReturn;
    }

    public Integer getLowestSeat() {
        if (this.lowestSeat == null) {
            for (Integer nextSeat : this.seatNumbers) {
                if (this.lowestSeat != null && this.lowestSeat <= nextSeat) continue;
                this.lowestSeat = nextSeat;
            }
        }
        return this.lowestSeat;
    }

    public int getSeatCount() {
        return this.seatNumbers.size();
    }

    public boolean getShowComboName() {
        return this.showComboName;
    }

    public void setShowComboName(boolean showComboName) {
        this.showComboName = showComboName;
    }

    protected void setSeatNumbers(Set<Integer> seatNumbers) {
        this.seatNumbers = seatNumbers;
    }

    protected void setSalesItems(List<SalesItem> salesItems) {
        this.salesItems = salesItems;
    }

    protected InventoryWeightUnit getWeightUnit() {
        return this.weightUnit;
    }

    protected void setWeightUnit(InventoryWeightUnit weightUnit) {
        this.weightUnit = weightUnit;
    }

    protected boolean isSortingItemName() {
        return this.sortingItemName;
    }

    protected void setLowestSeat(Integer lowestSeat) {
        this.lowestSeat = lowestSeat;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<Integer> SEAT_NUMBERS;
        public PropertiedObject.Property<SalesItem> SALES_ITEMS;
        public PropertiedObject.Property<InventoryWeightUnit> WEIGHT_UNIT;
        public PropertiedObject.Property<Boolean> SORTING_ITEM_NAME;
        public PropertiedObject.Property<Boolean> SHOW_COMBO_NAME;
    }
}

