/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.printSummary.collecting.ByCategorySalesItemSummaryCollectionStrategy;
import ordermate.database.sales.printSummary.sorting.SortingStrategyVendor;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;

public class SalesItemSummaryCreator {
    private SummarySortingStrategy sortingStrategy;
    private boolean groupByCategory = false;
    private boolean ignoreZeroPricedOptions = false;
    private boolean ignorePrice = false;
    private boolean ignoreCombos = false;
    private boolean ignoreSeats = true;

    public SalesItemSummaryCreator() {
        this(null);
    }

    public SalesItemSummaryCreator(SummarySortingStrategy yourSortingStrategy) {
        this.sortingStrategy = yourSortingStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public List<SalesItemSummary> getSummaries(List<? extends SalesLineItem> items) {
        ArrayList<SalesItemSummary> itemSummaries = new ArrayList<SalesItemSummary>();
        for (SalesLineItem salesLineItem : items) {
            for (SalesItem item : salesLineItem.getSalesItems()) {
                SalesItemSummary summary;
                boolean absorbed = false;
                for (int j = 0; j < itemSummaries.size() && !absorbed && !(absorbed = (summary = (SalesItemSummary)itemSummaries.get(j)).absorbSalesItem(item, this.ignoreZeroPricedOptions, this.ignorePrice, this.ignoreCombos, this.ignoreSeats)); ++j) {
                }
                if (absorbed) continue;
                SalesItemSummary newSummary = new SalesItemSummary();
                newSummary.absorbSalesItem(item);
                itemSummaries.add(newSummary);
            }
        }
        if (this.groupByCategory) {
            ByCategorySalesItemSummaryCollectionStrategy mainStrategy = new ByCategorySalesItemSummaryCollectionStrategy();
            mainStrategy.makeCollections(itemSummaries);
            if (!mainStrategy.getCollections().isEmpty()) {
                void var4_6;
                itemSummaries.clear();
                boolean bl = false;
                while (var4_6 < mainStrategy.getCollections().size()) {
                    if (!mainStrategy.getCollections().get((int)var4_6).getSummaries().isEmpty()) {
                        itemSummaries.addAll(mainStrategy.getCollections().get((int)var4_6).getSummaries());
                    }
                    ++var4_6;
                }
            }
        }
        if (this.sortingStrategy != null) {
            Comparator<SalesItemSummary> comparator = new Comparator<SalesItemSummary>(){

                @Override
                public int compare(SalesItemSummary o1, SalesItemSummary o2) {
                    return SalesItemSummaryCreator.this.sortingStrategy.compare(o1.getSalesItem(), o2.getSalesItem());
                }
            };
            Collections.sort(itemSummaries, comparator);
        }
        return itemSummaries;
    }

    public SalesItemSummaryCreator ignoreZeroPricedOptions() {
        this.ignoreZeroPricedOptions = true;
        return this;
    }

    public SalesItemSummaryCreator ignoreCombos() {
        this.ignoreCombos = true;
        return this;
    }

    public SalesItemSummaryCreator groupByCategory() {
        this.groupByCategory = true;
        return this;
    }

    public SalesItemSummaryCreator ignorePrice() {
        this.ignorePrice = true;
        return this;
    }

    public SalesItemSummaryCreator dontIgnoreSeat() {
        this.ignoreSeats = false;
        return this;
    }

    public static SalesItemSummaryCreator createDefaultInstance() {
        return new SalesItemSummaryCreator(SortingStrategyVendor.getDefaultSortingStrategy());
    }
}

