/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.printSummary.PropertySummaryGroupingStrategy;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;

public class SalesItemSummaryCreatorNew {
    private PropertySummaryGroupingStrategy grouping;
    private SummarySortingStrategy sorting;

    public SalesItemSummaryCreatorNew(PropertySummaryGroupingStrategy grouping, SummarySortingStrategy sortingStrategy) {
        this.grouping = grouping;
        this.sorting = sortingStrategy;
    }

    public List<SalesItemSummary> getSummaries(List<SalesLineItem> lineItems) {
        LinkedHashMap<Object, SalesItemSummary> summaryMap = new LinkedHashMap<Object, SalesItemSummary>();
        for (SalesLineItem lineItem : lineItems) {
            for (SalesItem item : lineItem.getSalesItems()) {
                SalesItemSummary summary;
                Object id = this.findIdentifier(item);
                if (!summaryMap.containsKey(id)) {
                    summary = new SalesItemSummary();
                    summary.absorbSalesItem(item);
                    summaryMap.put(id, summary);
                    continue;
                }
                if (((SalesItemSummary)summaryMap.get(id)).absorbSalesItem(item)) continue;
                summary = new SalesItemSummary();
                summary.absorbSalesItem(item);
                summaryMap.put("" + id + summary.hashCode(), summary);
            }
        }
        ArrayList<SalesItemSummary> summaries = new ArrayList<SalesItemSummary>(summaryMap.values());
        if (this.sorting != null) {
            Comparator<SalesItemSummary> comparator = new Comparator<SalesItemSummary>(){

                @Override
                public int compare(SalesItemSummary o1, SalesItemSummary o2) {
                    return SalesItemSummaryCreatorNew.this.sorting.compare(o1.getSalesItem(), o2.getSalesItem());
                }
            };
            Collections.sort(summaries, comparator);
        }
        return summaries;
    }

    private Object findIdentifier(SalesItem item) {
        return this.grouping.figureOutUniqueIdentifier(item);
    }
}

