/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.CostedItem;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesItemPriceAdjustmentLink;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.Course;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountSaveContext;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItemHelper;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.usage.StockUsageWatchdog;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_item")
@DiscriminatorColumn(name="type")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class SalesLineItem
extends PersistentObject
implements SaveableChild,
CostedItem,
Displayable {
    public static final Props Properties = new Props();
    protected Integer course;
    private int seat = 0;
    private int holdTime = 0;
    private boolean loyaltyPointsAvailable = true;
    private String notes;
    private Price openPrice;
    private Reference<Customer> customer;
    private Reference<Account> account;
    private Reference<Terminal> originalTerminal;
    private PersistentWriteableList<SalesItemQuantity> savedQuantities;
    private PersistentWriteableList<SalesItemPriceAdjustmentLink> itemAdjustmentLinks;
    private boolean weightManuallyEntered;
    private String extId;
    private PersistentWriteableList<FinanceTransaction> transactions;
    private List<SalesItemQuantity> localQuantities;
    private transient AccountSaveContext currentSaveContext;
    private Boolean hasTransactions;

    protected AccountSaveContext getCurrentSaveContext() {
        return this.currentSaveContext;
    }

    protected void setCurrentSaveContext(AccountSaveContext currentSaveContext) {
        this.currentSaveContext = currentSaveContext;
    }

    protected Boolean getHasTransactions() {
        return this.hasTransactions;
    }

    protected void setHasTransactions(Boolean hasTransactions) {
        this.hasTransactions = hasTransactions;
    }

    protected void setCustomer(Reference<Customer> customer) {
        this.customer = customer;
    }

    protected void setAccount(Reference<Account> account) {
        this.account = account;
    }

    protected void setOriginalTerminal(Reference<Terminal> originalTerminal) {
        this.originalTerminal = originalTerminal;
    }

    protected void setSavedQuantities(PersistentWriteableList<SalesItemQuantity> savedQuantities) {
        this.savedQuantities = savedQuantities;
    }

    protected void setItemAdjustmentLinks(PersistentWriteableList<SalesItemPriceAdjustmentLink> itemAdjustmentLinks) {
        this.itemAdjustmentLinks = itemAdjustmentLinks;
    }

    protected void setTransactions(PersistentWriteableList<FinanceTransaction> transactions) {
        this.transactions = transactions;
    }

    public SalesLineItem() {
        this.customer = this.createReference(SalesLineItem.Properties.CUSTOMER);
        this.account = this.createReference(SalesLineItem.Properties.ACCOUNT);
        this.originalTerminal = this.createReference(SalesLineItem.Properties.ORIGINAL_TERMINAL);
        this.savedQuantities = (PersistentWriteableList)this.createList(SalesLineItem.Properties.SAVED_QUANTITIES);
        this.itemAdjustmentLinks = (PersistentWriteableList)this.createList(SalesLineItem.Properties.ITEM_ADJUSTMENT_LINKS);
        this.weightManuallyEntered = false;
        this.transactions = (PersistentWriteableList)this.createList(SalesLineItem.Properties.TRANSACTIONS);
        this.localQuantities = new ArrayList<SalesItemQuantity>();
    }

    public SalesLineItem(int newCourse, int newSeat, EventContext context) {
        this(new Integer(newCourse), newSeat, context, "NOT_PRINTED");
        this.customer.collapse();
    }

    public SalesLineItem(Integer newCourse, int newSeat, EventContext context, String printState) {
        this.customer = this.createReference(SalesLineItem.Properties.CUSTOMER);
        this.account = this.createReference(SalesLineItem.Properties.ACCOUNT);
        this.originalTerminal = this.createReference(SalesLineItem.Properties.ORIGINAL_TERMINAL);
        this.savedQuantities = (PersistentWriteableList)this.createList(SalesLineItem.Properties.SAVED_QUANTITIES);
        this.itemAdjustmentLinks = (PersistentWriteableList)this.createList(SalesLineItem.Properties.ITEM_ADJUSTMENT_LINKS);
        this.weightManuallyEntered = false;
        this.transactions = (PersistentWriteableList)this.createList(SalesLineItem.Properties.TRANSACTIONS);
        this.localQuantities = new ArrayList<SalesItemQuantity>();
        this.course = newCourse;
        this.seat = newSeat;
        SalesItemQuantity qty = new SalesItemQuantity(SalesQuantity.ONE, "ACTIVE", printState, this, context);
        this.localQuantities.add(qty);
    }

    SalesLineItem(SalesLineItem copy, EventContext context, boolean deep) {
        this.customer = this.createReference(SalesLineItem.Properties.CUSTOMER);
        this.account = this.createReference(SalesLineItem.Properties.ACCOUNT);
        this.originalTerminal = this.createReference(SalesLineItem.Properties.ORIGINAL_TERMINAL);
        this.savedQuantities = (PersistentWriteableList)this.createList(SalesLineItem.Properties.SAVED_QUANTITIES);
        this.itemAdjustmentLinks = (PersistentWriteableList)this.createList(SalesLineItem.Properties.ITEM_ADJUSTMENT_LINKS);
        this.weightManuallyEntered = false;
        this.transactions = (PersistentWriteableList)this.createList(SalesLineItem.Properties.TRANSACTIONS);
        this.localQuantities = new ArrayList<SalesItemQuantity>();
        this.course = copy.course;
        this.seat = copy.seat;
        this.holdTime = copy.holdTime;
        this.loyaltyPointsAvailable = copy.loyaltyPointsAvailable;
        this.openPrice = copy.openPrice;
        this.notes = copy.notes;
        this.customer.set(copy.getCustomer());
        this.originalTerminal.set(context.getTerminal());
        this.localQuantities.clear();
        this.hasTransactions = copy.hasTransactions;
        for (SalesItemPriceAdjustmentLink link : copy.getItemAdjustmentLinks()) {
            if (link != null && link.getSalesPriceAdjustment() != null) {
                this.itemAdjustmentLinks.add(new SalesItemPriceAdjustmentLink(this, link.getSalesPriceAdjustment().copy()));
                continue;
            }
            OrderMate.LOG.warn("** Missing Price Adjustment for " + copy + " while copying, ignoring **");
        }
        if (deep) {
            for (SalesItemQuantity localQty : copy.localQuantities) {
                this.localQuantities.add(new SalesItemQuantity(localQty.getQuantity(), "ACTIVE", "NOT_PRINTED", this, context));
            }
            for (SalesItemQuantity savedQty : copy.savedQuantities) {
                this.localQuantities.add(new SalesItemQuantity(savedQty.getQuantity(), "ACTIVE", "NOT_PRINTED", this, context));
            }
        }
    }

    @Override
    public void init() {
        super.init();
    }

    public abstract SalesLineItem copy(EventContext var1, boolean var2);

    public abstract Collection<VirtualPrinter> getDocketPrinters(Terminal var1);

    public abstract boolean isPrintableThrough(Terminal var1, VirtualPrinter var2);

    @Transient
    public abstract List<SalesItem> getSalesItems();

    @Transient
    public Price getPricePerItem() {
        return this.getPrice(SalesQuantity.ONE);
    }

    @Override
    @Transient
    public Price getPrice() {
        return this.getPrice(this.getQuantity());
    }

    @Transient
    public abstract Price getBasePrice();

    protected abstract Price getPrice(SalesQuantity var1);

    public abstract void setPrice(Price var1, EventContext var2);

    @Transient
    public abstract Price getUnadjustedPrice();

    @Transient
    public Collection<SalesPriceAdjustment> getPriceAdjustments() {
        LinkedHashSet<SalesPriceAdjustment> adjustments = new LinkedHashSet<SalesPriceAdjustment>();
        for (SalesItemPriceAdjustmentLink link : this.itemAdjustmentLinks) {
            if (link.getSalesPriceAdjustment() == null) continue;
            adjustments.add(link.getSalesPriceAdjustment());
        }
        return adjustments;
    }

    @Transient
    public Collection<SalesPriceAdjustment> getPriceAdjustmentsNotIncludingPriceLevelAdjs() {
        LinkedHashSet<SalesPriceAdjustment> adjustments = new LinkedHashSet<SalesPriceAdjustment>();
        for (SalesItemPriceAdjustmentLink link : this.itemAdjustmentLinks) {
            if (link.getSalesPriceAdjustment() == null || PriceAdjustmentType.PRICE_LEVEL.equals(link.getSalesPriceAdjustment().getType())) continue;
            adjustments.add(link.getSalesPriceAdjustment());
        }
        return adjustments;
    }

    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        if (PriceAdjustmentLevel.ACCOUNT_LEVEL.equals(adjustment.getLevel())) {
            throw new IllegalArgumentException("Cannot add adjustment to this item, adjustment is account level " + adjustment);
        }
        if (!this.getPriceAdjustments().contains(adjustment)) {
            this.itemAdjustmentLinks.add(new SalesItemPriceAdjustmentLink(this, adjustment));
        }
        if (this.getAccount() != null) {
            this.getAccount().getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
        }
        TerminalEventLog.logAddAdjustment(context, adjustment, this);
    }

    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        TerminalEventLog.logRemoveAdjustment(context, adjustment, this);
        return this.removePriceAdjustment(adjustment, true);
    }

    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, boolean recalcForAccount, EventContext context) {
        TerminalEventLog.logRemoveAdjustment(context, adjustment, this);
        return this.removePriceAdjustment(adjustment, recalcForAccount);
    }

    private boolean removePriceAdjustment(SalesPriceAdjustment adjustment, boolean recalculateForAccount) {
        if (adjustment == null) {
            return false;
        }
        ArrayList<SalesItemPriceAdjustmentLink> removeList = new ArrayList<SalesItemPriceAdjustmentLink>();
        boolean retVal = false;
        for (SalesItemPriceAdjustmentLink link : this.itemAdjustmentLinks) {
            if (link.getSalesPriceAdjustment() == null || link.getSalesPriceAdjustment().equals(adjustment)) {
                removeList.add(link);
            }
            retVal |= adjustment.removeSalesLineItemLink(link);
        }
        this.itemAdjustmentLinks.removeAll(removeList);
        adjustment.tearDownUsages();
        if (recalculateForAccount) {
            Account accountForItem = this.getAccount();
            if (recalculateForAccount && accountForItem != null) {
                accountForItem.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
            }
        }
        return retVal;
    }

    public void removePriceAdjustments(Collection adjustmentsToRemove) {
        for (SalesPriceAdjustment adj : adjustmentsToRemove) {
            this.removePriceAdjustment(adj, false);
        }
    }

    @Transient
    public List<SalesPriceAdjustment> getDiscounts() {
        return PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentDirection.DISCOUNT);
    }

    @Transient
    public List<SalesPriceAdjustment> getSurcharges() {
        return PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentDirection.SURCHARGE);
    }

    @Transient
    public boolean isDiscounted() {
        return !this.getDiscounts().isEmpty();
    }

    @Transient
    public boolean isSurcharged() {
        return !this.getSurcharges().isEmpty();
    }

    @Transient
    public abstract Price getAccountDiscountTotal();

    @Transient
    protected abstract Price getPriceOfMods();

    @Transient
    public boolean isPriceAdjusted() {
        return !this.itemAdjustmentLinks.isEmpty();
    }

    @Transient
    public Price getDiscountsTotal() {
        if (!this.isDiscounted()) {
            return Price.ZERO_DOLLAR;
        }
        Price total = Price.ZERO_DOLLAR;
        List<SalesPriceAdjustment> discounts = PriceAdjustmentManager.getInstance().getMatching(this.getPriceAdjustments(), PriceAdjustmentDirection.DISCOUNT);
        for (SalesPriceAdjustment discount : discounts) {
            total = total.add(discount.getValue());
        }
        return total;
    }

    @Transient
    public String getDiscountsAsString() {
        if (!this.isDiscounted()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (SalesPriceAdjustment discount : this.getDiscounts()) {
            if (!discount.getType().isDisplayOnReceipt()) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(discount.getLabel());
            if (discount.getLabel().contains(discount.getValue(this).abs().toString())) continue;
            buffer.append(" ");
            buffer.append(discount.getValue(this).negate());
        }
        return buffer.toString();
    }

    @Transient
    public String getSurchargesAsString() {
        if (!this.isSurcharged()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (SalesPriceAdjustment surcharge : this.getSurcharges()) {
            if (!surcharge.getType().isDisplayOnReceipt()) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(surcharge.getLabel());
            if (surcharge.getLabel().contains(surcharge.getValue(this).abs().toString())) continue;
            buffer.append(" ");
            buffer.append(surcharge.getValue(this).negate());
        }
        return buffer.toString();
    }

    @Transient
    public SalesQuantity getQuantity() {
        SalesQuantity value = SalesQuantity.ZERO;
        value = value.add(SalesItemQuantity.getTotalQuantity(this.getLocalQuantities()));
        value = value.add(SalesItemQuantity.getTotalQuantity(this.savedQuantities));
        return value;
    }

    @Transient
    public boolean isRefund() {
        return this.getQuantity().lessThan(0L);
    }

    @Transient
    public List<SalesItemQuantity> getSalesItemQuantities() {
        ArrayList<SalesItemQuantity> quantities = new ArrayList<SalesItemQuantity>(this.savedQuantities.size() + this.localQuantities.size());
        quantities.addAll(this.getLocalQuantities());
        quantities.addAll(this.savedQuantities);
        return quantities;
    }

    @OneToMany(mappedBy="salesLineItem", targetEntity=SalesItemQuantity.class, fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public List<SalesItemQuantity> getSavedQuantities() {
        return this.savedQuantities.getUnmodifiable();
    }

    @Transient
    public void clearAllQuantities() {
        this.getLocalQuantities().clear();
        this.savedQuantities.clear();
    }

    public void addSavedQuantities(SalesItemQuantity qty) {
        this.savedQuantities.add(qty);
    }

    public boolean isModifiable(EventContext context) {
        if (this.hasFinanceTransactions()) {
            return false;
        }
        if (!this.getAccount().allowsOrderingItems()) {
            return false;
        }
        if (!this.isLoyaltyPointsAvailable()) {
            return false;
        }
        if (context.getUser().hasPermission(AllPermissions.USE_INACTIVE_PRICE_LEVEL)) {
            return true;
        }
        boolean priceLevelActive = true;
        Iterator<SalesItem> itemIt = this.getSalesItems().iterator();
        while (itemIt.hasNext() && priceLevelActive) {
            SalesItem salesItem = itemIt.next();
            SalesComponent aComp = salesItem.getComponent();
            if (aComp != null) {
                priceLevelActive = aComp.getPriceLevel().isActive(new TriggerActivationContext(context, new Date(), this.getAccount()));
                continue;
            }
            Iterator<SalesComponent> compIt = salesItem.getComponents().iterator();
            while (compIt.hasNext() && priceLevelActive) {
                SalesComponent combo = compIt.next();
                priceLevelActive = combo.getPriceLevel().isActive(new TriggerActivationContext(context, new Date(), this.getAccount()));
            }
        }
        return priceLevelActive;
    }

    public void setQuantity(SalesQuantity newQuantity, EventContext context) {
        this.setQuantity(newQuantity, context, newQuantity.lessThan(0L) ? "REFUNDED" : "ACTIVE");
    }

    public void setQuantity(SalesQuantity newQuantity, EventContext context, String systemStateType) {
        try {
            SalesLineItemHelper helper = new SalesLineItemHelper(this);
            this.setLocalQuantities(helper.calculateNewLocalQuantities(newQuantity, context, systemStateType));
        }
        catch (Exception e) {
            OrderMate.LOG.error("setQuantity() failed for SalesLineItem:" + this, (Throwable)e);
        }
    }

    protected abstract boolean hasSavedItems();

    private void splitQuantity(SalesQuantity qty, SalesLineItem target, EventContext context) {
        if (target.isPersistent()) {
            throw new IllegalArgumentException("Target should not yet be persistent. Target : " + target);
        }
        if (!target.getSavedQuantities().isEmpty()) {
            throw new IllegalArgumentException("Target should not have saved quantities. # Saved Qty: " + target.getSavedQuantities().size());
        }
        if (qty.lessThanOrEquals(0L)) {
            throw new IllegalArgumentException("The qty must be positive not null instead of " + qty + " with the current implementation.");
        }
        if (this.getQuantity().lessThan(qty)) {
            throw new IllegalArgumentException("The qty to transfer " + qty + " is greater than the line quantity of " + this.getQuantity());
        }
        SalesQuantity toRemove = qty;
        ArrayList<SalesItemQuantity> localQtys = new ArrayList<SalesItemQuantity>(this.getLocalQuantities());
        for (SalesItemQuantity nextLocal : localQtys) {
            if (!nextLocal.getItemState().equals("ACTIVE")) continue;
            SalesQuantity newQty = nextLocal.getQuantity().subtract(toRemove);
            this.localQuantities.remove(nextLocal);
            if (newQty.lessThanOrEquals(0L)) {
                toRemove = toRemove.subtract(nextLocal.getQuantity());
                continue;
            }
            this.localQuantities.add(new SalesItemQuantity(newQty, "ACTIVE", "NOT_PRINTED", this, context));
            toRemove = SalesQuantity.ZERO;
        }
        if (toRemove.greaterThan(0L)) {
            List<SalesItemQuantity> activeSavedQty = SalesItemQuantity.getMatchingQuantities(this.savedQuantities, new SalesItemQuantity.QuantityComparator[]{new SalesItemQuantity.StateQuantityComparator("ACTIVE")});
            Iterator<SalesItemQuantity> it = activeSavedQty.iterator();
            while (it.hasNext() && toRemove.greaterThan(0L)) {
                SalesItemQuantity savedQuantity = it.next();
                if (savedQuantity.getQuantity().lessThanOrEquals(toRemove)) {
                    this.savedQuantities.remove(savedQuantity);
                    target.savedQuantities.add(savedQuantity);
                    toRemove = toRemove.subtract(savedQuantity.getQuantity());
                    continue;
                }
                target.savedQuantities.add(new SalesItemQuantity(toRemove, savedQuantity, target));
                toRemove = SalesQuantity.ZERO;
            }
        }
        target.setQuantity(qty, context);
    }

    protected void mergeQuantity(SalesLineItem source, EventContext context) {
        this.localQuantities.addAll(source.getLocalQuantities());
        this.savedQuantities.addAll(source.getSavedQuantities());
    }

    @Transient
    public SalesQuantity getUnsavedQuantity() {
        SalesQuantity qty = SalesQuantity.ZERO;
        for (SalesItemQuantity nextLocal : this.getLocalQuantities()) {
            qty = qty.add(nextLocal.getQuantity());
        }
        return qty;
    }

    public boolean hasUnsavedQuantity() {
        return !this.getLocalQuantities().isEmpty();
    }

    @Transient
    public SalesQuantity getSavedQuantity(boolean printed) {
        List<SalesItemQuantity> matches = this.getSavedSalesItemQuantity(printed);
        return SalesItemQuantity.getTotalQuantity(matches);
    }

    @Transient
    public List<SalesItemQuantity> getSavedSalesItemQuantity(boolean printed) {
        List<SalesItemQuantity> matches = this.getSavedSalesItemQuantity(printed, true);
        return matches;
    }

    @Transient
    public List<SalesItemQuantity> getSavedSalesItemQuantity(boolean printed, boolean isPersistent) {
        List<SalesItemQuantity> matches = SalesItemQuantity.getMatchingQuantities(this.savedQuantities, new SalesItemQuantity.QuantityComparator[]{new SalesItemQuantity.PrintQuantityComparator(printed, isPersistent)});
        return matches;
    }

    public SalesQuantity getSavedQuantity(String itemState) {
        if (itemState == null || !itemState.equals("ACTIVE") && !itemState.equals("DELETED") && !itemState.equals("MOVED") && !itemState.equals("DELETED_WASTED")) {
            String s = "State must be one of ACTIVE, DELETED, DELETED_WASTED or MOVED";
            throw new IllegalArgumentException(s);
        }
        List<SalesItemQuantity> matches = SalesItemQuantity.getMatchingQuantities(this.savedQuantities, new SalesItemQuantity.QuantityComparator[]{new SalesItemQuantity.StateQuantityComparator(itemState)});
        return SalesItemQuantity.getTotalQuantity(matches);
    }

    public SalesQuantity getQuantity(String itemState) {
        if (!(itemState.equals("ACTIVE") || itemState.equals("DELETED") || itemState.equals("MOVED") || itemState.equals("DELETED_WASTED") || itemState.equals("REFUNDED") || itemState.equals("REFUNDED_WASTED"))) {
            String s = "State must be one of ACTIVE, DELETED, DELETED_WASTED, REFUNDED, REFUNDED_WASTED or MOVED";
            throw new IllegalArgumentException(s + " : was " + itemState);
        }
        ArrayList<SalesItemQuantity> allQtys = new ArrayList<SalesItemQuantity>(this.savedQuantities);
        allQtys.addAll(this.getLocalQuantities());
        List<SalesItemQuantity> matches = SalesItemQuantity.getMatchingQuantities(allQtys, new SalesItemQuantity.QuantityComparator[]{new SalesItemQuantity.StateQuantityComparator(itemState)});
        return SalesItemQuantity.getTotalQuantity(matches);
    }

    @Transient
    public SalesQuantity getSavedQuantity(boolean printed, String itemState) {
        List<SalesItemQuantity> matches;
        if (itemState != null) {
            SalesItemQuantity.isValidItemState(itemState);
            matches = SalesItemQuantity.getMatchingQuantities(this.savedQuantities, new SalesItemQuantity.QuantityComparator[]{new SalesItemQuantity.PrintQuantityComparator(printed, true), new SalesItemQuantity.StateQuantityComparator(itemState)});
        } else {
            matches = SalesItemQuantity.getMatchingQuantities(this.savedQuantities, new SalesItemQuantity.QuantityComparator[]{new SalesItemQuantity.PrintQuantityComparator(printed, true)});
        }
        return SalesItemQuantity.getTotalQuantity(matches);
    }

    public boolean hasUnsavedDeletedQuantity() {
        return this.hasUnsavedNegativeQuantityOfState(new String[]{"DELETED_WASTED", "DELETED"});
    }

    public boolean hasUnsavedRefundedQuantity() {
        return this.hasUnsavedNegativeQuantityOfState(new String[]{"REFUNDED_WASTED", "REFUNDED"});
    }

    private boolean hasUnsavedNegativeQuantityOfState(String[] itemStates) {
        if (!this.getLocalQuantities().isEmpty()) {
            for (SalesItemQuantity localQty : this.getLocalQuantities()) {
                if (!localQty.getQuantity().lessThan(0L) || !ArrayUtils.contains((Object[])itemStates, (Object)localQty.getItemState())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasUnsavedMovedQuantity() {
        return this.hasUnsavedNegativeQuantityOfState(new String[]{"MOVED"});
    }

    protected boolean isItemCourseOnHold(SalesLineItem salesLineItem) {
        Account acc = salesLineItem.getAccount();
        if (!(acc instanceof TableAccount)) {
            return false;
        }
        TableAccount tableAccount = (TableAccount)acc;
        return tableAccount.isCoursePrintOnHold(Course.getCourse(salesLineItem.getCourse()));
    }

    public void markPrinted() {
        for (SalesItemQuantity qty : this.getLocalQuantities()) {
            qty.markAsPrinted();
        }
        for (SalesItemQuantity siq : this.savedQuantities) {
            siq.markAsPrinted();
        }
    }

    private void markAsState(EventContext context, String state, String printedState) {
        SalesQuantity remaining = SalesItemQuantity.getTotalQuantity(this.savedQuantities);
        ArrayList<SalesItemQuantity> qtys = new ArrayList<SalesItemQuantity>(this.savedQuantities.size());
        for (SalesItemQuantity nextSaved : this.savedQuantities) {
            SalesItemQuantity qty;
            if (SalesQuantity.ZERO.equals(remaining)) break;
            if (!"ACTIVE".equals(nextSaved.getItemState())) continue;
            if (remaining.greaterThanOrEquals(nextSaved.getQuantity())) {
                qty = new SalesItemQuantity(nextSaved.getQuantity().negate(), state, printedState, this, context);
                remaining = remaining.subtract(nextSaved.getQuantity());
            } else {
                qty = new SalesItemQuantity(remaining.negate(), state, printedState, this, context);
            }
            qtys.add(qty);
        }
        this.setLocalQuantities(qtys);
    }

    public void markAsDeleted(EventContext context) {
        LoyaltyPointAdministrator.getInstance().salesLineItemRemoved(this, context);
        this.markAsState(context, "DELETED", "NOT_PRINTED");
    }

    public void markAsRefunded(EventContext context) {
        LoyaltyPointAdministrator.getInstance().salesLineItemRemoved(this, context);
        this.markAsState(context, "REFUNDED", "PRINTED");
    }

    public void markAsMoved(EventContext context, boolean printMove) {
        if (!this.isPersistent()) {
            String s = "Cannot mark item as moved unless it has been saved!";
            throw new IllegalStateException(s);
        }
        String state = printMove ? "NOT_PRINTED" : "PRINTED";
        this.markAsState(context, "MOVED", state);
    }

    public boolean hasEverPrinted() {
        return !this.getSavedSalesItemQuantity(true).isEmpty();
    }

    @Transient
    public boolean isPrinted() {
        List<SalesItemQuantity> notPrinted = this.getSavedSalesItemQuantity(false);
        if (notPrinted.isEmpty()) {
            if (this.getLocalQuantities().isEmpty()) {
                return !this.savedQuantities.isEmpty();
            }
            return this.getLocalQuantities().get(0).getQuantity().equals(SalesQuantity.ZERO) || this.getLocalQuantities().get(0).getPrintState().equals("PRINTED");
        }
        return SalesItemQuantity.getTotalQuantity(notPrinted).equals(SalesQuantity.ZERO);
    }

    public void markAsWasted() {
        for (SalesItemQuantity qty : this.getLocalQuantities()) {
            if (qty.getItemState().equals("DELETED")) {
                qty.changeItemState("DELETED_WASTED");
                continue;
            }
            if (!qty.getItemState().equals("REFUNDED")) continue;
            qty.changeItemState("REFUNDED_WASTED");
        }
    }

    @Transient
    public List<SalesItemQuantity> getLocalQuantities() {
        return this.localQuantities;
    }

    @Transient
    public boolean isSplittable() {
        return this.getQuantity().greaterThan(1L);
    }

    public SalesLineItem split(SalesQuantity splitQty, EventContext context) {
        if (!this.isSplittable()) {
            throw new IllegalStateException("Cannot split item with a quantity less than or equal to one. Qty:" + this.getQuantity());
        }
        SalesQuantity currentQty = this.getQuantity();
        if (splitQty.lessThan(0L) || splitQty.greaterThan(currentQty)) {
            throw new IllegalArgumentException("Can't split off " + splitQty + "; item has current quantity of " + currentQty);
        }
        if (splitQty.equals(0L) || splitQty.equals(currentQty)) {
            return null;
        }
        SalesLineItem splitItem = this.copy(context, false);
        this.splitQuantity(splitQty, splitItem, context);
        if (this.getAccount() != null) {
            this.getAccount().getItemHelper().addItem(splitItem);
        }
        Iterator it = this.getFinanceTransactions().iterator();
        while (it.hasNext()) {
            splitItem.addFinanceTransaction((FinanceTransaction)it.next());
        }
        LoyaltyPointAdministrator.getInstance().itemSplit(this, splitItem, context);
        return splitItem;
    }

    @ManyToOne(targetEntity=Terminal.class, fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_terminal")
    public Terminal getOriginalTerminal() {
        return this.originalTerminal.get();
    }

    void setOriginalTerminal(Terminal term) {
        this.originalTerminal.set(term);
    }

    @Column(name="course")
    public int getCourse() {
        if (this.course != null) {
            return this.course;
        }
        return 0;
    }

    public void setCourse(Course theCourse) {
        this.course = theCourse != null ? new Integer(theCourse.getCourseIndex()) : null;
    }

    public void setCourse(int newCourse) {
        this.course = new Integer(newCourse);
    }

    @Column(name="seat")
    public int getSeat() {
        return this.seat;
    }

    public void setSeat(int newSeat) {
        this.seat = newSeat;
    }

    @Transient
    public String getSeatName() {
        if (this.seat == 0) {
            return "Seat All";
        }
        return "Seat " + this.seat;
    }

    @Column(name="hold_time")
    public int getHoldTime() {
        return this.holdTime;
    }

    public void setHoldTime(int time) {
        this.holdTime = time;
    }

    @Column(name="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String newNotes) {
        this.notes = newNotes;
    }

    @Column(name="ext_id")
    public String getExtId() {
        return this.extId;
    }

    public void setExtId(String value) {
        this.extId = value;
    }

    public boolean hasNotes() {
        return this.notes != null && this.notes.trim().length() > 0;
    }

    @Column(name="OpenItemSellingPrice")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getOpenPrice() {
        return this.openPrice;
    }

    protected void setOpenPrice(Price newPrice) {
        this.openPrice = newPrice;
    }

    @Transient
    public boolean isPriceEdited() {
        return this.openPrice != null;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer newCustomer) {
        this.customer.set(newCustomer);
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_account")
    public Account getAccount() {
        return this.account.get();
    }

    protected void setAccount(Account acct) {
        this.account.set(acct);
    }

    public abstract boolean isEquivalentTo(SalesLineItem var1);

    public abstract boolean isEquivalentTo(SalesLineItem var1, boolean var2, boolean var3);

    public SalesLineItem getEquivalentItem(List items) {
        SalesLineItem equivalentItem = null;
        Iterator it = items.iterator();
        while (it.hasNext() && equivalentItem == null) {
            SalesLineItem checkItem = (SalesLineItem)it.next();
            if (!checkItem.isEquivalentTo(this)) continue;
            equivalentItem = checkItem;
        }
        return equivalentItem;
    }

    public <T extends SalesLineItem> List<T> getEquivalentItems(List<T> items) {
        ArrayList<SalesLineItem> equivItems = new ArrayList<SalesLineItem>();
        for (SalesLineItem checkItem : items) {
            if (!checkItem.isEquivalentTo(this)) continue;
            equivItems.add(checkItem);
        }
        return equivItems;
    }

    public SalesQuantity getEquivalentItemsTotalQuantity(List<? extends SalesLineItem> items) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : this.getEquivalentItems(items)) {
            quantity = quantity.add(salesLineItem.getQuantity());
        }
        return quantity;
    }

    public boolean hasLoyaltyPointsAvailable() {
        return this.loyaltyPointsAvailable;
    }

    public void markLoyaltyPointsTaken() {
        this.loyaltyPointsAvailable = false;
    }

    public void markAsLoyaltyPointsRedeemed() {
        this.markLoyaltyPointsTaken();
        for (SalesItem item : this.getSalesItems()) {
            for (SalesComponent currentComponent : item.getComponents()) {
                currentComponent.setLoyaltyRedeemed(true);
            }
        }
    }

    public void markAsLoyaltyPointsNotRedeemed() {
        for (SalesItem currentItem : this.getSalesItems()) {
            for (SalesComponent currentComponent : currentItem.getComponents()) {
                currentComponent.setLoyaltyRedeemed(false);
            }
        }
        this.loyaltyPointsAvailable = true;
    }

    @Transient
    public int getLoyaltyPointsCount() {
        if (!this.loyaltyPointsAvailable) {
            return 0;
        }
        return this.getLoyaltyPointsEarned();
    }

    @Column(name="loyalty_points_available")
    protected boolean isLoyaltyPointsAvailable() {
        return this.loyaltyPointsAvailable;
    }

    protected void setLoyaltyPointsAvailable(boolean loyaltyPointsAvailable) {
        this.loyaltyPointsAvailable = loyaltyPointsAvailable;
    }

    @Transient
    public abstract int getLoyaltyPointsCost();

    @Transient
    public abstract int getLoyaltyPointsEarned();

    @Transient
    public abstract Price getItemLevelPrice();

    @Transient
    public abstract Price getSubtotalPrice();

    @Transient
    public abstract Price getItemLevelPricePerItem();

    @Transient
    public String getDisplayablePriceLevels() {
        StringBuffer priceLevels = new StringBuffer();
        for (SalesItem item : this.getSalesItems()) {
            PriceLevel level;
            if (item.getComponent() != null && (level = item.getComponent().getPriceLevel()).isShowOnReceipt()) {
                level.setLabelFormat("");
                priceLevels.append(level);
            }
            for (SalesComponent comp : item.getComponents()) {
                PriceLevel currentPriceLevel = comp.getPriceLevel();
                if (!currentPriceLevel.isShowOnReceipt()) continue;
                if (priceLevels.length() > 0) {
                    priceLevels.append(", ");
                }
                currentPriceLevel.setLabelFormat("");
                priceLevels.append(currentPriceLevel.getLabel());
            }
        }
        return priceLevels.toString();
    }

    public boolean hasDisplayablePriceLevels() {
        for (SalesItem item : this.getSalesItems()) {
            if (item.getComponent() != null) {
                return item.getComponent().getPriceLevel().isShowOnReceipt();
            }
            for (SalesComponent comp : item.getComponents()) {
                if (!comp.getPriceLevel().isShowOnReceipt()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasFinanceTransactions() {
        SalesItem salesItem;
        SalesCombo parentCombo;
        if (this instanceof SalesItem && (parentCombo = (salesItem = (SalesItem)this).getParentCombo()) != null && parentCombo.hasFinanceTransactions()) {
            return true;
        }
        if (this.getAccount() != null) {
            return this.getAccount().hasPayments() && !this.getFinanceTransactions().isEmpty();
        }
        return !this.getFinanceTransactions().isEmpty();
    }

    @Transient
    public List getFinanceTransactions() {
        return this.transactions.getUnmodifiable();
    }

    public void addFinanceTransaction(FinanceTransaction toAdd) {
        this.transactions.add(toAdd);
    }

    public void addFinanceTransactions(Collection<FinanceTransaction> financeTransactionsToAdd) {
        this.transactions.addAll(financeTransactionsToAdd);
    }

    public void removeFinanceTransaction(FinanceTransaction toRemove) {
        this.transactions.remove(toRemove);
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return SalesLineItem.getItemBackgroundColor(this.isPrinted(), this.hasFinanceTransactions());
    }

    public static Color getItemBackgroundColor(boolean isPrinted, boolean hasFinanceTrans) {
        if (hasFinanceTrans) {
            return PAID_COLOR;
        }
        if (isPrinted) {
            return PRINTED_COLOR;
        }
        return null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.currentSaveContext = (AccountSaveContext)context;
    }

    @Transient
    protected AccountSaveContext getSaveContext() {
        return this.currentSaveContext;
    }

    @Override
    public void saveChild() {
        if (!this.isPersistent() && this.originalTerminal.isNull()) {
            this.originalTerminal.set(this.currentSaveContext.getTerminal());
        }
        if (this.course == null) {
            this.course = new Integer(0);
        }
        if (this.customer != null) {
            this.customer.saveChild();
        }
        if (this.getLocalQuantities().isEmpty() && this.savedQuantities.isEmpty()) {
            this.setLocalQuantities(Collections.singletonList(new SalesItemQuantity(SalesQuantity.ONE, "ACTIVE", "NOT_PRINTED", this, this.currentSaveContext)));
        }
        PersistenceManager.saveChild(this);
        this.itemAdjustmentLinks.prepareForSave(this.currentSaveContext);
        this.itemAdjustmentLinks.saveChild();
        this.transactions.saveChild();
        this.savedQuantities.saveChild();
    }

    public abstract void consumeStockIfLegal(SalesItemQuantity var1, User var2, String var3, String var4, StockControlProperty var5, Terminal var6);

    protected void saveDone() {
        try {
            StockUsageWatchdog.getInstance().checkSaveStockUsages(this);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot call StockUsageWatchdog", (Throwable)ex);
        }
        this.savedQuantities.addAll(this.getLocalQuantities());
        for (SalesItemQuantity localQty : this.getLocalQuantities()) {
            localQty.saveChild();
        }
        this.localQuantities.clear();
        this.currentSaveContext = null;
    }

    @Override
    public void deleteChild() {
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this) || !this.getLocalQuantities().isEmpty();
    }

    @Transient
    public abstract InventoryGroup getMenuGroup();

    @Transient
    public InventoryGroup getLowestSequenceInventoryGroup() {
        InventoryGroup currentMaxGroup = null;
        block0: for (SalesItem item : this.getSalesItems()) {
            for (SalesComponent currentComponent : item.getComponents()) {
                InventoryGroup currentGroup = currentComponent.getInventoryItem().getMenuGroup();
                if (currentMaxGroup == null) {
                    currentMaxGroup = currentGroup;
                    continue;
                }
                if (currentGroup.getID().equals(currentMaxGroup.getID())) continue block0;
                if (currentMaxGroup.getSequence() < currentGroup.getSequence()) {
                    currentMaxGroup = currentGroup;
                    continue;
                }
                if (currentMaxGroup.getSequence() != currentGroup.getSequence() || currentMaxGroup.getLabel().compareTo(currentGroup.getLabel()) <= 0) continue;
                currentMaxGroup = currentGroup;
            }
        }
        return currentMaxGroup;
    }

    @Transient
    public InventoryCategory getLowestSequenceInventoryCategory() {
        InventoryCategory currentMaxCategory = null;
        block0: for (SalesItem item : this.getSalesItems()) {
            for (SalesComponent currentComponent : item.getComponents()) {
                InventoryCategory currentCategory = currentComponent.getInventoryItem().getCategory();
                if (currentMaxCategory == null) {
                    currentMaxCategory = currentCategory;
                    continue;
                }
                if (currentCategory.getID().equals(currentMaxCategory.getID())) continue block0;
                if (currentMaxCategory.getSequence() < currentCategory.getSequence()) {
                    currentMaxCategory = currentCategory;
                    continue;
                }
                if (currentMaxCategory.getSequence() != currentCategory.getSequence() || currentMaxCategory.getLabel().compareTo(currentCategory.getLabel()) <= 0) continue;
                currentMaxCategory = currentCategory;
            }
        }
        return currentMaxCategory;
    }

    public void expandQuantities() {
        this.savedQuantities.size();
        for (SalesItem lineItem : this.getSalesItems()) {
            lineItem.getQuantity();
        }
    }

    @Transient
    public boolean isWastageCheckNeeded() {
        if (this.hasUnsavedDeletedQuantity() || this.hasUnsavedRefundedQuantity()) {
            for (SalesItem sale : this.getSalesItems()) {
                for (SalesComponent comp : sale.getComponents()) {
                    if (!comp.isWastageCheckNeeded()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void setLocalQuantities(List<SalesItemQuantity> quantities) {
        this.localQuantities.clear();
        if (quantities != null) {
            this.localQuantities.addAll(quantities);
            if (this.getAccount() != null) {
                this.getAccount().getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
            }
        }
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="finance_transaction_item", joinColumns={@JoinColumn(name="FK_sales_item", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="FK_finance_transaction", referencedColumnName="ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected List<FinanceTransaction> getTransactions() {
        return this.transactions;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @OneToMany(mappedBy="salesLineItem", targetEntity=SalesItemPriceAdjustmentLink.class, fetch=FetchType.LAZY)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    protected List<SalesItemPriceAdjustmentLink> getItemAdjustmentLinks() {
        return this.itemAdjustmentLinks;
    }

    protected void setItemAdjustmentLinks(List<SalesItemPriceAdjustmentLink> newItemAdjustmentLinks) {
        this.itemAdjustmentLinks = this.itemAdjustmentLinks.clone();
        this.itemAdjustmentLinks.set(newItemAdjustmentLinks);
    }

    protected void setTransactions(List<FinanceTransaction> newTransactions) {
        this.transactions = this.transactions.clone();
        this.transactions.set(newTransactions);
    }

    protected void setSavedQuantities(List<SalesItemQuantity> newSavedQuantities) {
        this.savedQuantities = this.savedQuantities.clone();
        this.savedQuantities.set(newSavedQuantities);
    }

    @Transient
    public int getNumPatrons() {
        double num = 0.0;
        for (SalesItem item : this.getSalesItems()) {
            for (SalesComponent comp : item.getComponents()) {
                num += (double)comp.getUnit().getNumPatrons() * item.getQuantity().getValue().doubleValue();
            }
        }
        return (int)num;
    }

    @Transient
    public abstract Price getTax();

    @Transient
    public abstract Price getUnitTax();

    @Transient
    public abstract Price getUnadjustedTax();

    public void markAsQuickRefunded(EventContext context, String refundedState) {
        LoyaltyPointAdministrator.getInstance().salesLineItemRemoved(this, context);
        this.markAsQuickRefundState(context, refundedState);
    }

    void markAsQuickRefundState(EventContext context, String state) {
        this.setQuantity(this.getQuantity().negate(), context, state);
    }

    public void setWeightManuallyEntered(boolean weightManuallyEntered) {
        this.weightManuallyEntered = weightManuallyEntered;
    }

    @Column(name="weight_manually_entered")
    public boolean isWeightManuallyEntered() {
        return this.weightManuallyEntered;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property COURSE;
        public PropertiedObject.Property SEAT;
        public PropertiedObject.Property HOLD_TIME;
        public PropertiedObject.Property LOYALTY_POINTS_AVAILABLE;
        public PropertiedObject.Property OPEN_PRICE;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property NOTES;
        public PropertiedObject.Property<Terminal> ORIGINAL_TERMINAL;
        public PropertiedObject.Property<SalesItemQuantity> SAVED_QUANTITIES;
        public PropertiedObject.Property<FinanceTransaction> TRANSACTIONS;
        public PropertiedObject.Property<SalesItemPriceAdjustmentLink> ITEM_ADJUSTMENT_LINKS;
        public PropertiedObject.Property WEIGHT_MANUALLY_ENTERED;
        public PropertiedObject.Property<String> EXT_ID;
        public PersistentObject.DerivedProperty<String> SEAT_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesLineItem.class), "seatName");
    }
}

