/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.AccountSaveContext;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.SalesRemove;

public class SalesLineItemHelper {
    private SalesLineItem salesLineItem;

    public SalesLineItemHelper(SalesLineItem toHelp) throws IllegalStateException {
        if (toHelp == null) {
            throw new IllegalStateException("null SalesLineItem passed in to SalesLineItemHelper's constructor");
        }
        this.salesLineItem = toHelp;
    }

    public static boolean containsAllIsEquivalentTo(List<? extends SalesLineItem> bigList, List<? extends SalesLineItem> toContainAllOf) {
        boolean toReturn = true;
        for (SalesLineItem salesLineItem : toContainAllOf) {
            boolean doesContain = false;
            for (SalesLineItem salesLineItem2 : bigList) {
                if (!salesLineItem.isEquivalentTo(salesLineItem2)) continue;
                doesContain = true;
                break;
            }
            if (doesContain) continue;
            toReturn = false;
            break;
        }
        return toReturn;
    }

    public static SalesItemQuantity getLastSalesItemQuantity(SalesLineItem salesItem) {
        List<SalesItemQuantity> localQtys = salesItem.getLocalQuantities();
        if (!localQtys.isEmpty()) {
            for (SalesItemQuantity qty : localQtys) {
                if ("DELETED".equals(qty.getItemState())) continue;
                return qty;
            }
        }
        ArrayList<SalesItemQuantity> mainList = new ArrayList<SalesItemQuantity>(salesItem.getSavedQuantities());
        PropertyComparator idComparator = new PropertyComparator((PropertiedObject.Property<? extends Comparable>)SalesItemQuantity.Properties.ID);
        Collections.sort(mainList, idComparator);
        ArrayList resultList = new ArrayList();
        Collections.addAll(resultList, mainList.toArray(new SalesItemQuantity[0]));
        Collections.reverse(resultList);
        for (SalesItemQuantity qty : resultList) {
            if ("DELETED".equals(qty.getItemState())) continue;
            return qty;
        }
        return null;
    }

    public static boolean validateItems(List<SalesLineItem> salesLineItems) {
        for (SalesLineItem lineItem : salesLineItems) {
            if (SalesLineItemHelper.validateItem(lineItem)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateItem(SalesLineItem salesLineItem) {
        for (SalesItem item : salesLineItem.getSalesItems()) {
            for (SalesComponent component : item.getComponentList()) {
                if (SalesLineItemHelper.validateOptions(component) && SalesLineItemHelper.validateAdds(component) && SalesLineItemHelper.validateRemoves(component)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean validateOptions(SalesComponent component) {
        for (SalesOption option : component.getCurrentOptions()) {
            if (option.getOption() != null && !"DELETED".equals(option.getOption().getSystemState())) continue;
            return false;
        }
        return true;
    }

    private static boolean validateAdds(SalesComponent component) {
        for (SalesAdd add : component.getCurrentPluses()) {
            if (add.getInventoryAdd() != null && !"DELETED".equals(add.getInventoryAdd().getSystemState())) continue;
            return false;
        }
        return true;
    }

    private static boolean validateRemoves(SalesComponent component) {
        for (AbstractSalesRemove remove : component.getCurrentMinuses()) {
            SalesRemove salesRemove;
            if (!(remove instanceof SalesRemove) || (salesRemove = (SalesRemove)remove).getInventoryRemove() != null && !"DELETED".equals(salesRemove.getInventoryRemove().getSystemState())) continue;
            return false;
        }
        return true;
    }

    public List<SalesItemQuantity> calculateNewLocalQuantities(SalesQuantity newQuantity, EventContext context, String systemStateType) {
        SalesQuantity currentSavedTotal = SalesItemQuantity.getTotalQuantity(this.getSalesLineItem().getSavedQuantities());
        SalesQuantity diff = newQuantity.subtract(currentSavedTotal);
        List<SalesItemQuantity> newLocalQtys = null;
        if (!this.isSavedQtyRefund()) {
            if (diff.greaterThan(0L)) {
                newLocalQtys = Collections.singletonList(this.createNewSalesItemQuantity(diff, systemStateType, "NOT_PRINTED", context));
            } else if (diff.lessThan(0L)) {
                newLocalQtys = this.createDeletedQuantities(diff.negate(), context, systemStateType);
            }
        } else if (diff.lessThan(0L)) {
            newLocalQtys = Collections.singletonList(this.createNewSalesItemQuantity(diff, systemStateType, "NOT_PRINTED", context));
        } else if (diff.greaterThan(0L)) {
            newLocalQtys = this.createDeletedQuantities(diff.negate(), context, systemStateType);
        }
        return newLocalQtys;
    }

    private List<SalesItemQuantity> createDeletedQuantities(SalesQuantity toRemove, EventContext context, String systemStateType) {
        ArrayList<SalesItemQuantity> newQtys = new ArrayList<SalesItemQuantity>();
        for (SalesItemQuantity qty : this.getSalesLineItem().getSavedQuantities()) {
            if (!"DELETED".equals(qty.getItemState())) {
                if (!this.isSavedQtyRefund() ? toRemove.greaterThan(qty.getQuantity()) : toRemove.lessThan(qty.getQuantity())) {
                    newQtys.add(this.createNewSalesItemQuantity(qty.getQuantity().negate(), "DELETED", "NOT_PRINTED", context));
                    toRemove = toRemove.subtract(qty.getQuantity());
                } else {
                    newQtys.add(this.createNewSalesItemQuantity(toRemove.negate(), "DELETED", "NOT_PRINTED", context));
                    toRemove = SalesQuantity.ZERO;
                }
            }
            if (!toRemove.equals(SalesQuantity.ZERO)) continue;
            break;
        }
        if (!this.isSavedQtyRefund() ? toRemove.greaterThan(SalesQuantity.ZERO) : toRemove.lessThan(SalesQuantity.ZERO)) {
            newQtys.add(this.createNewSalesItemQuantity(toRemove.negate(), systemStateType, "NOT_PRINTED", context));
        }
        return newQtys;
    }

    private boolean isSavedQtyRefund() {
        return SalesItemQuantity.getTotalQuantity(this.getSalesLineItem().getSavedQuantities()).lessThan(0L);
    }

    private SalesItemQuantity createNewSalesItemQuantity(SalesQuantity qtyToAdd, String systemState, String salesState, EventContext context) {
        return new SalesItemQuantity(qtyToAdd, systemState, salesState, this.getSalesLineItem(), context);
    }

    public SalesLineItem getSalesLineItem() {
        return this.salesLineItem;
    }

    void setSalesLineItem(SalesLineItem salesLineItem) {
        this.salesLineItem = salesLineItem;
    }

    public AccountSaveContext getSaveContext() {
        return this.salesLineItem.getSaveContext();
    }
}

