/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SellableWrapper;

public class SalesLineItemWrapper<V>
extends SellableWrapper {
    private final SalesLineItem salesItem;

    public SalesLineItemWrapper(SalesLineItem item) {
        this.salesItem = item;
    }

    @Override
    public int getCourse() {
        return this.salesItem.getCourse();
    }

    @Override
    public int getSeat() {
        return this.salesItem.getSeat();
    }

    @Override
    public boolean isModifiable(EventContext context) {
        return this.salesItem.isModifiable(context);
    }

    @Override
    public Price getChargeablePrice() {
        return this.salesItem.getItemLevelPrice();
    }

    @Override
    public Account getAccount() {
        return this.salesItem.getAccount();
    }

    @Override
    public SalesQuantity getQuantity() {
        return this.salesItem.getQuantity();
    }

    @Override
    public boolean hasFinanceTransactions() {
        return this.salesItem.hasFinanceTransactions();
    }

    @Override
    public Customer getCustomer() {
        return this.salesItem.getCustomer();
    }

    @Override
    public SalesQuantity getSavedQuantity(boolean printed) {
        return this.salesItem.getSavedQuantity(printed);
    }

    @Override
    public boolean canHaveItemsWithin() {
        return true;
    }

    @Override
    public List<SalesItem> getSalesItems() {
        return this.salesItem.getSalesItems();
    }

    @Override
    public boolean hasDisplayablePriceLevels() {
        return this.salesItem.hasDisplayablePriceLevels();
    }

    @Override
    public String getDisplayablePriceLevels() {
        return this.salesItem.getDisplayablePriceLevels();
    }

    @Override
    public Price getPrice() {
        return this.salesItem.getPrice();
    }

    @Override
    public Price getItemLevelPrice() {
        return this.salesItem.getItemLevelPrice();
    }

    @Override
    public boolean isQuantifiable() {
        return true;
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    @Override
    public boolean isPriceAdjustable() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return this.salesItem.isPersistent();
    }

    @Override
    public boolean isUpgradeable() {
        return true;
    }

    @Override
    public boolean isPriceEdited() {
        return this.salesItem.isPriceEdited();
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    @Override
    public boolean isPrinted() {
        return this.salesItem.isPrinted();
    }

    @Override
    public Collection<SalesPriceAdjustment> getPriceAdjustments() {
        return this.salesItem.getPriceAdjustments();
    }

    @Override
    public boolean isRefund() {
        return this.salesItem.isRefund();
    }

    @Override
    public Object getSellingObject() {
        return this.salesItem;
    }

    @Override
    public boolean canBeHeld() {
        return true;
    }

    @Override
    public boolean isWastageCheckNeeded() {
        return this.salesItem.isWastageCheckNeeded();
    }

    @Override
    public boolean hasGenericIcon() {
        return false;
    }

    @Override
    public String getGenericIcon() {
        return "";
    }

    @Override
    public Color getBackgroundColor() {
        return SalesLineItemWrapper.getItemBackgroundColor(this.salesItem.isPrinted(), this.salesItem.hasFinanceTransactions());
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String getIcon() {
        return "";
    }

    @Override
    public String getLabel() {
        return this.salesItem.getLabel();
    }

    public SalesLineItem getSalesLineItem() {
        return this.salesItem;
    }
}

