/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ordermate.database.inventory.Modification;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesComponent;

@MappedSuperclass
public abstract class SalesMod
extends Modification {
    public static final Props Properties = new Props();
    private Reference<SalesComponent> component;

    public SalesMod() {
        this.component = this.createReference(SalesMod.Properties.COMPONENT);
    }

    protected SalesMod(SalesMod other) {
        super(other);
        this.component = this.createReference(SalesMod.Properties.COMPONENT);
    }

    @Override
    @Transient
    public Price getModificationPrice() {
        if (SystemProperty.getInstance().isPortionedModsEnabled()) {
            double portion = this.getComponent().getInventoryPortion().getSize();
            return super.getModificationPrice().multiply(portion);
        }
        return super.getModificationPrice();
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_component")
    public SalesComponent getComponent() {
        return this.component.get();
    }

    protected void setComponent(SalesComponent comp) {
        this.component.set(comp);
    }

    public static class Props
    extends Modification.Props {
        public PropertiedObject.Property<SalesComponent> COMPONENT;
    }
}

